import os
qs = os.environ["QUERY_STRING"]

# The page as shown by default
main="""Content-Type:text/html;charset=UTF-8\n
<!doctype html>
<html>
<head><title>Demo for the article 'An HTML5-style "Google Suggest"'</title></head>
<body>
  <p>
    <label>
      Please enter a word:
      <input list="suggest" name="q"
             oninput="list.data = '?w=' + encodeURIComponent(value)">
    </label>
    <datalist id="suggest"></datalist>
  </p>
</body>
</html>"""

if qs=="":
    print main
else:
    # If a query string was provided we need to provide an XML file with
    # options filtered using the user input
    import sys
    print "Content-type: application/xml"
    print "Cache-control: no-cache"
    print ""
    sys.stdout.write('<select xmlns="http://www.w3.org/1999/xhtml">')
    sys.stdout.write('  <option>[searching for "%s"]</option>' % qs[2:])
    for name in open('suggest.txt').readlines():
        if name.lower().find(qs[2:].lower())!=-1:
            sys.stdout.write('<option>%s</option>' % name)
    sys.stdout.write('</select>')
