/*
 */
window.onload = function()
{
    // Once the widget has loaded, the onload function is called
    // ***[onLoad-1]*** Check the Screen size, and resize accordingly
    if(screen.availHeight < 400 || screen.availWidth < 400)
    {
        window.resizeTo(screen.availWidth, screen.availHeight);
    }
    
    // ***[onLoad-2]*** A New instance of the feedReader class is created.
    var operaFeed = new feedReader();
    
    // Provide the feedURL, ID of the container in the DOM and a refreshInterval
    operaFeed.init("http://www.opera.com/pressreleases/rss/", "content", 30);
    // ***[onLoad-8]*** The Onload function call is ended.
}
/*
 * The Feed Reader class
 */
var feedReader = function()
{
    // A reference to itself and an ID for the refresh timer are declared. These will be used when the widget updates itself.
    var _self = this;
    var _timerID = null;
    // The three most important properties for this widget are
    // (i)The Feed URL
    // (ii) The reference to the container in the widget's DOM
    // (iii) The interval at which the widget should re-fetch the feed.
    var _feedURL = "";
    var _container = null;
    var _refreshInterval = 15*60*1000; // 30 Minutes
    // A pirvate variable to hold the results from fetching the feed is declared.
    var _feedList = [];    
    //
    this.init = function(URL, containerID, refreshInterval)
    {
        // ***[onLoad-3]*** The widget is initialised
        _container = document.getElementById(containerID);
        if(URL=="" || !_container || refreshInterval < 0)
        {
            // ***[onLoad-4]*** In case any provided value was incorrect, the initialisation ends abruptly.
            return false;
        }
        _feedURL = URL;
        _refreshInterval = refreshInterval * 60 * 1000;
        // ***[onLoad-5]*** The timed feed fetching mechanism is started.
        startTimer();
        return true;
    }
    // This is the function that starts the automatic timer, which will trigger every X minutes and fetch the feed.
    function startTimer(){
        // ***[onLoad-6]*** Since this is the first run, the feed is fetched immediately.
        _self.fetchFeed();
        if(_timerID)
        {
            window.clearInterval(_timerID);
        }
        _timerID = window.setInterval(_self.fetchFeed, _refreshInterval);
    }
    this.fetchFeed = function()
    {
        // ***[onLoad-7]*** A new XMLHttpRequest is initiated, and a request is sent
        // ***[Timed-Call-1]*** A new XMLHttpRequest is initiated, and a request is sent
        var request = new XMLHttpRequest();
        request.open("GET", "http://www.opera.com/pressreleases/rss/", true);
        // ***[Async]*** _processFeed() shall be called asynchronously.
        request.onreadystatechange = _processFeed;
        request.send(null);
        // ***[Timed-Call-2]*** The timed function call is ended.
    }
    
    function _processFeed()
    {
        // ***[Async - 1]*** At every state change, this function is called.
        if(this.readyState == 4)
        {
            // ***[Async - 2]*** When the request has reached readyState 4, it parses the response and creates a list of items.
            _feedList = this.responseXML.getElementsByTagName("item");
            _displayFeed();
        }
    }
    function _displayFeed()
    {
        // ***[Async - 3]*** Once the response has been parsed and listed, this function parses the required "Title" and "Link" information and appends it to its container in the DOM
        var unorderedList = document.createElement("ul");
        var listElement, item;
        for(var i=0;item = _feedList[i];i++)
        {
            // ***[Async - 4]*** For each item, a list element is created that holds a linked Title
            listElement = document.createElement("li");
            anchorTag = document.createElement("a");
            anchorTag.href = item.getElementsByTagName("link")[0].textContent;
            anchorTag.textContent = item.getElementsByTagName("title")[0].textContent;
            listElement.appendChild(anchorTag);
            //
            //
            // ***[Async - 5]*** Each listElement is marked as even or odd, for styling purposes.
            listElement.className = (i%2)?"even":"odd";
            //
            // ***[Async - 6]*** Each listElement is appended to a parenting Unordered list element.
            unorderedList.appendChild(listElement);
        }
        // ***[Async - 7]*** The container in the DOM is emptied and then populated with new content.
        _container.textContent = "";
        _container.appendChild(unorderedList);
        // ***[Async - 8]*** The asynchronous function call is ended.
    }
}