/**
 *  Copyright 2009 Opera Software ASA. All rights reserved.
 *
 * This file contains Original Code and/or Contributions to the Original 
 * Code as defined in the Opera Web Applications License (the License). 
 * You may not use this file except in compliance with the License. Please 
 * obtain a copy of the License at http://www.opera.com/license/owal/
 * and read it before using this file. 
 *
 * The Original Code and all Contributions to the Original Code distributed 
 * under the License are distributed on an AS IS basis, WITHOUT WARRANTY 
 * OF ANY KIND, EITHER EXPRESS OR IMPLIED, AND OPERA HEREBY DISCLAIMS ALL 
 * SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. 
 *
 * Please see the License for the specific language governing rights and 
 * limitations under the License.
 */
 
opera           = opera||function(){};
opera.postError = opera.postError||function(){};

/*
 *  widgetModes
 */
var widgetModes = new (function()
{
    var _dockId     = 'dock';
    var _maxSize    = '40em';


    /*
     *  setMaxSize
     */
    this.setMaxSize = function( maxWidth )
    {
        var isValid = (''+maxWidth).match( /^[1-9][0-9]*(\.[0-9]+)?e[mx]$/gi );
        if( isValid )
        {
            _maxSize   = maxWidth;
            _adjustDocumentFontsize();
        }
        else
        {
        }
    }

    /*
     *  _adjustDocumentFontsize
     */
    function _adjustDocumentFontsize()
    {
        if( document.body )
        {
            var fontSize        = 6,
                tmp             = document.createElement('span'),
                defaultStyle    ='background:transparent;position:fixed;z-index:70;top:0;left:0;padding:0;margin:0;display:inline-block;width:'+ _maxSize +';height:'+ _maxSize +';font-size:';
            document.body.appendChild( tmp );
            do
            {
                tmp.style.cssText = defaultStyle+ fontSize++ +'px';
            }
            while( tmp.offsetWidth<window.outerWidth && tmp.offsetHeight<window.outerHeight );
            document.body.removeChild( tmp );
            document.body.style.cssText = 'font-size:'+ --fontSize +'px !important';
        }
        else
        {
            window.addEventListener
            (
                'load',
                arguments.callee,
                false
            );
        }
    }
    //  and on resize
    window.addEventListener
    (
        'resize',
        function(){ return _adjustDocumentFontsize }(),
        false
    );


    /*
     *  defineDockElement
     */
    this.defineDockElement = function( id )
    {
        if( document.getElementById( id ) )
        {
            _dockId = id;
        }
    }

    /*
     *  _widgetModeChangeHandler
     */
    function _widgetModeChangeHandler( event )
    {
        var mode = event.widgetMode||widget.widgetMode;
        
        if( mode=='widget' )
        {
            var closeButton = document.createElement('button');
            closeButton.id = 'close';
            var style = 'background: transparent url(' +
            'data:image/png;base64,' +
		'iVBORw0KGgoAAAANSUhEUgAAABoAAABoCAYAAADvoOAEAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29m' +
		'dHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAABFmSURBVHja7JoLdBRVmsfr1qMf6XTSSUsSwiOBQGSA' +
		'EF4iI6CDDsowsBLwHAdHRwWUWeMOy5FFBISVBVRUhIisAdwzs6wMjMpD1xGWGRBERGEnvEUMkwCBBEIe' +
		'/e563drvq65qqh/rbgJnzpk9W5yP7lTd+/3v47v3+1VVEyZ2EDAWzAYmgPHMzR0KmAwmgVEwjRgidrBy' +
		'sNFg+YbgzRwocBXsINhxMBFFOLDhS557buncZ54pcwnQIUopo2mMbh05CDGNBNvaostefvnYyq1bV8KV' +
		'oyjkBHum/ejRX7oikQitq2vRQiGZURS9yx3sCWF4niVOJ89kZztP1ddzw+bM2Qrn1/HGnORnUKrI58+3' +
		'au3tohaJKCikdbBHBHuDQqJICaVEUVWPMRUCb0y8TYGLot+v0GCQQo+oJstqZyaHwNATVaUsy6pSNEqN' +
		'+ebj0UUV6IQkaaooahREv21qcv6hvv621mjU1i83NzCmR4+2fJdLsjq94PM5/njhgrcxGHT29niCP+rZ' +
		's7UwN1dheV7jwJeiKPGybDxMVJWRFIWgiYrC7r940TuusrLbG++9l9tWUlLy2zNnChsDATteQ/uutTXj' +
		'nZqa4uKJE4tehzLOO+4o+lNTUzZeM/3A0JEUoWA0yomqyqKBKOsXRUGGwjBRZO7s2apSUtJ969mzXRtD' +
		'IXtte3vGxuPHi8Y++miXiokTVSwTVRReMuqaftrCYS5FKCSKXH1Li+M8WG1bmzPTbpc/2bWLDUsSh/bC' +
		'vHk0VFTUc83Ro71Xff11nzHTpuX9dPx4Fa8dOXnSdmjPnohDEFSsiz7QVyga5VOEKEYJmKppLH6WeDxh' +
		'3+nTzf+4YoWgGXG+ZMECJaNfv/xJTzzhmTxxooznfIEAWfbii8oIr7fJ43AoVh/wmTp0KlyQYZ3q4wtj' +
		'6+A4ZVS3bteDZ840oRgMD4P28uLF0SmTJkn4vd3vJ3PnziV3er2Xe7jdYVVVNayLPtAXNj61R4YYtsJs' +
		'TQYMxaju3Vsajx1rfWHpUiesK2Kaz+9n/3b2bHuBKDb1zc0N6o211EVf1BKh1qFDIVaBQtBaFlqkW1CS' +
		'eAgM29DycootNC3T5WJ69erFtImiPSTLvFke6yoxIRYsVUgXM4YHDXeF5nDYtqe+vmDqjBnuKTAnWMYP' +
		'c2KWf2nBAskzYECXQw0NXmgMr1nqmz7SCrGwhZiGC3XvhQsFOPEPTpigmCKVc+YIS1asiO/ui+fPV9z9' +
		'++d/3diYG1YUzupD35KShWDLYDiWpTwhGhSif25vd/344YezYJ3IcE0LhkLM8/PnM6UMczF89mzjsldf' +
		'5fE8GkSjnFFS4sURwLroA32BpRHCfAGVOCjEo2OYmz4lJRq0SgsEg8y8efOYvpRewuC4r6joWvibbxr/' +
		'6ZVXOLyO1qO4mISgDm/4QF/W4YovKLwgYAtgn2I5TuuelRU9fOCAfPLECeGbmhq5HyFNQwoLfQ6exxmm' +
		'9xUXXz947py29KWXuqBIc11dtAfshTaoy4MP9IW9TRHCkzwUgm2Xwh/aD7xe/4ULF+RwbS1/p8sVLfB6' +
		'RUNEP3KdTule6Nklvz/gP3JEKIK/u2dnR/Ue4RSALy6dEBQgNtjiWbsdN0MmD7b5vKysYEpisxwOu53e' +
		'5naHktIE4cEHD754WLhWIYwoCbZ2RnA6oS2U1WdZlrXOZFgUYtGPw8Fysd0bl4XKG1+u+pubw5CCBdh6' +
		'KIUWGam84weEAyMIbBulDtio8UwTdoQ3iOXgG5s23T26f/9SWGSZVJapRqnWGTghMAWE57kIJL69x4/X' +
		'wtkvUMOKW4PBRt0i3JKNnqDIMRO3kgHSZiDYzRyqMVJxgGTTFNKYmz80Jk24/kVIlTeGrHxpZeXLv3r8' +
		'8aEuhnAQcRATGAwdxkeIBxb3HyZ4vUV6Y/Xqo8v3/McSJFXeaP3oyvt+XGarORYNgWl+v8rgOtI6GOEE' +
		'2gzriLhcrJCfx1f07t1/eWyUTsRJ1RkOMWJNTVS7fl3RgkHIyVKn5orYbIRIIofDoTKaI4VU1WhUU3w+' +
		'Sv0BCkKaBiDZKSG7nYEUTVlYtEqMTxNJVYP9jUIvqCwxVIwy9YGAcCAYzGiBZHa7wyGOyMiIenk+AZOv' +
		'QAo/CJTaqMhCb5tdGulyRfJgvFk7+EZfTJoMS1VIvyrwgKICE2jkMDgY97ut+a9dbcrzTftZwc72dner' +
		'rHB4Da1BlIR/bWnx9Fr5asHKpqa8jMrKvG8iEbt+HX2AL+sU3wBIRWJhTIlpQUo5xcCl5155RVAefDD3' +
		'Iz+IqQrXIEvCprbW7B+9uSp38iOP6ItbpGoMSiw+/FKUTREKywppAIS9FInyl6IinwVpYtfmzXIcRN75' +
		'Z1tk0t94325uzlndfC0XRaY++qhe/8zJk9qh6vUhF2Ep1kUf6CskKSQNnACvwVziuIKRPoDEgQ+3+RbN' +
		'mhUXW1b9juCaUuGZUlWV/ZAh4vf5mIUTfhoararBHJ7DW0XdB/piiEZSEh8sT32OtBjXMS7I+3fD5O7f' +
		'tp0sZBjP8upqveybGzbE90EU+dWECdF7qBoodjhlJlYXamr6HFEtzRxpJtdhj7TYdxCjY1yucNP7H/jn' +
		'zJyZEHE+EPnF/Q9I3Wtr/aUQcUyc5xjDh8akJVVTLDZ8+paLnyQCGddHVW7kPfcklM3OzmZKy8vZdpVy' +
		'ItCpWd648SVaUuq39Mj8x8Q/m2EN/XsgkPmztWvdDz/2GDF7Yh4r11fzWVOnZO8PBZ0BaJC1rvl/ihCJ' +
		'/4t9b1VVbheIVLxVlWWdeByueU/Pit8zroC5c02Z4jkUCjnDIGb1YWUZNk3O0JPUOTEqjFu+zG0VefYn' +
		'E6Jl9XXtkW3bfAtn3RDDQLHdPy6zSZE51vBBkvISaxXRmZlBbgbHsGBLy8puiEB09a+rax/tyoyMA8SK' +
		'btvebg39ooEDebifZ7FuzAdh0pKqXoBjNRpjb62bYJMPbtkqHjt4kD/x+9+LA+rqA0Ngv7PDNXwCMhbE' +
		'Pt+xQ1sYDLpRpOnwV2JPnlfYGCLrvliSRggDhegieue12+0O8eLOj1rCIH0XbKb5zgwFReJRB9Q21uUO' +
		'NRw4KAY+288Wc5xayAtKrDcgp5claZCY5wgPuYSBnZdVbCQHEmVOhlP6PlLNhjnIZpxyYj6CxAc+0BcH' +
		'PlNIlXAcwzoziCDJsBYIo9kkplOpXLAR1uUijMMJWZ1JQ6qNjVHqcnLAmRrrsFFNkjv1dAt7pAEO++CW' +
		'wh+JqCmkWvXpp+N/2KPnIMhbTp0XVGNr7FCHoAOSvn+RsKrQfX+uO/n/pPrXQ6rxZ6rTygYtnXj77WWZ' +
		'gsARCAaqKp0iVZbjCYNribDynvPnT1Ud/jKRVH9ePmhgaaab3iYrIolEKCOznSZVJiODlV0Z3IiBAweA' +
		'UCKpeh0OzivLEUg4Kr0FpMrDcDi6dnWlkCoVAfgA7m8lqaqKzKR5pioDqcpxUtVi958dF4KemKSK9JtK' +
		'QUmkWh8Vhc8hRSMSl9od0ggXIDGXisRfhBCJFb63zSaPzHBFugg2yoAPBn3RNKk8IIsJpPpVOOS8//3f' +
		'5b9+7Wqe/+fT8j/y+XRKNa+btNr7tZU6Nmc8+2yXM2LUbvURkiU2pUdIlVCZUyNRQqMivSxJ+AxO3znm' +
		'AhIvamvP/bft29mxmZBd4fxOv889qWqNB5BYdxYBJI7IMoekCiHOcuEw65XTkSpJJNUeNpuy24LESKn2' +
		'isme7b72rC2+tmwUeciCxIcBiXsIgpJAqkyaZ6pJpEpKYMz9H3zot0LIsupqIbOiIntqEhIvmDAhPEpV' +
		'gjn4MMR4FJpMqrz1maqVVE1KPbBtG5OAxBsTkfjvEIlV6i92OGTGIFWMPKIlbizWTZUkk6qLZbUxQD2A' +
		'xIE5M5+iyUj8GDBej9raQF+4IWDSk2o6oVRS1fRJpgSQmB15z93kv0FiVtI0s5FJPtI+U00kVfzENfTJ' +
		'9yDxa4DE2YDEuN5COqUyST7Sk6pmJdU2VWU/DQRcyUj8eBISL48hcTYgsQN7n0Sq6Z+pWkn1W1G0ARIn' +
		'iCCtltXXt4vbE5EYo1G4f5y7CXYIK6mStEIGqRKDVPHuwIrEGF1Aq+1jMjPD49xZQXH7jrZFs34ZX2fF' +
		'QKsBgE2DVLX/NakWCoL8hYHEJwGJB9bV+4c4DSQGB/fCDnEAkHhRMJDVM4bE0SKOR1LVvpdUOYEnPEKz' +
		'Qar9tSz54q5PW0IQVWMEQc33eBR77Dm23s4cmIf77LbI5a++kn1fHGJ7AzYXZmaqvMMWJ1U2Halydjvh' +
		'oAwxSDXHZtdyNEb+PiT2gJiHsZSxkCrnhvt6ROxkUmU5TrLl5nLyLSBV1u3mMgcPtmsej5ZCqnsbLo8f' +
		'PPWh4ZneXIHBtyT6ausMfIMcL4Bnjq7btOlP/3dJlU+iS2oEh3YLhBJegZtDh8jVB6wMXzsY0UhuAoex' +
		'sa1geDeBz75l02GfoUOHDtq4ceO50tLSqNkSrYMvy4nlzdSJEye4ioqKPlevIhkzZ81AmPzxxx+fLiws' +
		'9EGBwLVr19RIJNKp4XM6ncTj8bBdu3YVNm/e7N6yZcsIOL3DBMhcyC/R3bt3h+vr67WmpibG7/d3atyy' +
		'srKYgoICBhpNHQ4HY04Fb0QY39jYSGpqatiGhgYOv0Pe6VSPoMGkubmZbWtrAxDSX2HrGmbUoWMOCqAx' +
		'LS0tJBAI4G8RSsCQn6/hy358fpjcAbDesRt05jpYvaIoYbh9Ze12OwdHPKjiaaK1tZWHeeFFURQopRiF' +
		'Jdt2frzhaM3xbYsWL3kR/h4C5jYiFM0Ldtf6d/9lDZZ5fdWbi+HvblgXfaCvUCjEpezeMCd4UVDwbTfV' +
		'39S6KFX1gpMrpjwAOUmuWrN6A2KcIXTH+o3vPj906LD++lYgK/ovcFAIfLDgi4WeCamkGgoJkiTpQvi+' +
		'ALP55wcOHC0u7tUNr//iiScn4lvjtVVrfouNqN7w7uyhw4b/QH8T1dTYsm7tWzsQKaCuLgS+WKNBiULQ' +
		'XQ4K8NgbQ6hlzZur3lNV1fbEk9N/gmXgcwKUcQwqL+8+bPjwUqOe9PSM6W9duXLla/wT6qIPFsXg4FOE' +
		'oAU8OBUsQriNnIcebMKK02fMfADLzXzq6XstjZMWvjD/1yDyJfYGo0unVHxPDnADn6k/nJAB0PECFGSN' +
		'kOeMXfg7GJYP11e/85k13KLRqPz8Pzz3/mf79v4BH1Ya0cUZYrpIWiEcNmgFvljXzegtb/xuyF0Ow5Xw' +
		'atThEAYMLCuEr5nG7qKXN+ujLxDi0wmx2BKjR6bhOhmyrnr9rDtH/rCP2ROzzlNPzxr7TOWz0+BrP6NB' +
		'ej3Tj+ErUQhCkcKeqJuxxWPFgSBSOWLEnaU3hmvuBxvWV+8z602f+dQ4EHvEWNzYg7gfw1cMfszsOmTI' +
		'kMZLly5FYIJVDHHoevdVq6v+/q5RowZaJv43nx/Y/8l/Hj1yGhrmGjJ0GDpn8BPmWD5WU3MSzgdtNpsG' +
		'mysjwAG7TAFm2fgYwjkVf51k6ZG9Z1HPPFNkwfznf7P/s3074c9L2PJ1b6/9NWFZ+uT0GeOxTN/S0m5G' +
		'dkYfGNr4/l1NCW9ohQJ7E/52wezy9S8PHTp07ttvu+7b+8cjILIbzl00khoep95+q2ojDGdrSUmfHqdO' +
		'nUIQ8UFd9AFQxbFphaCrlMeHrzeELr/x2so1Riv9himWwMMX9qff3bD+CgYhbi5g7VA3tlJjG2uKkOZy' +
		'uWS3261ACynOEbbMcPY//TIwlBT2BHwB2rlZw0dcCFUVr9erdunSRZ8nnMybybA5OTkUjIcGq0ZjqInE' +
		'rfgjCRDTIENSSMWa2MlHNDBcBHzomyokPtaAFNnkuX7gvN/gwYNroTcUfzhoLOIOicG8EKNXLGQDGwRI' +
		'X0iop0w4MXGrr4FbOdbt/SZ+1Wni1ndmj6ykaj5WY29SiBobsmKC5H8JMACWRa3dD9oeQgAAAABJRU5E' +
		'rkJggg==) 0 0 no-repeat; width: 26px; height: 26px;';
            closeButton.addEventListener( 'click', function() {
                widget.hide();
            }, false);
            
            var header = document.getElementById('header');
            if ( header )
            {
                closeButton.style = style + 'float: right; margin-top: 2px; margin-right: 0px';
                header.insertBefore( closeButton, header.firstChild );
            }
            else
            {
                document.body.appendChild( closeButton );
            }
            //  TODO : add close button in the h1#header
//            var foo = document.createElement('div');
//            foo.id  = 'caption';
//            foo.style = 'background:url(style/caption.title.gif) left center repeat-x;padding:.25em;border:1px solid #999;z-index:9999;display:block;';
//            foo.textContent = widget.identifier;
//            opera.postError( foo.outerHTML );

        }


        var wrapperElement = document.getElementById( 'widgetWrapper' )||document.getElementsByClassName( 'widgetWrapper' )[0]||{style:'dummy'};
        wrapperElement.style.display = mode=='docked'?'none':'block';

        var dockElement = document.getElementById( _dockId );
        if( dockElement )
        {
            if( mode=='docked' )
            {
                dockElement.style.display = 'block';
            }
            else
            {
                dockElement.style.display = 'none';
            }
        }
    }
    //  listen to the widgetmodechange events
    if( widget.addEventListener )
    {
        widget.addEventListener
        (
            'widgetmodechange',
            function(){ return _widgetModeChangeHandler }(),
            false
        );
    }
    //  check the widgetMode onload
    window.addEventListener
    (
        'load',
        function(){ return _widgetModeChangeHandler }(),
        false
    );


    /**
     * if we're on a small screen, use all of it
     */
    if( screen.availHeight + screen.availWidth <= 600 )
    {
        window.moveTo( 0, 0 );
        window.resizeTo( screen.availWidth, screen.availHeight );
        window.scrollTo( 0, 0 );

        /**
         * if we're on a small screen, use all of it
         */
        window.addEventListener
        (
            'resize',
            function()
            {
                window.resizeTo( screen.availWidth, screen.availHeight );
            },
            false
        );
    }



})();
