opera.io.webserver.addEventListener( '_request', handleRequest, false );

function handleRequest( event )
{
    var response = event.connection.response;
    
    var data =
    {
        name    : 'Template',
    };
    var template = new Markuper( 'templates/tutorial.html', data );
    
    template.registerDataAttribute( 'header', function( node, data, key )
    {
        var types =
        {
            'section'           : 'h1',
            'subsection'        : 'h2',
            'subsubsection'     : 'h3',
            'paragraph'         : 'h4',
            'subparagraph'      : 'h5'
        }
        
        var header = document.createElement( types[key] );
        header.textContent = node.textContent;
        
        node.parentNode.insertBefore( header, node );
        node.parentNode.removeChild( node );
    });
    
    response.write( template.parse().html() );
    response.close();
}