/*dragDrop class.  Written by PPK.  Adapted by DStorey. Added Wai-Aria. Changed so drag handle is different to the element which is dragged, and so the window can't be dragged out the boundries. Opera 10 demo, so removed IE backwards compat stuff (seems to make it a lot faster) .*/
dragDrop = {
	//keyHTML: '<a href="#" class="keyLink">#</a>',
	keySpeed: 10, // pixels per keypress event
	initialMouseX: undefined,
	initialMouseY: undefined,
	startX: undefined,
	startY: undefined,
	dXKeys: undefined,
	dYKeys: undefined,
	draggedObject: undefined,
	initElement: function (element) {
		var dragHandle = element.querySelector('header[role="wairole:heading"]') 
		dragHandle.relatedElement = element;
		dragHandle.onmousedown = dragDrop.startDragMouse;
	},
	startDragMouse: function (e) {
		dragDrop.startDrag(this.relatedElement);
		dragDrop.initialMouseX = e.clientX;
		dragDrop.initialMouseY = e.clientY;
		addEventListener('mousemove',dragDrop.dragMouse, false);
		addEventListener('mouseup',dragDrop.releaseElement, false);
		return false;
	},
	startDrag: function (obj) {
		if (dragDrop.draggedObject)
			dragDrop.releaseElement();
		dragDrop.startX = obj.offsetLeft;
		dragDrop.startY = obj.offsetTop;
		dragDrop.draggedObject = obj;
		obj.setAttribute('aria-grabbed', 'true');
	},
	dragMouse: function (e) {
		var dX = 0;
		//stop losing the element off the side of the screen by testing that the x co-ord is greater than the left edge of the screen.
		if (e.clientX > 0) {
		    dX = e.clientX - dragDrop.initialMouseX;
		} else {
		    dX = 0 - dragDrop.initialMouseX; 
		}
		var dY = 0;
		//stop the element overlapping the menu bar by testing that it the y co-ord is greater than the height of the menu
		if (e.clientY > 21) {
	   	    dY = e.clientY - dragDrop.initialMouseY;
	   	} else {
	   	    dY = 21 - dragDrop.startY;
	   	}
		dragDrop.setPosition(dX,dY);
		return false;
	},
	setPosition: function (dx,dy) {
		dragDrop.draggedObject.style.left = dragDrop.startX + dx + 'px';
		dragDrop.draggedObject.style.top = dragDrop.startY + dy + 'px';
	},
	releaseElement: function() {
		removeEventListener('mousemove',dragDrop.dragMouse, false);
		removeEventListener('mouseup',dragDrop.releaseElement, false);
		dragDrop.draggedObject.setAttribute('aria-grabbed', 'false');
		dragDrop.draggedObject = null;
	}
}

function setActive(e) {
	
	var el = e.target;
	var found = false;
	
	//flaky code. Added test to break if we hit the body to avoid risk of infinitive loop.  Need to support multiple class names.
	//don't try to set active if already active
	if (el.className != "active") {
		while (found == false || el.nodeName == "body") {
			if (el.getAttribute("role") == "wairole:application") {
				var previousActive = document.getElementsByClassName("active");
		
				for (var i=0; i<previousActive.length; i++){
					//needs to be fixed to remove active rather than full class
					previousActive[i].className = "";
				}
				el.className = "active";
				found = true;
			} else {
				el = el.parentNode;
			}
		}
	}
}

function init() {

	var apps = document.querySelectorAll('div[role="wairole:application"]');
	
	for (var i=0; i<apps.length; i++){
		//need to add both mouse and key listeners as click only fires when one releases the click, which stops it highlighting on drag until the drag stops.
		apps[i].addEventListener("mousedown", setActive, false);
		apps[i].addEventListener("keydown", setActive, false);

	}
	
	var dragApps = document.querySelectorAll('div[draggable="true"]');
	
	for (var i=0; i<dragApps.length; i++){
		dragDrop.initElement(dragApps[i]);
	}
	
	
}

window.addEventListener("load", init, false);
