URLs([
    '_index', spreadsheet,
    'spreadsheet_update', spreadsheet_update,
    'spreadsheet_set_cell', spreadsheet_set_cell,
]); 

db = new JSON_FILE('spreadsheet.json', {
	values:{ 
		//A1:'test' 
	},
	updates:[
		//[1245785592.5, 'C3', 'soft update'],
	],
});

function spreadsheet_set_cell(r) {
	if(r.GET.cell_id) {
		if (r.GET.cell_id.match(/^[A-Z][0-9]+$/)) {
			//r.write("alert('"+(r.GET.cell_id.match(/^[A-Z][0-9]+$/))+"');");
			db.store.values[r.GET.cell_id] = r.GET.value;
			db.store.updates.push([(new Date()).getTime()/1000, r.GET.cell_id, r.GET.value]);

			db.store.updates = db.store.updates.filter(
				function(i){
					return i[0]>((new Date()).getTime()/1000)-1800;
				}
			);

			db.save();
		};
	};
};

function spreadsheet_update(r) {
	db.store.updates.forEach(function(i) {
		if(i[0] && i[0]>=r.GET.since) {
			r.write('set_cell_value('+safe_js_val(i[1])+', '+safe_js_val(i[2])+');\n');
		};
	});
	r.write("current_time = "+(new Date()).getTime()/1000+";");
};

function spreadsheet(r) {
	template = new Markuper('templates/index.html', {
		base: r.uri('/'),
		current_time: (new Date()).getTime()/1000,
	});

	init_script = '';
	init_script += 'page_loaded = 0;';
	table = '<table>';
	table += '<tr><td style="background: transparent;">';

	for(var j=1;j<20;j++) {
		table += '<td class="header">'+j;
	};
	
	for(var i=0;i<15;i++) {
		A = String.fromCharCode(65+i);
		table += '<tr><td class="header">'+A;
		for(var j=1;j<20;j++) {
			var _value = (A+j in db.store.values) ? db.store.values[A+j] : "";
			table += '<td class="cell" id="CELL_'+A+j+'">';
			//table += _value;
			if(_value) {
				init_script += 'set_cell_value('+safe_js_val(A+j)+', '+safe_js_val(_value)+');';
			};

		};
	};
	table += '</table>';
	init_script += 'page_loaded = 1; evaluate_cells();';

	template.select('#main_table')[0].innerHTML = table;
	template.select('body')[0].innerHTML += '<scr'+'ipt>$(document).ready(function(){' + init_script + '});</scr'+'ipt>';

	r.write(template.parse().html());
};
