var current_cell = "";
var page_loaded = 0;

function current_server_time() {
	return (new Date()).getTime()/1000 - time_difference;
};
setInterval(function() {
	$.getScript(uri_base+'spreadsheet_update?json=1&since='+current_time+'&filename='+encodeURIComponent(current_page()));
}, 5000);

$(document).ready(function(){

	function bring_editor_to_front(cell_id) {
		this_ = $('#CELL_'+cell_id);
		$('#editor').css('top', $(this_).offset().top+$(this_).height()+3).css('left', $(this_).offset().left).stop().hide().show('fast');
		current_cell = cell_id;
		$('#cell_id').text(current_cell);
		$('#edit_value').val($(this_).attr('title')).focus();
	};

	function user_tip_about(title, place_where) {
		if(title) {
			$('<div class=tip_user><pre style=\'font-size:11px;\'>' + title.replace(/</,'&lt;') + '</pre></div>')
				.appendTo($('body'))
				.css('top', $(place_where).offset().top-18)
				.css('left', $(place_where).offset().left)
				.stop().hide().show('fast');
		};
	};
	function user_tip_close() {
		$('.tip_user').remove();
	};

	$('.rounded').each(function(){
		$(this).html(
			'<table style="width: 100%; height: 100%;"><tr><td style="background: url('+uri_base+'/img/rounded.png) top left; width: 14px; height: 14px;"><td style="background: url('+uri_base+'/img/rounded_v.png) top left; width: auto; height: 14px;"><td style="background: url('+uri_base+'/img/rounded.png) top right; width: 14px; height: 14px;"> <tr><td style="background: url('+uri_base+'/img/rounded_h.png) top left; width: 3px; height: auto;"><td style="background: #b2b6c9;"> '	+ $(this).html() + '<td style="background: url('+uri_base+'/img/rounded_h.png) top right; width: 3px; height: auto;"> <tr><td style="background: url('+uri_base+'/img/rounded.png) bottom left; width: 14px; height: 14px;"><td style="background: url('+uri_base+'/img/rounded_v.png) bottom left; width: auto; height: 14px;"><td style="background: url('+uri_base+'/img/rounded.png) bottom right; width: 14px; height: 14px;"> </table>'
		);
	});


	$('td.cell').mouseover(function(){ 
		$(this).addClass('cell_hover'); 
		var cell_id = $(this).attr('id').replace(/^CELL_/,'');
		user_tip_about(cell_errors[cell_id], this);
	});

	$('td.cell').mouseout(function(){ 
		$(this).removeClass('cell_hover'); 
		user_tip_close();
	});

	$('td.cell').click(function(){
		var cell_id = $(this).attr('id').replace(/^CELL_/,'');
		bring_editor_to_front(cell_id);
		$('#CELL_'+current_cell).addClass('highlighted');

	});

	$("#edit_value").focus(function(){ this.select(); });

	$(document).keyup(function(event){
		if (event.keyCode == 27) {
			$('#editor').stop().hide('fast');
			$('#CELL_'+current_cell).removeClass('highlighted');
			current_cell = '';
		};
	});
	
	$('#editor').keyup(function(event){
		
		// update editor width
		var len_ = $(this).find('#edit_value').val().length;
		len_ = len_ < 20 ? 20 : len_ - (len_%10);
		len_ = len_ > 50 ? 50 : len_;
		$(this).find('#edit_value').css('width', (len_*12)+'px');
		$(this).css('width', (len_*12)+'px');

		// user pressed ENTER
		if (event.keyCode == 13) {
			$('#editor').stop().hide('fast');
			$('#CELL_'+current_cell).removeClass('highlighted');
			var current_value = $('#edit_value').val();
			set_cell_value(current_cell, current_value);
			/* Send query to Opera Unite */
			$.getScript(uri_base+'spreadsheet_set_cell?json=1&cell_id='+encodeURIComponent(current_cell)+'&value='+encodeURIComponent(current_value)+'&filename='+encodeURIComponent(current_page()));
			current_cell = '';
		};
	});

	evaluate_cells();

	//set_cell_value('C3', 'testss');

});
function set_cell_value(cell_id, value) {
	if($('#CELL_'+cell_id).attr('title') != value) {
		if(page_loaded == 1) { $('#CELL_'+cell_id).addClass('highlighted'); };
		$('#CELL_'+cell_id).attr('title', value);
		if(page_loaded==1) { evaluate_cells(); };
		setTimeout(function(){ $('.highlighted').removeClass('highlighted'); }, 7000);
	};
};
