/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.NullIterator;
import au.net.zeus.collection.RC;
import au.net.zeus.collection.Ref;
import au.net.zeus.collection.Referrer;
import au.net.zeus.collection.SerializationOfReferenceCollection;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ReadResolveFixCollectionCircularReferences<T>
extends SerializationOfReferenceCollection<T>
implements List<T>,
Set<T>,
SortedSet<T>,
NavigableSet<T>,
Queue<T>,
Deque<T>,
BlockingQueue<T>,
BlockingDeque<T> {
    private volatile Collection<T> serialBuilt = null;
    private volatile boolean built = false;

    ReadResolveFixCollectionCircularReferences() {
    }

    @Override
    Collection<T> build() throws InstantiationException, IllegalAccessException, ObjectStreamException {
        if (this.isBuilt()) {
            return this.getSerialBuilt();
        }
        this.setBuilt();
        if (BlockingDeque.class.isAssignableFrom(this.getClazz())) {
            return RC.blockingDeque((BlockingDeque)this.getCollection(), this.getType(), 10000L);
        }
        if (BlockingQueue.class.isAssignableFrom(this.getClazz())) {
            return RC.blockingQueue((BlockingQueue)this.getCollection(), this.getType(), 10000L);
        }
        if (Deque.class.isAssignableFrom(this.getClazz())) {
            return RC.deque((Deque)this.getCollection(), this.getType(), 10000L);
        }
        if (Queue.class.isAssignableFrom(this.getClazz())) {
            return RC.queue((Queue)this.getCollection(), this.getType(), 10000L);
        }
        if (List.class.isAssignableFrom(this.getClazz())) {
            return RC.list((List)this.getCollection(), this.getType(), 10000L);
        }
        if (NavigableSet.class.isAssignableFrom(this.getClazz())) {
            return RC.navigableSet((NavigableSet)this.getCollection(), this.getType(), 10000L);
        }
        if (SortedSet.class.isAssignableFrom(this.getClazz())) {
            return RC.sortedSet((SortedSet)this.getCollection(), this.getType(), 10000L);
        }
        if (Set.class.isAssignableFrom(this.getClazz())) {
            return RC.set((Set)this.getCollection(), this.getType(), 10000L);
        }
        return RC.collection(this.getCollection(), this.getType(), 10000L);
    }

    abstract Ref getType();

    abstract Collection<Referrer<T>> getCollection();

    abstract Class getClazz();

    Collection<T> getSerialBuilt() {
        return this.serialBuilt;
    }

    Collection<T> setSerialBuilt(Collection<T> serialBuilt) {
        this.serialBuilt = serialBuilt;
        return serialBuilt;
    }

    boolean isBuilt() {
        return this.built;
    }

    void setBuilt() {
        this.built = true;
    }

    @Override
    public int hashCode() {
        if (this.getSerialBuilt() instanceof List || this.getSerialBuilt() instanceof Set) {
            return ((Object)this.getSerialBuilt()).hashCode();
        }
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (this.getSerialBuilt() instanceof List || this.getSerialBuilt() instanceof Set) {
            return ((Object)this.getSerialBuilt()).equals(o);
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.getSerialBuilt() != null) {
            return this.getSerialBuilt().iterator();
        }
        return new NullIterator();
    }

    @Override
    public int size() {
        if (this.getSerialBuilt() != null) {
            return this.getSerialBuilt().size();
        }
        return 0;
    }

    @Override
    public boolean add(T t) {
        if (this.getSerialBuilt() != null) {
            return this.getSerialBuilt().add(t);
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    final Object writeReplace() {
        if (this.isBuilt()) {
            return this.getSerialBuilt();
        }
        return this;
    }

    final Object readResolve() throws ObjectStreamException {
        try {
            return this.setSerialBuilt(this.build());
        }
        catch (InstantiationException ex) {
            throw new InvalidClassException(this.getClass().toString(), ex.fillInStackTrace().toString());
        }
        catch (IllegalAccessException ex) {
            throw new InvalidClassException(this.getClass().toString(), ex.fillInStackTrace().toString());
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if (this.getSerialBuilt() instanceof List) {
            return ((List)this.getSerialBuilt()).addAll(index, c);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T get(int index) {
        if (this.getSerialBuilt() instanceof List) {
            return (T)((List)this.getSerialBuilt()).get(index);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T set(int index, T element) {
        if (this.getSerialBuilt() instanceof List) {
            return ((List)this.getSerialBuilt()).set(index, element);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public void add(int index, T element) {
        if (this.getSerialBuilt() instanceof List) {
            ((List)this.getSerialBuilt()).add(index, element);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T remove(int index) {
        if (this.getSerialBuilt() instanceof List) {
            return (T)((List)this.getSerialBuilt()).remove(index);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public int indexOf(Object o) {
        if (this.getSerialBuilt() instanceof List) {
            return ((List)this.getSerialBuilt()).indexOf(o);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public int lastIndexOf(Object o) {
        if (this.getSerialBuilt() instanceof List) {
            return ((List)this.getSerialBuilt()).lastIndexOf(o);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public ListIterator<T> listIterator() {
        if (this.getSerialBuilt() instanceof List) {
            return ((List)this.getSerialBuilt()).listIterator();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        if (this.getSerialBuilt() instanceof List) {
            return ((List)this.getSerialBuilt()).listIterator(index);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        if (this.getSerialBuilt() instanceof List) {
            return ((List)this.getSerialBuilt()).subList(fromIndex, toIndex);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public Comparator<? super T> comparator() {
        if (this.getSerialBuilt() instanceof SortedSet) {
            return ((SortedSet)this.getSerialBuilt()).comparator();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public SortedSet<T> subSet(T fromElement, T toElement) {
        if (this.getSerialBuilt() instanceof SortedSet) {
            return ((SortedSet)this.getSerialBuilt()).subSet(fromElement, toElement);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public SortedSet<T> headSet(T toElement) {
        if (this.getSerialBuilt() instanceof SortedSet) {
            return ((SortedSet)this.getSerialBuilt()).headSet(toElement);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public SortedSet<T> tailSet(T fromElement) {
        if (this.getSerialBuilt() instanceof SortedSet) {
            return ((SortedSet)this.getSerialBuilt()).tailSet(fromElement);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T first() {
        if (this.getSerialBuilt() instanceof SortedSet) {
            return (T)((SortedSet)this.getSerialBuilt()).first();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T last() {
        if (this.getSerialBuilt() instanceof SortedSet) {
            return (T)((SortedSet)this.getSerialBuilt()).last();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T lower(T e) {
        if (this.getSerialBuilt() instanceof NavigableSet) {
            return ((NavigableSet)this.getSerialBuilt()).lower(e);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T floor(T e) {
        if (this.getSerialBuilt() instanceof NavigableSet) {
            return ((NavigableSet)this.getSerialBuilt()).floor(e);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T ceiling(T e) {
        if (this.getSerialBuilt() instanceof NavigableSet) {
            return ((NavigableSet)this.getSerialBuilt()).ceiling(e);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T higher(T e) {
        if (this.getSerialBuilt() instanceof NavigableSet) {
            return ((NavigableSet)this.getSerialBuilt()).higher(e);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T pollFirst() {
        if (this.getSerialBuilt() instanceof NavigableSet) {
            return (T)((NavigableSet)this.getSerialBuilt()).pollFirst();
        }
        if (this.getSerialBuilt() instanceof Deque) {
            return (T)((Deque)this.getSerialBuilt()).pollFirst();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T pollLast() {
        if (this.getSerialBuilt() instanceof NavigableSet) {
            return (T)((NavigableSet)this.getSerialBuilt()).pollLast();
        }
        if (this.getSerialBuilt() instanceof Deque) {
            return (T)((Deque)this.getSerialBuilt()).pollLast();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public NavigableSet<T> descendingSet() {
        if (this.getSerialBuilt() instanceof NavigableSet) {
            return ((NavigableSet)this.getSerialBuilt()).descendingSet();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public Iterator<T> descendingIterator() {
        if (this.getSerialBuilt() instanceof NavigableSet) {
            return ((NavigableSet)this.getSerialBuilt()).descendingIterator();
        }
        if (this.getSerialBuilt() instanceof Deque) {
            return ((Deque)this.getSerialBuilt()).descendingIterator();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public NavigableSet<T> subSet(T fromElement, boolean fromInclusive, T toElement, boolean toInclusive) {
        if (this.getSerialBuilt() instanceof NavigableSet) {
            return ((NavigableSet)this.getSerialBuilt()).subSet(fromElement, fromInclusive, toElement, toInclusive);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public NavigableSet<T> headSet(T toElement, boolean inclusive) {
        if (this.getSerialBuilt() instanceof NavigableSet) {
            return ((NavigableSet)this.getSerialBuilt()).headSet(toElement, inclusive);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public NavigableSet<T> tailSet(T fromElement, boolean inclusive) {
        if (this.getSerialBuilt() instanceof NavigableSet) {
            return ((NavigableSet)this.getSerialBuilt()).tailSet(fromElement, inclusive);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public boolean offer(T e) {
        if (this.getSerialBuilt() instanceof Queue) {
            return ((Queue)this.getSerialBuilt()).offer(e);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T remove() {
        if (this.getSerialBuilt() instanceof Queue) {
            return (T)((Queue)this.getSerialBuilt()).remove();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T poll() {
        if (this.getSerialBuilt() instanceof Queue) {
            return (T)((Queue)this.getSerialBuilt()).poll();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T element() {
        if (this.getSerialBuilt() instanceof Queue) {
            return (T)((Queue)this.getSerialBuilt()).element();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T peek() {
        if (this.getSerialBuilt() instanceof Queue) {
            return (T)((Queue)this.getSerialBuilt()).peek();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public void addFirst(T e) {
        if (this.getSerialBuilt() instanceof Deque) {
            ((Deque)this.getSerialBuilt()).addFirst(e);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public void addLast(T e) {
        if (this.getSerialBuilt() instanceof Deque) {
            ((Deque)this.getSerialBuilt()).addLast(e);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public boolean offerFirst(T e) {
        if (this.getSerialBuilt() instanceof Deque) {
            return ((Deque)this.getSerialBuilt()).offerFirst(e);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public boolean offerLast(T e) {
        if (this.getSerialBuilt() instanceof Deque) {
            return ((Deque)this.getSerialBuilt()).offerLast(e);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T removeFirst() {
        if (this.getSerialBuilt() instanceof Deque) {
            return (T)((Deque)this.getSerialBuilt()).removeFirst();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T removeLast() {
        if (this.getSerialBuilt() instanceof Deque) {
            return (T)((Deque)this.getSerialBuilt()).removeLast();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T getFirst() {
        if (this.getSerialBuilt() instanceof Deque) {
            return (T)((Deque)this.getSerialBuilt()).getFirst();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T getLast() {
        if (this.getSerialBuilt() instanceof Deque) {
            return (T)((Deque)this.getSerialBuilt()).getLast();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T peekFirst() {
        if (this.getSerialBuilt() instanceof Deque) {
            return (T)((Deque)this.getSerialBuilt()).peekFirst();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T peekLast() {
        if (this.getSerialBuilt() instanceof Deque) {
            return (T)((Deque)this.getSerialBuilt()).peekLast();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        if (this.getSerialBuilt() instanceof Deque) {
            return ((Deque)this.getSerialBuilt()).removeFirstOccurrence(o);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        if (this.getSerialBuilt() instanceof Deque) {
            return ((Deque)this.getSerialBuilt()).removeLastOccurrence(o);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public void push(T e) {
        if (this.getSerialBuilt() instanceof Deque) {
            ((Deque)this.getSerialBuilt()).push(e);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T pop() {
        if (this.getSerialBuilt() instanceof Deque) {
            return (T)((Deque)this.getSerialBuilt()).pop();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public void put(T e) throws InterruptedException {
        if (this.getSerialBuilt() instanceof BlockingQueue) {
            ((BlockingQueue)this.getSerialBuilt()).put(e);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.getSerialBuilt() instanceof BlockingQueue) {
            return ((BlockingQueue)this.getSerialBuilt()).offer(e, timeout, unit);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T take() throws InterruptedException {
        if (this.getSerialBuilt() instanceof BlockingQueue) {
            return (T)((BlockingQueue)this.getSerialBuilt()).take();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.getSerialBuilt() instanceof BlockingQueue) {
            return (T)((BlockingQueue)this.getSerialBuilt()).poll(timeout, unit);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public int remainingCapacity() {
        if (this.getSerialBuilt() instanceof BlockingQueue) {
            return ((BlockingQueue)this.getSerialBuilt()).remainingCapacity();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        if (this.getSerialBuilt() instanceof BlockingQueue) {
            return ((BlockingQueue)this.getSerialBuilt()).drainTo(c);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        if (this.getSerialBuilt() instanceof BlockingQueue) {
            return ((BlockingQueue)this.getSerialBuilt()).drainTo(c, maxElements);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public void putFirst(T e) throws InterruptedException {
        if (this.getSerialBuilt() instanceof BlockingDeque) {
            ((BlockingDeque)this.getSerialBuilt()).putFirst(e);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public void putLast(T e) throws InterruptedException {
        if (this.getSerialBuilt() instanceof BlockingDeque) {
            ((BlockingDeque)this.getSerialBuilt()).putLast(e);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public boolean offerFirst(T e, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.getSerialBuilt() instanceof BlockingDeque) {
            return ((BlockingDeque)this.getSerialBuilt()).offerFirst(e, timeout, unit);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public boolean offerLast(T e, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.getSerialBuilt() instanceof BlockingDeque) {
            return ((BlockingDeque)this.getSerialBuilt()).offerLast(e, timeout, unit);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T takeFirst() throws InterruptedException {
        if (this.getSerialBuilt() instanceof BlockingDeque) {
            return (T)((BlockingDeque)this.getSerialBuilt()).takeFirst();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T takeLast() throws InterruptedException {
        if (this.getSerialBuilt() instanceof BlockingDeque) {
            return (T)((BlockingDeque)this.getSerialBuilt()).takeLast();
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.getSerialBuilt() instanceof BlockingDeque) {
            return (T)((BlockingDeque)this.getSerialBuilt()).pollFirst(timeout, unit);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }

    @Override
    public T pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.getSerialBuilt() instanceof BlockingDeque) {
            return (T)((BlockingDeque)this.getSerialBuilt()).pollLast(timeout, unit);
        }
        throw new UnsupportedOperationException("Unsupported Interface Method.");
    }
}

