/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.Ref;
import au.net.zeus.collection.ReferenceCollection;
import au.net.zeus.collection.Referrer;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.NoSuchElementException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferencedQueue<T>
extends ReferenceCollection<T>
implements Queue<T> {
    private static final long serialVersionUID = 1L;
    private final Queue<Referrer<T>> queue;

    public ReferencedQueue(Queue<Referrer<T>> queue, Ref type, boolean gcThreads, long gcCycle) {
        super(queue, type, gcThreads, gcCycle);
        this.queue = queue;
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Builder required");
    }

    @Override
    public boolean offer(T e) {
        this.processQueue();
        Referrer<T> r = this.wrapObj(e, true, false);
        return this.queue.offer(r);
    }

    @Override
    public T remove() {
        this.processQueue();
        do {
            Referrer<T> r;
            T t;
            T t2 = t = (r = this.queue.remove()) == null ? null : (T)r.get();
            if (t == null) continue;
            return t;
        } while (!this.queue.isEmpty());
        throw new NoSuchElementException("Queue is empty");
    }

    @Override
    public T poll() {
        this.processQueue();
        do {
            Referrer<T> r;
            T t;
            T t2 = t = (r = this.queue.poll()) == null ? null : (T)r.get();
            if (t == null) continue;
            return t;
        } while (!this.queue.isEmpty());
        return null;
    }

    @Override
    public T element() {
        this.processQueue();
        Referrer<T> t = this.queue.element();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T peek() {
        this.processQueue();
        Referrer<T> t = this.queue.peek();
        if (t != null) {
            return t.get();
        }
        return null;
    }
}

