/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.fiddler;

import com.sun.jini.fiddler.Fiddler;
import com.sun.jini.fiddler.FiddlerLeaseMap;
import com.sun.jini.fiddler.ProxyUtil;
import com.sun.jini.lease.AbstractLease;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class FiddlerLease
extends AbstractLease
implements ReferentUuid {
    private static final long serialVersionUID = 2L;
    final Fiddler server;
    final Uuid serverID;
    final Uuid registrationID;
    final Uuid leaseID;

    public static FiddlerLease createLease(Fiddler server, Uuid serverID, Uuid registrationID, Uuid leaseID, long expiration) {
        if (server instanceof RemoteMethodControl) {
            return new ConstrainableFiddlerLease(server, serverID, registrationID, leaseID, expiration, null);
        }
        return new FiddlerLease(server, serverID, registrationID, leaseID, expiration);
    }

    private FiddlerLease(Fiddler server, Uuid serverID, Uuid registrationID, Uuid leaseID, long expiration) {
        super(expiration);
        this.server = server;
        this.serverID = serverID;
        this.registrationID = registrationID;
        this.leaseID = leaseID;
    }

    @Override
    public LeaseMap createLeaseMap(long duration) {
        return FiddlerLeaseMap.createLeaseMap(this, duration);
    }

    @Override
    public boolean canBatch(Lease lease) {
        return lease instanceof FiddlerLease && this.serverID.equals(((FiddlerLease)lease).serverID);
    }

    Fiddler getServer() {
        return this.server;
    }

    Uuid getServerID() {
        return this.serverID;
    }

    Uuid getRegistrationID() {
        return this.registrationID;
    }

    Uuid getLeaseID() {
        return this.leaseID;
    }

    void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    @Override
    public void cancel() throws UnknownLeaseException, RemoteException {
        this.server.cancelLease(this.registrationID, this.leaseID);
    }

    @Override
    protected long doRenew(long duration) throws UnknownLeaseException, RemoteException {
        return this.server.renewLease(this.registrationID, this.leaseID, duration);
    }

    @Override
    public Uuid getReferentUuid() {
        return this.leaseID;
    }

    public int hashCode() {
        return this.leaseID.hashCode();
    }

    public boolean equals(Object obj) {
        return ReferentUuids.compare(this, obj);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.server == null) {
            throw new InvalidObjectException("FiddlerLease.readObject failure - server field is null");
        }
        if (this.serverID == null) {
            throw new InvalidObjectException("FiddlerLease.readObject failure - serverID field is null");
        }
        if (this.registrationID == null) {
            throw new InvalidObjectException("FiddlerLease.readObject failure - registrationID field is null");
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data found when attempting to deserialize FiddlerLease instance");
    }

    static final class ConstrainableFiddlerLease
    extends FiddlerLease
    implements RemoteMethodControl {
        static final long serialVersionUID = 2L;
        private static final Method renewMethod = ProxyUtil.getMethod(Lease.class, "renew", new Class[]{Long.TYPE});
        private static final Method cancelMethod = ProxyUtil.getMethod(Lease.class, "cancel", new Class[0]);
        private static final Method[] methodMapArray = new Method[]{renewMethod, ProxyUtil.getMethod(Fiddler.class, "renewLease", new Class[]{Uuid.class, Uuid.class, Long.TYPE}), cancelMethod, ProxyUtil.getMethod(Fiddler.class, "cancelLease", new Class[]{Uuid.class, Uuid.class})};
        private static final Method[] canBatchMethodMapArray = new Method[]{renewMethod, renewMethod, cancelMethod, cancelMethod};
        private MethodConstraints methodConstraints;

        private ConstrainableFiddlerLease(Fiddler server, Uuid serverID, Uuid registrationID, Uuid leaseID, long expiration, MethodConstraints methodConstraints) {
            super(ConstrainableFiddlerLease.constrainServer(server, methodConstraints), serverID, registrationID, leaseID, expiration);
            this.methodConstraints = methodConstraints;
        }

        @Override
        public boolean canBatch(Lease lease) {
            if (!super.canBatch(lease)) {
                return false;
            }
            if (!(lease instanceof ConstrainableFiddlerLease)) {
                return false;
            }
            return ConstrainableProxyUtil.equivalentConstraints(this.methodConstraints, ((ConstrainableFiddlerLease)lease).methodConstraints, canBatchMethodMapArray);
        }

        private static Fiddler constrainServer(Fiddler server, MethodConstraints constraints) {
            MethodConstraints newConstraints = ConstrainableProxyUtil.translateConstraints(constraints, methodMapArray);
            RemoteMethodControl constrainedServer = ((RemoteMethodControl)((Object)server)).setConstraints(newConstraints);
            return (Fiddler)((Object)constrainedServer);
        }

        @Override
        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableFiddlerLease(this.server, this.serverID, this.registrationID, this.leaseID, this.expiration, constraints);
        }

        @Override
        public MethodConstraints getConstraints() {
            return this.methodConstraints;
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator(this.server);
        }

        @Override
        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            ConstrainableProxyUtil.verifyConsistentConstraints(this.methodConstraints, this.server, methodMapArray);
        }
    }
}

