/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.fiddler;

import com.sun.jini.fiddler.Fiddler;
import com.sun.jini.fiddler.FiddlerLease;
import com.sun.jini.fiddler.FiddlerRenewResults;
import com.sun.jini.fiddler.ProxyUtil;
import com.sun.jini.lease.AbstractLeaseMap;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMapException;
import net.jini.id.Uuid;

class FiddlerLeaseMap
extends AbstractLeaseMap {
    final Fiddler server;
    final Uuid serverID;

    static FiddlerLeaseMap createLeaseMap(FiddlerLease lease, long duration) {
        if (lease instanceof FiddlerLease.ConstrainableFiddlerLease) {
            MethodConstraints leaseConstraints = ((FiddlerLease.ConstrainableFiddlerLease)lease).getConstraints();
            return new ConstrainableFiddlerLeaseMap(lease.getServer(), lease, duration, leaseConstraints);
        }
        return new FiddlerLeaseMap(lease.getServer(), lease, duration);
    }

    private FiddlerLeaseMap(Fiddler server, FiddlerLease lease, long duration) {
        super(lease, duration);
        this.server = server;
        this.serverID = lease.getServerID();
    }

    @Override
    public boolean canContainKey(Object key) {
        return key instanceof FiddlerLease && this.serverID.equals(((FiddlerLease)key).getServerID());
    }

    @Override
    public void renewAll() throws LeaseMapException, RemoteException {
        int size = this.map.size();
        if (size == 0) {
            return;
        }
        Uuid[] registrationIDs = new Uuid[size];
        Uuid[] leaseIDs = new Uuid[size];
        long[] durations = new long[size];
        int i = 0;
        for (Map.Entry e : this.map.entrySet()) {
            FiddlerLease ls = (FiddlerLease)e.getKey();
            registrationIDs[i] = ls.getRegistrationID();
            leaseIDs[i] = ls.getLeaseID();
            durations[i] = (Long)e.getValue();
            ++i;
        }
        FiddlerRenewResults results = this.server.renewLeases(registrationIDs, leaseIDs, durations);
        long now = System.currentTimeMillis();
        HashMap emap = results.exceptions != null ? new HashMap(2 * results.exceptions.length + 1) : null;
        i = 0;
        int j = 0;
        Iterator iter2 = this.map.entrySet().iterator();
        while (iter2.hasNext()) {
            Map.Entry e = iter2.next();
            long duration = results.durations[i];
            if (duration >= 0L) {
                ((FiddlerLease)e.getKey()).setExpiration(duration + now);
            } else {
                emap.put(e.getKey(), results.exceptions[j++]);
                iter2.remove();
            }
            ++i;
        }
        if (emap != null) {
            throw new LeaseMapException("lease renewal failures", emap);
        }
    }

    @Override
    public void cancelAll() throws LeaseMapException, RemoteException {
        int size = this.map.size();
        if (size == 0) {
            return;
        }
        Uuid[] registrationIDs = new Uuid[size];
        Uuid[] leaseIDs = new Uuid[size];
        int i = 0;
        for (FiddlerLease ls : this.map.keySet()) {
            registrationIDs[i] = ls.getRegistrationID();
            leaseIDs[i] = ls.getLeaseID();
            ++i;
        }
        Exception[] exceptions = this.server.cancelLeases(registrationIDs, leaseIDs);
        if (exceptions == null) {
            return;
        }
        i = 0;
        HashMap<FiddlerLease, Exception> emap = new HashMap<FiddlerLease, Exception>(13);
        Iterator iter2 = this.map.keySet().iterator();
        while (iter2.hasNext()) {
            FiddlerLease ls = (FiddlerLease)iter2.next();
            Exception ex = exceptions[i];
            if (ex != null) {
                emap.put(ls, ex);
                iter2.remove();
            }
            ++i;
        }
        throw new LeaseMapException("lease cancellation failures", emap);
    }

    static final class ConstrainableFiddlerLeaseMap
    extends FiddlerLeaseMap {
        private static final Method renewMethod = ProxyUtil.getMethod(Lease.class, "renew", new Class[]{Long.TYPE});
        private static final Method cancelMethod = ProxyUtil.getMethod(Lease.class, "cancel", new Class[0]);
        private static final Method[] methodMapArray = new Method[]{renewMethod, ProxyUtil.getMethod(Fiddler.class, "renewLeases", new Class[]{Uuid[].class, Uuid[].class, long[].class}), cancelMethod, ProxyUtil.getMethod(Fiddler.class, "cancelLeases", new Class[]{Uuid[].class, Uuid[].class})};
        private static final Method[] canContainKeyMethodMapArray = new Method[]{renewMethod, renewMethod, cancelMethod, cancelMethod};
        private MethodConstraints methodConstraints;

        private ConstrainableFiddlerLeaseMap(Fiddler server, FiddlerLease lease, long duration, MethodConstraints methodConstraints) {
            super(ConstrainableFiddlerLeaseMap.constrainServer(server, methodConstraints), lease, duration);
            this.methodConstraints = methodConstraints;
        }

        @Override
        public boolean canContainKey(Object key) {
            if (!super.canContainKey(key)) {
                return false;
            }
            if (!(key instanceof FiddlerLease.ConstrainableFiddlerLease)) {
                return false;
            }
            MethodConstraints keyConstraints = ((FiddlerLease.ConstrainableFiddlerLease)key).getConstraints();
            return ConstrainableProxyUtil.equivalentConstraints(this.methodConstraints, keyConstraints, canContainKeyMethodMapArray);
        }

        private static Fiddler constrainServer(Fiddler server, MethodConstraints constraints) {
            MethodConstraints newConstraints = ConstrainableProxyUtil.translateConstraints(constraints, methodMapArray);
            RemoteMethodControl constrainedServer = ((RemoteMethodControl)((Object)server)).setConstraints(newConstraints);
            return (Fiddler)((Object)constrainedServer);
        }
    }
}

