/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.jeri.internal.runtime.Binding;
import com.sun.jini.jeri.internal.runtime.ObjectTable;
import com.sun.jini.jeri.internal.runtime.SameClassKey;
import com.sun.jini.jeri.internal.runtime.Target;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jini.id.Uuid;
import net.jini.jeri.Endpoint;
import net.jini.jeri.InvocationDispatcher;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;

public final class BasicExportTable {
    private final ObjectTable objectTable = new ObjectTable();
    private final ConcurrentMap<SameClassKey, Binding> listenPool = new ConcurrentHashMap<SameClassKey, Binding>(128);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry export(Remote impl, ServerEndpoint serverEndpoint, boolean allowDGC, boolean keepAlive, Uuid id) throws ExportException {
        Endpoint endpoint;
        List bindings = null;
        Target target = null;
        try {
            LC listenContext = new LC();
            try {
                endpoint = serverEndpoint.enumerateListenEndpoints(listenContext);
            }
            catch (IOException e) {
                throw new ExportException("listen failed", e);
            }
            finally {
                bindings = listenContext.getFinalBindings();
            }
            RequestDispatcher[] requestDispatchers = new RequestDispatcher[bindings.size()];
            for (int i = 0; i < requestDispatchers.length; ++i) {
                requestDispatchers[i] = ((Binding)bindings.get(i)).getRequestDispatcher();
            }
            target = this.objectTable.export(impl, requestDispatchers, allowDGC, keepAlive, id);
        }
        finally {
            if (bindings != null) {
                for (int i = 0; i < bindings.size(); ++i) {
                    Binding binding = (Binding)bindings.get(i);
                    binding.decrementExportInProgress();
                    if (target != null) continue;
                    binding.checkReferenced();
                }
            }
        }
        return new Entry(bindings, target, endpoint);
    }

    private Binding getBinding(ServerEndpoint.ListenEndpoint listenEndpoint) throws IOException {
        SameClassKey key = new SameClassKey(listenEndpoint);
        Binding binding = null;
        while (binding == null) {
            binding = (Binding)this.listenPool.get(key);
            if (binding == null) {
                boolean active;
                binding = new Binding(listenEndpoint, this.objectTable, this.listenPool);
                Binding existed = this.listenPool.putIfAbsent(key, binding);
                if (existed != null) {
                    binding = existed;
                    active = binding.incrementExportInProgress();
                    if (active) continue;
                    binding = null;
                    continue;
                }
                active = binding.activate();
                if (active) continue;
                binding = null;
                continue;
            }
            boolean active = binding.incrementExportInProgress();
            if (active) continue;
            binding = null;
        }
        binding.activate();
        return binding;
    }

    private class LC
    implements ServerEndpoint.ListenContext {
        private volatile boolean done = false;
        private final List<Binding> bindings = Collections.synchronizedList(new ArrayList());

        LC() {
        }

        @Override
        public ServerEndpoint.ListenCookie addListenEndpoint(ServerEndpoint.ListenEndpoint listenEndpoint) throws IOException {
            if (this.done) {
                throw new IllegalStateException();
            }
            listenEndpoint.checkPermissions();
            Binding binding = BasicExportTable.this.getBinding(listenEndpoint);
            this.bindings.add(binding);
            return binding.getListenHandle().getCookie();
        }

        private List getFinalBindings() {
            this.done = true;
            return this.bindings;
        }
    }

    public static final class Entry {
        private final List bindings;
        private final Target target;
        private final Endpoint endpoint;

        Entry(List bindings, Target target, Endpoint endpoint) {
            this.bindings = bindings;
            this.target = target;
            this.endpoint = endpoint;
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public void setInvocationDispatcher(InvocationDispatcher id) {
            this.target.setInvocationDispatcher(id);
        }

        public boolean unexport(boolean force) {
            if (!this.target.unexport(force)) {
                return false;
            }
            for (int i = 0; i < this.bindings.size(); ++i) {
                ((Binding)this.bindings.get(i)).checkReferenced();
            }
            return true;
        }
    }
}

