/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.jeri.internal.runtime.Target;
import com.sun.jini.jeri.internal.runtime.WeakKey;
import com.sun.jini.thread.NewThreadAction;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.rmi.Remote;
import java.rmi.server.Unreferenced;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.security.SecurityContext;

final class ImplRefManager {
    private static final Logger logger = Logger.getLogger("net.jini.jeri.BasicJeriExporter");
    private final ReferenceQueue reapQueue = new ReferenceQueue();
    private final Object lock = new Object();
    private final Map<Reference, ImplRef> weakImplTable = new HashMap<Reference, ImplRef>();
    private Thread reaper = null;
    private boolean interruptible = false;

    ImplRefManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImplRef getImplRef(Remote impl, Target target) {
        WeakKey lookupKey = new WeakKey(impl, this.reapQueue);
        Object object = this.lock;
        synchronized (object) {
            ImplRef implRef = this.weakImplTable.get(lookupKey);
            if (implRef == null) {
                implRef = new ImplRef(lookupKey);
                this.weakImplTable.put(lookupKey, implRef);
                if (this.reaper == null) {
                    this.reaper = (Thread)AccessController.doPrivileged(new NewThreadAction(new Reaper(), "Reaper", true));
                    this.reaper.start();
                }
            } else {
                lookupKey.clear();
            }
            implRef.addTarget(target);
            return implRef;
        }
    }

    static /* synthetic */ boolean access$702(ImplRefManager x0, boolean x1) {
        x0.interruptible = x1;
        return x0.interruptible;
    }

    static /* synthetic */ ReferenceQueue access$800(ImplRefManager x0) {
        return x0.reapQueue;
    }

    private class Reaper
    implements Runnable {
        private Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block14: while (true) {
                var1_1 = ImplRefManager.access$400(ImplRefManager.this);
                synchronized (var1_1) {
                    if (ImplRefManager.access$600(ImplRefManager.this) != Thread.currentThread()) {
                        break;
                    }
                    ImplRefManager.access$702(ImplRefManager.this, true);
                }
                try {
                    weakRef = ImplRefManager.access$800(ImplRefManager.this).remove();
                }
                catch (InterruptedException e) {
                    var3_5 = ImplRefManager.access$400(ImplRefManager.this);
                    synchronized (var3_5) {
                        ImplRefManager.access$702(ImplRefManager.this, false);
                        break;
                    }
                }
                var3_5 = ImplRefManager.access$400(ImplRefManager.this);
                synchronized (var3_5) {
                    ImplRefManager.access$702(ImplRefManager.this, false);
                    Thread.interrupted();
                    implRef = (ImplRef)ImplRefManager.access$500(ImplRefManager.this).get(weakRef);
                    if (implRef == null) {
                        continue;
                    }
                    if (!Reaper.$assertionsDisabled && ImplRef.access$900(implRef)) {
                        throw new AssertionError();
                    }
                    var5_8 = implRef;
                    synchronized (var5_8) {
                        if (!Reaper.$assertionsDisabled && ImplRef.access$1000(implRef)) {
                            throw new AssertionError();
                        }
                        collectedTargets = ImplRef.access$1100(implRef);
                        ImplRef.access$1200(implRef);
                        if (ImplRefManager.access$300().isLoggable(Level.FINEST)) {
                            ImplRefManager.access$300().log(Level.FINEST, "implRef={0}, targets={1}", new Object[]{implRef, collectedTargets});
                        }
                    }
                }
                i = collectedTargets.iterator();
                while (true) {
                    if (i.hasNext()) ** break;
                    continue block14;
                    ((Target)i.next()).collect();
                }
                break;
            }
        }
    }

    final class ImplRef {
        private final Reference weakRef;
        private boolean removed = false;
        private final Set targets = new HashSet(1);
        private final Set pinningTargets = new HashSet(1);
        private Remote strongRef = null;

        private ImplRef(Reference weakRef) {
            this.weakRef = weakRef;
        }

        private synchronized void addTarget(Target target) {
            assert (!this.targets.contains(target));
            this.targets.add(target);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "this={0}, target={1}", new Object[]{this, target});
            }
        }

        Remote getImpl() {
            return (Remote)this.weakRef.get();
        }

        synchronized void pin(Target target) {
            assert (target.getEnableDGC());
            assert (this.targets.contains(target));
            if (this.pinningTargets.isEmpty()) {
                assert (this.strongRef == null);
                this.strongRef = (Remote)this.weakRef.get();
            }
            assert (this.strongRef != null);
            assert (!this.pinningTargets.contains(target));
            this.pinningTargets.add(target);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "this={0}, target={1}, pin count now {2}", new Object[]{this, target, this.pinningTargets.size()});
            }
        }

        synchronized void unpin(Target target) {
            assert (target.getEnableDGC());
            assert (this.targets.contains(target));
            assert (this.pinningTargets.contains(target));
            this.pinningTargets.remove(target);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "this={0}, target={1}, pin count now {2}", new Object[]{this, target, this.pinningTargets.size()});
            }
            if (this.pinningTargets.isEmpty()) {
                assert (this.strongRef != null);
                this.invokeUnreferenced(target);
                this.strongRef = null;
            }
        }

        private void invokeUnreferenced(final Target target) {
            assert (Thread.holdsLock(this));
            assert (this.strongRef != null);
            assert (target.getEnableDGC());
            assert (this.targets.contains(target));
            if (this.strongRef instanceof Unreferenced) {
                final Unreferenced obj = (Unreferenced)((Object)this.strongRef);
                final Thread t = (Thread)AccessController.doPrivileged(new NewThreadAction(new Runnable(){

                    @Override
                    public void run() {
                        SecurityContext securityContext = target.getSecurityContext();
                        AccessController.doPrivileged(securityContext.wrap(new PrivilegedAction(){

                            public Object run() {
                                obj.unreferenced();
                                return null;
                            }
                        }), securityContext.getAccessControlContext());
                    }
                }, "Unreferenced", false, true));
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        t.setContextClassLoader(target.getContextClassLoader());
                        return null;
                    }
                });
                t.start();
            }
        }

        private boolean isPinned() {
            assert (Thread.holdsLock(this));
            return !this.pinningTargets.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release(Target target) {
            Object object = ImplRefManager.this.lock;
            synchronized (object) {
                if (this.removed) {
                    return;
                }
                ImplRef implRef = this;
                synchronized (implRef) {
                    boolean moreTargetsLeft;
                    assert (this.targets.contains(target));
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "this={0}, target={1}", new Object[]{this, target});
                    }
                    this.targets.remove(target);
                    boolean bl = moreTargetsLeft = !this.targets.isEmpty();
                    if (this.pinningTargets.remove(target) && this.pinningTargets.isEmpty()) {
                        assert (this.strongRef != null);
                        if (moreTargetsLeft) {
                            for (Target t : this.targets) {
                                if (!t.getEnableDGC()) continue;
                                this.invokeUnreferenced(t);
                                break;
                            }
                        }
                        this.strongRef = null;
                    }
                    if (!moreTargetsLeft) {
                        this.remove();
                    }
                }
            }
        }

        private void remove() {
            assert (Thread.holdsLock(ImplRefManager.this.lock));
            assert (!this.removed);
            assert (ImplRefManager.this.weakImplTable.get(this.weakRef) == this);
            ImplRefManager.this.weakImplTable.remove(this.weakRef);
            this.removed = true;
            if (ImplRefManager.this.weakImplTable.size() == 0) {
                assert (ImplRefManager.this.reaper != null);
                if (ImplRefManager.this.interruptible) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            ImplRefManager.this.reaper.interrupt();
                            return null;
                        }
                    });
                }
                ImplRefManager.this.reaper = null;
            }
        }

        public String toString() {
            return "ImplRef@" + Integer.toHexString(this.hashCode()) + "[" + this.getImpl() + "]";
        }

        static /* synthetic */ boolean access$900(ImplRef x0) {
            return x0.removed;
        }

        static /* synthetic */ boolean access$1000(ImplRef x0) {
            return x0.isPinned();
        }

        static /* synthetic */ Set access$1100(ImplRef x0) {
            return x0.targets;
        }

        static /* synthetic */ void access$1200(ImplRef x0) {
            x0.remove();
        }
    }
}

