/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.logging.Levels;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.security.AccessController;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SelectionManager {
    private static final int concurrency = 1;
    private static final Logger logger = Logger.getLogger("com.sun.jini.jeri.internal.runtime.SelectionManager");
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private final Selector selector;
    private final Pipe.SinkChannel wakeupPipeSink;
    private final Pipe.SourceChannel wakeupPipeSource;
    private final SelectionKey wakeupPipeKey;
    private final ByteBuffer wakeupBuffer = ByteBuffer.allocate(2);
    private final Map registeredChannels = Collections.synchronizedMap(new WeakHashMap());
    private final Object lock = new Object();
    private Thread selectingThread = null;
    private boolean wakeupPending = false;
    private Key renewQueue = null;
    private Key readyQueue = null;
    private final int[] renewMaskRef = new int[1];

    public SelectionManager() throws IOException {
        this.selector = Selector.open();
        Pipe pipe = Pipe.open();
        this.wakeupPipeSink = pipe.sink();
        this.wakeupPipeSource = pipe.source();
        this.wakeupPipeSource.configureBlocking(false);
        this.wakeupPipeKey = this.wakeupPipeSource.register(this.selector, 1);
        for (int i = 0; i < 1; ++i) {
            systemThreadPool.execute(new SelectLoop(), "I/O SelectionManager-" + i);
        }
    }

    public Key register(SelectableChannel channel, SelectionHandler handler) {
        if (this.registeredChannels.containsKey(channel)) {
            throw new IllegalStateException("channel already registered");
        }
        Key key = new Key(channel, handler);
        this.registeredChannels.put(channel, null);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Key waitForReadyKey(int[] readyMaskOut) throws InterruptedException {
        Key key;
        Object object;
        Set<SelectionKey> selectedKeys;
        boolean needToClearSelectingThread;
        block38: {
            assert (!Thread.holdsLock(this.lock));
            if (!$assertionsDisabled) {
                if (readyMaskOut == null) throw new AssertionError();
                if (readyMaskOut.length != 1) {
                    throw new AssertionError();
                }
            }
            needToClearSelectingThread = false;
            selectedKeys = this.selector.selectedKeys();
            object = this.lock;
            // MONITORENTER : object
            while (this.isReadyQueueEmpty() && this.selectingThread != null) {
                this.lock.wait();
            }
            if (this.isReadyQueueEmpty()) break block38;
            Key readyKey = this.removeFromReadyQueue(readyMaskOut);
            this.lock.notify();
            Key key2 = readyKey;
            // MONITOREXIT : object
            if (!needToClearSelectingThread) return key2;
            Object object2 = this.lock;
            // MONITORENTER : object2
            if (this.wakeupPending && selectedKeys.contains(this.wakeupPipeKey)) {
                this.drainWakeupPipe();
                this.wakeupPending = false;
                selectedKeys.remove(this.wakeupPipeKey);
            }
            this.selectingThread = null;
            needToClearSelectingThread = false;
            this.lock.notify();
            // MONITOREXIT : object2
            return key2;
        }
        try {
            assert (this.selectingThread == null);
            this.selectingThread = Thread.currentThread();
            needToClearSelectingThread = true;
            this.processRenewQueue();
            // MONITOREXIT : object
            while (true) {
                try {
                    int n = this.selector.select();
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                }
                catch (Error e) {
                    String message = e.getMessage();
                    if (message == null) throw e;
                    if (!message.startsWith("POLLNVAL")) throw e;
                    Thread.sleep(100L);
                    continue;
                }
                catch (CancelledKeyException e) {
                    continue;
                }
                catch (NullPointerException e) {
                    continue;
                }
                catch (IOException e) {
                    logger.log(Levels.HANDLED, "thrown by select, continuing", e);
                    continue;
                }
                object = this.lock;
                // MONITORENTER : object
                if (this.wakeupPending && selectedKeys.contains(this.wakeupPipeKey)) {
                    this.drainWakeupPipe();
                    this.wakeupPending = false;
                    selectedKeys.remove(this.wakeupPipeKey);
                }
                if (!selectedKeys.isEmpty()) break;
                this.processRenewQueue();
                // MONITOREXIT : object
            }
            this.selectingThread = null;
            needToClearSelectingThread = false;
            this.lock.notify();
            Iterator<SelectionKey> iter2 = selectedKeys.iterator();
            assert (iter2.hasNext());
            while (iter2.hasNext()) {
                SelectionKey selectionKey = iter2.next();
                Key key3 = (Key)selectionKey.attachment();
                int readyMask = 0;
                try {
                    readyMask = selectionKey.readyOps();
                    assert (readyMask != 0);
                    assert ((key3.interestMask & readyMask) == readyMask);
                    int newInterestMask = key3.interestMask & ~readyMask;
                    assert (key3.interestMask == selectionKey.interestOps());
                    key3.selectionKey.interestOps(newInterestMask);
                    key3.interestMask = newInterestMask;
                }
                catch (CancelledKeyException e) {
                    readyMask |= key3.interestMask;
                    key3.interestMask = 0;
                }
                this.addOrUpdateReadyQueue(key3, readyMask);
                iter2.remove();
            }
            key = this.removeFromReadyQueue(readyMaskOut);
            // MONITOREXIT : object
            if (!needToClearSelectingThread) return key;
            Object object3 = this.lock;
        }
        catch (Throwable throwable) {
            if (!needToClearSelectingThread) throw throwable;
            Object object4 = this.lock;
            // MONITORENTER : object4
            if (this.wakeupPending && selectedKeys.contains(this.wakeupPipeKey)) {
                this.drainWakeupPipe();
                this.wakeupPending = false;
                selectedKeys.remove(this.wakeupPipeKey);
            }
            this.selectingThread = null;
            needToClearSelectingThread = false;
            this.lock.notify();
            // MONITOREXIT : object4
            throw throwable;
        }
        if (this.wakeupPending && selectedKeys.contains(this.wakeupPipeKey)) {
            this.drainWakeupPipe();
            this.wakeupPending = false;
            selectedKeys.remove(this.wakeupPipeKey);
        }
        this.selectingThread = null;
        needToClearSelectingThread = false;
        this.lock.notify();
        // MONITOREXIT : object3
        return key;
    }

    private void wakeupSelector() {
        assert (Thread.holdsLock(this.lock));
        assert (!this.wakeupPending);
        this.wakeupBuffer.clear().limit(1);
        try {
            this.wakeupPipeSink.write(this.wakeupBuffer);
        }
        catch (IOException e) {
            AssertionError error = new AssertionError((Object)"unexpected I/O exception");
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
    }

    private void drainWakeupPipe() {
        assert (Thread.holdsLock(this.lock));
        assert (this.selectingThread != null);
        do {
            this.wakeupBuffer.clear();
            try {
                this.wakeupPipeSource.read(this.wakeupBuffer);
            }
            catch (IOException e) {
                AssertionError error = new AssertionError((Object)"unexpected I/O exception");
                ((Throwable)((Object)error)).initCause(e);
                throw error;
            }
        } while (!this.wakeupBuffer.hasRemaining());
    }

    private void processRenewQueue() {
        assert (Thread.holdsLock(this.lock));
        assert (this.selectingThread != null);
        while (!this.isRenewQueueEmpty()) {
            Key key = this.removeFromRenewQueue(this.renewMaskRef);
            int renewMask = this.renewMaskRef[0];
            assert (renewMask != 0);
            if (key.selectionKey == null) {
                assert (key.interestMask == 0 && key.readyMask == 0);
                try {
                    key.selectionKey = key.channel.register(this.selector, renewMask);
                    key.selectionKey.attach(key);
                    key.interestMask = renewMask;
                }
                catch (ClosedChannelException e) {
                    this.addOrUpdateReadyQueue(key, renewMask);
                }
                catch (IllegalBlockingModeException e) {
                    this.addOrUpdateReadyQueue(key, renewMask);
                }
                continue;
            }
            assert ((key.interestMask & renewMask) == 0);
            int newInterestMask = key.interestMask | renewMask;
            try {
                assert (key.interestMask == key.selectionKey.interestOps());
                key.selectionKey.interestOps(newInterestMask);
                key.interestMask = newInterestMask;
            }
            catch (CancelledKeyException e) {
                this.addOrUpdateReadyQueue(key, newInterestMask);
                key.interestMask = 0;
            }
            assert ((key.interestMask & key.readyMask) == 0);
        }
    }

    private boolean isRenewQueueEmpty() {
        assert (Thread.holdsLock(this.lock));
        return this.renewQueue == null;
    }

    private Key removeFromRenewQueue(int[] renewMaskOut) {
        assert (renewMaskOut != null && renewMaskOut.length == 1);
        assert (Thread.holdsLock(this.lock));
        Key key = this.renewQueue;
        assert (key != null);
        assert (key.onRenewQueue);
        assert (key.renewMask != 0);
        renewMaskOut[0] = key.renewMask;
        key.renewMask = 0;
        this.renewQueue = key.renewQueueNext;
        key.renewQueueNext = null;
        key.onRenewQueue = false;
        return key;
    }

    private void addOrUpdateRenewQueue(Key key, int newRenewMask) {
        assert (newRenewMask != 0);
        assert (Thread.holdsLock(this.lock));
        if (!key.onRenewQueue) {
            assert (key.renewMask == 0);
            assert (key.renewQueueNext == null);
            key.renewMask = newRenewMask;
            key.renewQueueNext = this.renewQueue;
            this.renewQueue = key;
            key.onRenewQueue = true;
        } else {
            assert (key.renewMask != 0);
            assert ((key.renewMask & newRenewMask) == 0);
            key.renewMask |= newRenewMask;
        }
    }

    private boolean isReadyQueueEmpty() {
        assert (Thread.holdsLock(this.lock));
        return this.readyQueue == null;
    }

    private Key removeFromReadyQueue(int[] readyMaskOut) {
        assert (readyMaskOut != null && readyMaskOut.length == 1);
        assert (Thread.holdsLock(this.lock));
        Key key = this.readyQueue;
        assert (key != null);
        assert (key.onReadyQueue);
        assert (key.readyMask != 0);
        readyMaskOut[0] = key.readyMask;
        key.readyMask = 0;
        this.readyQueue = key.readyQueueNext;
        key.readyQueueNext = null;
        key.onReadyQueue = false;
        return key;
    }

    private void addOrUpdateReadyQueue(Key key, int newReadyMask) {
        assert (newReadyMask != 0);
        assert (Thread.holdsLock(this.lock));
        if (!key.onReadyQueue) {
            assert (key.readyMask == 0);
            assert (key.readyQueueNext == null);
            key.readyMask = newReadyMask;
            key.readyQueueNext = this.readyQueue;
            this.readyQueue = key;
            key.onReadyQueue = true;
        } else {
            assert (key.readyMask != 0);
            assert ((key.readyMask & newReadyMask) == 0);
            key.readyMask |= newReadyMask;
        }
    }

    private class SelectLoop
    implements Runnable {
        private long lastExceptionTime = 0L;
        private int recentExceptionCount;

        private SelectLoop() {
        }

        @Override
        public void run() {
            int[] readyMaskRef = new int[1];
            while (true) {
                try {
                    while (true) {
                        Key readyKey = SelectionManager.this.waitForReadyKey(readyMaskRef);
                        readyKey.handler.handleSelection(readyMaskRef[0], readyKey);
                    }
                }
                catch (Throwable t) {
                    try {
                        logger.log(Level.WARNING, "select loop throws", t);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.throttleLoopOnException();
                    continue;
                }
                break;
            }
        }

        private void throttleLoopOnException() {
            long now = System.currentTimeMillis();
            if (this.lastExceptionTime == 0L || now - this.lastExceptionTime > 5000L) {
                this.lastExceptionTime = now;
                this.recentExceptionCount = 0;
            } else if (++this.recentExceptionCount >= 10) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public final class Key {
        final SelectableChannel channel;
        final SelectionHandler handler;
        SelectionKey selectionKey = null;
        int interestMask = 0;
        boolean onRenewQueue = false;
        Key renewQueueNext = null;
        int renewMask = 0;
        boolean onReadyQueue = false;
        Key readyQueueNext = null;
        int readyMask = 0;

        Key(SelectableChannel channel, SelectionHandler handler) {
            this.channel = channel;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void renewInterestMask(int mask) throws ClosedChannelException {
            if (!this.channel.isOpen()) {
                throw new ClosedChannelException();
            }
            if ((mask & ~this.channel.validOps()) != 0) {
                throw new IllegalArgumentException("invalid mask " + mask + " (valid mask " + this.channel.validOps() + ")");
            }
            if (this.channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            Object object = SelectionManager.this.lock;
            synchronized (object) {
                int delta = mask & ~(this.renewMask | this.interestMask | this.readyMask);
                if (delta != 0) {
                    SelectionManager.this.addOrUpdateRenewQueue(this, delta);
                    if (SelectionManager.this.selectingThread != null && !SelectionManager.this.wakeupPending) {
                        SelectionManager.this.wakeupSelector();
                        SelectionManager.this.wakeupPending = true;
                    }
                }
            }
        }
    }

    public static interface SelectionHandler {
        public void handleSelection(int var1, Key var2);
    }
}

