/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryTransition;
import com.sun.jini.outrigger.EventRegistrationRecord;
import com.sun.jini.outrigger.EventSender;
import com.sun.jini.outrigger.TemplateHandle;
import com.sun.jini.outrigger.TransitionWatcher;
import java.io.IOException;
import java.rmi.MarshalledObject;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.id.Uuid;
import net.jini.security.ProxyPreparer;
import net.jini.space.JavaSpace;

abstract class EventRegistrationWatcher
extends TransitionWatcher
implements EventRegistrationRecord {
    long expiration;
    Uuid cookie;
    MarshalledObject handback;
    long eventID;
    private long currentSeqNum = 0L;
    long lastSeqNumDelivered = -1L;
    private TemplateHandle owner;

    EventRegistrationWatcher(long timestamp, long startOrdinal, long currentSeqNum) {
        super(timestamp, startOrdinal);
        this.currentSeqNum = currentSeqNum;
    }

    EventRegistrationWatcher(long timestamp, long startOrdinal, Uuid cookie, MarshalledObject handback, long eventID) {
        super(timestamp, startOrdinal);
        if (cookie == null) {
            throw new NullPointerException("cookie must be non-null");
        }
        this.cookie = cookie;
        this.handback = handback;
        this.eventID = eventID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void process(EntryTransition transition, long now) {
        boolean doneFor = false;
        EventRegistrationWatcher eventRegistrationWatcher = this;
        synchronized (eventRegistrationWatcher) {
            if (this.owner == null) {
                return;
            }
            if (now > this.expiration) {
                doneFor = true;
            } else {
                ++this.currentSeqNum;
                this.owner.getServer().enqueueDelivery(new BasicEventSender());
            }
        }
        if (doneFor) {
            this.cancel();
        }
    }

    abstract RemoteEventListener getListener(ProxyPreparer var1) throws ClassNotFoundException, IOException;

    @Override
    boolean addTemplateHandle(TemplateHandle h) {
        if (h == null) {
            throw new NullPointerException("TemplateHandle must be non-null");
        }
        if (this.owner != null) {
            throw new AssertionError((Object)"Can only call addTemplateHandle once");
        }
        this.owner = h;
        return true;
    }

    @Override
    public void setExpiration(long newExpiration) {
        this.expiration = newExpiration;
    }

    @Override
    public long getExpiration() {
        return this.expiration;
    }

    @Override
    public Uuid getCookie() {
        return this.cookie;
    }

    void cleanup(TemplateHandle owner, boolean expired) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRemove(long now, boolean doIt) {
        TemplateHandle owner;
        EventRegistrationWatcher eventRegistrationWatcher = this;
        synchronized (eventRegistrationWatcher) {
            if (this.owner == null) {
                return false;
            }
            if (!doIt && now < this.expiration) {
                return false;
            }
            owner = this.owner;
            this.expiration = Long.MIN_VALUE;
            this.owner = null;
        }
        this.cleanup(owner, !doIt);
        owner.getServer().removeEventRegistration(this);
        owner.removeTransitionWatcher(this);
        return true;
    }

    @Override
    void removeIfExpired(long now) {
        this.doRemove(now, false);
    }

    @Override
    public boolean cancel() {
        return this.doRemove(0L, true);
    }

    private class BasicEventSender
    implements EventSender {
        private BasicEventSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendEvent(JavaSpace source, long now, ProxyPreparer preparer) throws UnknownEventException, IOException, ClassNotFoundException {
            boolean doneFor = false;
            long seqNum = -1L;
            EventRegistrationWatcher eventRegistrationWatcher = EventRegistrationWatcher.this;
            synchronized (eventRegistrationWatcher) {
                if (EventRegistrationWatcher.this.owner == null) {
                    return;
                }
                if (EventRegistrationWatcher.this.getExpiration() < now) {
                    doneFor = true;
                } else {
                    if (EventRegistrationWatcher.this.currentSeqNum <= EventRegistrationWatcher.this.lastSeqNumDelivered) {
                        return;
                    }
                    seqNum = EventRegistrationWatcher.this.currentSeqNum;
                }
            }
            if (doneFor) {
                EventRegistrationWatcher.this.cancel();
                return;
            }
            assert (seqNum != -1L);
            EventRegistrationWatcher.this.getListener(preparer).notify(new RemoteEvent(source, EventRegistrationWatcher.this.eventID, seqNum, EventRegistrationWatcher.this.handback));
            eventRegistrationWatcher = EventRegistrationWatcher.this;
            synchronized (eventRegistrationWatcher) {
                if (seqNum > EventRegistrationWatcher.this.lastSeqNumDelivered) {
                    EventRegistrationWatcher.this.lastSeqNumDelivered = seqNum;
                }
            }
        }

        @Override
        public void cancelRegistration() {
            EventRegistrationWatcher.this.cancel();
        }

        private EventRegistrationWatcher getOwner() {
            return EventRegistrationWatcher.this;
        }

        @Override
        public boolean runAfter(EventSender other) {
            if (!(other instanceof BasicEventSender)) {
                return false;
            }
            return EventRegistrationWatcher.this == ((BasicEventSender)other).getOwner();
        }
    }
}

