/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.logging.Levels;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.outrigger.Txn;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.security.ProxyPreparer;

class TxnTable {
    private final Map txns = new HashMap();
    private Map brokenTxns = null;
    private final ProxyPreparer proxyPreparer;
    private static final Txn[] txnArray = new Txn[0];
    private static final Logger logger = Logger.getLogger("com.sun.jini.outrigger.transactions");

    TxnTable(ProxyPreparer proxyPreparer) {
        this.proxyPreparer = proxyPreparer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Txn get(TransactionManager manager, long id) throws IOException, ClassNotFoundException {
        Txn[] brokenTxnsForId;
        Long idAsLong;
        TxnTable txnTable = this;
        synchronized (txnTable) {
            Txn r = (Txn)this.txns.get(new Key(manager, id, false));
            if (r != null) {
                return r;
            }
            if (this.brokenTxns == null) {
                return null;
            }
            idAsLong = id;
            List txnsForId = (List)this.brokenTxns.get(idAsLong);
            if (txnsForId == null) {
                return null;
            }
            brokenTxnsForId = txnsForId.toArray(txnArray);
        }
        Txn match = null;
        Throwable t = null;
        LinkedList<Txn> fixed = new LinkedList<Txn>();
        for (int i = 0; i < brokenTxnsForId.length; ++i) {
            try {
                ServerTransaction st = brokenTxnsForId[i].getTransaction(this.proxyPreparer);
                fixed.add(brokenTxnsForId[i]);
                if (!st.mgr.equals(manager)) continue;
                match = brokenTxnsForId[i];
                break;
            }
            catch (Throwable tt) {
                try {
                    if (logger.isLoggable(Levels.FAILED)) {
                        logger.log(Levels.FAILED, "Encountered " + tt + "while recovering/re-preparing " + "transaction, will retry latter", tt);
                    }
                }
                catch (Throwable ttt) {
                    // empty catch block
                }
                if (t != null) continue;
                t = tt;
            }
        }
        if (!fixed.isEmpty()) {
            TxnTable txnTable2 = this;
            synchronized (txnTable2) {
                List txnsForId;
                if (this.brokenTxns != null && (txnsForId = (List)this.brokenTxns.get(idAsLong)) != null) {
                    txnsForId.removeAll(fixed);
                    if (txnsForId.isEmpty()) {
                        this.brokenTxns.remove(idAsLong);
                        if (this.brokenTxns.isEmpty()) {
                            this.brokenTxns = null;
                        }
                    }
                    Iterator i = fixed.iterator();
                    while (i.hasNext()) {
                        this.put((Txn)i.next());
                    }
                }
            }
        }
        if (match != null) {
            return match;
        }
        if (t != null) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new AssertionError((Object)t);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Txn put(ServerTransaction tr) {
        Key k = new Key(tr.mgr, tr.id, true);
        long internalID = OutriggerServerImpl.nextID();
        TxnTable txnTable = this;
        synchronized (txnTable) {
            Txn r = (Txn)this.txns.get(k);
            if (r == null) {
                r = new Txn(tr, internalID);
                this.txns.put(k, r);
            }
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(Txn txn) {
        Key k = new Key(txn.getManager(), txn.getTransactionId(), true);
        TxnTable txnTable = this;
        synchronized (txnTable) {
            Txn r = (Txn)this.txns.get(k);
            if (r == null) {
                this.txns.put(k, txn);
            }
        }
    }

    void recover(Txn txn) {
        ServerTransaction st = null;
        try {
            st = txn.getTransaction(this.proxyPreparer);
        }
        catch (Throwable t) {
            try {
                if (logger.isLoggable(Levels.FAILED)) {
                    logger.log(Levels.FAILED, "Encountered " + t + " while " + "recovering/re-preparing transaction, " + "will retry latter", t);
                }
            }
            catch (Throwable tt) {
                // empty catch block
            }
        }
        if (st == null) {
            Long id;
            LinkedList<Txn> txnsForId;
            if (this.brokenTxns == null) {
                this.brokenTxns = new HashMap();
            }
            if ((txnsForId = (LinkedList<Txn>)this.brokenTxns.get(id = Long.valueOf(txn.getTransactionId()))) == null) {
                txnsForId = new LinkedList<Txn>();
                this.brokenTxns.put(id, txnsForId);
            }
            txnsForId.add(txn);
        } else {
            Key k = new Key(st.mgr, st.id, true);
            this.txns.put(k, txn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(TransactionManager manager, long id) {
        Key k = new Key(manager, id, false);
        TxnTable txnTable = this;
        synchronized (txnTable) {
            this.txns.remove(k);
        }
    }

    private class Key {
        private final TransactionManager manager;
        private final long id;
        private final boolean prepared;

        private Key(TransactionManager manager, long id, boolean prepared) {
            if (manager == null) {
                throw new NullPointerException("manager must be non-null");
            }
            this.manager = manager;
            this.id = id;
            this.prepared = prepared;
        }

        public int hashCode() {
            return (int)this.id ^ this.manager.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof Key)) {
                return false;
            }
            Key o = (Key)other;
            if (this.id != o.id) {
                return false;
            }
            if (o.prepared) {
                return o.manager.equals(this.manager);
            }
            if (this.prepared) {
                return this.manager.equals(o.manager);
            }
            throw new AssertionError((Object)"TxnTable.Key equals call with two unprepared managers");
        }
    }
}

