/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import com.sun.jini.phoenix.AID;
import com.sun.jini.phoenix.AbstractActivator;
import com.sun.jini.phoenix.AbstractMonitor;
import com.sun.jini.phoenix.AbstractRegistry;
import com.sun.jini.phoenix.AbstractSystem;
import com.sun.jini.phoenix.AccessILFactory;
import com.sun.jini.phoenix.ActivationGroupData;
import com.sun.jini.phoenix.Activator;
import com.sun.jini.phoenix.ConstrainableAID;
import com.sun.jini.phoenix.GroupOutputHandler;
import com.sun.jini.phoenix.InactiveGroupException;
import com.sun.jini.phoenix.PhoenixConstants;
import com.sun.jini.phoenix.PhoenixStarter;
import com.sun.jini.phoenix.PipeWriter;
import com.sun.jini.phoenix.RegistrySunExporter;
import com.sun.jini.phoenix.SystemAccessILFactory;
import com.sun.jini.proxy.BasicProxyTrustVerifier;
import com.sun.jini.proxy.MarshalledWrapper;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UID;
import java.security.CodeSource;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationNotFoundException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.NoSuchEntryException;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.export.Exporter;
import net.jini.io.MarshalInputStream;
import net.jini.io.MarshalOutputStream;
import net.jini.io.MarshalledInstance;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

class Activation
implements Serializable {
    private static final long serialVersionUID = -6825932652725866242L;
    private static final String PHOENIX = "com.sun.jini.phoenix";
    private static ResourceBundle resources = null;
    private static Logger logger = Logger.getLogger("com.sun.jini.phoenix");
    private static final int PHOENIX_PORT = 1198;
    private static final Object logLock = new Object();
    private Map idTable = new HashMap();
    private Map groupTable = new HashMap();
    private transient LoginContext login;
    private transient int groupSemaphore;
    private transient int groupCounter = 0;
    private transient ReliableLog log;
    private transient int numUpdates = 0;
    private transient int snapshotInterval;
    private transient String[] command;
    private transient long groupTimeout;
    private transient long unexportTimeout;
    private transient long unexportWait;
    private transient Activator activator;
    private transient Exporter activatorExporter;
    private transient Activator activatorStub;
    private transient ActivationSystem system;
    private transient Exporter systemExporter;
    private transient ActivationSystem systemStub;
    private transient ActivationMonitor monitor;
    private transient Exporter monitorExporter;
    private transient ActivationMonitor monitorStub;
    private transient Registry registry;
    private transient Exporter registryExporter;
    private transient Registry registryStub;
    private transient MarshalledObject groupData;
    private transient String groupLocation;
    private transient ProxyPreparer groupPreparer;
    private transient GroupOutputHandler outputHandler;
    private volatile boolean shuttingDown = false;
    private transient Thread shutdownHook;
    private transient PhoenixStarter starter;

    private Activation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(ReliableLog log, LoginContext login, Configuration config, String[] configOptions, PhoenixStarter starter) throws Exception {
        this.log = log;
        this.login = login;
        this.starter = starter;
        this.groupSemaphore = Activation.getInt(config, "groupThrottle", 3);
        this.snapshotInterval = Activation.getInt(config, "persistenceSnapshotThreshold", 200);
        this.groupTimeout = Activation.getInt(config, "groupTimeout", 60000);
        this.unexportTimeout = Activation.getInt(config, "unexportTimeout", 60000);
        this.unexportWait = Activation.getInt(config, "unexportWait", 10);
        String[] opts = (String[])config.getEntry(PHOENIX, "groupOptions", String[].class, new String[0]);
        this.command = new String[opts.length + 2];
        this.command[0] = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        System.arraycopy(opts, 0, this.command, 1, opts.length);
        this.command[this.command.length - 1] = "com.sun.jini.phoenix.ActivationGroupInit";
        this.shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.groupPreparer = Activation.getPreparer(config, "instantiatorPreparer");
        this.groupData = new MarshalledObject<ActivationGroupData>(new ActivationGroupData((String[])config.getEntry(PHOENIX, "groupConfig", String[].class, configOptions)));
        this.outputHandler = (GroupOutputHandler)config.getEntry(PHOENIX, "groupOutputHandler", GroupOutputHandler.class, new GroupOutputHandler(){

            @Override
            public void handleOutput(ActivationGroupID id, ActivationGroupDesc desc, long incarnation, String groupName, InputStream out, InputStream err) {
                PipeWriter.plugTogetherPair(groupName, out, System.out, err, System.err);
            }
        });
        this.groupLocation = (String)config.getEntry(PHOENIX, "groupLocation", String.class, Activation.getDefaultGroupLocation());
        ActivationGroupID[] gids = this.groupTable.keySet().toArray(new ActivationGroupID[this.groupTable.size()]);
        this.activator = new ActivatorImpl();
        TcpServerEndpoint se = TcpServerEndpoint.getInstance(1198);
        this.activatorExporter = Activation.getExporter(config, "activatorExporter", new BasicJeriExporter(se, new BasicILFactory(), false, true, PhoenixConstants.ACTIVATOR_UUID));
        this.system = new SystemImpl();
        this.systemExporter = Activation.getExporter(config, "systemExporter", new BasicJeriExporter(se, new SystemAccessILFactory(), false, true, PhoenixConstants.ACTIVATION_SYSTEM_UUID));
        this.monitor = new MonitorImpl();
        this.monitorExporter = Activation.getExporter(config, "monitorExporter", new BasicJeriExporter(se, new AccessILFactory()));
        this.registry = new RegistryImpl();
        this.registryExporter = Activation.getExporter(config, "registryExporter", new RegistrySunExporter());
        this.monitorStub = (ActivationMonitor)this.monitorExporter.export((Remote)this.monitor);
        Exporter exporter = this.activatorExporter;
        synchronized (exporter) {
            this.systemStub = (ActivationSystem)this.systemExporter.export((Remote)this.system);
            this.activatorStub = (Activator)this.activatorExporter.export(this.activator);
        }
        this.registryStub = (Registry)this.registryExporter.export(this.registry);
        logger.info(Activation.getTextResource("phoenix.daemon.started"));
        int i = gids.length;
        while (--i >= 0) {
            try {
                this.getGroupEntry(gids[i]).restartServices();
            }
            catch (UnknownGroupException e) {}
        }
    }

    private static String getDefaultGroupLocation() {
        String loc;
        ProtectionDomain pd = Activation.class.getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        URL location = null;
        if (cs != null) {
            location = cs.getLocation();
        }
        if (location != null && (loc = location.toString()).endsWith(".jar")) {
            return loc.substring(0, loc.length() - 4) + "-group.jar";
        }
        return null;
    }

    private static Configuration getConfig(String[] configOptions, PhoenixStarter starter) throws ConfigurationException {
        try {
            return ConfigurationProvider.getInstance(configOptions, Activation.class.getClassLoader());
        }
        catch (ConfigurationNotFoundException e) {
            if (starter == null) {
                Activation.bomb("phoenix.missing.config", Arrays.asList(configOptions).toString());
            }
            throw e;
        }
    }

    private static int getInt(Configuration config, String name, int defValue) throws ConfigurationException {
        return (Integer)config.getEntry(PHOENIX, name, Integer.TYPE, defValue);
    }

    private static Exporter getExporter(Configuration config, String name, Exporter defaultExporter) throws ConfigurationException {
        return (Exporter)config.getEntry(PHOENIX, name, Exporter.class, defaultExporter);
    }

    private static ProxyPreparer getPreparer(Configuration config, String name) throws ConfigurationException {
        return (ProxyPreparer)config.getEntry(PHOENIX, name, ProxyPreparer.class, new BasicProxyPreparer());
    }

    private void checkShutdown() throws ActivationException {
        if (this.shuttingDown) {
            throw new ActivationException("activation system is shutting down");
        }
    }

    private ActivationID getAID(UID uid) {
        if (this.activatorStub instanceof RemoteMethodControl) {
            return new ConstrainableAID(this.activatorStub, uid);
        }
        return new AID(this.activatorStub, uid);
    }

    private static UID getUID(ActivationID id) throws UnknownObjectException {
        Class<?> c = id.getClass();
        if (c == AID.class || c == ConstrainableAID.class) {
            return ((AID)id).getUID();
        }
        throw new UnknownObjectException("object unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivationGroupID getGroupID(UID uid) throws UnknownObjectException {
        Map map = this.idTable;
        synchronized (map) {
            ActivationGroupID groupID = (ActivationGroupID)this.idTable.get(uid);
            if (groupID != null) {
                return groupID;
            }
        }
        throw new UnknownObjectException("object unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupEntry getGroupEntry(ActivationGroupID id) throws UnknownGroupException {
        if (id.getClass() == ActivationGroupID.class) {
            Map map = this.groupTable;
            synchronized (map) {
                GroupEntry entry = (GroupEntry)this.groupTable.get(id);
                if (entry != null && !entry.removed) {
                    return entry;
                }
            }
        }
        throw new UnknownGroupException("group unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupEntry getGroupEntry(UID uid) throws UnknownObjectException {
        ActivationGroupID gid = this.getGroupID(uid);
        Map map = this.groupTable;
        synchronized (map) {
            GroupEntry entry = (GroupEntry)this.groupTable.get(gid);
            if (entry != null) {
                return entry;
            }
        }
        throw new UnknownObjectException("object's group removed");
    }

    private String[] activationArgs(ActivationGroupDesc desc) {
        Properties props;
        ActivationGroupDesc.CommandEnvironment cmdenv = desc.getCommandEnvironment();
        ArrayList<String> argv = new ArrayList<String>();
        argv.add(cmdenv != null && cmdenv.getCommandPath() != null ? cmdenv.getCommandPath() : this.command[0]);
        if (cmdenv != null && cmdenv.getCommandOptions() != null) {
            argv.addAll(Arrays.asList(cmdenv.getCommandOptions()));
        }
        if ((props = desc.getPropertyOverrides()) != null) {
            Enumeration<?> p = props.propertyNames();
            while (p.hasMoreElements()) {
                String name = (String)p.nextElement();
                argv.add("-D" + name + "=" + props.getProperty(name));
            }
        }
        for (int i = 1; i < this.command.length; ++i) {
            argv.add(this.command[i]);
        }
        String[] realArgv = new String[argv.size()];
        System.arraycopy(argv.toArray(), 0, realArgv, 0, realArgv.length);
        return realArgv;
    }

    private void addLogRecord(LogRecord rec) throws ActivationException {
        assert (Thread.holdsLock(logLock));
        this.checkShutdown();
        if (this.numUpdates >= this.snapshotInterval) {
            this.snapshot();
        }
        try {
            this.log.update(rec, true);
            ++this.numUpdates;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "log update throws", e);
            this.snapshot();
        }
    }

    private void snapshot() throws ActivationException {
        assert (Thread.holdsLock(logLock));
        try {
            this.log.snapshot();
            this.numUpdates = 0;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "log snapshot throws", e);
            try {
                this.system.shutdown();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            throw new ActivationException("log snapshot failed", (Throwable)e);
        }
    }

    private static void usage() {
        System.err.println(MessageFormat.format(Activation.getTextResource("phoenix.usage"), Activation.class.getName()));
        System.exit(1);
    }

    private static void bomb(String error) {
        System.err.println("phoenix: " + error);
        Activation.usage();
    }

    private static void bomb(String res, String val) {
        Activation.bomb(MessageFormat.format(Activation.getTextResource(res), val));
    }

    public static void main(String[] args) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        boolean stop = false;
        if (args.length > 0 && args[0].equals("-stop")) {
            stop = true;
            String[] nargs = new String[args.length - 1];
            System.arraycopy(args, 1, nargs, 0, nargs.length);
            args = nargs;
        } else if (args.length == 1 && args[0].equals("-help")) {
            Activation.usage();
        }
        try {
            Activation.main(args, stop, null);
        }
        catch (Exception e) {
            System.err.println(MessageFormat.format(Activation.getTextResource("phoenix.unexpected.exception"), e.getMessage()));
            e.printStackTrace();
            System.exit(1);
        }
    }

    ActivationSystem getActivationSystemProxy() {
        return this.systemStub;
    }

    static Activation main(final String[] configOptions, final boolean stop, final PhoenixStarter starter) throws Exception {
        final Configuration config = Activation.getConfig(configOptions, starter);
        final LoginContext login = (LoginContext)config.getEntry(PHOENIX, "loginContext", LoginContext.class, null);
        if (login != null) {
            login.login();
        }
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                if (stop) {
                    assert (starter == null);
                    Activation.shutdown(config);
                    System.exit(0);
                }
                String logName = null;
                try {
                    logName = (String)config.getEntry(Activation.PHOENIX, "persistenceDirectory", String.class);
                }
                catch (NoSuchEntryException e) {
                    if (starter == null) {
                        Activation.bomb("phoenix.missing.log", null);
                    }
                    throw e;
                }
                ActLogHandler handler = new ActLogHandler();
                ReliableLog log = new ReliableLog(logName, handler);
                log.recover();
                Activation state = handler.getState();
                if (state == null) {
                    log.snapshot();
                    state = handler.getState();
                }
                state.init(log, login, config, configOptions, starter);
                if (starter == null) {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(Long.MAX_VALUE);
                            }
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                        break;
                    }
                }
                return state;
            }
        };
        if (login != null) {
            return (Activation)Subject.doAsPrivileged(login.getSubject(), action, null);
        }
        return (Activation)action.run();
    }

    private static void shutdown(Configuration config) throws Exception {
        String host = (String)config.getEntry(PHOENIX, "registryHost", String.class, null);
        int port = Activation.getInt(config, "registryPort", 1098);
        Registry reg = LocateRegistry.getRegistry(host, port);
        ActivationSystem sys = (ActivationSystem)reg.lookup(ActivationSystem.class.getName());
        ProxyPreparer sysPreparer = Activation.getPreparer(config, "systemPreparer");
        sys = (ActivationSystem)sysPreparer.prepareProxy(sys);
        sys.shutdown();
    }

    static String getTextResource(String key) {
        if (resources == null) {
            try {
                resources = ResourceBundle.getBundle("com.sun.jini.phoenix.resources.phoenix");
            }
            catch (MissingResourceException mre) {
                return "[missing resource file: " + key + "]";
            }
        }
        try {
            return resources.getString(key);
        }
        catch (MissingResourceException mre) {
            return "[missing resource: " + key + "]";
        }
    }

    private synchronized String Pstartgroup() throws ActivationException {
        while (true) {
            this.checkShutdown();
            if (this.groupSemaphore > 0) {
                --this.groupSemaphore;
                return "Group-" + this.groupCounter++;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private synchronized void Vstartgroup() {
        ++this.groupSemaphore;
        this.notifyAll();
    }

    private static class LogGroupIncarnation
    extends LogRecord {
        private static final long serialVersionUID = 4146872747377631897L;
        private ActivationGroupID id;
        private long inc;

        LogGroupIncarnation(ActivationGroupID id, long inc) {
            this.id = id;
            this.inc = inc;
        }

        @Override
        Object apply(Object state) {
            try {
                GroupEntry entry = ((Activation)state).getGroupEntry(this.id);
                entry.incarnation = this.inc;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "log recovery throws", e);
            }
            return state;
        }
    }

    private static class LogUnregisterGroup
    extends LogRecord {
        private static final long serialVersionUID = -3356306586522147344L;
        private ActivationGroupID id;

        LogUnregisterGroup(ActivationGroupID id) {
            this.id = id;
        }

        @Override
        Object apply(Object state) {
            GroupEntry entry = (GroupEntry)((Activation)state).groupTable.remove(this.id);
            try {
                entry.unregisterGroup(false);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "log recovery throws", e);
            }
            return state;
        }
    }

    private static class LogUpdateGroupDesc
    extends LogRecord {
        private static final long serialVersionUID = -1271300989218424337L;
        private ActivationGroupID id;
        private ActivationGroupDesc desc;

        LogUpdateGroupDesc(ActivationGroupID id, ActivationGroupDesc desc) {
            this.id = id;
            this.desc = desc;
        }

        @Override
        Object apply(Object state) {
            try {
                ((Activation)state).getGroupEntry(this.id).setActivationGroupDesc(this.id, this.desc, false);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "log recovery throws", e);
            }
            return state;
        }
    }

    private static class LogUpdateDesc
    extends LogRecord {
        private static final long serialVersionUID = 545511539051179885L;
        private UID uid;
        private ActivationDesc desc;

        LogUpdateDesc(UID uid, ActivationDesc desc) {
            this.uid = uid;
            this.desc = desc;
        }

        @Override
        Object apply(Object state) {
            try {
                ((Activation)state).getGroupEntry(this.uid).setActivationDesc(this.uid, this.desc, false);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "log recovery throws", e);
            }
            return state;
        }
    }

    private static class LogRegisterGroup
    extends LogRecord {
        private static final long serialVersionUID = -1966827458515403625L;
        private ActivationGroupID id;
        private ActivationGroupDesc desc;

        LogRegisterGroup(ActivationGroupID id, ActivationGroupDesc desc) {
            this.id = id;
            this.desc = desc;
        }

        @Override
        Object apply(Object state) {
            Map map = ((Activation)state).groupTable;
            Activation activation = (Activation)state;
            activation.getClass();
            map.put(this.id, activation.new GroupEntry(this.id, this.desc));
            return state;
        }
    }

    private static class LogUnregisterObject
    extends LogRecord {
        private static final long serialVersionUID = 6269824097396935501L;
        private UID uid;

        LogUnregisterObject(UID uid) {
            this.uid = uid;
        }

        @Override
        Object apply(Object state) {
            try {
                ((Activation)state).getGroupEntry(this.uid).unregisterObject(this.uid, false);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "log recovery throws", e);
            }
            return state;
        }
    }

    private static class LogRegisterObject
    extends LogRecord {
        private static final long serialVersionUID = -6280336276146085143L;
        private UID uid;
        private ActivationDesc desc;

        LogRegisterObject(UID uid, ActivationDesc desc) {
            this.uid = uid;
            this.desc = desc;
        }

        @Override
        Object apply(Object state) {
            try {
                ((Activation)state).getGroupEntry(this.desc.getGroupID()).registerObject(this.uid, this.desc, false);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "log recovery throws", e);
            }
            return state;
        }
    }

    private static abstract class LogRecord
    implements Serializable {
        private static final long serialVersionUID = 8395140512322687529L;

        private LogRecord() {
        }

        abstract Object apply(Object var1) throws Exception;
    }

    private static class ActLogHandler
    extends LogHandler {
        private Activation state = null;

        ActLogHandler() {
        }

        public Activation getState() {
            return this.state;
        }

        @Override
        public void snapshot(OutputStream out) throws Exception {
            if (this.state == null) {
                this.state = new Activation();
            }
            MarshalOutputStream s = new MarshalOutputStream(out, Collections.EMPTY_LIST);
            s.writeObject(this.state);
            s.flush();
        }

        @Override
        public void recover(InputStream in) throws Exception {
            MarshalInputStream s = new MarshalInputStream(in, ActLogHandler.class.getClassLoader(), false, null, Collections.EMPTY_LIST);
            s.useCodebaseAnnotations();
            this.state = (Activation)s.readObject();
        }

        @Override
        public void writeUpdate(OutputStream out, Object value) throws Exception {
            MarshalOutputStream s = new MarshalOutputStream(out, Collections.EMPTY_LIST);
            s.writeObject(value);
            s.flush();
        }

        @Override
        public void readUpdate(InputStream in) throws Exception {
            MarshalInputStream s = new MarshalInputStream(in, ActLogHandler.class.getClassLoader(), false, null, Collections.EMPTY_LIST);
            s.useCodebaseAnnotations();
            this.applyUpdate(s.readObject());
        }

        @Override
        public void applyUpdate(Object update) throws Exception {
            ((LogRecord)update).apply(this.state);
        }
    }

    private class ObjectEntry
    implements Serializable {
        private static final long serialVersionUID = -808474359039620126L;
        ActivationDesc desc;
        volatile transient MarshalledWrapper stub = null;
        volatile transient boolean removed = false;

        ObjectEntry(ActivationDesc desc) {
            this.desc = desc;
        }

        synchronized MarshalledWrapper activate(UID uid, boolean force, ActivationInstantiator inst) throws RemoteException, ActivationException {
            MarshalledWrapper nstub = this.stub;
            if (this.removed) {
                throw new UnknownObjectException("object removed");
            }
            if (!force && nstub != null) {
                return nstub;
            }
            MarshalledInstance marshalledProxy = new MarshalledInstance(inst.newInstance(Activation.this.getAID(uid), this.desc));
            this.stub = nstub = new MarshalledWrapper(marshalledProxy);
            return nstub;
        }

        void reset() {
            this.stub = null;
        }

        void removed() {
            this.removed = true;
        }
    }

    private class GroupEntry
    implements Serializable {
        private static final long serialVersionUID = 7222464070032993304L;
        private static final int MAX_TRIES = 2;
        private static final int NORMAL = 0;
        private static final int CREATING = 1;
        private static final int TERMINATE = 2;
        private static final int TERMINATING = 3;
        ActivationGroupDesc desc;
        ActivationGroupID groupID;
        long incarnation = 0L;
        Map objects = new HashMap(11);
        HashSet restartSet = new HashSet();
        transient ActivationInstantiator group = null;
        transient int status = 0;
        transient long waitTime = 0L;
        transient String groupName = null;
        transient Process child = null;
        transient boolean removed = false;
        transient Watchdog watchdog = null;

        GroupEntry(ActivationGroupID groupID, ActivationGroupDesc desc) {
            this.groupID = groupID;
            this.desc = desc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void restartServices() {
            Iterator iter2 = null;
            GroupEntry groupEntry = this;
            synchronized (groupEntry) {
                if (this.restartSet.isEmpty()) {
                    return;
                }
                iter2 = ((Set)this.restartSet.clone()).iterator();
            }
            while (iter2.hasNext()) {
                UID uid = (UID)iter2.next();
                try {
                    this.activate(uid, true);
                }
                catch (Exception e) {
                    if (Activation.this.shuttingDown) {
                        return;
                    }
                    logger.log(Level.WARNING, "unable to restart service", e);
                }
            }
        }

        synchronized void activeGroup(ActivationInstantiator inst, long instIncarnation) throws ActivationException {
            if (this.group != null && this.group.equals(inst) && this.incarnation == instIncarnation) {
                return;
            }
            if (this.child != null && this.status != 1) {
                throw new ActivationException("group not being created");
            }
            if (this.incarnation != instIncarnation) {
                throw new ActivationException("invalid incarnation");
            }
            if (this.group != null) {
                throw new ActivationException("group already active");
            }
            this.group = inst;
            this.status = 0;
            this.notifyAll();
        }

        private void checkRemoved() throws UnknownGroupException {
            if (this.removed) {
                throw new UnknownGroupException("group removed");
            }
        }

        private ObjectEntry getObjectEntry(UID uid) throws UnknownObjectException {
            if (this.removed) {
                throw new UnknownObjectException("object's group removed");
            }
            ObjectEntry objEntry = (ObjectEntry)this.objects.get(uid);
            if (objEntry == null) {
                throw new UnknownObjectException("object unknown");
            }
            return objEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void registerObject(UID uid, ActivationDesc desc, boolean addRecord) throws ActivationException {
            this.checkRemoved();
            Object object = logLock;
            synchronized (object) {
                if (addRecord) {
                    Activation.this.addLogRecord(new LogRegisterObject(uid, desc));
                }
                this.objects.put(uid, new ObjectEntry(desc));
                if (desc.getRestartMode()) {
                    this.restartSet.add(uid);
                }
                Map map = Activation.this.idTable;
                synchronized (map) {
                    Activation.this.idTable.put(uid, this.groupID);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void unregisterObject(UID uid, boolean addRecord) throws ActivationException {
            ObjectEntry objEntry = this.getObjectEntry(uid);
            Object object = logLock;
            synchronized (object) {
                if (addRecord) {
                    Activation.this.addLogRecord(new LogUnregisterObject(uid));
                }
                objEntry.removed();
                this.objects.remove(uid);
                if (objEntry.desc.getRestartMode()) {
                    this.restartSet.remove(uid);
                }
                Map map = Activation.this.idTable;
                synchronized (map) {
                    Activation.this.idTable.remove(uid);
                }
            }
        }

        synchronized Map getActivatableObjects() {
            HashMap<ActivationID, ActivationDesc> map = new HashMap<ActivationID, ActivationDesc>(this.objects.size());
            for (Map.Entry ent : this.objects.entrySet()) {
                map.put(Activation.this.getAID((UID)ent.getKey()), ((ObjectEntry)ent.getValue()).desc);
            }
            return map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void unregisterGroup(boolean addRecord) throws ActivationException {
            this.checkRemoved();
            Object object = logLock;
            synchronized (object) {
                if (addRecord) {
                    Activation.this.addLogRecord(new LogUnregisterGroup(this.groupID));
                }
                this.removed = true;
                for (Map.Entry ent : this.objects.entrySet()) {
                    UID uid = (UID)ent.getKey();
                    Map map = Activation.this.idTable;
                    synchronized (map) {
                        Activation.this.idTable.remove(uid);
                    }
                    ObjectEntry objEntry = (ObjectEntry)ent.getValue();
                    objEntry.removed();
                }
                this.objects.clear();
                this.restartSet.clear();
                this.reset();
                this.childGone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized ActivationDesc setActivationDesc(UID uid, ActivationDesc desc, boolean addRecord) throws ActivationException {
            ObjectEntry objEntry = this.getObjectEntry(uid);
            Object object = logLock;
            synchronized (object) {
                if (addRecord) {
                    Activation.this.addLogRecord(new LogUpdateDesc(uid, desc));
                }
                ActivationDesc oldDesc = objEntry.desc;
                objEntry.desc = desc;
                if (desc.getRestartMode()) {
                    this.restartSet.add(uid);
                } else {
                    this.restartSet.remove(uid);
                }
                return oldDesc;
            }
        }

        synchronized ActivationDesc getActivationDesc(UID uid) throws UnknownObjectException {
            return this.getObjectEntry((UID)uid).desc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized ActivationGroupDesc setActivationGroupDesc(ActivationGroupID id, ActivationGroupDesc desc, boolean addRecord) throws ActivationException {
            this.checkRemoved();
            Object object = logLock;
            synchronized (object) {
                if (addRecord) {
                    Activation.this.addLogRecord(new LogUpdateGroupDesc(id, desc));
                }
                ActivationGroupDesc oldDesc = this.desc;
                this.desc = desc;
                return oldDesc;
            }
        }

        synchronized void inactiveGroup(long incarnation, boolean failure) throws UnknownGroupException {
            this.checkRemoved();
            if (this.incarnation != incarnation) {
                throw new UnknownGroupException("invalid incarnation");
            }
            this.reset();
            if (failure) {
                this.terminate();
            } else if (this.child != null && this.status == 0) {
                this.status = 2;
                this.watchdog.noRestart();
            }
        }

        synchronized void activeObject(UID uid, MarshalledObject mobj) throws UnknownObjectException {
            this.getObjectEntry((UID)uid).stub = new MarshalledWrapper(new MarshalledInstance(mobj));
        }

        synchronized void inactiveObject(UID uid) throws UnknownObjectException {
            this.getObjectEntry(uid).reset();
        }

        private void reset() {
            this.group = null;
            Iterator iter2 = this.objects.values().iterator();
            while (iter2.hasNext()) {
                ((ObjectEntry)iter2.next()).reset();
            }
        }

        private void childGone() {
            if (this.child != null) {
                this.child = null;
                this.watchdog.dispose();
                this.watchdog = null;
                this.status = 0;
                this.notifyAll();
            }
        }

        private void terminate() {
            if (this.child != null && this.status != 3) {
                this.child.destroy();
                this.status = 3;
                this.waitTime = System.currentTimeMillis() + Activation.this.groupTimeout;
                this.notifyAll();
            }
        }

        private void await() {
            while (true) {
                switch (this.status) {
                    case 0: {
                        return;
                    }
                    case 2: {
                        this.terminate();
                    }
                    case 3: {
                        try {
                            this.child.exitValue();
                        }
                        catch (IllegalThreadStateException e) {
                            long now = System.currentTimeMillis();
                            if (this.waitTime > now) {
                                try {
                                    this.wait(this.waitTime - now);
                                }
                                catch (InterruptedException ee) {}
                                break;
                            }
                            logger.log(Level.WARNING, "group did not terminate: {0}", this.groupName);
                        }
                        this.childGone();
                        return;
                    }
                    case 1: {
                        try {
                            this.wait();
                            break;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        void shutdownFast() {
            Process p = this.child;
            if (p != null) {
                p.destroy();
            }
        }

        synchronized void shutdown() {
            this.reset();
            this.terminate();
            this.await();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MarshalledWrapper activate(UID uid, boolean force) throws ActivationException {
            Object detail = null;
            for (int tries = 2; tries > 0; --tries) {
                boolean failure;
                boolean groupInactive;
                long curIncarnation;
                block13: {
                    ActivationInstantiator inst;
                    ObjectEntry objEntry;
                    GroupEntry groupEntry = this;
                    synchronized (groupEntry) {
                        objEntry = this.getObjectEntry(uid);
                        if (!force && objEntry.stub != null) {
                            return objEntry.stub;
                        }
                        inst = this.getInstantiator(this.groupID);
                        curIncarnation = this.incarnation;
                    }
                    groupInactive = false;
                    failure = false;
                    try {
                        return objEntry.activate(uid, force, inst);
                    }
                    catch (NoSuchObjectException e) {
                        groupInactive = true;
                        detail = e;
                    }
                    catch (ConnectException e) {
                        groupInactive = true;
                        failure = true;
                        detail = e;
                    }
                    catch (ConnectIOException e) {
                        groupInactive = true;
                        failure = true;
                        detail = e;
                    }
                    catch (InactiveGroupException e) {
                        groupInactive = true;
                        detail = e;
                    }
                    catch (RemoteException e) {
                        if (detail != null) break block13;
                        detail = e;
                    }
                }
                if (!groupInactive) continue;
                try {
                    Activation.this.getGroupEntry(this.groupID).inactiveGroup(curIncarnation, failure);
                    continue;
                }
                catch (UnknownGroupException e) {
                    // empty catch block
                }
            }
            throw new ActivationException("object activation failed after 2 tries", detail);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ActivationInstantiator getInstantiator(ActivationGroupID id) throws ActivationException {
            this.await();
            if (this.group != null) {
                return this.group;
            }
            this.checkRemoved();
            boolean acquired = false;
            try {
                this.groupName = Activation.this.Pstartgroup();
                acquired = true;
                String[] argv = Activation.this.activationArgs(this.desc);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "{0} exec {1}", new Object[]{this.groupName, Arrays.asList(argv)});
                }
                try {
                    this.child = Runtime.getRuntime().exec(argv);
                    this.status = 1;
                    ++this.incarnation;
                    this.watchdog = new Watchdog();
                    this.watchdog.start();
                    Object object = logLock;
                    synchronized (object) {
                        Activation.this.addLogRecord(new LogGroupIncarnation(id, this.incarnation));
                    }
                    Activation.this.outputHandler.handleOutput(id, this.desc, this.incarnation, this.groupName, this.child.getInputStream(), this.child.getErrorStream());
                    MarshalOutputStream out = new MarshalOutputStream(this.child.getOutputStream(), Collections.EMPTY_LIST);
                    out.writeObject(id);
                    ActivationGroupDesc gd = this.desc;
                    if (gd.getClassName() == null) {
                        String loc;
                        MarshalledObject data = gd.getData();
                        if (data == null) {
                            data = Activation.this.groupData;
                        }
                        if ((loc = gd.getLocation()) == null) {
                            loc = Activation.this.groupLocation;
                        }
                        gd = new ActivationGroupDesc("com.sun.jini.phoenix.ActivationGroupImpl", loc, data, gd.getPropertyOverrides(), gd.getCommandEnvironment());
                    }
                    out.writeObject(gd);
                    out.writeLong(this.incarnation);
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    this.terminate();
                    if (!(e instanceof ActivationException)) throw new ActivationException("unable to create activation group", (Throwable)e);
                    throw (ActivationException)((Object)e);
                }
                try {
                    long now = System.currentTimeMillis();
                    long stop = now + Activation.this.groupTimeout;
                    do {
                        this.wait(stop - now);
                        if (this.group != null) {
                            ActivationInstantiator activationInstantiator = this.group;
                            return activationInstantiator;
                        }
                        now = System.currentTimeMillis();
                    } while (this.status == 1 && now < stop);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.terminate();
                throw new ActivationException("timeout creating child process");
            }
            finally {
                if (acquired) {
                    Activation.this.Vstartgroup();
                }
            }
        }

        private class Watchdog
        extends Thread {
            private Process groupProcess;
            private long groupIncarnation;
            private boolean canInterrupt;
            private boolean shouldQuit;
            private boolean shouldRestart;

            Watchdog() {
                super("Watchdog-" + GroupEntry.this.groupName + "-" + GroupEntry.this.incarnation);
                this.groupProcess = GroupEntry.this.child;
                this.groupIncarnation = GroupEntry.this.incarnation;
                this.canInterrupt = true;
                this.shouldQuit = false;
                this.shouldRestart = true;
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (this.shouldQuit) {
                    return;
                }
                try {
                    this.groupProcess.waitFor();
                }
                catch (InterruptedException exit) {
                    return;
                }
                boolean restart = false;
                GroupEntry groupEntry = GroupEntry.this;
                synchronized (groupEntry) {
                    if (this.shouldQuit) {
                        return;
                    }
                    this.canInterrupt = false;
                    Watchdog.interrupted();
                    if (this.groupIncarnation == GroupEntry.this.incarnation) {
                        restart = this.shouldRestart && !Activation.this.shuttingDown;
                        GroupEntry.this.reset();
                        GroupEntry.this.childGone();
                    }
                }
                if (restart) {
                    GroupEntry.this.restartServices();
                }
            }

            void dispose() {
                this.shouldQuit = true;
                if (this.canInterrupt) {
                    this.interrupt();
                }
            }

            void noRestart() {
                this.shouldRestart = false;
            }
        }
    }

    private class ShutdownHook
    extends Thread {
        ShutdownHook() {
            super("Phoenix Shutdown Hook");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = Activation.this;
            synchronized (object) {
                Activation.this.shuttingDown = true;
            }
            object = Activation.this.groupTable;
            synchronized (object) {
                Iterator iter2 = Activation.this.groupTable.values().iterator();
                while (iter2.hasNext()) {
                    ((GroupEntry)iter2.next()).shutdownFast();
                }
            }
        }
    }

    private class Shutdown
    extends Thread {
        Shutdown() {
            super("Shutdown");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                GroupEntry[] groupEntries;
                long stop = System.currentTimeMillis() + Activation.this.unexportTimeout;
                boolean force = false;
                while (!(Activation.this.registryExporter.unexport(force) && Activation.this.activatorExporter.unexport(force) && Activation.this.systemExporter.unexport(force) && Activation.this.monitorExporter.unexport(force))) {
                    long rem = stop - System.currentTimeMillis();
                    if (rem <= 0L) {
                        force = true;
                        continue;
                    }
                    try {
                        Thread.sleep(Math.min(rem, Activation.this.unexportWait));
                    }
                    catch (InterruptedException e) {}
                }
                Map map = Activation.this.groupTable;
                synchronized (map) {
                    groupEntries = Activation.this.groupTable.values().toArray(new GroupEntry[Activation.this.groupTable.size()]);
                }
                for (int i = 0; i < groupEntries.length; ++i) {
                    groupEntries[i].shutdown();
                }
                Runtime.getRuntime().removeShutdownHook(Activation.this.shutdownHook);
                try {
                    Object i = logLock;
                    synchronized (i) {
                        Activation.this.log.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    if (Activation.this.login != null) {
                        Activation.this.login.logout();
                    }
                }
                catch (LoginException e) {
                    // empty catch block
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "exception during shutdown", t);
            }
            finally {
                logger.info(Activation.getTextResource("phoenix.daemon.shutdown"));
                if (Activation.this.starter == null) {
                    System.exit(0);
                } else {
                    Activation.this.starter.unregister();
                }
            }
        }
    }

    class RegistryImpl
    extends AbstractRegistry {
        private final String NAME = ActivationSystem.class.getName();

        RegistryImpl() {
        }

        @Override
        public Remote lookup(String name) throws NotBoundException {
            if (name.equals(this.NAME)) {
                return Activation.this.systemStub;
            }
            throw new NotBoundException(name);
        }

        @Override
        public void bind(String name, Remote obj) {
            throw new SecurityException("read-only registry");
        }

        @Override
        public void unbind(String name) {
            throw new SecurityException("read-only registry");
        }

        @Override
        public void rebind(String name, Remote obj) {
            throw new SecurityException("read-only registry");
        }

        @Override
        public String[] list() {
            return new String[]{this.NAME};
        }
    }

    class SystemImpl
    extends AbstractSystem
    implements ServerProxyTrust {
        SystemImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ActivationID registerObject(ActivationDesc desc) throws ActivationException {
            UID uid = new UID();
            ActivationGroupID groupID = desc.getGroupID();
            Activation.this.getGroupEntry(groupID).registerObject(uid, desc, true);
            Exporter exporter = Activation.this.activatorExporter;
            synchronized (exporter) {
                return Activation.this.getAID(uid);
            }
        }

        public void unregisterObject(ActivationID id) throws ActivationException {
            UID uid = Activation.getUID(id);
            Activation.this.getGroupEntry(Activation.this.getGroupID(uid)).unregisterObject(uid, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ActivationGroupID registerGroup(ActivationGroupDesc desc) throws ActivationException {
            ActivationGroupID id = new ActivationGroupID(Activation.this.systemStub);
            Object object = logLock;
            synchronized (object) {
                Activation.this.addLogRecord(new LogRegisterGroup(id, desc));
                GroupEntry entry = new GroupEntry(id, desc);
                Map map = Activation.this.groupTable;
                synchronized (map) {
                    Activation.this.groupTable.put(id, entry);
                }
            }
            return id;
        }

        public ActivationMonitor activeGroup(ActivationGroupID id, ActivationInstantiator group, long incarnation) throws ActivationException, RemoteException {
            group = (ActivationInstantiator)Activation.this.groupPreparer.prepareProxy(group);
            Activation.this.getGroupEntry(id).activeGroup(group, incarnation);
            return Activation.this.monitorStub;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterGroup(ActivationGroupID id) throws ActivationException {
            GroupEntry groupEntry;
            Map map = Activation.this.groupTable;
            synchronized (map) {
                groupEntry = Activation.this.getGroupEntry(id);
                Activation.this.groupTable.remove(id);
            }
            groupEntry.unregisterGroup(true);
        }

        public ActivationDesc setActivationDesc(ActivationID id, ActivationDesc desc) throws ActivationException {
            UID uid = Activation.getUID(id);
            if (!Activation.this.getGroupID(uid).equals((Object)desc.getGroupID())) {
                throw new ActivationException("ActivationDesc contains wrong group");
            }
            return Activation.this.getGroupEntry(uid).setActivationDesc(uid, desc, true);
        }

        public ActivationGroupDesc setActivationGroupDesc(ActivationGroupID id, ActivationGroupDesc desc) throws ActivationException {
            return Activation.this.getGroupEntry(id).setActivationGroupDesc(id, desc, true);
        }

        public ActivationDesc getActivationDesc(ActivationID id) throws UnknownObjectException {
            UID uid = Activation.getUID(id);
            return Activation.this.getGroupEntry(uid).getActivationDesc(uid);
        }

        public ActivationGroupDesc getActivationGroupDesc(ActivationGroupID id) throws UnknownGroupException {
            return ((Activation)Activation.this).getGroupEntry((ActivationGroupID)id).desc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Activation activation = Activation.this;
            synchronized (activation) {
                if (!Activation.this.shuttingDown) {
                    Activation.this.shuttingDown = true;
                    new Shutdown().start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map getActivationGroups() {
            Map map = Activation.this.groupTable;
            synchronized (map) {
                HashMap<ActivationGroupID, ActivationGroupDesc> map2 = new HashMap<ActivationGroupID, ActivationGroupDesc>(Activation.this.groupTable.size());
                for (GroupEntry entry : Activation.this.groupTable.values()) {
                    if (entry.removed) continue;
                    map2.put(entry.groupID, entry.desc);
                }
                return map2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map getActivatableObjects(ActivationGroupID id) throws UnknownGroupException {
            Exporter exporter = Activation.this.activatorExporter;
            synchronized (exporter) {
            }
            return Activation.this.getGroupEntry(id).getActivatableObjects();
        }

        @Override
        public TrustVerifier getProxyVerifier() {
            return new BasicProxyTrustVerifier(Activation.this.systemStub);
        }
    }

    class MonitorImpl
    extends AbstractMonitor
    implements ServerProxyTrust {
        MonitorImpl() {
        }

        public void inactiveObject(ActivationID id) throws UnknownObjectException {
            UID uid = Activation.getUID(id);
            Activation.this.getGroupEntry(uid).inactiveObject(uid);
        }

        public void activeObject(ActivationID id, MarshalledObject mobj) throws UnknownObjectException {
            UID uid = Activation.getUID(id);
            Activation.this.getGroupEntry(uid).activeObject(uid, mobj);
        }

        public void inactiveGroup(ActivationGroupID id, long incarnation) throws UnknownGroupException {
            Activation.this.getGroupEntry(id).inactiveGroup(incarnation, false);
        }

        @Override
        public TrustVerifier getProxyVerifier() {
            return new BasicProxyTrustVerifier(Activation.this.monitorStub);
        }
    }

    class ActivatorImpl
    extends AbstractActivator
    implements ServerProxyTrust {
        ActivatorImpl() {
        }

        @Override
        public MarshalledWrapper activate(ActivationID id, boolean force) throws ActivationException {
            UID uid = Activation.getUID(id);
            return Activation.this.getGroupEntry(uid).activate(uid, force);
        }

        @Override
        public TrustVerifier getProxyVerifier() {
            return new ConstrainableAID.Verifier(Activation.this.activatorStub);
        }
    }
}

