/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import com.sun.jini.phoenix.AID;
import com.sun.jini.phoenix.Activator;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import java.rmi.server.UID;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;
import net.jini.security.proxytrust.TrustEquivalence;

final class ConstrainableAID
extends AID
implements RemoteMethodControl,
TrustEquivalence {
    private static final long serialVersionUID = 2625527831091986783L;
    private static final Method[] methodMapping = new Method[2];
    private final MethodConstraints constraints;

    public ConstrainableAID(Activator activator, UID uid) {
        this(activator, uid, null);
    }

    private ConstrainableAID(Activator activator, UID uid, MethodConstraints constraints) {
        super(activator, uid);
        if (!(activator instanceof RemoteMethodControl)) {
            throw new IllegalArgumentException("activator not RemoteMethodControl instance");
        }
        if (!(activator instanceof TrustEquivalence)) {
            throw new IllegalArgumentException("activator not TrustEquivalence instance");
        }
        this.constraints = constraints;
    }

    private ProxyTrustIterator getProxyTrustIterator() {
        return new SingletonProxyTrustIterator(this.activator);
    }

    @Override
    public RemoteMethodControl setConstraints(MethodConstraints constraints) {
        MethodConstraints actConstraints = ConstrainableProxyUtil.translateConstraints(constraints, methodMapping);
        RemoteMethodControl act = ((RemoteMethodControl)((Object)this.activator)).setConstraints(actConstraints);
        return new ConstrainableAID((Activator)((Object)act), this.uid, constraints);
    }

    @Override
    public MethodConstraints getConstraints() {
        return this.constraints;
    }

    @Override
    public boolean checkTrustEquivalence(Object obj) {
        if (!(obj instanceof ConstrainableAID)) {
            return false;
        }
        ConstrainableAID aid = (ConstrainableAID)obj;
        return this.uid.equals(aid.uid) && ((TrustEquivalence)((Object)this.activator)).checkTrustEquivalence(aid.activator);
    }

    private Object writeReplace() {
        return new State(this.activator, this.uid, this.constraints);
    }

    static {
        try {
            ConstrainableAID.methodMapping[0] = ActivationID.class.getMethod("activate", Boolean.TYPE);
            ConstrainableAID.methodMapping[1] = Activator.class.getMethod("activate", ActivationID.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    static final class Verifier
    implements TrustVerifier,
    Serializable {
        private static final long serialVersionUID = 570158651966790233L;
        private final RemoteMethodControl activator;

        Verifier(Activator activator) {
            if (!(activator instanceof RemoteMethodControl)) {
                throw new IllegalArgumentException("activator not a RemoteMethodControl instance");
            }
            if (!(activator instanceof TrustEquivalence)) {
                throw new IllegalArgumentException("activator must implement TrustEquivalence");
            }
            this.activator = (RemoteMethodControl)((Object)activator);
        }

        @Override
        public boolean isTrustedObject(Object obj, TrustVerifier.Context ctx) throws RemoteException {
            if (obj == null || ctx == null) {
                throw new NullPointerException();
            }
            if (!(obj instanceof ConstrainableAID)) {
                return false;
            }
            RemoteMethodControl act = (RemoteMethodControl)((Object)((ConstrainableAID)obj).activator);
            MethodConstraints mc = act.getConstraints();
            TrustEquivalence trusted = (TrustEquivalence)((Object)this.activator.setConstraints(mc));
            return trusted.checkTrustEquivalence(act);
        }
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1673734348880788487L;
        private final Activator activator;
        private final UID uid;
        private final MethodConstraints constraints;

        State(Activator activator, UID uid, MethodConstraints constraints) {
            this.activator = activator;
            this.uid = uid;
            this.constraints = constraints;
        }

        private Object readResolve() throws InvalidObjectException {
            ConstrainableProxyUtil.verifyConsistentConstraints(this.constraints, this.activator, methodMapping);
            return new ConstrainableAID(this.activator, this.uid, this.constraints);
        }
    }
}

