/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.proxy.MarshalledWrapper;
import com.sun.jini.reggie.ClassMapper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.MarshalException;
import java.rmi.UnmarshalException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import net.jini.loader.ClassLoading;

class EntryClass
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected String name;
    protected long hash;
    protected EntryClass superclass;
    protected int numFields;
    protected transient int numInstances;
    protected transient int numTemplates;
    protected transient EntryClass replacement;
    private transient boolean integrity = false;

    public EntryClass(Class clazz, EntryClass superclass) throws MarshalException {
        this.name = clazz.getName();
        this.superclass = superclass;
        ClassMapper.EntryField[] fields = ClassMapper.getFields(clazz);
        this.numFields = fields.length;
        this.computeHash(fields);
    }

    private EntryClass(EntryClass orig) {
        this.name = orig.name;
        this.hash = orig.hash;
    }

    public EntryClass getSuperclass() {
        return this.superclass;
    }

    public int getNumFields() {
        return this.numFields;
    }

    public void setNumInstances(int numInstances) {
        this.numInstances = numInstances;
    }

    public void setNumTemplates(int numTemplates) {
        this.numTemplates = numTemplates;
    }

    public synchronized EntryClass getReplacement() {
        if (this.replacement == null) {
            this.replacement = new EntryClass(this);
        }
        return this.replacement;
    }

    public boolean isAssignableFrom(EntryClass cls) {
        EntryClass sup = cls;
        while (sup != null) {
            if (this.hash == sup.hash) {
                return true;
            }
            sup = sup.superclass;
        }
        return false;
    }

    public int getNumInstances() {
        return this.numInstances;
    }

    public int getNumTemplates() {
        return this.numTemplates;
    }

    public Class toClass(String codebase) throws IOException, ClassNotFoundException {
        EntryClass local;
        Class cls = ClassLoading.loadClass(codebase, this.name, null, this.integrity, null);
        try {
            local = ClassMapper.toEntryClassBase((Class)cls).eclass;
        }
        catch (MarshalException e) {
            throw new UnmarshalException("problem obtaining local version of " + this.toString(), e);
        }
        if (this.hash != local.hash) {
            throw new UnmarshalException("incoming entry type: " + this.toString() + " is not assignable to the local" + " version of the type: " + local);
        }
        return cls;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntryClass)) {
            return false;
        }
        EntryClass t = (EntryClass)o;
        return this.hash == t.hash;
    }

    public int hashCode() {
        return (int)(this.hash ^ this.hash >>> 32);
    }

    public String toString() {
        return this.getClass() + "[name=" + this.getName() + ", hash=" + this.hash + "]";
    }

    private void computeHash(ClassMapper.EntryField[] fields) throws MarshalException {
        this.hash = 0L;
        try {
            int startDeclaredFields;
            MessageDigest md = MessageDigest.getInstance("SHA");
            DataOutputStream out = new DataOutputStream(new DigestOutputStream(new ByteArrayOutputStream(127), md));
            if (this.superclass != null) {
                out.writeLong(this.superclass.hash);
            }
            out.writeUTF(this.name);
            for (int i = startDeclaredFields = this.superclass != null ? this.superclass.numFields : 0; i < fields.length; ++i) {
                out.writeUTF(fields[i].field.getName());
                out.writeUTF(fields[i].field.getType().getName());
            }
            out.flush();
            byte[] digest = md.digest();
            int i = Math.min(8, digest.length);
            while (--i >= 0) {
                this.hash += (long)(digest[i] & 0xFF) << i * 8;
            }
        }
        catch (Exception e) {
            throw new MarshalException("Unable to calculate type hash for " + this.name, e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.name == null) {
            throw new InvalidObjectException("name cannot be null");
        }
        if (this.hash == 0L) {
            throw new InvalidObjectException("hash cannot be zero");
        }
        this.integrity = MarshalledWrapper.integrityEnforced(in);
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data");
    }
}

