/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security;

import com.sun.jini.collection.WeakIdentityMap;
import com.sun.jini.logging.Levels;
import com.sun.jini.resource.Service;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Guard;
import java.security.Permission;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;
import net.jini.security.GrantPermission;
import net.jini.security.IntegrityVerifier;
import net.jini.security.SecurityContext;
import net.jini.security.TrustVerifier;
import net.jini.security.policy.DynamicPolicy;
import net.jini.security.policy.SecurityContextSource;
import org.apache.river.api.security.SubjectDomain;

public final class Security {
    private static final Logger trustLogger = Logger.getLogger("net.jini.security.trust");
    private static final Logger integrityLogger = Logger.getLogger("net.jini.security.integrity");
    private static final Logger policyLogger = Logger.getLogger("net.jini.security.policy");
    private static Map pathToURLsCache = new WeakHashMap(5);
    private static final WeakIdentityMap integrityMap = new WeakIdentityMap();
    private static final ClassContextAccess ctxAccess = (ClassContextAccess)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return new ClassContextAccess();
        }
    });
    private static final Guard authPerm = new AuthPermission("doAsPrivileged");

    private Security() {
    }

    public static void verifyObjectTrust(Object obj, ClassLoader loader, Collection context) throws RemoteException {
        if (context == null) {
            throw new NullPointerException("collection cannot be null");
        }
        if (new Context(loader, context).isTrustedObject(obj)) {
            return;
        }
        SecurityException e = new SecurityException("object is not trusted: " + obj);
        if (trustLogger.isLoggable(Levels.FAILED)) {
            Security.logThrow(trustLogger, Levels.FAILED, Security.class.getName(), "verifyObjectTrust", "no verifier trusts {0}", new Object[]{obj}, e);
        }
        throw e;
    }

    public static void verifyCodebaseIntegrity(String codebase, ClassLoader loader) throws MalformedURLException {
        if (codebase == null) {
            return;
        }
        if (loader == null) {
            loader = Security.getContextClassLoader();
        }
        URL[] urls = Security.pathToURLs(codebase);
        IntegrityVerifier[] verifiers = Security.getIntegrityVerifiers(loader);
        int i = urls.length;
        block0: while (--i >= 0) {
            for (int j = 0; j < verifiers.length; ++j) {
                if (!verifiers[j].providesIntegrity(urls[i])) continue;
                if (!integrityLogger.isLoggable(Level.FINE)) continue block0;
                integrityLogger.log(Level.FINE, "{0} verifies {1}", new Object[]{verifiers[j], urls[i]});
                continue block0;
            }
            SecurityException e = new SecurityException("URL does not provide integrity: " + urls[i]);
            if (integrityLogger.isLoggable(Levels.FAILED)) {
                Security.logThrow(integrityLogger, Levels.FAILED, Security.class.getName(), "verifyCodebaseIntegrity", "no verifier verifies {0}", new Object[]{urls[i]}, e);
            }
            throw e;
        }
    }

    private static void logThrow(Logger logger, Level level, String clazz, String method, String msg, Object[] args, Throwable t) {
        LogRecord lr = new LogRecord(level, msg);
        lr.setLoggerName(logger.getName());
        lr.setSourceClassName(clazz);
        lr.setSourceMethodName(method);
        lr.setParameters(args);
        lr.setThrown(t);
        logger.log(lr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL[] pathToURLs(String path) throws MalformedURLException {
        Map map = pathToURLsCache;
        synchronized (map) {
            Object[] v = (Object[])pathToURLsCache.get(path);
            if (v != null) {
                return (URL[])v[0];
            }
        }
        StringTokenizer st = new StringTokenizer(path);
        URL[] urls = new URL[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            urls[i] = new URL(st.nextToken());
            ++i;
        }
        Map map2 = pathToURLsCache;
        synchronized (map2) {
            pathToURLsCache.put(path, new Object[]{urls, new SoftReference<String>(path)});
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IntegrityVerifier[] getIntegrityVerifiers(final ClassLoader cl) {
        SoftReference ref;
        WeakIdentityMap weakIdentityMap = integrityMap;
        synchronized (weakIdentityMap) {
            ref = (SoftReference)integrityMap.get(cl);
        }
        IntegrityVerifier[] verifiers = null;
        if (ref != null) {
            verifiers = (IntegrityVerifier[])ref.get();
        }
        if (verifiers == null) {
            final ArrayList list = new ArrayList(1);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Iterator iter2 = Service.providers(IntegrityVerifier.class, cl);
                    while (iter2.hasNext()) {
                        list.add(iter2.next());
                    }
                    return null;
                }
            });
            if (integrityLogger.isLoggable(Level.FINE)) {
                integrityLogger.logp(Level.FINE, Security.class.getName(), "verifyCodebaseIntegrity", "integrity verifiers {0}", new Object[]{list});
            }
            verifiers = list.toArray(new IntegrityVerifier[list.size()]);
            WeakIdentityMap weakIdentityMap2 = integrityMap;
            synchronized (weakIdentityMap2) {
                integrityMap.put(cl, new SoftReference<IntegrityVerifier[]>(verifiers));
            }
        }
        return verifiers;
    }

    public static SecurityContext getContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm instanceof SecurityContextSource) {
            return ((SecurityContextSource)((Object)sm)).getContext();
        }
        Policy policy = Security.getPolicy();
        if (policy instanceof SecurityContextSource) {
            return ((SecurityContextSource)((Object)policy)).getContext();
        }
        AccessControlContext acc = AccessController.getContext();
        return new SecurityContextImpl(acc);
    }

    public static <T> T doPrivileged(final PrivilegedAction<T> action) {
        final Class caller = ctxAccess.getCaller();
        final AccessControlContext acc = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return AccessController.doPrivileged(action, Security.createPrivilegedContext(caller, acc));
            }
        });
    }

    public static <T> T doPrivileged(final PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        final Class caller = ctxAccess.getCaller();
        final AccessControlContext acc = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

            @Override
            public T run() throws Exception {
                try {
                    return AccessController.doPrivileged(action, Security.createPrivilegedContext(caller, acc));
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
        });
    }

    public static <T> T doAs(Subject subject, PrivilegedAction<T> action) {
        if (action == null) {
            throw new NullPointerException("action was null");
        }
        AccessControlContext acc = AccessController.getContext();
        return AccessController.doPrivileged(action, Security.combine(acc, subject));
    }

    public static <T> T doAs(Subject subject, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (action == null) {
            throw new NullPointerException("action was null");
        }
        AccessControlContext acc = AccessController.getContext();
        return AccessController.doPrivileged(action, Security.combine(acc, subject));
    }

    public static <T> T doAsPrivileged(Subject subject, PrivilegedAction<T> action, SecurityContext context) {
        if (action == null) {
            throw new NullPointerException("action was null");
        }
        authPerm.checkGuard(null);
        AccessControlContext acc = context != null ? context.getAccessControlContext() : null;
        PrivilegedAction<T> act = context != null ? context.wrap(action) : action;
        return AccessController.doPrivileged(act, Security.combine(acc, subject));
    }

    public static <T> T doAsPrivileged(Subject subject, PrivilegedExceptionAction<T> action, SecurityContext context) throws PrivilegedActionException {
        if (action == null) {
            throw new NullPointerException("action was null");
        }
        authPerm.checkGuard(null);
        AccessControlContext acc = context != null ? context.getAccessControlContext() : null;
        PrivilegedExceptionAction<T> act = context != null ? context.wrap(action) : action;
        return AccessController.doPrivileged(act, Security.combine(acc, subject));
    }

    private static AccessControlContext combine(final AccessControlContext acc, final Subject subject) {
        return AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

            @Override
            public AccessControlContext run() {
                AccessControlContext context;
                AccessControlContext accessControlContext = context = acc != null ? acc : new AccessControlContext(new ProtectionDomain[0]);
                if (subject == null) {
                    return context;
                }
                return new AccessControlContext(context, new DistributedSubjectCombiner(subject));
            }
        });
    }

    private static AccessControlContext createPrivilegedContext(Class caller, AccessControlContext acc) {
        ProtectionDomain[] pds;
        ProtectionDomain[] protectionDomainArray;
        DomainCombiner comb = acc.getDomainCombiner();
        ProtectionDomain pd = caller.getProtectionDomain();
        if (pd != null) {
            ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[1];
            protectionDomainArray = protectionDomainArray2;
            protectionDomainArray2[0] = pd;
        } else {
            protectionDomainArray = pds = null;
        }
        if (comb != null) {
            pds = comb.combine(pds, null);
        }
        if (pds == null) {
            pds = new ProtectionDomain[]{};
        }
        return new AccessControlContext(new AccessControlContext(pds), comb);
    }

    public static boolean grantSupported() {
        Policy policy = Security.getPolicy();
        return policy instanceof DynamicPolicy && ((DynamicPolicy)((Object)policy)).grantSupported();
    }

    public static void grant(Class cl, Permission[] permissions) {
        Security.grant(cl, Security.getCurrentPrincipals(), permissions);
    }

    public static void grant(Class cl, Principal[] principals, Permission[] permissions) {
        Policy policy = Security.getPolicy();
        if (!(policy instanceof DynamicPolicy)) {
            throw new UnsupportedOperationException("grants not supported");
        }
        ((DynamicPolicy)((Object)policy)).grant(cl, principals, permissions);
        if (policyLogger.isLoggable(Level.FINER)) {
            policyLogger.log(Level.FINER, "granted {0} to {1}, {2}", new Object[]{permissions != null ? Arrays.asList(permissions) : null, cl != null ? cl.getName() : null, principals != null ? Arrays.asList(principals) : null});
        }
    }

    public static void grant(Class fromClass, Class toClass) {
        if (fromClass == null || toClass == null) {
            throw new NullPointerException();
        }
        Policy policy = Security.getPolicy();
        if (!(policy instanceof DynamicPolicy)) {
            throw new UnsupportedOperationException("grants not supported");
        }
        DynamicPolicy dpolicy = (DynamicPolicy)((Object)policy);
        Principal[] principals = Security.getCurrentPrincipals();
        Permission[] permissions = Security.grantablePermissions(dpolicy.getGrants(fromClass, principals));
        dpolicy.grant(toClass, principals, permissions);
        if (policyLogger.isLoggable(Level.FINER)) {
            policyLogger.log(Level.FINER, "granted {0} from {1} to {2}, {3}", new Object[]{permissions != null ? Arrays.asList(permissions) : null, fromClass.getName(), toClass.getName(), principals != null ? Arrays.asList(principals) : null});
        }
    }

    private static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static Policy getPolicy() {
        return AccessController.doPrivileged(new PrivilegedAction<Policy>(){

            @Override
            public Policy run() {
                return Policy.getPolicy();
            }
        });
    }

    private static Permission[] grantablePermissions(Permission[] permissions) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null || permissions.length == 0) {
            return permissions;
        }
        try {
            sm.checkPermission(new GrantPermission(permissions));
            return permissions;
        }
        catch (SecurityException e) {
            ArrayList<Permission> list = new ArrayList<Permission>(permissions.length);
            for (int i = 0; i < permissions.length; ++i) {
                try {
                    Permission p = permissions[i];
                    sm.checkPermission(new GrantPermission(p));
                    list.add(p);
                    continue;
                }
                catch (SecurityException e2) {
                    // empty catch block
                }
            }
            return list.toArray(new Permission[list.size()]);
        }
    }

    private static Principal[] getCurrentPrincipals() {
        final AccessControlContext acc = AccessController.getContext();
        Subject s = AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                return Subject.getSubject(acc);
            }
        });
        if (s != null) {
            Set<Principal> ps = s.getPrincipals();
            return ps.toArray(new Principal[ps.size()]);
        }
        return null;
    }

    private static class SubjectProtectionDomain
    extends ProtectionDomain
    implements SubjectDomain {
        private static final CodeSource nullCS = new CodeSource(null, (Certificate[])null);
        private final Subject subject;

        private SubjectProtectionDomain(Subject subject) {
            super(nullCS, new Permissions(), null, (Principal[])subject.getPrincipals().toArray());
            this.subject = subject;
        }

        public int hashCode() {
            int hash = 5;
            hash = 67 * hash + (this.subject != null ? this.subject.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SubjectProtectionDomain)) {
                return false;
            }
            if (this == o) {
                return true;
            }
            SubjectProtectionDomain other = (SubjectProtectionDomain)o;
            if (nullCS != this.getCodeSource()) {
                return false;
            }
            return this.subject == other.subject;
        }

        @Override
        public Subject getSubject() {
            return this.subject;
        }
    }

    private static class DistributedSubjectCombiner
    extends SubjectDomainCombiner {
        private final Subject subject;

        private DistributedSubjectCombiner(Subject subject) {
            super(subject);
            if (subject == null) {
                throw new NullPointerException("subject cannot be null");
            }
            this.subject = subject;
        }

        @Override
        public ProtectionDomain[] combine(ProtectionDomain[] currentDomains, ProtectionDomain[] assignedDomains) {
            int i;
            LinkedHashSet<ProtectionDomain> result = new LinkedHashSet<ProtectionDomain>(currentDomains.length + assignedDomains.length + 1);
            result.add(new SubjectProtectionDomain(this.subject));
            int l = currentDomains.length;
            for (i = 0; i < l; ++i) {
                if (currentDomains[i] == null || currentDomains[i] instanceof SubjectDomain) continue;
                result.add(currentDomains[i]);
            }
            l = assignedDomains.length;
            for (i = 0; i < l; ++i) {
                if (assignedDomains[i] == null || assignedDomains[i] instanceof SubjectDomain) continue;
                result.add(assignedDomains[i]);
            }
            return result.toArray(new ProtectionDomain[result.size()]);
        }
    }

    private static class SecurityContextImpl
    implements SecurityContext {
        private final AccessControlContext acc;
        private final int hashCode;

        public SecurityContextImpl(AccessControlContext acc) {
            this.acc = acc;
            int hash = 7;
            this.hashCode = hash = 23 * hash + (this.acc != null ? this.acc.hashCode() : 0);
        }

        @Override
        public <T> PrivilegedAction<T> wrap(PrivilegedAction<T> a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return a;
        }

        @Override
        public <T> PrivilegedExceptionAction<T> wrap(PrivilegedExceptionAction<T> a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return a;
        }

        @Override
        public AccessControlContext getAccessControlContext() {
            return this.acc;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SecurityContextImpl)) {
                return false;
            }
            SecurityContext that = (SecurityContext)o;
            return this.getAccessControlContext().equals(that.getAccessControlContext());
        }
    }

    private static class ClassContextAccess
    extends SecurityManager {
        private ClassContextAccess() {
        }

        Class getCaller() {
            return this.getClassContext()[2];
        }
    }

    private static class Context
    implements TrustVerifier.Context {
        private final TrustVerifier[] verifiers;
        private final ClassLoader cl;
        private final Collection context;
        private static final WeakIdentityMap map = new WeakIdentityMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Context(ClassLoader cl, Collection context) {
            SoftReference ref;
            this.cl = cl;
            if (cl == null) {
                cl = Security.getContextClassLoader();
            }
            WeakIdentityMap weakIdentityMap = map;
            synchronized (weakIdentityMap) {
                ref = (SoftReference)map.get(cl);
            }
            TrustVerifier[] verifiers = null;
            if (ref != null) {
                verifiers = (TrustVerifier[])ref.get();
            }
            if (verifiers == null) {
                final ArrayList list = new ArrayList(1);
                final ClassLoader scl = cl;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Iterator iter2 = Service.providers(TrustVerifier.class, scl);
                        while (iter2.hasNext()) {
                            list.add(iter2.next());
                        }
                        return null;
                    }
                });
                if (trustLogger.isLoggable(Level.FINE)) {
                    trustLogger.logp(Level.FINE, Security.class.getName(), "verifyObjectTrust", "trust verifiers {0}", list);
                }
                verifiers = list.toArray(new TrustVerifier[list.size()]);
                WeakIdentityMap weakIdentityMap2 = map;
                synchronized (weakIdentityMap2) {
                    map.put(cl, new SoftReference<TrustVerifier[]>(verifiers));
                }
            }
            this.verifiers = verifiers;
            this.context = context;
        }

        @Override
        public boolean isTrustedObject(Object obj) throws RemoteException {
            if (obj == null) {
                return true;
            }
            Exception ex = null;
            for (int i = 0; i < this.verifiers.length; ++i) {
                try {
                    if (!this.verifiers[i].isTrustedObject(obj, this)) continue;
                    if (trustLogger.isLoggable(Level.FINE)) {
                        trustLogger.log(Level.FINE, "{0} trusts {1}", new Object[]{this.verifiers[i], obj});
                    }
                    return true;
                }
                catch (Exception e) {
                    Level level;
                    boolean rethrow = e instanceof RuntimeException && !(e instanceof SecurityException);
                    Level level2 = level = rethrow ? Levels.FAILED : Levels.HANDLED;
                    if (trustLogger.isLoggable(level)) {
                        Security.logThrow(trustLogger, level, this.getClass().getName(), "isTrustedObject", "{0} checking {1} throws", new Object[]{this.verifiers[i], obj}, e);
                    }
                    if (rethrow) {
                        throw (RuntimeException)e;
                    }
                    ex = e;
                }
            }
            if (ex != null) {
                if (trustLogger.isLoggable(Levels.FAILED)) {
                    Security.logThrow(trustLogger, Levels.FAILED, this.getClass().getName(), "isTrustedObject", "checking {0} throws", new Object[]{obj}, ex);
                }
                if (ex instanceof RemoteException) {
                    throw (RemoteException)ex;
                }
                throw (SecurityException)ex;
            }
            if (trustLogger.isLoggable(Level.FINE)) {
                trustLogger.log(Level.FINE, "no verifier trusts {0}", obj);
            }
            return false;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.cl;
        }

        @Override
        public Collection getCallerContext() {
            return this.context;
        }
    }
}

