/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.security.Permission;
import java.security.Principal;
import java.security.ProtectionDomain;
import org.apache.river.api.security.PermissionGrantBuilder;
import org.apache.river.api.security.ProtectionDomainGrant;

class ClassLoaderGrant
extends ProtectionDomainGrant {
    private static final long serialVersionUID = 1L;
    private final int hashCode;

    ClassLoaderGrant(WeakReference<ProtectionDomain> domain, Principal[] groups, Permission[] perm) {
        super(domain, groups, perm);
        int hash = 7;
        this.hashCode = hash = 19 * hash + super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.hashCode() != this.hashCode()) {
            return false;
        }
        return o instanceof ClassLoaderGrant && super.equals(o);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(500);
        return sb.append(super.toString()).append("ClassLoader grant.").toString();
    }

    @Override
    public boolean implies(ProtectionDomain pd) {
        ClassLoader cl = null;
        Principal[] pals = null;
        if (pd != null) {
            cl = pd.getClassLoader();
            pals = this.getPrincipals(pd);
        }
        return this.implies(cl, pals);
    }

    @Override
    public PermissionGrantBuilder getBuilderTemplate() {
        PermissionGrantBuilder pgb = super.getBuilderTemplate();
        return pgb.context(0);
    }

    private Object writeReplace() {
        return this.getBuilderTemplate();
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("PermissionGrantBuilder required");
    }
}

