/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.river.config.LocalHostLookupSpi;

public class LocalHostLookup {
    private static final Logger logger = Logger.getLogger(LocalHostLookup.class.getName());
    private static LocalHostLookupSpi spi = AccessController.doPrivileged(new PrivilegedAction<LocalHostLookupSpi>(){

        @Override
        public LocalHostLookupSpi run() {
            return LocalHostLookup.initSpi();
        }
    });

    private static LocalHostLookupSpi initSpi() {
        ServiceLoader<LocalHostLookupSpi> loader = ServiceLoader.load(LocalHostLookupSpi.class);
        Iterator<LocalHostLookupSpi> iter2 = loader.iterator();
        if (iter2.hasNext()) {
            try {
                LocalHostLookupSpi firstSpi = iter2.next();
                logger.log(Level.CONFIG, "loaded: {0}", firstSpi);
                LocalHostLookup.checkForLoopback(firstSpi);
                return firstSpi;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "error loading LocalHostLookupSpi: {0}", new Object[]{e});
                throw new Error(e);
            }
        }
        DefaultLocalHostLookupProvider defaultLocalHostLookupProvider = new DefaultLocalHostLookupProvider();
        LocalHostLookup.checkForLoopback(defaultLocalHostLookupProvider);
        return defaultLocalHostLookupProvider;
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        return spi.getLocalHost();
    }

    public static String getHostName() throws UnknownHostException {
        return spi.getHostName();
    }

    public static String getHostAddress() throws UnknownHostException {
        return spi.getHostAddress();
    }

    private static void checkForLoopback(LocalHostLookupSpi spi) {
        try {
            if (spi.getLocalHost().isLoopbackAddress()) {
                logger.warning("local host is loopback");
            }
        }
        catch (UnknownHostException ex) {
            logger.log(Level.SEVERE, "{0} during checkForLoopback", new Object[]{ex});
        }
    }

    private LocalHostLookup() {
    }

    static class DefaultLocalHostLookupProvider
    extends LocalHostLookupSpi {
        DefaultLocalHostLookupProvider() {
        }

        @Override
        public InetAddress getLocalHost() throws UnknownHostException {
            return InetAddress.getLocalHost();
        }

        @Override
        public String getHostName() throws UnknownHostException {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }

        @Override
        public String getHostAddress() throws UnknownHostException {
            return InetAddress.getLocalHost().getHostAddress();
        }
    }
}

