/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.impl.net;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class UriString {
    private static final char[] latin = new char[256];
    private static final String[] latinEsc = new String[256];
    private static final Map<String, Character> unreserved = new HashMap<String, Character>(66);
    private static final char escape = '%';
    private static final char[] gen_delims = new char[]{':', '/', '?', '#', '[', ']', '@'};
    private static final char[] sub_delims = new char[]{'!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '='};
    private static final char[] lowalpha = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] upalpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] numeric = "0123456789".toCharArray();
    private static final char[] unres_punct = new char[]{'-', '.', '_', '~'};
    private static final char[] schemeEx = "+-.".toCharArray();

    private UriString() {
    }

    private static void processUnreserved() {
        int n;
        int i;
        int l = lowalpha.length;
        for (i = 0; i < l; ++i) {
            n = UriString.index(latin, lowalpha[i]);
            unreserved.put(latinEsc[i], Character.valueOf(lowalpha[i]));
        }
        l = upalpha.length;
        for (i = 0; i < l; ++i) {
            n = UriString.index(latin, upalpha[i]);
            unreserved.put(latinEsc[i], Character.valueOf(upalpha[i]));
        }
        l = numeric.length;
        for (i = 0; i < l; ++i) {
            n = UriString.index(latin, numeric[i]);
            unreserved.put(latinEsc[i], Character.valueOf(numeric[i]));
        }
        l = unres_punct.length;
        for (i = 0; i < l; ++i) {
            n = UriString.index(latin, unres_punct[i]);
            unreserved.put(latinEsc[i], Character.valueOf(unres_punct[i]));
        }
    }

    public static int index(char[] array, char character) {
        int l = array.length;
        for (int i = 0; i < l; ++i) {
            if (array[i] != character) continue;
            return i;
        }
        return -1;
    }

    public static String escapeIllegalCharacters(String str) throws URISyntaxException {
        if (str == null) {
            return null;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        StringBuilder sb = new StringBuilder(len + 12);
        boolean esc = false;
        for (int i = 0; i < len; ++i) {
            if (chars[i] == '%') {
                sb.append(chars[i]);
                continue;
            }
            if (UriString.index(gen_delims, chars[i]) != -1 || UriString.index(sub_delims, chars[i]) != -1 || UriString.index(lowalpha, chars[i]) != -1 || UriString.index(upalpha, chars[i]) != -1 || UriString.index(numeric, chars[i]) != -1 || UriString.index(unres_punct, chars[i]) != -1) {
                sb.append(chars[i]);
                continue;
            }
            int n = UriString.index(latin, chars[i]);
            if (n < 0) {
                throw new URISyntaxException(str, "String contains unescapable character");
            }
            sb.append(latinEsc[n]);
            esc = true;
        }
        if (!esc) {
            return str;
        }
        return sb.toString();
    }

    public static String fixWindowsURI(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("file:") || path.startsWith("FILE:")) {
            char[] u = path.toCharArray();
            int l = u.length;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < l; ++i) {
                if (u[i] == File.separatorChar) {
                    sb.append('/');
                    continue;
                }
                if (i == 5 && path.startsWith(":", 6)) {
                    sb.append("/");
                }
                sb.append(u[i]);
            }
            return sb.toString();
        }
        return path;
    }

    public static URI normalise(URI codebase) throws URISyntaxException {
        if (codebase == null) {
            return null;
        }
        String scheme = codebase.getScheme();
        if (scheme != null) {
            scheme = scheme.toLowerCase();
        }
        if ("file".equals(scheme)) {
            if (codebase.getHost() == null || codebase.getHost().isEmpty()) {
                String path = codebase.getPath();
                if (path == null || path.length() == 0) {
                    path = "*";
                }
                return UriString.normalisation(UriString.filePathToURI(new File(path).getAbsolutePath()));
            }
            return UriString.normalisation(codebase);
        }
        return UriString.normalisation(codebase);
    }

    private static URI filePathToURI(String path) throws URISyntaxException {
        if (File.separatorChar == '\\') {
            path = path.replace(File.separatorChar, '/');
            path = path.toUpperCase();
        }
        if (!path.startsWith("/")) {
            return new URI("file", null, new StringBuilder(path.length() + 1).append('/').append(path).toString(), null, null);
        }
        return new URI("file", null, path, null, null);
    }

    public static URI normalisation(URI uri) throws URISyntaxException {
        String host;
        if (uri == null) {
            return null;
        }
        uri = uri.normalize();
        String scheme = uri.getScheme();
        char[] esc = new char[3];
        if (scheme != null) {
            scheme = scheme.toLowerCase();
            char[] scm = scheme.toCharArray();
            int l = scm.length;
            for (int i = 0; i < l; ++i) {
                if (UriString.index(lowalpha, scm[i]) >= 0 || UriString.index(numeric, scm[i]) >= 0 || UriString.index(schemeEx, scm[i]) >= 0) continue;
                throw new URISyntaxException(scheme, "Scheme contains illegal character at index " + i);
            }
        }
        if ((host = uri.getHost()) != null) {
            char[] hos = host.toCharArray();
            int l = hos.length;
            StringBuilder sb = new StringBuilder(l + 12);
            int escIndex = -1;
            for (int i = 0; i < l; ++i) {
                if (hos[i] == '%') {
                    esc[0] = hos[i];
                    esc[1] = hos[i + 1];
                    esc[2] = hos[i + 2];
                    String e = new String(esc).toUpperCase();
                    Character c = unreserved.get(e);
                    if (c != null) {
                        sb.append(c);
                        i += 2;
                        continue;
                    }
                    sb.append(hos[i]);
                    escIndex = i;
                    continue;
                }
                if (escIndex > 0 && i > escIndex && i < escIndex + 3) {
                    if (UriString.index(numeric, hos[i]) > 0) {
                        sb.append(hos[i]);
                        continue;
                    }
                    if (UriString.index(upalpha, hos[i]) > 0) {
                        sb.append(hos[i]);
                        continue;
                    }
                    int n = UriString.index(lowalpha, hos[i]);
                    if (n > 0) {
                        sb.append(upalpha[n]);
                        continue;
                    }
                    throw new URISyntaxException(host, "host contains escaped sequence that has an illegal character at index " + i);
                }
                int n = UriString.index(upalpha, hos[i]);
                if (n > 0) {
                    sb.append(lowalpha[n]);
                    continue;
                }
                sb.append(hos[i]);
            }
            host = sb.toString();
        }
        String authority = uri.getAuthority();
        String path = uri.getPath();
        if (path != null && !path.equals("")) {
            if (authority != null) {
                if (!path.startsWith("/")) {
                    path = '/' + path;
                }
            } else if (path.startsWith("//") && !path.startsWith("///")) {
                throw new URISyntaxException(path, "Path cannot start with two slash characters becuause Authority component is null");
            }
            char[] pth = path.toCharArray();
            int l = pth.length;
            StringBuilder sb = new StringBuilder(l);
            int escIndex = -1;
            for (int i = 0; i < l; ++i) {
                if (pth[i] == '%') {
                    esc[0] = pth[i];
                    esc[1] = pth[i + 1];
                    esc[2] = pth[i + 2];
                    String e = new String(esc).toUpperCase();
                    Character c = unreserved.get(e);
                    if (c != null) {
                        sb.append(c);
                        i += 2;
                        continue;
                    }
                    sb.append(pth[i]);
                    escIndex = i;
                    continue;
                }
                if (escIndex > 0 && i > escIndex && i < escIndex + 3) {
                    if (UriString.index(numeric, pth[i]) > 0) {
                        sb.append(pth[i]);
                        continue;
                    }
                    if (UriString.index(upalpha, pth[i]) > 0) {
                        sb.append(pth[i]);
                        continue;
                    }
                    int n = UriString.index(lowalpha, pth[i]);
                    if (n > 0) {
                        sb.append(upalpha[n]);
                        continue;
                    }
                    throw new URISyntaxException(path, "path contains escaped sequence that has an illegal character at index " + i);
                }
                sb.append(pth[i]);
            }
            path = sb.toString();
        }
        return new URI(scheme, uri.getRawUserInfo(), host, uri.getPort(), path, uri.getQuery(), uri.getFragment());
    }

    private static void processLatin() {
        UriString.latin[0] = '\u0000';
        UriString.latinEsc[0] = "%00";
        UriString.latin[1] = '\u0001';
        UriString.latinEsc[1] = "%01";
        UriString.latin[2] = 2;
        UriString.latinEsc[2] = "%02";
        UriString.latin[3] = 3;
        UriString.latinEsc[3] = "%03";
        UriString.latin[4] = 4;
        UriString.latinEsc[4] = "%04";
        UriString.latin[5] = 5;
        UriString.latinEsc[5] = "%05";
        UriString.latin[6] = 6;
        UriString.latinEsc[6] = "%06";
        UriString.latin[7] = 7;
        UriString.latinEsc[7] = "%07";
        UriString.latin[8] = 8;
        UriString.latinEsc[8] = "%08";
        UriString.latin[9] = 9;
        UriString.latinEsc[9] = "%09";
        UriString.latin[10] = 10;
        UriString.latinEsc[10] = "%0A";
        UriString.latin[11] = 11;
        UriString.latinEsc[11] = "%0B";
        UriString.latin[12] = 12;
        UriString.latinEsc[12] = "%0C";
        UriString.latin[13] = 13;
        UriString.latinEsc[13] = "%0D";
        UriString.latin[14] = 14;
        UriString.latinEsc[14] = "%0E";
        UriString.latin[15] = 15;
        UriString.latinEsc[15] = "%0F";
        UriString.latin[16] = 16;
        UriString.latinEsc[16] = "%10";
        UriString.latin[17] = 17;
        UriString.latinEsc[17] = "%11";
        UriString.latin[18] = 18;
        UriString.latinEsc[18] = "%12";
        UriString.latin[19] = 19;
        UriString.latinEsc[19] = "%13";
        UriString.latin[20] = 20;
        UriString.latinEsc[20] = "%14";
        UriString.latin[21] = 21;
        UriString.latinEsc[21] = "%15";
        UriString.latin[22] = 22;
        UriString.latinEsc[22] = "%16";
        UriString.latin[23] = 23;
        UriString.latinEsc[23] = "%17";
        UriString.latin[24] = 24;
        UriString.latinEsc[24] = "%18";
        UriString.latin[25] = 25;
        UriString.latinEsc[25] = "%19";
        UriString.latin[26] = 26;
        UriString.latinEsc[26] = "%1A";
        UriString.latin[27] = 27;
        UriString.latinEsc[27] = "%1B";
        UriString.latin[28] = 28;
        UriString.latinEsc[28] = "%1C";
        UriString.latin[29] = 29;
        UriString.latinEsc[29] = "%1D";
        UriString.latin[30] = 30;
        UriString.latinEsc[30] = "%1E";
        UriString.latin[31] = 31;
        UriString.latinEsc[31] = "%1F";
        UriString.latin[32] = 32;
        UriString.latinEsc[32] = "%20";
        UriString.latin[33] = 33;
        UriString.latinEsc[33] = "%21";
        UriString.latin[34] = 34;
        UriString.latinEsc[34] = "%22";
        UriString.latin[35] = 35;
        UriString.latinEsc[35] = "%23";
        UriString.latin[36] = 36;
        UriString.latinEsc[36] = "%24";
        UriString.latin[37] = 37;
        UriString.latinEsc[37] = "%25";
        UriString.latin[38] = 38;
        UriString.latinEsc[38] = "%26";
        UriString.latin[39] = 39;
        UriString.latinEsc[39] = "%27";
        UriString.latin[40] = 40;
        UriString.latinEsc[40] = "%28";
        UriString.latin[41] = 41;
        UriString.latinEsc[41] = "%29";
        UriString.latin[42] = 42;
        UriString.latinEsc[42] = "%2A";
        UriString.latin[43] = 43;
        UriString.latinEsc[43] = "%2B";
        UriString.latin[44] = 44;
        UriString.latinEsc[44] = "%2C";
        UriString.latin[45] = 45;
        UriString.latinEsc[0] = "%2D";
        UriString.latin[46] = 46;
        UriString.latinEsc[46] = "%2E";
        UriString.latin[47] = 47;
        UriString.latinEsc[47] = "%2F";
        UriString.latin[48] = 48;
        UriString.latinEsc[48] = "%30";
        UriString.latin[49] = 49;
        UriString.latinEsc[49] = "%31";
        UriString.latin[50] = 50;
        UriString.latinEsc[50] = "%32";
        UriString.latin[51] = 51;
        UriString.latinEsc[51] = "%33";
        UriString.latin[52] = 52;
        UriString.latinEsc[52] = "%34";
        UriString.latin[53] = 53;
        UriString.latinEsc[53] = "%35";
        UriString.latin[54] = 54;
        UriString.latinEsc[54] = "%36";
        UriString.latin[55] = 55;
        UriString.latinEsc[55] = "%37";
        UriString.latin[56] = 56;
        UriString.latinEsc[56] = "%38";
        UriString.latin[57] = 57;
        UriString.latinEsc[57] = "%39";
        UriString.latin[58] = 58;
        UriString.latinEsc[58] = "%3A";
        UriString.latin[59] = 59;
        UriString.latinEsc[59] = "%3B";
        UriString.latin[60] = 60;
        UriString.latinEsc[60] = "%3C";
        UriString.latin[61] = 61;
        UriString.latinEsc[61] = "%3D";
        UriString.latin[62] = 62;
        UriString.latinEsc[62] = "%3E";
        UriString.latin[63] = 63;
        UriString.latinEsc[63] = "%3F";
        UriString.latin[64] = 64;
        UriString.latinEsc[64] = "%40";
        UriString.latin[65] = 65;
        UriString.latinEsc[65] = "%41";
        UriString.latin[66] = 66;
        UriString.latinEsc[66] = "%42";
        UriString.latin[67] = 67;
        UriString.latinEsc[67] = "%43";
        UriString.latin[68] = 68;
        UriString.latinEsc[68] = "%44";
        UriString.latin[69] = 69;
        UriString.latinEsc[69] = "%45";
        UriString.latin[70] = 70;
        UriString.latinEsc[70] = "%46";
        UriString.latin[71] = 71;
        UriString.latinEsc[71] = "%47";
        UriString.latin[72] = 72;
        UriString.latinEsc[72] = "%48";
        UriString.latin[73] = 73;
        UriString.latinEsc[73] = "%49";
        UriString.latin[74] = 74;
        UriString.latinEsc[74] = "%4A";
        UriString.latin[75] = 75;
        UriString.latinEsc[75] = "%4B";
        UriString.latin[76] = 76;
        UriString.latinEsc[76] = "%4C";
        UriString.latin[77] = 77;
        UriString.latinEsc[77] = "%4D";
        UriString.latin[78] = 78;
        UriString.latinEsc[78] = "%4E";
        UriString.latin[79] = 79;
        UriString.latinEsc[79] = "%4F";
        UriString.latin[80] = 80;
        UriString.latinEsc[80] = "%50";
        UriString.latin[81] = 81;
        UriString.latinEsc[81] = "%51";
        UriString.latin[82] = 82;
        UriString.latinEsc[82] = "%52";
        UriString.latin[83] = 83;
        UriString.latinEsc[83] = "%53";
        UriString.latin[84] = 84;
        UriString.latinEsc[84] = "%54";
        UriString.latin[85] = 85;
        UriString.latinEsc[85] = "%55";
        UriString.latin[86] = 86;
        UriString.latinEsc[86] = "%56";
        UriString.latin[87] = 87;
        UriString.latinEsc[87] = "%57";
        UriString.latin[88] = 88;
        UriString.latinEsc[88] = "%58";
        UriString.latin[89] = 89;
        UriString.latinEsc[89] = "%59";
        UriString.latin[90] = 90;
        UriString.latinEsc[90] = "%5A";
        UriString.latin[91] = 91;
        UriString.latinEsc[91] = "%5B";
        UriString.latin[92] = 92;
        UriString.latinEsc[92] = "%5C";
        UriString.latin[93] = 93;
        UriString.latinEsc[93] = "%5D";
        UriString.latin[94] = 94;
        UriString.latinEsc[94] = "%5E";
        UriString.latin[95] = 95;
        UriString.latinEsc[95] = "%5F";
        UriString.latin[96] = 96;
        UriString.latinEsc[96] = "%60";
        UriString.latin[97] = 97;
        UriString.latinEsc[97] = "%61";
        UriString.latin[98] = 98;
        UriString.latinEsc[98] = "%62";
        UriString.latin[99] = 99;
        UriString.latinEsc[99] = "%63";
        UriString.latin[100] = 100;
        UriString.latinEsc[100] = "%64";
        UriString.latin[101] = 101;
        UriString.latinEsc[101] = "%65";
        UriString.latin[102] = 102;
        UriString.latinEsc[102] = "%66";
        UriString.latin[103] = 103;
        UriString.latinEsc[103] = "%67";
        UriString.latin[104] = 104;
        UriString.latinEsc[104] = "%68";
        UriString.latin[105] = 105;
        UriString.latinEsc[105] = "%69";
        UriString.latin[106] = 106;
        UriString.latinEsc[106] = "%6A";
        UriString.latin[107] = 107;
        UriString.latinEsc[107] = "%6B";
        UriString.latin[108] = 108;
        UriString.latinEsc[108] = "%6C";
        UriString.latin[109] = 109;
        UriString.latinEsc[109] = "%6D";
        UriString.latin[110] = 110;
        UriString.latinEsc[110] = "%6E";
        UriString.latin[111] = 111;
        UriString.latinEsc[111] = "%6F";
        UriString.latin[112] = 112;
        UriString.latinEsc[112] = "%70";
        UriString.latin[113] = 113;
        UriString.latinEsc[113] = "%71";
        UriString.latin[114] = 114;
        UriString.latinEsc[114] = "%72";
        UriString.latin[115] = 115;
        UriString.latinEsc[115] = "%73";
        UriString.latin[116] = 116;
        UriString.latinEsc[116] = "%74";
        UriString.latin[117] = 117;
        UriString.latinEsc[117] = "%75";
        UriString.latin[118] = 118;
        UriString.latinEsc[118] = "%76";
        UriString.latin[119] = 119;
        UriString.latinEsc[119] = "%77";
        UriString.latin[120] = 120;
        UriString.latinEsc[120] = "%78";
        UriString.latin[121] = 121;
        UriString.latinEsc[121] = "%79";
        UriString.latin[122] = 122;
        UriString.latinEsc[122] = "%7A";
        UriString.latin[123] = 123;
        UriString.latinEsc[123] = "%7B";
        UriString.latin[124] = 124;
        UriString.latinEsc[124] = "%7C";
        UriString.latin[125] = 125;
        UriString.latinEsc[125] = "%7D";
        UriString.latin[126] = 126;
        UriString.latinEsc[126] = "%7E";
        UriString.latin[127] = 127;
        UriString.latinEsc[127] = "%7F";
        UriString.latin[128] = 128;
        UriString.latinEsc[128] = "%80";
        UriString.latin[129] = 129;
        UriString.latinEsc[129] = "%81";
        UriString.latin[130] = 130;
        UriString.latinEsc[130] = "%82";
        UriString.latin[131] = 131;
        UriString.latinEsc[131] = "%83";
        UriString.latin[132] = 132;
        UriString.latinEsc[132] = "%84";
        UriString.latin[133] = 133;
        UriString.latinEsc[133] = "%85";
        UriString.latin[134] = 134;
        UriString.latinEsc[134] = "%86";
        UriString.latin[135] = 135;
        UriString.latinEsc[135] = "%87";
        UriString.latin[136] = 136;
        UriString.latinEsc[136] = "%88";
        UriString.latin[137] = 137;
        UriString.latinEsc[137] = "%89";
        UriString.latin[138] = 138;
        UriString.latinEsc[138] = "%8A";
        UriString.latin[139] = 139;
        UriString.latinEsc[139] = "%8B";
        UriString.latin[140] = 140;
        UriString.latinEsc[140] = "%8C";
        UriString.latin[141] = 141;
        UriString.latinEsc[141] = "%8D";
        UriString.latin[142] = 142;
        UriString.latinEsc[142] = "%8E";
        UriString.latin[143] = 143;
        UriString.latinEsc[143] = "%8F";
        UriString.latin[144] = 144;
        UriString.latinEsc[144] = "%90";
        UriString.latin[145] = 145;
        UriString.latinEsc[145] = "%91";
        UriString.latin[146] = 146;
        UriString.latinEsc[146] = "%92";
        UriString.latin[147] = 147;
        UriString.latinEsc[147] = "%93";
        UriString.latin[148] = 148;
        UriString.latinEsc[148] = "%94";
        UriString.latin[149] = 149;
        UriString.latinEsc[149] = "%95";
        UriString.latin[150] = 150;
        UriString.latinEsc[150] = "%96";
        UriString.latin[151] = 151;
        UriString.latinEsc[151] = "%97";
        UriString.latin[152] = 152;
        UriString.latinEsc[152] = "%98";
        UriString.latin[153] = 153;
        UriString.latinEsc[153] = "%99";
        UriString.latin[154] = 154;
        UriString.latinEsc[154] = "%9A";
        UriString.latin[155] = 155;
        UriString.latinEsc[155] = "%9B";
        UriString.latin[156] = 156;
        UriString.latinEsc[156] = "%9C";
        UriString.latin[157] = 157;
        UriString.latinEsc[157] = "%9D";
        UriString.latin[158] = 158;
        UriString.latinEsc[158] = "%9E";
        UriString.latin[159] = 159;
        UriString.latinEsc[159] = "%9F";
        UriString.latin[160] = 160;
        UriString.latinEsc[160] = "%A0";
        UriString.latin[161] = 161;
        UriString.latinEsc[161] = "%A1";
        UriString.latin[162] = 162;
        UriString.latinEsc[162] = "%A2";
        UriString.latin[163] = 163;
        UriString.latinEsc[163] = "%A3";
        UriString.latin[164] = 164;
        UriString.latinEsc[164] = "%A4";
        UriString.latin[165] = 165;
        UriString.latinEsc[165] = "%A5";
        UriString.latin[166] = 166;
        UriString.latinEsc[166] = "%A6";
        UriString.latin[167] = 167;
        UriString.latinEsc[167] = "%A7";
        UriString.latin[168] = 168;
        UriString.latinEsc[168] = "%A8";
        UriString.latin[169] = 169;
        UriString.latinEsc[169] = "%A9";
        UriString.latin[170] = 170;
        UriString.latinEsc[170] = "%AA";
        UriString.latin[171] = 171;
        UriString.latinEsc[171] = "%AB";
        UriString.latin[172] = 172;
        UriString.latinEsc[172] = "%AC";
        UriString.latin[173] = 173;
        UriString.latinEsc[173] = "%AD";
        UriString.latin[174] = 174;
        UriString.latinEsc[174] = "%AE";
        UriString.latin[175] = 175;
        UriString.latinEsc[175] = "%AF";
        UriString.latin[176] = 176;
        UriString.latinEsc[176] = "%B0";
        UriString.latin[177] = 177;
        UriString.latinEsc[177] = "%B1";
        UriString.latin[178] = 178;
        UriString.latinEsc[178] = "%B2";
        UriString.latin[179] = 179;
        UriString.latinEsc[179] = "%B3";
        UriString.latin[180] = 180;
        UriString.latinEsc[180] = "%B4";
        UriString.latin[181] = 181;
        UriString.latinEsc[181] = "%B5";
        UriString.latin[182] = 182;
        UriString.latinEsc[182] = "%B6";
        UriString.latin[183] = 183;
        UriString.latinEsc[183] = "%B7";
        UriString.latin[184] = 184;
        UriString.latinEsc[184] = "%B8";
        UriString.latin[185] = 185;
        UriString.latinEsc[185] = "%B9";
        UriString.latin[186] = 186;
        UriString.latinEsc[186] = "%BA";
        UriString.latin[187] = 187;
        UriString.latinEsc[187] = "%BB";
        UriString.latin[188] = 188;
        UriString.latinEsc[188] = "%BC";
        UriString.latin[189] = 189;
        UriString.latinEsc[189] = "%BD";
        UriString.latin[190] = 190;
        UriString.latinEsc[190] = "%BE";
        UriString.latin[191] = 191;
        UriString.latinEsc[191] = "%BF";
        UriString.latin[192] = 192;
        UriString.latinEsc[192] = "%C0";
        UriString.latin[193] = 193;
        UriString.latinEsc[193] = "%C1";
        UriString.latin[194] = 194;
        UriString.latinEsc[194] = "%C2";
        UriString.latin[195] = 195;
        UriString.latinEsc[195] = "%C3";
        UriString.latin[196] = 196;
        UriString.latinEsc[196] = "%C4";
        UriString.latin[197] = 197;
        UriString.latinEsc[197] = "%C5";
        UriString.latin[198] = 198;
        UriString.latinEsc[198] = "%C6";
        UriString.latin[199] = 199;
        UriString.latinEsc[199] = "%C7";
        UriString.latin[200] = 200;
        UriString.latinEsc[200] = "%C8";
        UriString.latin[201] = 201;
        UriString.latinEsc[201] = "%C9";
        UriString.latin[202] = 202;
        UriString.latinEsc[202] = "%CA";
        UriString.latin[203] = 203;
        UriString.latinEsc[203] = "%CB";
        UriString.latin[204] = 204;
        UriString.latinEsc[204] = "%CC";
        UriString.latin[205] = 205;
        UriString.latinEsc[205] = "%CD";
        UriString.latin[206] = 206;
        UriString.latinEsc[206] = "%CE";
        UriString.latin[207] = 207;
        UriString.latinEsc[207] = "%CF";
        UriString.latin[208] = 208;
        UriString.latinEsc[208] = "%D0";
        UriString.latin[209] = 209;
        UriString.latinEsc[209] = "%D1";
        UriString.latin[210] = 210;
        UriString.latinEsc[210] = "%D2";
        UriString.latin[211] = 211;
        UriString.latinEsc[211] = "%D3";
        UriString.latin[212] = 212;
        UriString.latinEsc[212] = "%D4";
        UriString.latin[213] = 213;
        UriString.latinEsc[213] = "%D5";
        UriString.latin[214] = 214;
        UriString.latinEsc[214] = "%D6";
        UriString.latin[215] = 215;
        UriString.latinEsc[215] = "%D7";
        UriString.latin[216] = 216;
        UriString.latinEsc[216] = "%D8";
        UriString.latin[217] = 217;
        UriString.latinEsc[217] = "%D9";
        UriString.latin[218] = 218;
        UriString.latinEsc[218] = "%DA";
        UriString.latin[219] = 219;
        UriString.latinEsc[219] = "%DB";
        UriString.latin[220] = 220;
        UriString.latinEsc[220] = "%DC";
        UriString.latin[221] = 221;
        UriString.latinEsc[221] = "%DD";
        UriString.latin[222] = 222;
        UriString.latinEsc[222] = "%DE";
        UriString.latin[223] = 223;
        UriString.latinEsc[223] = "%DF";
        UriString.latin[224] = 224;
        UriString.latinEsc[224] = "%E0";
        UriString.latin[225] = 225;
        UriString.latinEsc[225] = "%E1";
        UriString.latin[226] = 226;
        UriString.latinEsc[226] = "%E2";
        UriString.latin[227] = 227;
        UriString.latinEsc[227] = "%E3";
        UriString.latin[228] = 228;
        UriString.latinEsc[228] = "%E4";
        UriString.latin[229] = 229;
        UriString.latinEsc[229] = "%E5";
        UriString.latin[230] = 230;
        UriString.latinEsc[230] = "%E6";
        UriString.latin[231] = 231;
        UriString.latinEsc[231] = "%E7";
        UriString.latin[232] = 232;
        UriString.latinEsc[232] = "%E8";
        UriString.latin[233] = 233;
        UriString.latinEsc[233] = "%E9";
        UriString.latin[234] = 234;
        UriString.latinEsc[234] = "%EA";
        UriString.latin[235] = 235;
        UriString.latinEsc[235] = "%EB";
        UriString.latin[236] = 236;
        UriString.latinEsc[236] = "%EC";
        UriString.latin[237] = 237;
        UriString.latinEsc[237] = "%ED";
        UriString.latin[238] = 238;
        UriString.latinEsc[238] = "%EE";
        UriString.latin[239] = 239;
        UriString.latinEsc[239] = "%EF";
        UriString.latin[240] = 240;
        UriString.latinEsc[240] = "%F0";
        UriString.latin[241] = 241;
        UriString.latinEsc[241] = "%F1";
        UriString.latin[242] = 242;
        UriString.latinEsc[242] = "%F2";
        UriString.latin[243] = 243;
        UriString.latinEsc[243] = "%F3";
        UriString.latin[244] = 244;
        UriString.latinEsc[244] = "%F4";
        UriString.latin[245] = 245;
        UriString.latinEsc[245] = "%F5";
        UriString.latin[246] = 246;
        UriString.latinEsc[246] = "%F6";
        UriString.latin[247] = 247;
        UriString.latinEsc[247] = "%F7";
        UriString.latin[248] = 248;
        UriString.latinEsc[248] = "%F8";
        UriString.latin[249] = 249;
        UriString.latinEsc[249] = "%F9";
        UriString.latin[250] = 250;
        UriString.latinEsc[250] = "%FA";
        UriString.latin[251] = 251;
        UriString.latinEsc[251] = "%FB";
        UriString.latin[252] = 252;
        UriString.latinEsc[252] = "%FC";
        UriString.latin[253] = 253;
        UriString.latinEsc[253] = "%FD";
        UriString.latin[254] = 254;
        UriString.latinEsc[254] = "%FE";
        UriString.latin[255] = 255;
        UriString.latinEsc[255] = "%FF";
    }

    static {
        UriString.processLatin();
        UriString.processUnreserved();
    }
}

