/*
 * Decompiled with CFR 0.152.
 */
package org.cliffc.high_scale_lib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.cliffc.high_scale_lib.AbstractEntry;
import org.cliffc.high_scale_lib.Counter;
import org.cliffc.high_scale_lib.UtilUnsafe;
import sun.misc.Unsafe;

public class NonBlockingHashMapLong<TypeV>
extends AbstractMap<Long, TypeV>
implements ConcurrentMap<Long, TypeV>,
Serializable {
    private static final long serialVersionUID = 1234123412341234124L;
    private static final int REPROBE_LIMIT = 10;
    private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
    private static final int _Obase = _unsafe.arrayBaseOffset(Object[].class);
    private static final int _Oscale = _unsafe.arrayIndexScale(Object[].class);
    private static final int _Lbase = _unsafe.arrayBaseOffset(long[].class);
    private static final int _Lscale = _unsafe.arrayIndexScale(long[].class);
    private static final long _chm_offset;
    private static final long _val_1_offset;
    private transient CHM _chm;
    private transient Object _val_1;
    private transient long _last_resize_milli;
    private final boolean _opt_for_space;
    private static final int MIN_SIZE_LOG = 4;
    private static final int MIN_SIZE = 16;
    private static final Object NO_MATCH_OLD;
    private static final Object MATCH_ANY;
    private static final Object TOMBSTONE;
    private static final Prime TOMBPRIME;
    private static final long NO_KEY = 0L;
    private transient Counter _reprobes = new Counter();

    private static long rawIndex(Object[] objectArray, int n) {
        assert (n >= 0 && n < objectArray.length);
        return _Obase + n * _Oscale;
    }

    private static long rawIndex(long[] lArray, int n) {
        assert (n >= 0 && n < lArray.length);
        return _Lbase + n * _Lscale;
    }

    private final boolean CAS(long l, Object object, Object object2) {
        return _unsafe.compareAndSwapObject(this, l, object, object2);
    }

    public final void print() {
        System.out.println("=========");
        NonBlockingHashMapLong.print_impl(-99, 0L, this._val_1);
        this._chm.print();
        System.out.println("=========");
    }

    private static final void print_impl(int n, long l, Object object) {
        String string = object instanceof Prime ? "prime_" : "";
        Object object2 = Prime.unbox(object);
        String string2 = object2 == TOMBSTONE ? "tombstone" : object2.toString();
        System.out.println("[" + n + "]=(" + l + "," + string + string2 + ")");
    }

    private final void print2() {
        System.out.println("=========");
        NonBlockingHashMapLong.print2_impl(-99, 0L, this._val_1);
        this._chm.print();
        System.out.println("=========");
    }

    private static final void print2_impl(int n, long l, Object object) {
        if (object != null && Prime.unbox(object) != TOMBSTONE) {
            NonBlockingHashMapLong.print_impl(n, l, object);
        }
    }

    public long reprobes() {
        long l = this._reprobes.get();
        this._reprobes = new Counter();
        return l;
    }

    private static final int reprobe_limit(int n) {
        return 10 + (n >> 2);
    }

    public NonBlockingHashMapLong() {
        this(16, true);
    }

    public NonBlockingHashMapLong(int n) {
        this(n, true);
    }

    public NonBlockingHashMapLong(boolean bl) {
        this(1, bl);
    }

    public NonBlockingHashMapLong(int n, boolean bl) {
        this._opt_for_space = bl;
        this.initialize(n);
    }

    private final void initialize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = 4;
        while (1 << n2 < n) {
            ++n2;
        }
        this._chm = new CHM(this, new Counter(), n2);
        this._val_1 = TOMBSTONE;
        this._last_resize_milli = System.currentTimeMillis();
    }

    @Override
    public int size() {
        return (this._val_1 == TOMBSTONE ? 0 : 1) + this._chm.size();
    }

    public boolean containsKey(long l) {
        return this.get(l) != null;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public TypeV put(long l, TypeV TypeV) {
        return this.putIfMatch(l, TypeV, NO_MATCH_OLD);
    }

    @Override
    public TypeV putIfAbsent(long l, TypeV TypeV) {
        return this.putIfMatch(l, TypeV, TOMBSTONE);
    }

    public TypeV remove(long l) {
        return this.putIfMatch(l, TOMBSTONE, NO_MATCH_OLD);
    }

    public boolean remove(long l, Object object) {
        return this.putIfMatch(l, TOMBSTONE, object) == object;
    }

    @Override
    public TypeV replace(long l, TypeV TypeV) {
        return this.putIfMatch(l, TypeV, MATCH_ANY);
    }

    @Override
    public boolean replace(long l, TypeV TypeV, TypeV TypeV2) {
        return this.putIfMatch(l, TypeV2, TypeV) == TypeV;
    }

    private final TypeV putIfMatch(long l, Object object, Object object2) {
        if (object2 == null || object == null) {
            throw new NullPointerException();
        }
        if (l == 0L) {
            Object object3 = this._val_1;
            if (object2 == NO_MATCH_OLD || object3 == object2 || object2 == MATCH_ANY && object3 != TOMBSTONE || object2.equals(object3)) {
                this.CAS(_val_1_offset, object3, object);
            }
            return (TypeV)(object3 == TOMBSTONE ? null : object3);
        }
        Object object4 = this._chm.putIfMatch(l, object, object2);
        assert (!(object4 instanceof Prime));
        assert (object4 != null);
        return (TypeV)(object4 == TOMBSTONE ? null : object4);
    }

    @Override
    public void clear() {
        CHM cHM = new CHM(this, new Counter(), 4);
        while (!this.CAS(_chm_offset, this._chm, cHM)) {
        }
        this.CAS(_val_1_offset, this._val_1, TOMBSTONE);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this._val_1) {
            return true;
        }
        for (TypeV TypeV : this.values()) {
            if (TypeV != object && !TypeV.equals(object)) continue;
            return true;
        }
        return false;
    }

    public final TypeV get(long l) {
        if (l == 0L) {
            Object object = this._val_1;
            return (TypeV)(object == TOMBSTONE ? null : object);
        }
        Object object = this._chm.get_impl(l);
        assert (!(object instanceof Prime));
        assert (object != TOMBSTONE);
        return (TypeV)object;
    }

    @Override
    public TypeV get(Object object) {
        return object instanceof Long ? (TypeV)this.get((Long)object) : null;
    }

    @Override
    public TypeV remove(Object object) {
        return object instanceof Long ? (TypeV)this.remove((Long)object) : null;
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return object instanceof Long ? this.remove((Long)object, object2) : false;
    }

    @Override
    public boolean containsKey(Object object) {
        return object instanceof Long ? this.containsKey((Long)object) : false;
    }

    @Override
    public TypeV putIfAbsent(Long l, TypeV TypeV) {
        return this.putIfAbsent((long)l, TypeV);
    }

    @Override
    public TypeV replace(Long l, TypeV TypeV) {
        return this.replace((long)l, TypeV);
    }

    @Override
    public TypeV put(Long l, TypeV TypeV) {
        return this.put((long)l, TypeV);
    }

    @Override
    public boolean replace(Long l, TypeV TypeV, TypeV TypeV2) {
        return this.replace((long)l, TypeV, TypeV2);
    }

    private final void help_copy() {
        CHM cHM = this._chm;
        if (cHM._newchm == null) {
            return;
        }
        cHM.help_copy_impl(false);
    }

    public Enumeration<TypeV> elements() {
        return new SnapshotV();
    }

    @Override
    public Collection<TypeV> values() {
        return new AbstractCollection<TypeV>(){

            @Override
            public void clear() {
                NonBlockingHashMapLong.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMapLong.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return NonBlockingHashMapLong.this.containsValue(object);
            }

            @Override
            public Iterator<TypeV> iterator() {
                return new SnapshotV();
            }
        };
    }

    public Enumeration<Long> keys() {
        return new IteratorLong();
    }

    @Override
    public Set<Long> keySet() {
        return new AbstractSet<Long>(){

            @Override
            public void clear() {
                NonBlockingHashMapLong.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMapLong.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return NonBlockingHashMapLong.this.containsKey(object);
            }

            @Override
            public boolean remove(Object object) {
                return NonBlockingHashMapLong.this.remove(object) != null;
            }

            public IteratorLong iterator() {
                return new IteratorLong();
            }
        };
    }

    @Override
    public Set<Map.Entry<Long, TypeV>> entrySet() {
        return new AbstractSet<Map.Entry<Long, TypeV>>(){

            @Override
            public void clear() {
                NonBlockingHashMapLong.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMapLong.this.size();
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return NonBlockingHashMapLong.this.remove(entry.getKey(), entry.getValue());
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object TypeV = NonBlockingHashMapLong.this.get(entry.getKey());
                return TypeV.equals(entry.getValue());
            }

            @Override
            public Iterator<Map.Entry<Long, TypeV>> iterator() {
                return new SnapshotE();
            }
        };
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (long l : this.keySet()) {
            TypeV TypeV = this.get(l);
            objectOutputStream.writeLong(l);
            objectOutputStream.writeObject(TypeV);
        }
        objectOutputStream.writeLong(0L);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialize(16);
        while (true) {
            long l = objectInputStream.readLong();
            Object object = objectInputStream.readObject();
            if (l == 0L && object == null) break;
            this.put(l, (TypeV)object);
        }
    }

    static {
        Field field = null;
        try {
            field = NonBlockingHashMapLong.class.getDeclaredField("_chm");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
        _chm_offset = _unsafe.objectFieldOffset(field);
        try {
            field = NonBlockingHashMapLong.class.getDeclaredField("_val_1");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
        _val_1_offset = _unsafe.objectFieldOffset(field);
        NO_MATCH_OLD = new Object();
        MATCH_ANY = new Object();
        TOMBSTONE = new Object();
        TOMBPRIME = new Prime(TOMBSTONE);
    }

    private class SnapshotE
    implements Iterator<Map.Entry<Long, TypeV>> {
        final SnapshotV _ss;

        public SnapshotE() {
            this._ss = new SnapshotV();
        }

        @Override
        public void remove() {
            this._ss.remove();
        }

        @Override
        public Map.Entry<Long, TypeV> next() {
            this._ss.next();
            return new NBHMLEntry(this._ss._prevK, this._ss._prevV);
        }

        @Override
        public boolean hasNext() {
            return this._ss.hasNext();
        }
    }

    private class NBHMLEntry
    extends AbstractEntry<Long, TypeV> {
        NBHMLEntry(Long l, TypeV TypeV) {
            super(l, TypeV);
        }

        @Override
        public TypeV setValue(TypeV TypeV) {
            if (TypeV == null) {
                throw new NullPointerException();
            }
            this._val = TypeV;
            return NonBlockingHashMapLong.this.put((Long)this._key, TypeV);
        }
    }

    public class IteratorLong
    implements Iterator<Long>,
    Enumeration<Long> {
        private final SnapshotV _ss;

        public IteratorLong() {
            this._ss = new SnapshotV();
        }

        @Override
        public void remove() {
            this._ss.remove();
        }

        @Override
        public Long next() {
            this._ss.next();
            return this._ss._prevK;
        }

        public long nextLong() {
            this._ss.next();
            return this._ss._prevK;
        }

        @Override
        public boolean hasNext() {
            return this._ss.hasNext();
        }

        @Override
        public Long nextElement() {
            return this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private class SnapshotV
    implements Iterator<TypeV>,
    Enumeration<TypeV> {
        final CHM _sschm;
        private int _idx;
        private long _nextK;
        private long _prevK;
        private TypeV _nextV;
        private TypeV _prevV;

        public SnapshotV() {
            CHM cHM;
            while (true) {
                cHM = NonBlockingHashMapLong.this._chm;
                if (cHM._newchm == null) break;
                cHM.help_copy_impl(true);
            }
            this._sschm = cHM;
            this._idx = -1;
            this.next();
        }

        int length() {
            return this._sschm._keys.length;
        }

        long key(int n) {
            return this._sschm._keys[n];
        }

        @Override
        public boolean hasNext() {
            return this._nextV != null;
        }

        @Override
        public TypeV next() {
            if (this._idx != -1 && this._nextV == null) {
                throw new NoSuchElementException();
            }
            this._prevK = this._nextK;
            this._prevV = this._nextV;
            this._nextV = null;
            if (this._idx == -1) {
                this._idx = 0;
                this._nextK = 0L;
                this._nextV = NonBlockingHashMapLong.this.get(this._nextK);
                if (this._nextV != null) {
                    return this._prevV;
                }
            }
            while (this._idx < this.length()) {
                this._nextK = this.key(this._idx++);
                if (this._nextK == 0L || (this._nextV = NonBlockingHashMapLong.this.get(this._nextK)) == null) continue;
                break;
            }
            return this._prevV;
        }

        @Override
        public void remove() {
            if (this._prevV == null) {
                throw new IllegalStateException();
            }
            this._sschm.putIfMatch(this._prevK, TOMBSTONE, this._prevV);
            this._prevV = null;
        }

        @Override
        public TypeV nextElement() {
            return this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private static final class CHM<TypeV>
    implements Serializable {
        final NonBlockingHashMapLong _nbhml;
        private final Counter _size;
        private final Counter _slots;
        volatile CHM _newchm;
        private static final AtomicReferenceFieldUpdater<CHM, CHM> _newchmUpdater = AtomicReferenceFieldUpdater.newUpdater(CHM.class, CHM.class, "_newchm");
        volatile long _resizers;
        private static final AtomicLongFieldUpdater<CHM> _resizerUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_resizers");
        final long[] _keys;
        final Object[] _vals;
        volatile long _copyIdx = 0L;
        private static final AtomicLongFieldUpdater<CHM> _copyIdxUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_copyIdx");
        volatile long _copyDone = 0L;
        private static final AtomicLongFieldUpdater<CHM> _copyDoneUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_copyDone");

        public int size() {
            return (int)this._size.get();
        }

        public int slots() {
            return (int)this._slots.get();
        }

        boolean CAS_newchm(CHM cHM) {
            return _newchmUpdater.compareAndSet(this, null, cHM);
        }

        private final boolean CAS_key(int n, long l, long l2) {
            return _unsafe.compareAndSwapLong(this._keys, NonBlockingHashMapLong.rawIndex(this._keys, n), l, l2);
        }

        private final boolean CAS_val(int n, Object object, Object object2) {
            return _unsafe.compareAndSwapObject(this._vals, NonBlockingHashMapLong.rawIndex(this._vals, n), object, object2);
        }

        CHM(NonBlockingHashMapLong nonBlockingHashMapLong, Counter counter, int n) {
            this._nbhml = nonBlockingHashMapLong;
            this._size = counter;
            this._slots = new Counter();
            this._keys = new long[1 << n];
            this._vals = new Object[1 << n];
        }

        private final void print() {
            for (int i = 0; i < this._keys.length; ++i) {
                long l = this._keys[i];
                if (l == 0L) continue;
                NonBlockingHashMapLong.print_impl(i, l, this._vals[i]);
            }
            CHM cHM = this._newchm;
            if (cHM != null) {
                System.out.println("----");
                cHM.print();
            }
        }

        private final void print2() {
            for (int i = 0; i < this._keys.length; ++i) {
                long l = this._keys[i];
                if (l == 0L) continue;
                NonBlockingHashMapLong.print2_impl(i, l, this._vals[i]);
            }
            CHM cHM = this._newchm;
            if (cHM != null) {
                System.out.println("----");
                cHM.print2();
            }
        }

        private final Object get_impl(long l) {
            int n = this._keys.length;
            int n2 = (int)(l & (long)(n - 1));
            int n3 = 0;
            while (true) {
                long l2 = this._keys[n2];
                Object object = this._vals[n2];
                if (l2 == 0L) {
                    return null;
                }
                if (l == l2) {
                    if (!(object instanceof Prime)) {
                        if (object == TOMBSTONE) {
                            return null;
                        }
                        CHM cHM = this._newchm;
                        return object;
                    }
                    return this.copy_slot_and_check(n2, l).get_impl(l);
                }
                if (++n3 >= NonBlockingHashMapLong.reprobe_limit(n)) {
                    return this._newchm == null ? null : this.copy_slot_and_check(n2, l).get_impl(l);
                }
                n2 = n2 + 1 & n - 1;
            }
        }

        private final Object putIfMatch(long l, Object object, Object object2) {
            assert (object != null);
            assert (!(object instanceof Prime));
            assert (!(object2 instanceof Prime));
            int n = this._keys.length;
            int n2 = (int)(l & (long)(n - 1));
            int n3 = 0;
            long l2 = 0L;
            Object object3 = null;
            while (true) {
                object3 = this._vals[n2];
                l2 = this._keys[n2];
                if (l2 == 0L) {
                    if (object == TOMBSTONE) {
                        return object;
                    }
                    if (this.CAS_key(n2, 0L, l)) {
                        this._slots.add(1L);
                        break;
                    }
                    l2 = this._keys[n2];
                    assert (l2 != 0L);
                }
                if (l2 == l) break;
                if (++n3 >= NonBlockingHashMapLong.reprobe_limit(n)) {
                    CHM cHM = this.resize();
                    if (object2 != null) {
                        this._nbhml.help_copy();
                    }
                    return cHM.putIfMatch(l, object, object2);
                }
                n2 = n2 + 1 & n - 1;
            }
            if (object == object3) {
                return object3;
            }
            if (object3 == null && this.tableFull(n3, n) || object3 instanceof Prime) {
                this.resize();
                return this.copy_slot_and_check(n2, object2).putIfMatch(l, object, object2);
            }
            do {
                assert (!(object3 instanceof Prime));
                if (!(object2 == NO_MATCH_OLD || object3 == object2 || object2 == MATCH_ANY && object3 != TOMBSTONE && object3 != null || object3 == null && object2 == TOMBSTONE || object2 != null && object2.equals(object3))) {
                    return object3;
                }
                if (!this.CAS_val(n2, object3, object)) continue;
                if (object2 != null) {
                    if ((object3 == null || object3 == TOMBSTONE) && object != TOMBSTONE) {
                        this._size.add(1L);
                    }
                    if (object3 != null && object3 != TOMBSTONE && object == TOMBSTONE) {
                        this._size.add(-1L);
                    }
                }
                return object3 == null && object2 != null ? TOMBSTONE : object3;
            } while (!((object3 = this._vals[n2]) instanceof Prime));
            return this.copy_slot_and_check(n2, object2).putIfMatch(l, object, object2);
        }

        private final boolean tableFull(int n, int n2) {
            return n >= 10 && this._slots.estimate_get() >= (long)NonBlockingHashMapLong.reprobe_limit(n2);
        }

        private final CHM resize() {
            int n;
            CHM cHM = this._newchm;
            if (cHM != null) {
                return cHM;
            }
            int n2 = this._keys.length;
            int n3 = n = this.size();
            if (this._nbhml._opt_for_space) {
                if (n >= n2 >> 1) {
                    n3 = n2 << 1;
                }
            } else if (n >= n2 >> 2) {
                n3 = n2 << 1;
                if (n >= n2 >> 1) {
                    n3 = n2 << 2;
                }
            }
            long l = System.currentTimeMillis();
            long l2 = 0L;
            if (n3 <= n2 && l <= this._nbhml._last_resize_milli + 10000L) {
                n3 = n2 << 1;
            }
            if (n3 < n2) {
                n3 = n2;
            }
            int n4 = 4;
            while (1 << n4 < n3) {
                ++n4;
            }
            long l3 = this._resizers;
            while (!_resizerUpdater.compareAndSet(this, l3, l3 + 1L)) {
                l3 = this._resizers;
            }
            int n5 = (1 << n4 << 1) + 4 << 3 >> 20;
            if (l3 >= 2L && n5 > 0) {
                cHM = this._newchm;
                if (cHM != null) {
                    return cHM;
                }
                try {
                    Thread.sleep(8 * n5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((cHM = this._newchm) != null) {
                return cHM;
            }
            cHM = new CHM(this._nbhml, this._size, n4);
            if (this._newchm != null) {
                return this._newchm;
            }
            if (!this.CAS_newchm(cHM)) {
                cHM = this._newchm;
            }
            return cHM;
        }

        private final void help_copy_impl(boolean bl) {
            CHM cHM = this._newchm;
            assert (cHM != null);
            int n = this._keys.length;
            int n2 = Math.min(n, 1024);
            int n3 = -1;
            int n4 = -9999;
            while (this._copyDone < (long)n) {
                if (n3 == -1) {
                    n4 = (int)this._copyIdx;
                    while (n4 < n << 1 && !_copyIdxUpdater.compareAndSet(this, n4, n4 + n2)) {
                        n4 = (int)this._copyIdx;
                    }
                    if (n4 >= n << 1) {
                        n3 = n4;
                    }
                }
                int n5 = 0;
                for (int i = 0; i < n2; ++i) {
                    if (!this.copy_slot(n4 + i & n - 1)) continue;
                    ++n5;
                }
                if (n5 > 0) {
                    this.copy_check_and_promote(n5);
                }
                n4 += n2;
                if (bl || n3 != -1) continue;
                return;
            }
            this.copy_check_and_promote(0);
        }

        private final CHM copy_slot_and_check(int n, Object object) {
            assert (this._newchm != null);
            if (this.copy_slot(n)) {
                this.copy_check_and_promote(1);
            }
            if (object != null) {
                this._nbhml.help_copy();
            }
            return this._newchm;
        }

        private final void copy_check_and_promote(int n) {
            int n2 = this._keys.length;
            long l = this._copyDone;
            long l2 = l + (long)n;
            assert (l2 <= (long)n2);
            if (n > 0) {
                while (!_copyDoneUpdater.compareAndSet(this, l, l2)) {
                    l = this._copyDone;
                    l2 = l + (long)n;
                    assert (l2 <= (long)n2);
                }
            }
            if (l2 == (long)n2 && this._nbhml._chm == this && this._nbhml.CAS(_chm_offset, this, this._newchm)) {
                this._nbhml._last_resize_milli = System.currentTimeMillis();
            }
        }

        private boolean copy_slot(int n) {
            boolean bl;
            Object object;
            long l;
            while ((l = this._keys[n]) == 0L) {
                this.CAS_key(n, 0L, n + this._keys.length);
            }
            Object object2 = this._vals[n];
            while (!(object2 instanceof Prime)) {
                Object object3 = object = object2 == null || object2 == TOMBSTONE ? TOMBPRIME : new Prime(object2);
                if (this.CAS_val(n, object2, object)) {
                    if (object == TOMBPRIME) {
                        return true;
                    }
                    object2 = object;
                    break;
                }
                object2 = this._vals[n];
            }
            if (object2 == TOMBPRIME) {
                return false;
            }
            object = ((Prime)object2)._V;
            assert (object != TOMBSTONE);
            boolean bl2 = bl = this._newchm.putIfMatch(l, object, null) == null;
            while (!this.CAS_val(n, object2, TOMBPRIME)) {
                object2 = this._vals[n];
            }
            return bl;
        }
    }

    private static final class Prime {
        final Object _V;

        Prime(Object object) {
            this._V = object;
        }

        static Object unbox(Object object) {
            return object instanceof Prime ? ((Prime)object)._V : object;
        }
    }
}

