/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.services;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;

public class DevelopmentServices {
    protected Session session;

    public DevelopmentServices() {
    }

    public DevelopmentServices(Session session) {
        this.session = session;
    }

    public void initializeIdentityMap(String className) throws ClassNotFoundException {
        Class classToChange = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        this.getSession().getIdentityMapAccessorInstance().initializeIdentityMap(classToChange);
    }

    public void initializeAllIdentityMaps() {
        this.getSession().getIdentityMapAccessorInstance().initializeIdentityMaps();
    }

    public void setIdentityMapForClass(String className, String identityMapClassType, int maxSize) throws ClassNotFoundException {
        Class classToChange = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        Class identityMapClass = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                identityMapClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(identityMapClassType));
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getCause();
            }
        } else {
            identityMapClass = PrivilegedAccessHelper.getClassForName(identityMapClassType);
        }
        ClassDescriptor descriptor = this.getSession().getDescriptor(classToChange);
        descriptor.setIdentityMapClass(identityMapClass);
        descriptor.setIdentityMapSize(maxSize);
        this.getSession().getIdentityMapAccessorInstance().initializeIdentityMap(classToChange);
    }

    public void refreshProject(String projectFilePath) {
        ((DatabaseSessionImpl)this.getSession()).logout();
        this.getSession().setProject(XMLProjectReader.read(projectFilePath));
        ((DatabaseSessionImpl)this.getSession()).login();
    }

    public void updateCacheSize(String className, int newSize) throws ClassNotFoundException {
        Class classToChange = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        this.getSession().getIdentityMapAccessorInstance().getIdentityMap(classToChange).updateMaxSize(newSize);
    }

    public void setShouldBindAllParameters(boolean shouldBindAllParameters) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setShouldBindAllParameters(shouldBindAllParameters);
    }

    public boolean getShouldBindAllParameters() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return false;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).shouldBindAllParameters();
    }

    public void setStringBindingSize(int size) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setStringBindingSize(size);
    }

    public int getStringBindingSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return 0;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).getStringBindingSize();
    }

    public void setUsesBatchWriting(boolean usesBatchWriting) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesBatchWriting(usesBatchWriting);
    }

    public boolean getUsesBatchWriting() {
        return this.getSession().getDatasourceLogin().getPlatform().usesBatchWriting();
    }

    public void setUsesJDBCBatchWriting(boolean usesJDBCBatchWriting) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesJDBCBatchWriting(usesJDBCBatchWriting);
    }

    public boolean getUsesJDBCBatchWriting() {
        return this.getSession().getDatasourceLogin().getPlatform().usesJDBCBatchWriting();
    }

    public void setUsesByteArrayBinding(boolean usesByteArrayBinding) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesByteArrayBinding(usesByteArrayBinding);
    }

    public boolean getUsesByteArrayBinding() {
        return this.getSession().getDatasourceLogin().getPlatform().usesByteArrayBinding();
    }

    public void setUsesNativeSQL(boolean usesNativeSQL) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesNativeSQL(usesNativeSQL);
    }

    public boolean getUsesNativeSQL() {
        return this.getSession().getDatasourceLogin().getPlatform().usesNativeSQL();
    }

    public void setUsesStreamsForBinding(boolean usesStreamsForBinding) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesStreamsForBinding(usesStreamsForBinding);
    }

    public boolean getUsesStreamsForBinding() {
        return this.getSession().getDatasourceLogin().getPlatform().usesStreamsForBinding();
    }

    public void setUsesStringBinding(boolean usesStringBinding) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesStringBinding(usesStringBinding);
    }

    public boolean getUsesStringBinding() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return false;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).getPlatform().usesStringBinding();
    }

    protected AbstractSession getSession() {
        return (AbstractSession)this.session;
    }
}

