/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.CollectionDecorator;
import au.net.zeus.collection.Ref;
import au.net.zeus.collection.ReferenceDeque;
import au.net.zeus.collection.Referrer;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceBlockingDeque<T>
extends ReferenceDeque<T>
implements BlockingDeque<T> {
    private static final long serialVersionUID = 1L;
    private final BlockingDeque<Referrer<T>> deque;

    ReferenceBlockingDeque(BlockingDeque<Referrer<T>> deque, Ref type, boolean gcThreads, long gcCycle) {
        super(deque, type, gcThreads, gcCycle);
        this.deque = deque;
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Builder required");
    }

    @Override
    public void putFirst(T e) throws InterruptedException {
        this.processQueue();
        Referrer<T> r = this.wrapObj(e, true, false);
        this.deque.putFirst(r);
    }

    @Override
    public void putLast(T e) throws InterruptedException {
        this.processQueue();
        Referrer<T> r = this.wrapObj(e, true, false);
        this.deque.putLast(r);
    }

    @Override
    public boolean offerFirst(T e, long timeout, TimeUnit unit) throws InterruptedException {
        this.processQueue();
        Referrer<T> r = this.wrapObj(e, true, false);
        return this.deque.offerFirst(r, timeout, unit);
    }

    @Override
    public boolean offerLast(T e, long timeout, TimeUnit unit) throws InterruptedException {
        this.processQueue();
        Referrer<T> r = this.wrapObj(e, true, false);
        return this.deque.offerLast(r, timeout, unit);
    }

    @Override
    public T takeFirst() throws InterruptedException {
        this.processQueue();
        Referrer<T> t = this.deque.takeFirst();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T takeLast() throws InterruptedException {
        this.processQueue();
        Referrer<T> t = this.deque.takeLast();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        this.processQueue();
        Referrer<T> t = this.deque.pollFirst(timeout, unit);
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        this.processQueue();
        Referrer<T> t = this.deque.pollLast(timeout, unit);
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public void put(T e) throws InterruptedException {
        this.processQueue();
        Referrer<T> r = this.wrapObj(e, true, false);
        this.deque.put(r);
    }

    @Override
    public boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
        this.processQueue();
        Referrer<T> r = this.wrapObj(e, true, false);
        return this.deque.offer(r, timeout, unit);
    }

    @Override
    public T take() throws InterruptedException {
        this.processQueue();
        Referrer<T> t = this.deque.take();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.processQueue();
        Referrer<T> t = this.deque.poll(timeout, unit);
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public int remainingCapacity() {
        return this.deque.remainingCapacity();
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        this.processQueue();
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        CollectionDecorator<? super T> dr = new CollectionDecorator<T>(c, this.getRQF(), false, true);
        return this.deque.drainTo(dr);
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        this.processQueue();
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        CollectionDecorator<? super T> drain = new CollectionDecorator<T>(c, this.getRQF(), false, true);
        return this.deque.drainTo(drain, maxElements);
    }
}

