/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.Ref;
import au.net.zeus.collection.ReferenceComparator;
import au.net.zeus.collection.ReferenceConcurrentMap;
import au.net.zeus.collection.ReferenceEntryFacade;
import au.net.zeus.collection.ReferenceNavigableSet;
import au.net.zeus.collection.ReferenceQueuingFactory;
import au.net.zeus.collection.Referrer;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentNavigableMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceConcurrentNavigableMap<K, V>
extends ReferenceConcurrentMap<K, V>
implements ConcurrentNavigableMap<K, V> {
    private final ConcurrentNavigableMap<Referrer<K>, Referrer<V>> map;

    ReferenceConcurrentNavigableMap(ConcurrentNavigableMap<Referrer<K>, Referrer<V>> map, Ref keyRef, Ref valRef, boolean gcThreads, long gcKeyCycle, long gcValCycle) {
        super(map, keyRef, valRef, gcThreads, gcKeyCycle, gcValCycle);
        this.map = map;
    }

    ReferenceConcurrentNavigableMap(ConcurrentNavigableMap<Referrer<K>, Referrer<V>> map, ReferenceQueuingFactory<K, Referrer<K>> krqf, ReferenceQueuingFactory<V, Referrer<V>> vrqf, Ref key, Ref val) {
        super(map, krqf, vrqf, key, val);
        this.map = map;
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        this.processQueue();
        return new ReferenceConcurrentNavigableMap(this.map.subMap((Object)this.wrapKey(fromKey, false, true), fromInclusive, (Object)this.wrapKey(toKey, false, true), toInclusive), this.getKeyRQF(), this.getValRQF(), this.keyRef(), this.valRef());
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        this.processQueue();
        return new ReferenceConcurrentNavigableMap(this.map.headMap((Object)this.wrapKey(toKey, false, true), inclusive), this.getKeyRQF(), this.getValRQF(), this.keyRef(), this.valRef());
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        this.processQueue();
        return new ReferenceConcurrentNavigableMap(this.map.tailMap((Object)this.wrapKey(fromKey, false, true), inclusive), this.getKeyRQF(), this.getValRQF(), this.keyRef(), this.valRef());
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, K toKey) {
        this.processQueue();
        return new ReferenceConcurrentNavigableMap(this.map.subMap((Object)this.wrapKey(fromKey, false, true), (Object)this.wrapKey(toKey, false, true)), this.getKeyRQF(), this.getValRQF(), this.keyRef(), this.valRef());
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey) {
        this.processQueue();
        return new ReferenceConcurrentNavigableMap(this.map.headMap((Object)this.wrapKey(toKey, false, true)), this.getKeyRQF(), this.getValRQF(), this.keyRef(), this.valRef());
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey) {
        this.processQueue();
        return new ReferenceConcurrentNavigableMap(this.map.tailMap((Object)this.wrapKey(fromKey, false, true)), this.getKeyRQF(), this.getValRQF(), this.keyRef(), this.valRef());
    }

    @Override
    public ConcurrentNavigableMap<K, V> descendingMap() {
        this.processQueue();
        return new ReferenceConcurrentNavigableMap(this.map.descendingMap(), this.getKeyRQF(), this.getValRQF(), this.keyRef(), this.valRef());
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        this.processQueue();
        return new ReferenceNavigableSet(this.map.navigableKeySet(), this.getKeyRQF(), this.keyRef());
    }

    @Override
    public NavigableSet<K> keySet() {
        this.processQueue();
        return new ReferenceNavigableSet(this.map.keySet(), this.getKeyRQF(), this.keyRef());
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        this.processQueue();
        return new ReferenceNavigableSet(this.map.descendingKeySet(), this.getKeyRQF(), this.keyRef());
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        this.processQueue();
        return new ReferenceEntryFacade(this.map.lowerEntry(this.wrapKey(key, false, true)), this.getValRQF());
    }

    @Override
    public K lowerKey(K key) {
        this.processQueue();
        Referrer<K> k = this.map.lowerKey(this.wrapKey(key, false, true));
        if (k != null) {
            return k.get();
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        this.processQueue();
        return new ReferenceEntryFacade(this.map.floorEntry(this.wrapKey(key, false, true)), this.getValRQF());
    }

    @Override
    public K floorKey(K key) {
        this.processQueue();
        Referrer<K> k = this.map.floorKey(this.wrapKey(key, false, true));
        if (k != null) {
            return k.get();
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        this.processQueue();
        return new ReferenceEntryFacade(this.map.ceilingEntry(this.wrapKey(key, false, true)), this.getValRQF());
    }

    @Override
    public K ceilingKey(K key) {
        this.processQueue();
        Referrer<K> k = this.map.ceilingKey(this.wrapKey(key, false, true));
        if (k != null) {
            return k.get();
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        this.processQueue();
        return new ReferenceEntryFacade(this.map.higherEntry(this.wrapKey(key, false, true)), this.getValRQF());
    }

    @Override
    public K higherKey(K key) {
        this.processQueue();
        Referrer<K> k = this.map.higherKey(this.wrapKey(key, false, true));
        if (k != null) {
            return k.get();
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        this.processQueue();
        return new ReferenceEntryFacade(this.map.firstEntry(), this.getValRQF());
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        this.processQueue();
        return new ReferenceEntryFacade(this.map.lastEntry(), this.getValRQF());
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        this.processQueue();
        return new ReferenceEntryFacade(this.map.pollFirstEntry(), this.getValRQF());
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        this.processQueue();
        return new ReferenceEntryFacade(this.map.pollLastEntry(), this.getValRQF());
    }

    @Override
    public Comparator<? super K> comparator() {
        this.processQueue();
        Comparator c = this.map.comparator();
        if (c instanceof ReferenceComparator) {
            return ((ReferenceComparator)c).get();
        }
        return null;
    }

    @Override
    public K firstKey() {
        this.processQueue();
        Referrer k = (Referrer)this.map.firstKey();
        if (k != null) {
            return (K)k.get();
        }
        return null;
    }

    @Override
    public K lastKey() {
        this.processQueue();
        Referrer k = (Referrer)this.map.lastKey();
        if (k != null) {
            return (K)k.get();
        }
        return null;
    }
}

