/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.ComparableReferrerDecorator;
import au.net.zeus.collection.Ref;
import au.net.zeus.collection.RefQueue;
import au.net.zeus.collection.RefReferenceQueue;
import au.net.zeus.collection.Referrer;
import au.net.zeus.collection.ReferrerDecorator;
import au.net.zeus.collection.SoftEqualityReference;
import au.net.zeus.collection.SoftIdentityReference;
import au.net.zeus.collection.StrongReference;
import au.net.zeus.collection.TempComparableReferrer;
import au.net.zeus.collection.TempEqualReferrer;
import au.net.zeus.collection.TempIdentityReferrer;
import au.net.zeus.collection.TimedComparableReferrerDecorator;
import au.net.zeus.collection.TimedRefQueue;
import au.net.zeus.collection.TimedReferrer;
import au.net.zeus.collection.TimedReferrerDecorator;
import au.net.zeus.collection.WeakEqualityReference;
import au.net.zeus.collection.WeakIdentityReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceFactory<T> {
    private ReferenceFactory() {
    }

    static <T> Referrer<T> create(T t, RefQueue<? super T> queue, Ref type) {
        if (t == null) {
            throw new NullPointerException("Reference collections cannot contain null");
        }
        RefReferenceQueue refQueue = null;
        TimedRefQueue timedRefQue = null;
        if (queue instanceof RefReferenceQueue) {
            refQueue = (RefReferenceQueue)queue;
        }
        if (queue instanceof TimedRefQueue) {
            timedRefQue = (TimedRefQueue)queue;
        }
        switch (type) {
            case WEAK_IDENTITY: {
                return new ReferrerDecorator<T>(new WeakIdentityReference<T>(t, refQueue));
            }
            case SOFT_IDENTITY: {
                return new ReferrerDecorator<T>(new SoftIdentityReference<T>(t, refQueue));
            }
            case WEAK: {
                if (t instanceof Comparable) {
                    return new ComparableReferrerDecorator<T>(new WeakEqualityReference<T>(t, refQueue));
                }
                return new ReferrerDecorator<T>(new WeakEqualityReference<T>(t, refQueue));
            }
            case SOFT: {
                if (t instanceof Comparable) {
                    return new ComparableReferrerDecorator<T>(new SoftEqualityReference<T>(t, refQueue));
                }
                return new ReferrerDecorator<T>(new SoftEqualityReference<T>(t, refQueue));
            }
            case TIME: {
                if (t instanceof Comparable) {
                    return new TimedComparableReferrerDecorator<T>(new TimedReferrer<T>(t, timedRefQue));
                }
                return new TimedReferrerDecorator<T>(new TimedReferrer<T>(t, timedRefQue));
            }
        }
        if (t instanceof Comparable) {
            return new ComparableReferrerDecorator<T>(new StrongReference<T>(t, refQueue));
        }
        return new ReferrerDecorator<T>(new StrongReference<T>(t, refQueue));
    }

    static <T> Referrer<T> singleUseForLookup(T t, Ref type) {
        if (t == null) {
            throw new NullPointerException("Reference collections cannot contain null");
        }
        switch (type) {
            case WEAK_IDENTITY: {
                return new TempIdentityReferrer<T>(t);
            }
            case SOFT_IDENTITY: {
                return new TempIdentityReferrer<T>(t);
            }
            case WEAK: {
                if (t instanceof Comparable) {
                    return new TempComparableReferrer<T>(t);
                }
                return new TempEqualReferrer<T>(t);
            }
            case SOFT: {
                if (t instanceof Comparable) {
                    return new TempComparableReferrer<T>(t);
                }
                return new TempEqualReferrer<T>(t);
            }
        }
        if (t instanceof Comparable) {
            return new TempComparableReferrer<T>(t);
        }
        return new TempEqualReferrer<T>(t);
    }
}

