/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.Ref;
import au.net.zeus.collection.RefQueue;
import au.net.zeus.collection.ReferenceFactory;
import au.net.zeus.collection.ReferenceQueuingFactory;
import au.net.zeus.collection.Referrer;
import au.net.zeus.collection.TimeBomb;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceProcessor<T>
implements ReferenceQueuingFactory<T, Referrer<T>> {
    private static final ScheduledExecutorService garbageCleaner = Executors.newScheduledThreadPool(1, new SystemThreadFactory());
    private static final Map<Reference, ScheduledFuture> finalizerTasks = new ConcurrentHashMap<Reference, ScheduledFuture>();
    private static final ReferenceQueue<Reference> phantomQueue = new ReferenceQueue();
    private final Collection<Referrer<T>> col;
    private final Object colLock;
    private final RefQueue<T> queue;
    private final Ref type;
    private final Lock queueLock;
    private final boolean gcThreads;
    private volatile boolean started = false;

    ReferenceProcessor(Collection<Referrer<T>> col, Ref type, RefQueue<T> queue, boolean gcThreads, Object lock) {
        if (col == null || type == null) {
            throw new NullPointerException("collection or reference type cannot be null");
        }
        this.col = col;
        this.colLock = lock;
        this.type = type;
        this.queue = type == Ref.STRONG ? null : queue;
        this.gcThreads = gcThreads;
        this.queueLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(long GcInterval) {
        if (this.started) {
            return;
        }
        ReferenceProcessor referenceProcessor = this;
        synchronized (referenceProcessor) {
            if (this.started) {
                return;
            }
            this.started = true;
        }
        long enqDelay = GcInterval * 0L;
        ScheduledFuture<?> task = this.queue != null && (this.gcThreads || this.type.equals((Object)Ref.TIME)) ? garbageCleaner.scheduleAtFixedRate(new CleanerTask(this.col, this.queue), GcInterval, GcInterval, TimeUnit.MILLISECONDS) : null;
        this.scheduleFinaliserTask(task);
        task = this.type.equals((Object)Ref.TIME) ? garbageCleaner.scheduleAtFixedRate(new EnqueGarbageTask(this.col, this.colLock), enqDelay, GcInterval, TimeUnit.MILLISECONDS) : null;
        this.scheduleFinaliserTask(task);
    }

    private void scheduleFinaliserTask(ScheduledFuture task) {
        if (task != null) {
            PhantomReference<Reference> r = new PhantomReference<Reference>((Reference)((Object)this), phantomQueue);
            finalizerTasks.put(r, task);
        }
    }

    @Override
    public T pseudoReferent(Referrer<T> u) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Referrer<T> referenced(T w, boolean enque, boolean temporary) {
        if (w == null) {
            return null;
        }
        if (temporary) {
            return ReferenceFactory.singleUseForLookup(w, this.type);
        }
        return ReferenceFactory.create(w, enque ? this.queue : null, this.type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processQueue() {
        if (this.queue == null || this.gcThreads) {
            return;
        }
        Object t = null;
        if (this.queueLock.tryLock()) {
            try {
                while ((t = this.queue.poll()) != null) {
                    this.col.remove(t);
                }
            }
            finally {
                this.queueLock.unlock();
            }
        }
    }

    static {
        garbageCleaner.scheduleAtFixedRate(new FinalizerTask(phantomQueue, finalizerTasks), 5L, 5L, TimeUnit.MINUTES);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadGroupAction
    implements PrivilegedAction<ThreadGroup> {
        private ThreadGroup tg;

        ThreadGroupAction(ThreadGroup g) {
            this.tg = g;
        }

        @Override
        public ThreadGroup run() {
            try {
                ThreadGroup parent = this.tg.getParent();
                while (parent != null) {
                    this.tg = parent;
                    parent = this.tg.getParent();
                }
            }
            catch (SecurityException e) {
                Logger.getLogger(ReferenceProcessor.class.getName()).log(Level.FINE, "Unable to get parent thread group", e);
            }
            return this.tg;
        }
    }

    private static class SystemThreadFactory
    implements ThreadFactory {
        private static final ThreadGroup g;

        private SystemThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(g, r);
            try {
                t.setContextClassLoader(null);
                t.setPriority(10);
            }
            catch (SecurityException e) {
                Logger.getLogger(ReferenceProcessor.class.getName()).log(Level.FINE, "Unable to set ContextClassLoader or Priority", e);
            }
            return t;
        }

        static {
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            g = AccessController.doPrivileged(new ThreadGroupAction(tg));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FinalizerTask
    implements Runnable {
        private final ReferenceQueue phantomQueue;
        private final Map<Reference, ScheduledFuture> finalizerTasks;

        private FinalizerTask(ReferenceQueue queue, Map<Reference, ScheduledFuture> tasks) {
            this.phantomQueue = queue;
            this.finalizerTasks = tasks;
        }

        @Override
        public void run() {
            Reference p;
            while ((p = this.phantomQueue.poll()) != null) {
                ScheduledFuture sf = this.finalizerTasks.remove(p);
                if (sf != null) {
                    sf.cancel(true);
                }
                p.clear();
            }
        }
    }

    private static class CleanerTask
    implements Runnable {
        private final Collection col;
        private final RefQueue queue;

        private CleanerTask(Collection c, RefQueue queue) {
            this.col = c;
            this.queue = queue;
        }

        public void run() {
            try {
                Object t = this.queue.poll();
                while (t != null) {
                    this.col.remove(t);
                    t = this.queue.poll();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private static class EnqueGarbageTask
    implements Runnable {
        private final Collection col;
        private final Object lock;

        EnqueGarbageTask(Collection c, Object lock) {
            this.col = c;
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long time = System.nanoTime();
            Object object = this.lock;
            synchronized (object) {
                for (Object r : this.col) {
                    if (!(r instanceof TimeBomb)) continue;
                    ((TimeBomb)r).updateClock(time);
                }
            }
        }
    }
}

