/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.Referrer;
import au.net.zeus.collection.TimeBomb;
import au.net.zeus.collection.TimedRefQueue;
import au.net.zeus.collection.UntouchableReferrer;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimedReferrer<T>
implements UntouchableReferrer<T>,
TimeBomb {
    private volatile long clock;
    private volatile long read;
    private final TimedRefQueue queue;
    private final T referent;
    private volatile boolean enqued;
    private final Object lock;

    TimedReferrer(T k, TimedRefQueue q) {
        long time;
        this.clock = time = System.nanoTime();
        this.read = time;
        this.referent = k;
        this.queue = q;
        this.enqued = false;
        this.lock = new Object();
    }

    @Override
    public T get() {
        if (this.read < this.clock) {
            this.read = this.clock;
        }
        return this.referent;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean isEnqueued() {
        return this.enqued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enqueue() {
        if (this.enqued) {
            return false;
        }
        if (this.queue == null) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.enqued) {
                return false;
            }
            this.enqued = this.queue.offer(this);
        }
        return this.enqued;
    }

    @Override
    public void updateClock(long time) {
        if (this.read < this.clock) {
            if (this.referent instanceof Future) {
                ((Future)this.referent).cancel(false);
            }
            this.enqueue();
        } else {
            this.clock = time;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Referrer)) {
            return false;
        }
        T k1 = this.get();
        Object k2 = ((Referrer)o).get();
        if (k1 != null && k1.equals(k2)) {
            return true;
        }
        return k1 == null && k2 == null && this.hashCode() == o.hashCode();
    }

    @Override
    public int hashCode() {
        T k = this.referent;
        int hash = 7;
        hash = 29 * hash + k.hashCode();
        hash = 29 * hash + k.getClass().hashCode();
        return hash;
    }

    public String toString() {
        T s = this.get();
        if (s != null) {
            return s.toString();
        }
        return super.toString();
    }

    @Override
    public T lookDontTouch() {
        return this.referent;
    }
}

