/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.action;

import com.sun.jini.logging.Levels;
import com.sun.jini.logging.LogUtil;
import java.security.PrivilegedAction;
import java.util.logging.Logger;

public class GetIntegerAction
implements PrivilegedAction {
    private static final Logger logger = Logger.getLogger("com.sun.jini.action.GetIntegerAction");
    private final String theProp;
    private final int defaultVal;
    private final boolean defaultSet;

    public GetIntegerAction(String theProp) {
        this.theProp = theProp;
        this.defaultVal = 0;
        this.defaultSet = false;
    }

    public GetIntegerAction(String theProp, int defaultVal) {
        this.theProp = theProp;
        this.defaultVal = defaultVal;
        this.defaultSet = true;
    }

    public Object run() {
        block3: {
            try {
                Integer value = Integer.getInteger(this.theProp);
                if (value != null) {
                    return value;
                }
            }
            catch (SecurityException e) {
                if (!logger.isLoggable(Levels.HANDLED)) break block3;
                LogUtil.logThrow(logger, Levels.HANDLED, GetIntegerAction.class, "run", "security exception reading \"{0}\", returning {1}", new Object[]{this.theProp, this.defaultValue()}, e);
            }
        }
        return this.defaultValue();
    }

    private Integer defaultValue() {
        return this.defaultSet ? Integer.valueOf(this.defaultVal) : null;
    }
}

