/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery;

import com.sun.jini.collection.SoftCache;
import com.sun.jini.discovery.ClientSubjectChecker;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Set;
import javax.security.auth.Subject;

public class ClientPermissionChecker
implements ClientSubjectChecker {
    private static final CodeSource emptyCS = new CodeSource(null, (Certificate[])null);
    private static final ProtectionDomain emptyPD = new ProtectionDomain(emptyCS, null, null, null);
    private final SoftCache domains = new SoftCache();
    private final Permission permission;

    public ClientPermissionChecker(Permission permission) {
        if (permission == null) {
            throw new NullPointerException();
        }
        this.permission = permission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkClientSubject(Subject subject) {
        ProtectionDomain pd;
        if (subject != null && !subject.isReadOnly()) {
            throw new IllegalArgumentException("subject is not read-only");
        }
        if (System.getSecurityManager() == null) {
            return;
        }
        if (subject == null) {
            pd = emptyPD;
        } else {
            SoftCache softCache = this.domains;
            synchronized (softCache) {
                pd = (ProtectionDomain)this.domains.get(subject);
            }
            if (pd == null) {
                Set<Principal> s = subject.getPrincipals();
                Principal[] prins = s.toArray(new Principal[s.size()]);
                pd = new ProtectionDomain(emptyCS, null, null, prins);
                SoftCache softCache2 = this.domains;
                synchronized (softCache2) {
                    this.domains.put(subject, pd);
                }
            }
        }
        if (!pd.implies(this.permission)) {
            throw new AccessControlException("access denied " + this.permission);
        }
    }
}

