/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import com.sun.jini.discovery.UnicastDiscoveryClient;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.EndpointBasedProvider;
import com.sun.jini.discovery.internal.EndpointInternals;
import com.sun.jini.discovery.internal.Plaintext;
import com.sun.jini.jeri.internal.connection.ConnManager;
import com.sun.jini.jeri.internal.connection.ConnManagerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.net.SocketFactory;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.connection.Connection;
import net.jini.jeri.connection.ConnectionEndpoint;
import net.jini.jeri.connection.OutboundRequestHandle;

public abstract class EndpointBasedClient
extends EndpointBasedProvider
implements UnicastDiscoveryClient {
    protected EndpointBasedClient(String formatName, EndpointInternals endpointInternals) {
        super(formatName, endpointInternals);
    }

    @Override
    public void checkUnicastDiscoveryConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        if (constraints == null) {
            constraints = InvocationConstraints.EMPTY;
        }
        ConnectionInfo ci = this.getConnectionInfo(null, constraints);
        EndpointBasedClient.checkIntegrity(this.endpointInternals.getUnfulfilledConstraints(ci.handle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnicastResponse doUnicastDiscovery(Socket socket, InvocationConstraints constraints, ClassLoader defaultLoader, ClassLoader verifierLoader, Collection context, ByteBuffer sent, ByteBuffer received) throws IOException, ClassNotFoundException {
        if (socket == null || sent == null || received == null) {
            throw new NullPointerException();
        }
        if (constraints == null) {
            constraints = InvocationConstraints.EMPTY;
        }
        ConnectionInfo ci = this.getConnectionInfo(socket, constraints);
        Connection conn = ci.endpoint.connect(ci.handle);
        try {
            boolean integrity = EndpointBasedClient.checkIntegrity(conn.getUnfulfilledConstraints(ci.handle));
            BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
            conn.writeRequestData(ci.handle, out);
            ((OutputStream)out).write(EndpointBasedClient.calcHandshakeHash(sent, received));
            ((OutputStream)out).flush();
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            IOException e = conn.readResponseData(ci.handle, in);
            if (e != null) {
                throw e;
            }
            UnicastResponse unicastResponse = Plaintext.readUnicastResponse(in, defaultLoader, integrity, verifierLoader, context);
            return unicastResponse;
        }
        finally {
            conn.close();
        }
    }

    protected abstract Endpoint getEndpoint(SocketFactory var1, InvocationConstraints var2) throws UnsupportedConstraintException;

    private ConnectionInfo getConnectionInfo(Socket socket, InvocationConstraints constraints) throws UnsupportedConstraintException {
        Endpoint ep = this.getEndpoint(new PrearrangedSocketFactory(socket), constraints);
        ConnManagerFactoryImpl factory = new ConnManagerFactoryImpl();
        this.endpointInternals.setConnManagerFactory(ep, factory);
        this.endpointInternals.disableSocketConnect(ep);
        OutboundRequestIterator iter2 = ep.newRequest(constraints);
        ConnectionInfo ci = factory.getConnectionInfo();
        if (ci != null) {
            return ci;
        }
        if (iter2.hasNext()) {
            try {
                iter2.next();
            }
            catch (UnsupportedConstraintException e) {
                throw e;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        throw new AssertionError((Object)"expected UnsupportedConstraintException");
    }

    private static class PrearrangedSocketFactory
    extends SocketFactory {
        private final Socket socket;

        PrearrangedSocketFactory(Socket socket) {
            this.socket = socket;
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.socket;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.socket;
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.socket;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.socket;
        }

        @Override
        public Socket createSocket(InetAddress host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.socket;
        }

        public String toString() {
            return "PrearrangedSocketFactory[" + this.socket + "]";
        }
    }

    private static class ConnManagerFactoryImpl
    implements ConnManagerFactory {
        private ConnectionInfo connInfo = null;

        ConnManagerFactoryImpl() {
        }

        @Override
        public ConnManager create(final ConnectionEndpoint endpoint) {
            if (endpoint == null) {
                throw new NullPointerException();
            }
            return new ConnManager(){

                @Override
                public OutboundRequestIterator newRequest(OutboundRequestHandle handle) {
                    if (handle == null) {
                        throw new NullPointerException();
                    }
                    ConnManagerFactoryImpl.this.connInfo = new ConnectionInfo(endpoint, handle);
                    return new OutboundRequestIterator(){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public OutboundRequest next() throws IOException {
                            throw new NoSuchElementException();
                        }
                    };
                }
            };
        }

        ConnectionInfo getConnectionInfo() {
            return this.connInfo;
        }
    }

    private static class ConnectionInfo {
        final ConnectionEndpoint endpoint;
        final OutboundRequestHandle handle;

        ConnectionInfo(ConnectionEndpoint endpoint, OutboundRequestHandle handle) {
            this.endpoint = endpoint;
            this.handle = handle;
        }
    }
}

