/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import com.sun.jini.discovery.DatagramBufferFactory;
import com.sun.jini.discovery.internal.BaseProvider;
import com.sun.jini.discovery.internal.Plaintext;
import com.sun.jini.logging.Levels;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.io.UnsupportedConstraintException;
import net.jini.security.AuthenticationPermission;

class X500Provider
extends BaseProvider {
    private static final String NAME = "com.sun.jini.discovery.x500";
    private static final String JSSE = "javax.net.ssl";
    private static final int INT_LEN = 4;
    private static final Pattern hostPortPattern = Pattern.compile("^(.+):(\\d+?)$");
    private static final AuthPermission authPermission = new AuthPermission("getSubject");
    static final Logger logger = Logger.getLogger("com.sun.jini.discovery.x500");
    protected final String signatureAlgorithm;
    protected final int maxSignatureLength;
    protected final String keyAlgorithm;
    protected final String keyAlgorithmOID;
    private KeyStore trustStore = null;
    private CertStore[] certStores = null;
    private final Object storeLock = new Object();

    X500Provider(String formatName, String signatureAlgorithm, int maxSignatureLength, String keyAlgorithm, String keyAlgorithmOID) {
        super(formatName);
        if (maxSignatureLength < 0) {
            throw new IllegalArgumentException();
        }
        if (keyAlgorithm == null || keyAlgorithmOID == null) {
            throw new NullPointerException();
        }
        this.signatureAlgorithm = signatureAlgorithm;
        this.maxSignatureLength = maxSignatureLength;
        this.keyAlgorithm = keyAlgorithm;
        this.keyAlgorithmOID = keyAlgorithmOID;
    }

    protected Certificate getCertificate(final X500Principal principal) throws IOException, GeneralSecurityException {
        try {
            return (Certificate)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, GeneralSecurityException {
                    return X500Provider.this.getCertificate0(principal);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw (GeneralSecurityException)t;
        }
    }

    X500PrivateCredential[] getPrivateCredentials() {
        final AccessControlContext acc = AccessController.getContext();
        Collection[] subjInfo = (Collection[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Collection[] collectionArray;
                Subject s = Subject.getSubject(acc);
                if (s != null) {
                    Collection[] collectionArray2 = new Collection[2];
                    collectionArray2[0] = X500Provider.syncGetInstances(s.getPrincipals(), X500Principal.class);
                    collectionArray = collectionArray2;
                    collectionArray2[1] = X500Provider.syncGetInstances(s.getPrivateCredentials(), X500PrivateCredential.class);
                } else {
                    Collection[] collectionArray3 = new Collection[2];
                    collectionArray3[0] = Collections.EMPTY_SET;
                    collectionArray = collectionArray3;
                    collectionArray3[1] = Collections.EMPTY_SET;
                }
                return collectionArray;
            }
        });
        Collection ppals = subjInfo[0];
        Collection creds = subjInfo[1];
        ArrayList<X500PrivateCredential> l = new ArrayList<X500PrivateCredential>();
        for (X500PrivateCredential cred : creds) {
            X509Certificate cert = cred.getCertificate();
            try {
                X500Provider.checkCertificate(cert);
            }
            catch (CertificateException e) {
                logger.log(Levels.HANDLED, "invalid certificate", e);
                continue;
            }
            if (!this.keyAlgorithm.equals(cred.getPrivateKey().getAlgorithm()) || !ppals.contains(cert.getSubjectX500Principal())) continue;
            l.add(cred);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "obtained private credentials {0}", new Object[]{l});
        }
        return l.toArray(new X500PrivateCredential[l.size()]);
    }

    private static boolean canGetSubject() {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(authPermission);
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    static void secureThrow(SecurityException detailedException, UnsupportedConstraintException genericException) throws UnsupportedConstraintException {
        if (X500Provider.canGetSubject()) {
            throw detailedException;
        }
        throw genericException;
    }

    void checkAuthenticationPermission(X500Principal principal, String action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthenticationPermission(Collections.singleton(principal), null, action));
        }
    }

    boolean verify(ByteBuffer data, ByteBuffer sig, PublicKey key) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        data = X500Provider.ensureArrayBacking(data);
        sig = X500Provider.ensureArrayBacking(sig);
        Signature s = this.getSignature();
        s.initVerify(key);
        s.update(data.array(), data.arrayOffset() + data.position(), data.remaining());
        return s.verify(sig.array(), sig.arrayOffset() + sig.position(), sig.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate getCertificate0(X500Principal principal) throws IOException, GeneralSecurityException {
        PKIXCertPathBuilderResult result;
        Object object = this.storeLock;
        synchronized (object) {
            if (this.trustStore == null) {
                this.initStores();
            }
        }
        X509CertSelector selector = new X509CertSelector();
        selector.setSubject(principal.getName());
        selector.setSubjectPublicKeyAlgID(this.keyAlgorithmOID);
        selector.setCertificateValid(new Date());
        selector.setKeyUsage(new boolean[]{true});
        PKIXBuilderParameters params = new PKIXBuilderParameters(this.trustStore, (CertSelector)selector);
        for (int j = 0; j < this.certStores.length; ++j) {
            params.addCertStore(this.certStores[j]);
        }
        try {
            result = (PKIXCertPathBuilderResult)CertPathBuilder.getInstance("PKIX").build(params);
        }
        catch (CertPathBuilderException e) {
            logger.log(Levels.HANDLED, "exception building certificate path", e);
            return null;
        }
        List<? extends Certificate> certs = result.getCertPath().getCertificates();
        return certs.isEmpty() ? result.getTrustAnchor().getTrustedCert() : certs.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStores() throws IOException, GeneralSecurityException {
        String passwd;
        String type;
        String path = System.getProperty("com.sun.jini.discovery.x500.trustStore");
        if (path != null) {
            type = System.getProperty("com.sun.jini.discovery.x500.trustStoreType", KeyStore.getDefaultType());
            passwd = System.getProperty("com.sun.jini.discovery.x500.trustStorePassword");
        } else {
            path = System.getProperty("javax.net.ssl.trustStore");
            if (path != null) {
                type = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
                passwd = System.getProperty("javax.net.ssl.trustStorePassword");
            } else {
                path = System.getProperty("java.home") + "/lib/security/cacerts";
                type = KeyStore.getDefaultType();
                passwd = null;
            }
        }
        KeyStore kstore = KeyStore.getInstance(type);
        URL url = null;
        try {
            url = new URL(path);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        InputStream in = url != null ? url.openStream() : new FileInputStream(path);
        try {
            kstore.load(in, passwd != null ? passwd.toCharArray() : null);
        }
        finally {
            in.close();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "loaded trust store from {0} ({1})", new Object[]{path, type});
        }
        String cstores = System.getProperty("com.sun.jini.discovery.x500.ldapCertStores");
        ArrayList<CertStore> l = new ArrayList<CertStore>();
        if (cstores != null) {
            StringTokenizer tok = new StringTokenizer(cstores, ",");
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken().trim();
                Matcher m = hostPortPattern.matcher(s);
                try {
                    LDAPCertStoreParameters params = m.matches() ? new LDAPCertStoreParameters(m.group(1), Integer.parseInt(m.group(2))) : new LDAPCertStoreParameters(s);
                    l.add(CertStore.getInstance("LDAP", params));
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "exception initializing cert store", e);
                }
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "using cert stores {0}", new Object[]{l});
        }
        this.certStores = l.toArray(new CertStore[l.size()]);
        this.trustStore = kstore;
    }

    private Signature getSignature() throws NoSuchAlgorithmException {
        return Signature.getInstance(this.signatureAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection syncGetInstances(Collection coll, Class cl) {
        Collection collection = coll;
        synchronized (collection) {
            ArrayList c = new ArrayList(coll.size());
            for (Object obj : coll) {
                if (!cl.isInstance(obj)) continue;
                c.add(obj);
            }
            return c;
        }
    }

    private static void checkCertificate(X509Certificate cert) throws CertificateException {
        cert.checkValidity();
        boolean[] keyUsage = cert.getKeyUsage();
        if (keyUsage != null && keyUsage.length > 0 && !keyUsage[0]) {
            throw new CertificateException("certificate not permitted for digital signatures: " + cert);
        }
    }

    private static ByteBuffer ensureArrayBacking(ByteBuffer buf) {
        return buf.hasArray() ? buf : (ByteBuffer)ByteBuffer.allocate(buf.remaining()).put(buf).flip();
    }

    class SigningBufferFactory
    implements DatagramBufferFactory {
        private final List buffers = new ArrayList();
        private final DatagramBufferFactory factory;
        private final byte[] principalName;
        private final Signature signature;

        SigningBufferFactory(DatagramBufferFactory factory, X500PrivateCredential cred) throws InvalidKeyException, UTFDataFormatException, NoSuchAlgorithmException {
            this.factory = factory;
            this.principalName = Plaintext.toUtf(cred.getCertificate().getSubjectX500Principal().getName());
            this.signature = X500Provider.this.getSignature();
            this.signature.initSign(cred.getPrivateKey());
        }

        @Override
        public ByteBuffer newBuffer() {
            BufferInfo bi = new BufferInfo(this.factory.newBuffer());
            this.buffers.add(bi);
            return bi.getDataBuffer();
        }

        public void sign() throws SignatureException {
            Iterator i = this.buffers.iterator();
            while (i.hasNext()) {
                ((BufferInfo)i.next()).sign();
            }
        }

        private class BufferInfo {
            private final ByteBuffer buf;
            private final ByteBuffer data;
            private final boolean overflow;

            BufferInfo(ByteBuffer buf) {
                this.buf = buf;
                this.data = buf.duplicate();
                int authBlockLen = SigningBufferFactory.this.principalName.length + X500Provider.this.maxSignatureLength;
                if (this.data.remaining() >= 4 + authBlockLen) {
                    this.data.position(this.data.position() + 4);
                    this.data.limit(this.data.limit() - authBlockLen);
                    this.overflow = false;
                } else {
                    this.data.limit(this.data.position());
                    this.overflow = true;
                }
            }

            ByteBuffer getDataBuffer() {
                return this.data;
            }

            void sign() throws SignatureException {
                if (this.overflow) {
                    throw new BufferOverflowException();
                }
                this.buf.putInt(this.data.position() - (this.buf.position() + 4));
                this.buf.position(this.data.position());
                this.buf.put(SigningBufferFactory.this.principalName);
                ByteBuffer b = X500Provider.ensureArrayBacking((ByteBuffer)this.data.duplicate().flip());
                SigningBufferFactory.this.signature.update(b.array(), b.arrayOffset() + b.position(), b.remaining());
                this.buf.put(SigningBufferFactory.this.signature.sign());
            }
        }
    }
}

