/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.example.browser;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

class Introspector {
    Introspector() {
    }

    public static boolean isHidden(Field f) {
        int m = f.getModifiers();
        return Modifier.isPrivate(m) || Modifier.isStatic(m);
    }

    public static boolean isString(Class clazz) {
        return "java.lang.String".equals(clazz.getName());
    }

    public static boolean isWrapper(Class clazz) {
        String name = clazz.getName();
        return "java.lang.Integer".equals(name) || "java.lang.Boolean".equals(name) || "java.lang.Byte".equals(name) || "java.lang.Char".equals(name) || "java.lang.Double".equals(name) || "java.lang.Float".equals(name) || "java.lang.Long".equals(name);
    }

    public static String getTypename(Class t, boolean showPackage) {
        String brackets = "";
        while (t.isArray()) {
            brackets = brackets + "[]";
            t = t.getComponentType();
        }
        if (showPackage) {
            return t.getName() + brackets;
        }
        return Introspector.extractClassName(t.getName()) + brackets;
    }

    public static String getModifierString(int m) {
        if (m == 0) {
            return "";
        }
        return Modifier.toString(m) + " ";
    }

    public static String getFieldString(Field f, boolean showModifier, boolean showPackage) {
        String fstring = "";
        if (showModifier) {
            fstring = fstring + Introspector.getModifierString(f.getModifiers());
        }
        fstring = fstring + Introspector.getTypename(f.getType(), showPackage);
        fstring = fstring + " ";
        fstring = fstring + f.getName();
        return fstring;
    }

    public static String extractClassName(String fullName) {
        int index = fullName.lastIndexOf(".");
        return fullName.substring(index + 1);
    }
}

