/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.example.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.plaf.metal.MetalLookAndFeel;

class MetalIcons
implements Serializable {
    private static Icon blueFolderIcon;
    private static Icon blueFileIcon;
    private static Icon orangeFolderIcon;
    private static Icon orangeFileIcon;
    private static Icon grayFolderIcon;
    private static Icon grayFileIcon;
    private static Icon unusableFolderIcon;
    private static Icon unusableFileIcon;
    private static Color orangeDarkShadowColor;
    private static Color orangeColor;
    private static Color orangeShadowColor;
    private static Color orangeInfoColor;
    private static Color orangeHighlightColor;
    private static Color grayDarkShadowColor;
    private static Color grayColor;
    private static Color grayShadowColor;
    private static Color grayInfoColor;
    private static Color grayHighlightColor;
    public static final boolean DARK = false;
    public static final boolean LIGHT = true;
    private static final Dimension folderIcon16Size;
    private static final Dimension fileIcon16Size;

    MetalIcons() {
    }

    public static Icon getBlueFolderIcon() {
        if (blueFolderIcon == null) {
            blueFolderIcon = new BlueFolderIcon();
        }
        return blueFolderIcon;
    }

    public static Icon getBlueFileIcon() {
        if (blueFileIcon == null) {
            blueFileIcon = new BlueFileIcon();
        }
        return blueFileIcon;
    }

    public static Icon getOrangeFolderIcon() {
        if (orangeFolderIcon == null) {
            orangeFolderIcon = new OrangeFolderIcon();
        }
        return orangeFolderIcon;
    }

    public static Icon getOrangeFileIcon() {
        if (orangeFileIcon == null) {
            orangeFileIcon = new OrangeFileIcon();
        }
        return orangeFileIcon;
    }

    public static Icon getGrayFolderIcon() {
        if (grayFolderIcon == null) {
            grayFolderIcon = new GrayFolderIcon();
        }
        return grayFolderIcon;
    }

    public static Icon getGrayFileIcon() {
        if (grayFileIcon == null) {
            grayFileIcon = new GrayFileIcon();
        }
        return grayFileIcon;
    }

    public static Icon getUnusableFolderIcon() {
        if (unusableFolderIcon == null) {
            unusableFolderIcon = new UnusableFolderIcon();
        }
        return unusableFolderIcon;
    }

    public static Icon getUnusableFileIcon() {
        if (unusableFileIcon == null) {
            unusableFileIcon = new UnusableFileIcon();
        }
        return unusableFileIcon;
    }

    static {
        orangeDarkShadowColor = new Color(204, 153, 102);
        orangeColor = new Color(255, 153, 51);
        orangeShadowColor = new Color(204, 153, 102);
        orangeInfoColor = new Color(153, 0, 51);
        orangeHighlightColor = new Color(255, 255, 51);
        grayDarkShadowColor = new Color(153, 153, 153);
        grayColor = new Color(187, 187, 187);
        grayShadowColor = new Color(170, 170, 170);
        grayInfoColor = new Color(136, 136, 136);
        grayHighlightColor = new Color(221, 221, 221);
        folderIcon16Size = new Dimension(16, 16);
        fileIcon16Size = new Dimension(16, 16);
    }

    static class TreeLeafIcon
    extends FileIcon16 {
        TreeLeafIcon() {
        }

        @Override
        public int getShift() {
            return 2;
        }

        @Override
        public int getAdditionalHeight() {
            return 4;
        }
    }

    private static abstract class FileIcon16
    implements Serializable {
        private FileIcon16() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y, Color controlHighlightColor, Color controlInfoColor, Color controlColor) {
            g.translate(x, y + this.getShift());
            int right = fileIcon16Size.width - 1;
            int bottom = fileIcon16Size.height - 1;
            g.setColor(controlHighlightColor);
            g.fillRect(4, 2, 9, 12);
            g.setColor(controlInfoColor);
            g.drawLine(2, 0, 2, bottom);
            g.drawLine(2, 0, right - 4, 0);
            g.drawLine(2, bottom, right - 1, bottom);
            g.drawLine(right - 1, 6, right - 1, bottom);
            g.drawLine(right - 6, 2, right - 2, 6);
            g.drawLine(right - 5, 1, right - 4, 1);
            g.drawLine(right - 3, 2, right - 3, 3);
            g.drawLine(right - 2, 4, right - 2, 5);
            g.setColor(controlColor);
            g.drawLine(3, 1, 3, bottom - 1);
            g.drawLine(3, 1, right - 6, 1);
            g.drawLine(right - 2, 7, right - 2, bottom - 1);
            g.drawLine(right - 5, 2, right - 3, 4);
            g.drawLine(3, bottom - 1, right - 2, bottom - 1);
            g.translate(-x, -(y + this.getShift()));
        }

        public void drawCross(Component c, Graphics g, int x, int y) {
            g.translate(x, y + this.getShift());
            int right = folderIcon16Size.width - 1;
            int bottom = folderIcon16Size.height - 1;
            Color crossColor = Color.red;
            g.setColor(crossColor);
            g.drawLine(1, 1, right - 1, bottom - 1);
            g.drawLine(1, bottom - 1, right - 1, 1);
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getIconWidth() {
            return fileIcon16Size.width;
        }

        public int getIconHeight() {
            return fileIcon16Size.height + this.getAdditionalHeight();
        }
    }

    static class UnusableFileIcon
    extends FileIcon16
    implements Icon {
        UnusableFileIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y, grayHighlightColor, grayInfoColor, grayColor);
            super.drawCross(c, g, x, y);
        }

        @Override
        public int getShift() {
            return -1;
        }

        @Override
        public int getAdditionalHeight() {
            return 2;
        }
    }

    static class GrayFileIcon
    extends FileIcon16
    implements Icon {
        GrayFileIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y, grayHighlightColor, grayInfoColor, grayColor);
        }

        @Override
        public int getShift() {
            return -1;
        }

        @Override
        public int getAdditionalHeight() {
            return 2;
        }
    }

    static class OrangeFileIcon
    extends FileIcon16
    implements Icon {
        OrangeFileIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y, orangeHighlightColor, orangeInfoColor, orangeColor);
        }

        @Override
        public int getShift() {
            return -1;
        }

        @Override
        public int getAdditionalHeight() {
            return 2;
        }
    }

    static class BlueFileIcon
    extends FileIcon16
    implements Icon {
        BlueFileIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControl());
        }

        @Override
        public int getShift() {
            return -1;
        }

        @Override
        public int getAdditionalHeight() {
            return 2;
        }
    }

    private static abstract class FolderIcon16
    implements Serializable {
        private FolderIcon16() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y, Color controlDarkShadowColor, Color controlColor, Color controlShadowColor, Color controlInfoColor, Color controlHighlightColor) {
            g.translate(x, y + this.getShift());
            int right = folderIcon16Size.width - 1;
            int bottom = folderIcon16Size.height - 1;
            g.setColor(controlDarkShadowColor);
            g.drawLine(right - 5, 3, right, 3);
            g.drawLine(right - 6, 4, right, 4);
            g.setColor(controlColor);
            g.fillRect(2, 7, 13, 8);
            g.setColor(controlShadowColor);
            g.drawLine(right - 6, 5, right - 1, 5);
            g.setColor(controlInfoColor);
            g.drawLine(0, 6, 0, bottom);
            g.drawLine(1, 5, right - 7, 5);
            g.drawLine(right - 6, 6, right - 1, 6);
            g.drawLine(right, 5, right, bottom);
            g.drawLine(0, bottom, right, bottom);
            g.setColor(controlHighlightColor);
            g.drawLine(1, 6, 1, bottom - 1);
            g.drawLine(1, 6, right - 7, 6);
            g.drawLine(right - 6, 7, right - 1, 7);
            g.translate(-x, -(y + this.getShift()));
        }

        public void drawCross(Component c, Graphics g, int x, int y) {
            g.translate(x, y + this.getShift());
            int right = folderIcon16Size.width - 1;
            int bottom = folderIcon16Size.height - 1;
            Color crossColor = Color.red;
            g.setColor(crossColor);
            g.drawLine(2, 2, right, bottom);
            g.drawLine(2, bottom, right, 2);
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getIconWidth() {
            return folderIcon16Size.width;
        }

        public int getIconHeight() {
            return folderIcon16Size.height + this.getAdditionalHeight();
        }
    }

    static class UnusableFolderIcon
    extends FolderIcon16
    implements Icon {
        UnusableFolderIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y, grayDarkShadowColor, grayColor, grayShadowColor, grayInfoColor, grayHighlightColor);
            super.drawCross(c, g, x, y);
        }

        @Override
        public int getShift() {
            return -1;
        }

        @Override
        public int getAdditionalHeight() {
            return 2;
        }
    }

    static class GrayFolderIcon
    extends FolderIcon16
    implements Icon {
        GrayFolderIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y, grayDarkShadowColor, grayColor, grayShadowColor, grayInfoColor, grayHighlightColor);
        }

        @Override
        public int getShift() {
            return -1;
        }

        @Override
        public int getAdditionalHeight() {
            return 2;
        }
    }

    static class OrangeFolderIcon
    extends FolderIcon16
    implements Icon {
        OrangeFolderIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y, orangeDarkShadowColor, orangeColor, orangeShadowColor, orangeInfoColor, orangeHighlightColor);
        }

        @Override
        public int getShift() {
            return -1;
        }

        @Override
        public int getAdditionalHeight() {
            return 2;
        }
    }

    static class BlueFolderIcon
    extends FolderIcon16
    implements Icon {
        BlueFolderIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y, MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControl(), MetalLookAndFeel.getPrimaryControlShadow(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlHighlight());
        }

        @Override
        public int getShift() {
            return -1;
        }

        @Override
        public int getAdditionalHeight() {
            return 2;
        }
    }
}

