/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.example.browser;

import com.sun.jini.example.browser.Introspector;
import com.sun.jini.example.browser.MetalIcons;
import java.io.Serializable;
import java.lang.reflect.Field;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;

class ObjectNode
extends DefaultMutableTreeNode
implements Serializable {
    private String name;
    private Object obj;
    private Class clazz;
    private String fieldName;
    private int arrayIndex = -1;
    private boolean editable = false;
    private boolean isLeaf;
    private boolean isAdministrable;
    private boolean isControllable;
    private boolean isRoot = false;
    private boolean isEntryTop = false;
    private static Icon[] icons = new Icon[6];

    public ObjectNode(boolean isAdministrable) {
        this("Root node", "".getClass(), null, -1, false);
        this.isAdministrable = isAdministrable;
        this.isRoot = true;
        this.isEntryTop = true;
    }

    public ObjectNode(Object obj, boolean isControllable) {
        this(obj, obj.getClass(), null, -1, false);
        this.isControllable = isControllable;
        this.isEntryTop = true;
    }

    public ObjectNode(Object obj, Class clazz, String fieldName, boolean isLeaf) {
        this(obj, clazz, fieldName, -1, isLeaf);
    }

    public ObjectNode(Object obj, Class clazz, String fieldName, int arrayIndex, boolean isLeaf) {
        this.obj = obj;
        this.clazz = clazz;
        this.fieldName = fieldName;
        this.arrayIndex = arrayIndex;
        this.isLeaf = isLeaf;
        super.setAllowsChildren(!isLeaf);
        this.setNodeName();
    }

    private void setNodeName() {
        this.name = Introspector.getTypename(this.clazz, false);
        if (this.fieldName != null) {
            this.name = this.name + " " + this.fieldName;
        }
        if (this.isLeaf) {
            String value = "";
            if (this.arrayIndex >= 0) {
                value = value + "[" + this.arrayIndex + "]";
            }
            value = value + "=";
            if (this.clazz.isPrimitive()) {
                value = value + "" + this.obj;
                this.editable = false;
            } else if (Introspector.isWrapper(this.clazz)) {
                value = value + "" + this.obj;
                this.editable = true;
            } else if (Introspector.isString(this.clazz)) {
                value = value + "\"" + this.obj + "\"";
                this.editable = true;
            } else {
                value = value + (this.obj == null ? "null" : this.obj.toString());
            }
            this.name = this.name + value;
        } else if (this.obj == null) {
            this.name = this.name + "=null";
        }
        super.setUserObject(this.name);
    }

    public void add(ObjectNode child) {
        child.setAdministrable(this.isAdministrable);
        if (!this.isRoot) {
            child.setControllable(this.isControllable);
        }
        super.add(child);
    }

    public Object getEntryTop() {
        ObjectNode snode = this;
        while (!(snode = (ObjectNode)snode.getParent()).isEntryTop()) {
        }
        return snode.getObject();
    }

    protected boolean isEntryTop() {
        return this.isEntryTop;
    }

    public void setObjectRecursive() throws NoSuchFieldException, IllegalAccessException {
        ObjectNode pnode = this;
        do {
            pnode = (ObjectNode)pnode.getParent();
            Object pobj = pnode.getObject();
            Field f = pobj.getClass().getField(this.fieldName);
            f.set(pobj, this.obj);
        } while (!pnode.isEntryTop());
    }

    public String getTitle() {
        return this.name;
    }

    public Icon getIcon() {
        if (this.isAdministrable && this.isControllable) {
            if (this.isLeaf) {
                return icons[3];
            }
            return icons[0];
        }
        if (this.isLeaf) {
            return icons[4];
        }
        return icons[1];
    }

    @Override
    public void setUserObject(Object obj) {
        if (obj instanceof String) {
            this.name = (String)obj;
        }
        super.setUserObject(obj);
    }

    @Override
    public Object getUserObject() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getObject() {
        return this.obj;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isAdministrable() {
        return this.isAdministrable;
    }

    public void setAdministrable(boolean val) {
        this.isAdministrable = val;
    }

    public boolean isControllable() {
        return this.isControllable;
    }

    public void setControllable(boolean val) {
        this.isControllable = val;
    }

    public Object setValue(Object val) throws NumberFormatException {
        String clazzName = this.clazz.getName();
        Object newObj = null;
        if (val instanceof String || val == null) {
            String sval = (String)val;
            if (clazzName.equals("java.lang.Integer")) {
                newObj = Integer.valueOf(sval);
            } else if (clazzName.equals("java.lang.Boolean")) {
                newObj = Boolean.valueOf(sval);
            } else if (clazzName.equals("java.lang.Byte")) {
                newObj = Byte.valueOf(sval);
            } else if (clazzName.equals("java.lang.Character")) {
                newObj = Character.valueOf(sval.charAt(0));
            } else if (clazzName.equals("java.lang.Double")) {
                newObj = Double.valueOf(sval);
            } else if (clazzName.equals("java.lang.Float")) {
                newObj = Float.valueOf(sval);
            } else if (clazzName.equals("java.lang.Long")) {
                newObj = Long.valueOf(sval);
            } else if (clazzName.equals("java.lang.String")) {
                newObj = sval;
            }
        } else if (val.getClass().equals(this.obj.getClass())) {
            newObj = val;
        }
        Object oldObj = this.obj;
        this.obj = newObj;
        this.setNodeName();
        return oldObj;
    }

    static {
        ObjectNode.icons[0] = MetalIcons.getBlueFolderIcon();
        ObjectNode.icons[1] = MetalIcons.getGrayFolderIcon();
        ObjectNode.icons[2] = MetalIcons.getOrangeFolderIcon();
        ObjectNode.icons[3] = MetalIcons.getBlueFileIcon();
        ObjectNode.icons[4] = MetalIcons.getGrayFileIcon();
        ObjectNode.icons[5] = MetalIcons.getOrangeFileIcon();
    }
}

