/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.example.browser;

import com.sun.jini.example.browser.Browser;
import com.sun.jini.example.browser.EntryTreePanel;
import com.sun.jini.example.browser.ObjectNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.lookup.entry.UIDescriptor;
import net.jini.lookup.ui.factory.JFrameFactory;

class ServiceBrowser
extends JFrame {
    private Browser browser;
    private AttributePanel attrPanel;
    private static final int MINIMUM_WINDOW_WIDTH = 320;

    public ServiceBrowser(ServiceItem item, ServiceRegistrar registrar, Browser browser) {
        super("ServiceItem Browser");
        this.browser = browser;
        this.attrPanel = new AttributePanel(item, registrar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new BrowserMenuBar(), "North");
        this.getContentPane().add((Component)this.attrPanel, "Center");
        this.validate();
        this.pack();
        this.setSize(this.getSize().width < 320 ? 320 : this.getSize().width, this.getSize().height);
        Rectangle bounds = browser.getBounds();
        Dimension dialogSize = this.getPreferredSize();
        int xpos = bounds.x + (bounds.width - dialogSize.width) / 2;
        int ypos = bounds.y + (bounds.height - dialogSize.height) / 2;
        this.setLocation(xpos < 0 ? 0 : xpos, ypos < 0 ? 0 : ypos);
    }

    private UIDescriptor getSelectedUIDescriptor() {
        ObjectNode selectedNode = (ObjectNode)this.attrPanel.tree.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return null;
        }
        Object selectedObject = selectedNode.getObject();
        try {
            return (UIDescriptor)selectedObject;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private void higlightSelection(MouseEvent anEvent) {
        this.attrPanel.tree.setSelectionPath(this.attrPanel.tree.getPathForLocation(anEvent.getX(), anEvent.getY()));
    }

    private UIDescriptorPopup uiDescriptorPopup() {
        return new UIDescriptorPopup();
    }

    class MouseReceiver
    extends MouseAdapter {
        private UIDescriptorPopup popup;
        private ServiceItem serviceItem;

        public MouseReceiver(ServiceItem aServiceItem, UIDescriptorPopup popup) {
            this.popup = popup;
            this.serviceItem = aServiceItem;
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            ServiceBrowser.this.higlightSelection(ev);
            if (!ev.isPopupTrigger()) {
                return;
            }
            UIDescriptor selectedDescriptor = ServiceBrowser.this.getSelectedUIDescriptor();
            if (selectedDescriptor == null) {
                return;
            }
            if (!"javax.swing".equals(selectedDescriptor.toolkit)) {
                return;
            }
            this.popup.setServiceItem(this.serviceItem);
            this.popup.show(ev.getComponent(), ev.getX(), ev.getY());
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            ServiceBrowser.this.higlightSelection(ev);
            if (!ev.isPopupTrigger()) {
                return;
            }
            UIDescriptor selectedDescriptor = ServiceBrowser.this.getSelectedUIDescriptor();
            if (selectedDescriptor == null) {
                return;
            }
            if (!"javax.swing".equals(selectedDescriptor.toolkit)) {
                return;
            }
            this.popup.setServiceItem(this.serviceItem);
            this.popup.show(ev.getComponent(), ev.getX(), ev.getY());
        }
    }

    public class UIDescriptorPopup
    extends JPopupMenu
    implements ActionListener,
    PopupMenuListener {
        protected transient JMenuItem showUIItem = new JMenuItem("Show UI");
        protected transient ServiceItem serviceItem;

        public UIDescriptorPopup() {
            this.showUIItem.addActionListener(this);
            this.showUIItem.setActionCommand("showUI");
            this.add(this.showUIItem);
            this.addPopupMenuListener(this);
            this.setOpaque(true);
            this.setLightWeightPopupEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent anEvent) {
            UIDescriptor uiDescriptor = ServiceBrowser.this.getSelectedUIDescriptor();
            if (uiDescriptor == null) {
                return;
            }
            try {
                JFrameFactory uiFactory = (JFrameFactory)uiDescriptor.getUIFactory(Thread.currentThread().getContextClassLoader());
                JFrame frame = uiFactory.getJFrame(this.serviceItem);
                frame.validate();
                frame.setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent ev) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent ev) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent ev) {
        }

        public void setServiceItem(ServiceItem anItem) {
            this.serviceItem = anItem;
        }
    }

    class AttributePanel
    extends EntryTreePanel {
        private ServiceItem item;
        private ServiceRegistrar registrar;

        public AttributePanel(ServiceItem item, ServiceRegistrar registrar) {
            super(false);
            this.item = item;
            this.registrar = registrar;
            this.tree.addMouseListener(ServiceBrowser.this.browser.wrap(new MouseReceiver(item, ServiceBrowser.this.uiDescriptorPopup())));
            this.refreshPanel();
        }

        @Override
        protected Entry[] getEntryArray() {
            try {
                ServiceMatches matches = this.registrar.lookup(new ServiceTemplate(this.item.serviceID, new Class[]{this.item.service.getClass()}, new Entry[0]), 10);
                if (matches.totalMatches == 1) {
                    return matches.items[0].attributeSets;
                }
                Browser.logger.log(Level.INFO, "unexpected lookup matches: {0}", matches.totalMatches);
            }
            catch (Throwable t) {
                Browser.logger.log(Level.INFO, "lookup failed", t);
            }
            return null;
        }
    }

    class BrowserMenuBar
    extends JMenuBar {
        public BrowserMenuBar() {
            JMenu fileMenu = this.add(new JMenu("File"));
            JMenuItem mitem = fileMenu.add(new JMenuItem("Refresh"));
            mitem.addActionListener(ServiceBrowser.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ServiceBrowser.this.attrPanel.refreshPanel();
                }
            }));
            mitem = fileMenu.add(new JMenuItem("Close"));
            mitem.addActionListener(ServiceBrowser.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ServiceBrowser.this.setVisible(false);
                }
            }));
        }
    }
}

