/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.example.browser;

import com.sun.jini.admin.DestroyAdmin;
import com.sun.jini.config.Config;
import com.sun.jini.example.browser.Browser;
import com.sun.jini.example.browser.EntryTreePanel;
import com.sun.jini.example.browser.ObjectNode;
import com.sun.jini.logging.Levels;
import com.sun.jini.proxy.BasicProxyTrustVerifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.rmi.server.ExportException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.TreePath;
import net.jini.admin.JoinAdmin;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.lookup.ServiceEvent;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.export.Exporter;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lookup.DiscoveryAdmin;
import net.jini.lookup.entry.ServiceControlled;
import net.jini.lookup.entry.UIDescriptor;
import net.jini.lookup.ui.factory.JFrameFactory;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

class ServiceEditor
extends JFrame {
    private static final Logger logger = Browser.logger;
    private Browser browser;
    private ServiceItem item;
    private ServiceRegistrar registrar;
    protected Object admin;
    private ServiceTemplate stmpl;
    private NotifyReceiver receiver;
    private Lease elease = null;
    private long eventID = 0L;
    private long seqNo = Long.MAX_VALUE;
    private AttributeTreePanel attrPanel;
    private static final int MINIMUM_WINDOW_WIDTH = 320;

    public ServiceEditor(ServiceItem item, Object admin, ServiceRegistrar registrar, Browser browser) {
        super("ServiceItem Editor");
        this.item = item;
        this.admin = admin;
        this.registrar = registrar;
        this.browser = browser;
        this.attrPanel = new AttributeTreePanel();
        try {
            this.stmpl = new ServiceTemplate(item.serviceID, new Class[]{item.service.getClass()}, new Entry[0]);
            this.receiver = new NotifyReceiver();
            this.setupNotify();
        }
        catch (Throwable t) {
            logger.log(Level.INFO, "event registration failed", t);
            this.cancelNotify();
        }
        this.addWindowListener(browser.wrap(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ServiceEditor.this.cleanup();
            }
        }));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JoinMenuBar(), "North");
        this.getContentPane().add((Component)this.attrPanel, "Center");
        this.validate();
        this.pack();
        this.setSize(this.getSize().width < 320 ? 320 : this.getSize().width, this.getSize().height);
        Rectangle bounds = browser.getBounds();
        Dimension dialogSize = this.getPreferredSize();
        int xpos = bounds.x + (bounds.width - dialogSize.width) / 2;
        int ypos = bounds.y + (bounds.height - dialogSize.height) / 2;
        this.setLocation(xpos < 0 ? 0 : xpos, ypos < 0 ? 0 : ypos);
    }

    void cleanup() {
        this.cancelNotify();
        this.dispose();
        this.receiver.unexport();
    }

    protected void cancelNotify() {
        if (this.elease != null) {
            try {
                this.browser.leaseMgr.cancel(this.elease);
            }
            catch (Throwable t) {
                logger.log(Levels.HANDLED, "event cancellation failed", t);
            }
            this.elease = null;
            this.seqNo = Long.MAX_VALUE;
        }
    }

    protected void setupNotify() {
        if (this.registrar != null) {
            try {
                EventRegistration reg = this.registrar.notify(this.stmpl, 7, this.receiver.proxy, null, -1L);
                this.elease = (Lease)this.browser.leasePreparer.prepareProxy(reg.getLease());
                this.browser.leaseMgr.renewUntil(this.elease, -1L, new Browser.LeaseNotify());
                this.eventID = reg.getID();
                this.seqNo = reg.getSequenceNumber();
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "event registration failed", t);
            }
        }
    }

    private UIDescriptor getSelectedUIDescriptor() {
        ObjectNode selectedNode = (ObjectNode)this.attrPanel.tree.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return null;
        }
        Object selectedObject = selectedNode.getObject();
        try {
            return (UIDescriptor)selectedObject;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private void higlightSelection(MouseEvent event) {
        this.attrPanel.tree.setSelectionPath(this.attrPanel.tree.getPathForLocation(event.getX(), event.getY()));
    }

    private UIDescriptorPopup uiDescriptorPopup() {
        return new UIDescriptorPopup();
    }

    class MouseReceiver
    extends MouseAdapter {
        private UIDescriptorPopup popup;
        private ServiceItem serviceItem;

        public MouseReceiver(ServiceItem aServiceItem, UIDescriptorPopup popup) {
            this.popup = popup;
            this.serviceItem = aServiceItem;
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            ServiceEditor.this.higlightSelection(ev);
            if (!ev.isPopupTrigger()) {
                return;
            }
            UIDescriptor selectedDescriptor = ServiceEditor.this.getSelectedUIDescriptor();
            if (selectedDescriptor == null) {
                return;
            }
            if (!"javax.swing".equals(selectedDescriptor.toolkit)) {
                return;
            }
            this.popup.setServiceItem(this.serviceItem);
            this.popup.show(ev.getComponent(), ev.getX(), ev.getY());
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            ServiceEditor.this.higlightSelection(ev);
            if (!ev.isPopupTrigger()) {
                return;
            }
            UIDescriptor selectedDescriptor = ServiceEditor.this.getSelectedUIDescriptor();
            if (selectedDescriptor == null) {
                return;
            }
            if (!"javax.swing".equals(selectedDescriptor.toolkit)) {
                return;
            }
            this.popup.setServiceItem(this.serviceItem);
            this.popup.show(ev.getComponent(), ev.getX(), ev.getY());
        }
    }

    public class UIDescriptorPopup
    extends JPopupMenu
    implements ActionListener,
    PopupMenuListener {
        protected transient JMenuItem showUIItem = new JMenuItem("Show UI");
        protected transient ServiceItem serviceItem;

        public UIDescriptorPopup() {
            this.showUIItem.addActionListener(this);
            this.showUIItem.setActionCommand("showUI");
            this.add(this.showUIItem);
            this.addPopupMenuListener(this);
            this.setOpaque(true);
            this.setLightWeightPopupEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent anEvent) {
            UIDescriptor uiDescriptor = ServiceEditor.this.getSelectedUIDescriptor();
            if (uiDescriptor == null) {
                return;
            }
            try {
                JFrameFactory uiFactory = (JFrameFactory)uiDescriptor.getUIFactory(Thread.currentThread().getContextClassLoader());
                JFrame frame = uiFactory.getJFrame(this.serviceItem);
                frame.validate();
                frame.setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent ev) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent ev) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent ev) {
        }

        public void setServiceItem(ServiceItem anItem) {
            this.serviceItem = anItem;
        }
    }

    class LocatorLister
    extends ListerFrame {
        public LocatorLister(String title) {
            super(title);
        }

        @Override
        protected void initListModel() {
            if (!(ServiceEditor.this.admin instanceof JoinAdmin)) {
                return;
            }
            try {
                LookupLocator[] locators = ((JoinAdmin)ServiceEditor.this.admin).getLookupLocators();
                for (int i = 0; i < locators.length; ++i) {
                    this.model.addElement(locators[i]);
                }
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "obtaining locators failed", t);
            }
        }

        @Override
        protected String getAddMessage() {
            return "Enter a new locator's URL";
        }

        @Override
        protected String getRemoveMessage(Object[] items) {
            StringBuffer msg = new StringBuffer();
            if (items.length > 1) {
                msg.append("Remove these locators : ");
            } else {
                msg.append("Remove a locator : ");
            }
            for (int i = 0; i < items.length; ++i) {
                if (i != 0) {
                    msg.append(", ");
                }
                msg.append(items[i].toString());
            }
            return msg.toString();
        }

        @Override
        protected void addItems(String[] items) {
            LookupLocator[] locs = new LookupLocator[items.length];
            for (int i = 0; i < items.length; ++i) {
                try {
                    locs[i] = new LookupLocator(items[i]);
                    continue;
                }
                catch (MalformedURLException e) {
                    JOptionPane.showMessageDialog(this, "\"" + items[i] + "\": " + e.getMessage(), "Bad Locator", 2);
                    return;
                }
            }
            try {
                ((JoinAdmin)ServiceEditor.this.admin).addLookupLocators(locs);
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "adding locators failed", t);
            }
        }

        @Override
        protected void removeItems(Object[] items) {
            LookupLocator[] locs = new LookupLocator[items.length];
            for (int i = 0; i < items.length; ++i) {
                locs[i] = (LookupLocator)items[i];
            }
            try {
                ((JoinAdmin)ServiceEditor.this.admin).removeLookupLocators(locs);
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "removing locators failed", t);
            }
        }
    }

    class GroupItem {
        public String group;

        public GroupItem(String group) {
            this.group = group.equals("public") ? "" : group;
        }

        public String toString() {
            if ("".equals(this.group)) {
                return "public";
            }
            return this.group;
        }
    }

    class MemberGroupLister
    extends ListerFrame {
        public MemberGroupLister(String title) {
            super(title);
        }

        @Override
        protected void initListModel() {
            try {
                String[] groups = ((DiscoveryAdmin)ServiceEditor.this.admin).getMemberGroups();
                for (int i = 0; i < groups.length; ++i) {
                    this.model.addElement(new GroupItem(groups[i]));
                }
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "obtaining groups failed", t);
            }
        }

        @Override
        protected String getAddMessage() {
            return "Enter adding group(s)";
        }

        @Override
        protected String getRemoveMessage(Object[] items) {
            StringBuffer msg = new StringBuffer();
            if (items.length > 1) {
                msg.append("Remove these groups : ");
            } else {
                msg.append("Remove a group : ");
            }
            for (int i = 0; i < items.length; ++i) {
                if (i != 0) {
                    msg.append(", ");
                }
                msg.append(((GroupItem)items[i]).toString());
            }
            return msg.toString();
        }

        @Override
        protected void addItems(String[] items) {
            String[] grps = new String[items.length];
            for (int i = 0; i < items.length; ++i) {
                grps[i] = (ServiceEditor)ServiceEditor.this.new GroupItem((String)items[i]).group;
            }
            try {
                ((DiscoveryAdmin)ServiceEditor.this.admin).addMemberGroups(grps);
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "adding groups failed", t);
            }
        }

        @Override
        protected void removeItems(Object[] items) {
            String[] grps = new String[items.length];
            for (int i = 0; i < items.length; ++i) {
                grps[i] = ((GroupItem)items[i]).group;
            }
            try {
                ((DiscoveryAdmin)ServiceEditor.this.admin).removeMemberGroups(grps);
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "removing groups failed", t);
            }
        }
    }

    class GroupLister
    extends ListerFrame {
        public GroupLister(String title) {
            super(title);
        }

        @Override
        protected void initListModel() {
            if (!(ServiceEditor.this.admin instanceof JoinAdmin)) {
                return;
            }
            try {
                String[] groups = ((JoinAdmin)ServiceEditor.this.admin).getLookupGroups();
                for (int i = 0; i < groups.length; ++i) {
                    this.model.addElement(new GroupItem(groups[i]));
                }
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "obtaining groups failed", t);
            }
        }

        @Override
        protected String getAddMessage() {
            return "Enter adding group(s)";
        }

        @Override
        protected String getRemoveMessage(Object[] items) {
            StringBuffer msg = new StringBuffer();
            if (items.length > 1) {
                msg.append("Remove these groups : ");
            } else {
                msg.append("Remove a group : ");
            }
            for (int i = 0; i < items.length; ++i) {
                if (i != 0) {
                    msg.append(", ");
                }
                msg.append(((GroupItem)items[i]).toString());
            }
            return msg.toString();
        }

        @Override
        protected void addItems(String[] items) {
            String[] grps = new String[items.length];
            for (int i = 0; i < items.length; ++i) {
                grps[i] = (ServiceEditor)ServiceEditor.this.new GroupItem((String)items[i]).group;
            }
            try {
                ((JoinAdmin)ServiceEditor.this.admin).addLookupGroups(grps);
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "adding groups failed", t);
            }
        }

        @Override
        protected void removeItems(Object[] items) {
            String[] grps = new String[items.length];
            for (int i = 0; i < items.length; ++i) {
                grps[i] = ((GroupItem)items[i]).group;
            }
            try {
                ((JoinAdmin)ServiceEditor.this.admin).removeLookupGroups(grps);
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "removing groups failed", t);
            }
        }
    }

    abstract class ListerFrame
    extends JFrame {
        private JList listBox;
        private JScrollPane scrollPane;
        protected DefaultListModel model;
        private DefaultListModel dummyModel;
        private JButton addButton;
        private JButton removeButton;
        private JButton closeButton;

        public ListerFrame(String title) {
            super(title);
            this.model = new DefaultListModel();
            this.dummyModel = new DefaultListModel();
            this.getContentPane().setLayout(new BorderLayout());
            this.listBox = new JList(this.model);
            this.listBox.setFixedCellHeight(20);
            this.scrollPane = new JScrollPane(this.listBox);
            this.getContentPane().add((Component)this.scrollPane, "Center");
            JPanel buttonPanel = new JPanel();
            this.addButton = new JButton("Add");
            this.addButton.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    String result = JOptionPane.showInputDialog(ListerFrame.this, (Object)ListerFrame.this.getAddMessage());
                    if (result != null) {
                        StringTokenizer st = new StringTokenizer(result);
                        String[] tokens = new String[st.countTokens()];
                        for (int i = 0; i < tokens.length; ++i) {
                            tokens[i] = st.nextToken().trim();
                        }
                        ListerFrame.this.addItems(tokens);
                        ListerFrame.this.resetListModel();
                        ListerFrame.this.scrollPane.validate();
                    }
                }
            }));
            buttonPanel.add(this.addButton);
            this.removeButton = new JButton("Remove");
            this.removeButton.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    Object[] selected = ListerFrame.this.listBox.getSelectedValues();
                    if (selected == null || selected.length == 0) {
                        JOptionPane.showMessageDialog(ListerFrame.this, "No items are selected", "Warning", 2);
                        return;
                    }
                    int result = JOptionPane.showConfirmDialog(ListerFrame.this, ListerFrame.this.getRemoveMessage(selected), "Query", 0);
                    if (result == 0) {
                        ListerFrame.this.removeItems(selected);
                        ListerFrame.this.resetListModel();
                        ListerFrame.this.scrollPane.validate();
                    }
                }
            }));
            buttonPanel.add(this.removeButton);
            this.closeButton = new JButton("Close");
            this.closeButton.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ListerFrame.this.setVisible(false);
                }
            }));
            buttonPanel.add(this.closeButton);
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
        }

        public void showFrame() {
            this.resetListModel();
            Rectangle bounds = ServiceEditor.this.getBounds();
            Dimension dialogSize = this.getPreferredSize();
            this.setLocation(bounds.x + (bounds.width - dialogSize.width) / 2, bounds.y + (bounds.height - dialogSize.height) / 2);
            this.setVisible(true);
        }

        private void resetListModel() {
            this.listBox.setModel(this.dummyModel);
            this.model.removeAllElements();
            this.initListModel();
            this.listBox.setModel(this.model);
            this.listBox.clearSelection();
            this.listBox.ensureIndexIsVisible(0);
            this.listBox.repaint();
            this.listBox.revalidate();
        }

        protected abstract void initListModel();

        protected abstract String getAddMessage();

        protected abstract String getRemoveMessage(Object[] var1);

        protected abstract void addItems(String[] var1);

        protected abstract void removeItems(Object[] var1);
    }

    class AttributeTreePanel
    extends EntryTreePanel {
        public AttributeTreePanel() {
            super(ServiceEditor.this.admin instanceof JoinAdmin);
            if (ServiceEditor.this.admin instanceof JoinAdmin) {
                this.tree.addMouseListener(ServiceEditor.this.browser.wrap(new DoubleClicker(this)));
            }
            this.tree.addMouseListener(ServiceEditor.this.browser.wrap(new MouseReceiver(ServiceEditor.this.item, ServiceEditor.this.uiDescriptorPopup())));
            this.refreshPanel();
        }

        @Override
        protected Entry[] getEntryArray() {
            if (ServiceEditor.this.admin instanceof JoinAdmin) {
                try {
                    ((ServiceEditor)ServiceEditor.this).item.attributeSets = ((JoinAdmin)ServiceEditor.this.admin).getLookupAttributes();
                }
                catch (Throwable t) {
                    logger.log(Level.INFO, "obtaining attributes failed", t);
                }
            } else {
                try {
                    ServiceMatches matches = ServiceEditor.this.registrar.lookup(ServiceEditor.this.stmpl, 1);
                    if (matches.totalMatches != 1) {
                        Browser.logger.log(Level.INFO, "unexpected lookup matches: {0}", matches.totalMatches);
                    } else {
                        ((ServiceEditor)ServiceEditor.this).item.attributeSets = matches.items[0].attributeSets;
                    }
                }
                catch (Throwable t) {
                    Browser.logger.log(Level.INFO, "lookup failed", t);
                }
            }
            return ((ServiceEditor)ServiceEditor.this).item.attributeSets;
        }

        protected void receiveNotify(int transition) {
            String[] stringArray;
            if (ServiceEditor.this.browser.isAutoConfirm()) {
                if (transition == 1) {
                    ServiceEditor.this.cleanup();
                } else {
                    this.refreshPanel();
                }
                return;
            }
            if (transition == 1) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "Service has been removed from lookup service.";
                stringArray = stringArray2;
                stringArray2[1] = "Do you want to close the service editor window ?";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "Attributes have been modified by another client or the service itself.";
                stringArray = stringArray3;
                stringArray3[1] = "Do you want to refresh the attributes ?";
            }
            String[] msg = stringArray;
            int result = JOptionPane.showConfirmDialog(this, msg, "Query", 0);
            if (result == 0) {
                if (transition == 1) {
                    ServiceEditor.this.cleanup();
                } else {
                    this.refreshPanel();
                }
            }
        }

        public void editField(ObjectNode node) {
            String result = JOptionPane.showInputDialog(this, "Input a new value", "Modify a field", 3);
            if (result != null) {
                Entry template = this.cloneEntry((Entry)node.getEntryTop());
                Object oldVal = null;
                oldVal = result.length() == 0 ? node.setValue(null) : node.setValue(result);
                try {
                    node.setObjectRecursive();
                    Entry attr = (Entry)node.getEntryTop();
                    ServiceEditor.this.cancelNotify();
                    ((JoinAdmin)ServiceEditor.this.admin).modifyLookupAttributes(new Entry[]{template}, new Entry[]{attr});
                    ServiceEditor.this.setupNotify();
                    this.model.nodeChanged(node);
                }
                catch (Throwable t) {
                    logger.log(Level.INFO, "attribute modification failed", t);
                    try {
                        node.setValue(oldVal);
                        node.setObjectRecursive();
                    }
                    catch (Throwable tt) {
                        logger.log(Levels.HANDLED, "node reset failed", tt);
                    }
                    this.model.nodeChanged(node);
                    JOptionPane.showMessageDialog(this, t.getMessage(), t.getClass().getName(), 0);
                }
            }
        }

        public void addAttr() {
            String result = JOptionPane.showInputDialog(this, "Input an entry class name", "Add an attribute", 3);
            if (result != null && result.length() != 0) {
                try {
                    Class<?> clazz = Class.forName(result);
                    Object attr = clazz.newInstance();
                    if (!(attr instanceof Entry)) {
                        JOptionPane.showMessageDialog(this, "Does not implement Entry interface", "Unacceptable Class", 2);
                    } else if (attr instanceof ServiceControlled) {
                        JOptionPane.showMessageDialog(this, "Implements ServiceControlled interface", "Unacceptable Class", 2);
                    } else {
                        ServiceEditor.this.cancelNotify();
                        ((JoinAdmin)ServiceEditor.this.admin).addLookupAttributes(new Entry[]{(Entry)attr});
                        ObjectNode node = new ObjectNode(attr, true);
                        this.root.add(node);
                        this.recursiveObjectTree(node);
                        ServiceEditor.this.setupNotify();
                        this.model.nodesWereInserted(this.root, new int[]{this.model.getIndexOfChild(this.root, node)});
                    }
                }
                catch (ClassNotFoundException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Class Not Found", 2);
                }
                catch (Throwable t) {
                    logger.log(Level.INFO, "adding attribute failed", t);
                    JOptionPane.showMessageDialog(this, t.getMessage(), t.getClass().getName(), 2);
                }
            }
        }

        public void removeAttr() {
            ObjectNode node = (ObjectNode)this.tree.getLastSelectedPathComponent();
            if (node == null) {
                JOptionPane.showMessageDialog(this, "Select an attribute folder to remove.", "Warning", 2);
                return;
            }
            if (!node.isControllable()) {
                JOptionPane.showMessageDialog(this, "This attribute is under service provider's control.", "Warning", 2);
                return;
            }
            if (!node.isEntryTop()) {
                JOptionPane.showMessageDialog(this, "Select a top of attribute folder.", "Warning", 2);
                return;
            }
            Entry target = (Entry)node.getObject();
            int result = JOptionPane.showConfirmDialog(this, new String[]{"Remove attribute:", target.toString()}, "Query", 0);
            if (result == 0) {
                try {
                    ServiceEditor.this.cancelNotify();
                    ((JoinAdmin)ServiceEditor.this.admin).modifyLookupAttributes(new Entry[]{target}, new Entry[]{null});
                    ServiceEditor.this.setupNotify();
                    int index = this.root.getIndex(node);
                    this.root.remove(node);
                    this.model.nodesWereRemoved(this.root, new int[]{index}, new Object[]{node});
                    node = null;
                }
                catch (Throwable t) {
                    logger.log(Level.INFO, "attribute removal failed", t);
                    JOptionPane.showMessageDialog(this, t.getMessage(), t.getClass().getName(), 0);
                }
            }
        }

        private Entry cloneEntry(Entry attr) {
            try {
                Class<?> realClass = attr.getClass();
                Entry template = (Entry)realClass.newInstance();
                Field[] f = realClass.getFields();
                for (int i = 0; i < f.length; ++i) {
                    if (!this.usableField(f[i])) continue;
                    f[i].set(template, f[i].get(attr));
                }
                return template;
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "duplicating entry failed", t);
                return null;
            }
        }

        private boolean usableField(Field field) {
            Class<?> desc = field.getDeclaringClass();
            if (desc.isPrimitive()) {
                throw new IllegalArgumentException("primitive types not allowed in an Entry");
            }
            int mods = field.getModifiers();
            return 0 == (mods & 0x98);
        }

        private Entry generateTemplate(Entry attr) {
            try {
                Class<?> realClass = attr.getClass();
                Entry template = (Entry)realClass.newInstance();
                Field[] f = realClass.getFields();
                for (int i = 0; i < f.length; ++i) {
                    f[i].set(template, null);
                }
                return template;
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "instantiating template failed", t);
                return null;
            }
        }

        class DoubleClicker
        extends MouseAdapter {
            AttributeTreePanel parent;

            public DoubleClicker(AttributeTreePanel parent) {
                this.parent = parent;
            }

            @Override
            public void mouseClicked(MouseEvent ev) {
                if (ev.getClickCount() >= 2) {
                    JTree tree = (JTree)ev.getSource();
                    TreePath path = tree.getPathForLocation(ev.getX(), ev.getY());
                    if (path == null) {
                        return;
                    }
                    ObjectNode node = (ObjectNode)path.getLastPathComponent();
                    if (node.isLeaf()) {
                        if (!node.isControllable()) {
                            JOptionPane.showMessageDialog(AttributeTreePanel.this, "This attribute is under service provider's control.", "Warning", 2);
                        } else if (node.isEditable() && ((ObjectNode)node.getParent()).isEntryTop()) {
                            this.parent.editField(node);
                        } else {
                            JOptionPane.showMessageDialog(AttributeTreePanel.this, "This field is not editable.", "Warning", 2);
                        }
                    }
                    tree.scrollPathToVisible(path);
                }
            }
        }
    }

    class JoinMenuBar
    extends JMenuBar {
        public JoinMenuBar() {
            JMenu fileMenu = this.add(new JMenu("File"));
            JMenuItem mitem = fileMenu.add(new JMenuItem("Show Info"));
            mitem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    Class[] infs = Browser.getInterfaces(((ServiceEditor)ServiceEditor.this).item.service.getClass());
                    String[] msg = new String[3 + infs.length];
                    msg[0] = "ServiceID: " + ((ServiceEditor)ServiceEditor.this).item.serviceID;
                    msg[1] = "Service Instance: " + ((ServiceEditor)ServiceEditor.this).item.service.getClass().getName();
                    msg[2] = infs.length == 1 ? "Implemented Interface:" : "Implemented Interfaces:";
                    for (int i = 0; i < infs.length; ++i) {
                        msg[3 + i] = "    " + infs[i].getName();
                    }
                    JOptionPane.showMessageDialog(ServiceEditor.this, msg, "ServiceItem Information", 1);
                }
            }));
            mitem = fileMenu.add(new JMenuItem("Refresh"));
            mitem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ServiceEditor.this.attrPanel.refreshPanel();
                }
            }));
            mitem = fileMenu.add(new JMenuItem("Close"));
            mitem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ServiceEditor.this.cleanup();
                }
            }));
            JMenu editMenu = this.add(new JMenu("Edit"));
            mitem = editMenu.add(new JMenuItem("Add Attribute..."));
            mitem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ServiceEditor.this.attrPanel.addAttr();
                }
            }));
            if (!(ServiceEditor.this.admin instanceof JoinAdmin)) {
                mitem.setEnabled(false);
            }
            mitem = editMenu.add(new JMenuItem("Remove Attribute"));
            mitem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ServiceEditor.this.attrPanel.removeAttr();
                }
            }));
            if (!(ServiceEditor.this.admin instanceof JoinAdmin)) {
                mitem.setEnabled(false);
            }
            JMenu adminMenu = this.add(new JMenu("Admin"));
            mitem = adminMenu.add(new JMenuItem("Joining groups..."));
            mitem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    new GroupLister("Joining Groups").showFrame();
                }
            }));
            if (!(ServiceEditor.this.admin instanceof JoinAdmin)) {
                mitem.setEnabled(false);
            }
            mitem = adminMenu.add(new JMenuItem("Joining locators..."));
            mitem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    new LocatorLister("Joining Locators").showFrame();
                }
            }));
            if (!(ServiceEditor.this.admin instanceof JoinAdmin)) {
                mitem.setEnabled(false);
            }
            adminMenu.addSeparator();
            mitem = adminMenu.add(new JMenuItem("Member groups..."));
            mitem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    new MemberGroupLister("Member Groups").showFrame();
                }
            }));
            if (!(ServiceEditor.this.admin instanceof DiscoveryAdmin)) {
                mitem.setEnabled(false);
            }
            mitem = adminMenu.add(new JMenuItem("Unicast port..."));
            mitem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    try {
                        String[] msg = new String[]{"Current port is " + ((DiscoveryAdmin)ServiceEditor.this.admin).getUnicastPort(), "Input a new value"};
                        String result = JOptionPane.showInputDialog(ServiceEditor.this, msg, "Unicast Port", 3);
                        if (result == null) {
                            return;
                        }
                        try {
                            int port = Integer.parseInt(result);
                            ((DiscoveryAdmin)ServiceEditor.this.admin).setUnicastPort(port);
                        }
                        catch (NumberFormatException e) {
                            JOptionPane.showMessageDialog(ServiceEditor.this, result + " is not acceptable.", "Error", 0);
                        }
                        catch (Throwable t) {
                            logger.log(Level.INFO, "setting unicast port failed", t);
                            JOptionPane.showMessageDialog(ServiceEditor.this, t.getMessage(), t.getClass().getName(), 0);
                        }
                    }
                    catch (Throwable t) {
                        logger.log(Level.INFO, "getting unicast port failed", t);
                        JOptionPane.showMessageDialog(ServiceEditor.this, t.getMessage(), t.getClass().getName(), 0);
                    }
                }
            }));
            if (!(ServiceEditor.this.admin instanceof DiscoveryAdmin)) {
                mitem.setEnabled(false);
            }
            adminMenu.addSeparator();
            mitem = adminMenu.add(new JMenuItem("Destroy"));
            mitem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (JOptionPane.showConfirmDialog(ServiceEditor.this, "Are you sure to destroy this service?", "Query", 0) == 0) {
                        try {
                            ((DestroyAdmin)ServiceEditor.this.admin).destroy();
                            ServiceEditor.this.cleanup();
                        }
                        catch (Throwable t) {
                            logger.log(Level.INFO, "service destroy failed", t);
                            JOptionPane.showMessageDialog(ServiceEditor.this, t.getMessage(), t.getClass().getName(), 0);
                        }
                    }
                }
            }));
            if (!(ServiceEditor.this.admin instanceof DestroyAdmin)) {
                mitem.setEnabled(false);
            }
        }
    }

    private class NotifyReceiver
    implements RemoteEventListener,
    ServerProxyTrust {
        private final Exporter exporter;
        final RemoteEventListener proxy;

        public NotifyReceiver() throws ConfigurationException, ExportException {
            this.exporter = (Exporter)Config.getNonNullEntry(((ServiceEditor)ServiceEditor.this).browser.config, "com.sun.jini.example.browser", "listenerExporter", Exporter.class, new BasicJeriExporter(TcpServerEndpoint.getInstance(0), new BasicILFactory(), false, false));
            this.proxy = (RemoteEventListener)this.exporter.export(this);
        }

        @Override
        public void notify(final RemoteEvent ev) {
            SwingUtilities.invokeLater(ServiceEditor.this.browser.wrap(new Runnable(){

                @Override
                public void run() {
                    if (ServiceEditor.this.eventID == ev.getID() && ServiceEditor.this.seqNo < ev.getSequenceNumber()) {
                        ServiceEditor.this.seqNo = ev.getSequenceNumber();
                        ServiceEditor.this.attrPanel.receiveNotify(((ServiceEvent)ev).getTransition());
                    }
                }
            }));
        }

        @Override
        public TrustVerifier getProxyVerifier() {
            return new BasicProxyTrustVerifier(this.proxy);
        }

        void unexport() {
            this.exporter.unexport(true);
        }
    }
}

