/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.fiddler;

import com.sun.jini.admin.DestroyAdmin;
import com.sun.jini.fiddler.Fiddler;
import com.sun.jini.fiddler.FiddlerAdmin;
import com.sun.jini.fiddler.ProxyUtil;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import net.jini.admin.JoinAdmin;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class FiddlerAdminProxy
implements FiddlerAdmin,
ReferentUuid,
Serializable {
    private static final long serialVersionUID = 2L;
    final Fiddler server;
    final Uuid proxyID;

    public static FiddlerAdminProxy createAdminProxy(Fiddler server, Uuid proxyID) {
        if (server instanceof RemoteMethodControl) {
            return new ConstrainableFiddlerAdminProxy(server, proxyID, null);
        }
        return new FiddlerAdminProxy(server, proxyID);
    }

    private FiddlerAdminProxy(Fiddler server, Uuid proxyID) {
        this.server = server;
        this.proxyID = proxyID;
    }

    @Override
    public void setLeaseBound(long newBound) throws RemoteException {
        this.server.setLeaseBound(newBound);
    }

    @Override
    public long getLeaseBound() throws RemoteException {
        return this.server.getLeaseBound();
    }

    @Override
    public void setPersistenceSnapshotWeight(float weight) throws RemoteException {
        this.server.setPersistenceSnapshotWeight(weight);
    }

    @Override
    public float getPersistenceSnapshotWeight() throws RemoteException {
        return this.server.getPersistenceSnapshotWeight();
    }

    @Override
    public void setPersistenceSnapshotThreshold(int threshold) throws RemoteException {
        this.server.setPersistenceSnapshotThreshold(threshold);
    }

    @Override
    public int getPersistenceSnapshotThreshold() throws RemoteException {
        return this.server.getPersistenceSnapshotThreshold();
    }

    @Override
    public Entry[] getLookupAttributes() throws RemoteException {
        return this.server.getLookupAttributes();
    }

    @Override
    public void addLookupAttributes(Entry[] attrSets) throws RemoteException {
        this.server.addLookupAttributes(attrSets);
    }

    @Override
    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) throws RemoteException {
        this.server.modifyLookupAttributes(attrSetTemplates, attrSets);
    }

    @Override
    public String[] getLookupGroups() throws RemoteException {
        return this.server.getLookupGroups();
    }

    @Override
    public void addLookupGroups(String[] groups) throws RemoteException {
        this.server.addLookupGroups(groups);
    }

    @Override
    public void removeLookupGroups(String[] groups) throws RemoteException {
        this.server.removeLookupGroups(groups);
    }

    @Override
    public void setLookupGroups(String[] groups) throws RemoteException {
        this.server.setLookupGroups(groups);
    }

    @Override
    public LookupLocator[] getLookupLocators() throws RemoteException {
        return this.server.getLookupLocators();
    }

    @Override
    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.server.addLookupLocators(locators);
    }

    @Override
    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.server.removeLookupLocators(locators);
    }

    @Override
    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.server.setLookupLocators(locators);
    }

    @Override
    public Uuid getReferentUuid() {
        return this.proxyID;
    }

    @Override
    public void destroy() throws RemoteException {
        this.server.destroy();
    }

    public int hashCode() {
        return this.proxyID.hashCode();
    }

    public boolean equals(Object obj) {
        return ReferentUuids.compare(this, obj);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.server == null) {
            throw new InvalidObjectException("FiddlerAdminProxy.readObject failure - server field is null");
        }
        if (this.proxyID == null) {
            throw new InvalidObjectException("FiddlerAdminProxy.readObject failure - proxyID field is null");
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data found when attempting to deserialize FiddlerAdminProxy instance");
    }

    static final class ConstrainableFiddlerAdminProxy
    extends FiddlerAdminProxy
    implements RemoteMethodControl {
        static final long serialVersionUID = 2L;
        private static final Method[] methodMapArray = new Method[]{ProxyUtil.getMethod(JoinAdmin.class, "getLookupAttributes", new Class[0]), ProxyUtil.getMethod(JoinAdmin.class, "getLookupAttributes", new Class[0]), ProxyUtil.getMethod(JoinAdmin.class, "addLookupAttributes", new Class[]{Entry[].class}), ProxyUtil.getMethod(JoinAdmin.class, "addLookupAttributes", new Class[]{Entry[].class}), ProxyUtil.getMethod(JoinAdmin.class, "modifyLookupAttributes", new Class[]{Entry[].class, Entry[].class}), ProxyUtil.getMethod(JoinAdmin.class, "modifyLookupAttributes", new Class[]{Entry[].class, Entry[].class}), ProxyUtil.getMethod(JoinAdmin.class, "getLookupGroups", new Class[0]), ProxyUtil.getMethod(JoinAdmin.class, "getLookupGroups", new Class[0]), ProxyUtil.getMethod(JoinAdmin.class, "addLookupGroups", new Class[]{String[].class}), ProxyUtil.getMethod(JoinAdmin.class, "addLookupGroups", new Class[]{String[].class}), ProxyUtil.getMethod(JoinAdmin.class, "removeLookupGroups", new Class[]{String[].class}), ProxyUtil.getMethod(JoinAdmin.class, "removeLookupGroups", new Class[]{String[].class}), ProxyUtil.getMethod(JoinAdmin.class, "setLookupGroups", new Class[]{String[].class}), ProxyUtil.getMethod(JoinAdmin.class, "setLookupGroups", new Class[]{String[].class}), ProxyUtil.getMethod(JoinAdmin.class, "getLookupLocators", new Class[0]), ProxyUtil.getMethod(JoinAdmin.class, "getLookupLocators", new Class[0]), ProxyUtil.getMethod(JoinAdmin.class, "addLookupLocators", new Class[]{LookupLocator[].class}), ProxyUtil.getMethod(JoinAdmin.class, "addLookupLocators", new Class[]{LookupLocator[].class}), ProxyUtil.getMethod(JoinAdmin.class, "removeLookupLocators", new Class[]{LookupLocator[].class}), ProxyUtil.getMethod(JoinAdmin.class, "removeLookupLocators", new Class[]{LookupLocator[].class}), ProxyUtil.getMethod(JoinAdmin.class, "setLookupLocators", new Class[]{LookupLocator[].class}), ProxyUtil.getMethod(JoinAdmin.class, "setLookupLocators", new Class[]{LookupLocator[].class}), ProxyUtil.getMethod(DestroyAdmin.class, "destroy", new Class[0]), ProxyUtil.getMethod(DestroyAdmin.class, "destroy", new Class[0]), ProxyUtil.getMethod(FiddlerAdmin.class, "setLeaseBound", new Class[]{Long.TYPE}), ProxyUtil.getMethod(FiddlerAdmin.class, "setLeaseBound", new Class[]{Long.TYPE}), ProxyUtil.getMethod(FiddlerAdmin.class, "getLeaseBound", new Class[0]), ProxyUtil.getMethod(FiddlerAdmin.class, "getLeaseBound", new Class[0]), ProxyUtil.getMethod(FiddlerAdmin.class, "setPersistenceSnapshotWeight", new Class[]{Float.TYPE}), ProxyUtil.getMethod(FiddlerAdmin.class, "setPersistenceSnapshotWeight", new Class[]{Float.TYPE}), ProxyUtil.getMethod(FiddlerAdmin.class, "getPersistenceSnapshotWeight", new Class[0]), ProxyUtil.getMethod(FiddlerAdmin.class, "getPersistenceSnapshotWeight", new Class[0]), ProxyUtil.getMethod(FiddlerAdmin.class, "setPersistenceSnapshotThreshold", new Class[]{Integer.TYPE}), ProxyUtil.getMethod(FiddlerAdmin.class, "setPersistenceSnapshotThreshold", new Class[]{Integer.TYPE}), ProxyUtil.getMethod(FiddlerAdmin.class, "getPersistenceSnapshotThreshold", new Class[0]), ProxyUtil.getMethod(FiddlerAdmin.class, "getPersistenceSnapshotThreshold", new Class[0])};
        private MethodConstraints methodConstraints;

        private ConstrainableFiddlerAdminProxy(Fiddler server, Uuid proxyID, MethodConstraints methodConstraints) {
            super(ConstrainableFiddlerAdminProxy.constrainServer(server, methodConstraints), proxyID);
            this.methodConstraints = methodConstraints;
        }

        private static Fiddler constrainServer(Fiddler server, MethodConstraints constraints) {
            MethodConstraints newConstraints = ConstrainableProxyUtil.translateConstraints(constraints, methodMapArray);
            RemoteMethodControl constrainedServer = ((RemoteMethodControl)((Object)server)).setConstraints(newConstraints);
            return (Fiddler)((Object)constrainedServer);
        }

        @Override
        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableFiddlerAdminProxy(this.server, this.proxyID, constraints);
        }

        @Override
        public MethodConstraints getConstraints() {
            return this.methodConstraints;
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator(this.server);
        }

        @Override
        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            ConstrainableProxyUtil.verifyConsistentConstraints(this.methodConstraints, this.server, methodMapArray);
        }
    }
}

