/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.fiddler;

import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.fiddler.Fiddler;
import com.sun.jini.fiddler.FiddlerAdminProxy;
import com.sun.jini.fiddler.FiddlerLease;
import com.sun.jini.fiddler.FiddlerProxy;
import com.sun.jini.fiddler.FiddlerRegistration;
import com.sun.jini.fiddler.FiddlerRenewResults;
import com.sun.jini.fiddler.ProxyVerifier;
import com.sun.jini.logging.Levels;
import com.sun.jini.lookup.entry.BasicServiceType;
import com.sun.jini.lookup.entry.LookupAttributes;
import com.sun.jini.proxy.ThrowThis;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import com.sun.jini.start.LifeCycle;
import com.sun.jini.thread.InterruptedStatusThread;
import com.sun.jini.thread.ReadersWriter;
import com.sun.jini.thread.ReadyState;
import com.sun.jini.thread.TaskManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.rmi.server.ExportException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.activation.ActivationExporter;
import net.jini.activation.ActivationGroup;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.NoSuchEntryException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryChangeListener;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.discovery.LookupDiscoveryRegistration;
import net.jini.discovery.RemoteDiscoveryEvent;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lookup.JoinManager;
import net.jini.lookup.entry.Comment;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.lookup.entry.Status;
import net.jini.lookup.entry.StatusType;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

class FiddlerImpl
implements ServerProxyTrust,
ProxyAccessor,
Fiddler {
    private static final String COMPONENT_NAME = "com.sun.jini.fiddler";
    static final Logger problemLogger = Logger.getLogger("com.sun.jini.fiddler.problem");
    static final Logger startupLogger = Logger.getLogger("com.sun.jini.fiddler.startup");
    static final Logger tasksLogger = Logger.getLogger("com.sun.jini.fiddler.tasks");
    static final Logger eventsLogger = Logger.getLogger("com.sun.jini.fiddler.events");
    static final Logger groupsLogger = Logger.getLogger("com.sun.jini.fiddler.groups");
    static final Logger locatorsLogger = Logger.getLogger("com.sun.jini.fiddler.locators");
    static final Logger discardLogger = Logger.getLogger("com.sun.jini.fiddler.discard");
    static final Logger leaseLogger = Logger.getLogger("com.sun.jini.fiddler.lease");
    static final Logger registrationLogger = Logger.getLogger("com.sun.jini.fiddler.registration");
    static final Logger persistLogger = Logger.getLogger("com.sun.jini.fiddler.persist");
    private static final String PRODUCT = "Lookup Discovery Service";
    private static final String MANUFACTURER = "Sun Microsystems, Inc.";
    private static final String VENDOR = "Sun Microsystems, Inc.";
    private static final String VERSION = "2.2.0";
    private static final long MAX_LEASE = 31536000000000L;
    private static final int LOG_VERSION = 2;
    private FiddlerProxy outerProxy;
    private Fiddler innerProxy;
    private FiddlerAdminProxy adminProxy;
    private ServiceID serviceID = null;
    private ActivationID activationID;
    private ActivationSystem activationSystem;
    private Uuid proxyID = null;
    private final HashMap allDiscoveredRegs = new HashMap(11);
    private final HashMap registrationByID = new HashMap(11);
    private final TreeMap registrationByTime = new TreeMap();
    private LookupDiscoveryManager discoveryMgr = null;
    private final LookupDiscoveryListener discoveryListener = new LookupDiscoveryListener();
    private long curEventID = 0L;
    private long minExpiration = Long.MAX_VALUE;
    private DiscoveryManagement joinMgrLDM;
    private JoinManager joinMgr;
    private TaskManager taskMgr;
    private Thread leaseExpireThread;
    private Thread snapshotThread;
    private final ReadersWriter concurrentObj = new ReadersWriter();
    private final Object leaseExpireThreadSyncObj = new Object();
    private final Object snapshotThreadSyncObj = new Object();
    private ReliableLog log = null;
    private boolean inRecovery;
    private int logFileSize = 0;
    private String persistDir;
    private long leaseBound = 1800000L;
    private float snapshotWt = 10.0f;
    private int snapshotThresh = 200;
    private String[] thisServicesGroups = new String[]{""};
    private LookupLocator[] thisServicesLocators = new LookupLocator[0];
    private Entry[] thisServicesAttrs = new Entry[]{new ServiceInfo("Lookup Discovery Service", "Sun Microsystems, Inc.", "Sun Microsystems, Inc.", "2.2.0", "", ""), new BasicServiceType("Lookup Discovery Service")};
    private Configuration config;
    private LoginContext loginContext = null;
    private Exporter serverExporter;
    private long leaseMax = 31536000000000L;
    private boolean initialStartup = true;
    private LifeCycle lifeCycle = null;
    private static ProxyPreparer listenerPreparer;
    private static ProxyPreparer recoveredListenerPreparer;
    private static ProxyPreparer locatorToJoinPreparer;
    private static ProxyPreparer recoveredLocatorToJoinPreparer;
    private static ProxyPreparer locatorToDiscoverPreparer;
    private static ProxyPreparer recoveredLocatorToDiscoverPreparer;
    private final ReadyState readyState = new ReadyState();

    FiddlerImpl(ActivationID activationID, MarshalledObject data) throws IOException, ActivationException, ConfigurationException, LoginException, ClassNotFoundException {
        this.activationID = activationID;
        try {
            this.activationSystem = ActivationGroup.getSystem();
            this.init((String[])data.get(), true);
        }
        catch (Throwable e) {
            this.cleanupInitFailure();
            this.handleActivatableInitThrowable(e);
        }
    }

    FiddlerImpl(String[] configArgs, LifeCycle lifeCycle, boolean persistent) throws IOException, ConfigurationException, LoginException {
        try {
            this.lifeCycle = lifeCycle;
            this.init(configArgs, persistent);
        }
        catch (Throwable e) {
            this.cleanupInitFailure();
            this.handleInitThrowable(e);
        }
    }

    @Override
    public TrustVerifier getProxyVerifier() throws NoSuchObjectException {
        this.readyState.check();
        return new ProxyVerifier(this.innerProxy, this.proxyID);
    }

    @Override
    public Object getProxy() {
        return this.innerProxy;
    }

    @Override
    public Object getAdmin() throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        return this.adminProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry[] getLookupAttributes() throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.readLock();
        try {
            Entry[] entryArray = this.thisServicesAttrs;
            return entryArray;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLookupAttributes(Entry[] attrSets) throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.joinMgr.addAttributes(attrSets, true);
            this.thisServicesAttrs = this.joinMgr.getAttributes();
            this.addLogRecord(new LookupAttrsAddedLogObj(this, attrSets));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.joinMgr.modifyAttributes(attrSetTemplates, attrSets, true);
            this.thisServicesAttrs = this.joinMgr.getAttributes();
            this.addLogRecord(new LookupAttrsModifiedLogObj(this, attrSetTemplates, attrSets));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getLookupGroups() throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.readLock();
        try {
            String[] stringArray = this.thisServicesGroups;
            return stringArray;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLookupGroups(String[] groups) throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            try {
                ((DiscoveryGroupManagement)((Object)this.joinMgrLDM)).addGroups(groups);
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
            this.thisServicesGroups = ((DiscoveryGroupManagement)((Object)this.joinMgrLDM)).getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.thisServicesGroups));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLookupGroups(String[] groups) throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            ((DiscoveryGroupManagement)((Object)this.joinMgrLDM)).removeGroups(groups);
            this.thisServicesGroups = ((DiscoveryGroupManagement)((Object)this.joinMgrLDM)).getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.thisServicesGroups));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLookupGroups(String[] groups) throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            try {
                ((DiscoveryGroupManagement)((Object)this.joinMgrLDM)).setGroups(groups);
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
            this.thisServicesGroups = ((DiscoveryGroupManagement)((Object)this.joinMgrLDM)).getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.thisServicesGroups));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupLocator[] getLookupLocators() throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.readLock();
        try {
            LookupLocator[] lookupLocatorArray = this.thisServicesLocators;
            return lookupLocatorArray;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLookupLocators(LookupLocator[] locators) throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        FiddlerImpl.prepareNewLocators(locatorToJoinPreparer, locators);
        this.concurrentObj.writeLock();
        try {
            ((DiscoveryLocatorManagement)((Object)this.joinMgrLDM)).addLocators(locators);
            this.thisServicesLocators = ((DiscoveryLocatorManagement)((Object)this.joinMgrLDM)).getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.thisServicesLocators));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLookupLocators(LookupLocator[] locators) throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        FiddlerImpl.prepareNewLocators(locatorToJoinPreparer, locators);
        this.concurrentObj.writeLock();
        try {
            ((DiscoveryLocatorManagement)((Object)this.joinMgrLDM)).removeLocators(locators);
            this.thisServicesLocators = ((DiscoveryLocatorManagement)((Object)this.joinMgrLDM)).getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.thisServicesLocators));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLookupLocators(LookupLocator[] locators) throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        FiddlerImpl.prepareNewLocators(locatorToJoinPreparer, locators);
        this.concurrentObj.writeLock();
        try {
            ((DiscoveryLocatorManagement)((Object)this.joinMgrLDM)).setLocators(locators);
            this.thisServicesLocators = ((DiscoveryLocatorManagement)((Object)this.joinMgrLDM)).getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.thisServicesLocators));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    @Override
    public void destroy() throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.destroyDo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLeaseBound(long newBound) throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            if (newBound > this.leaseMax) {
                throw new IllegalArgumentException("max duration exceeded");
            }
            this.leaseBound = newBound;
            this.addLogRecord(new LeaseBoundSetLogObj(newBound));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLeaseBound() throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.readLock();
        try {
            long l = this.leaseBound;
            return l;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPersistenceSnapshotWeight(float weight) throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.snapshotWt = weight;
            this.addLogRecord(new SnapshotWeightSetLogObj(weight));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getPersistenceSnapshotWeight() throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.readLock();
        try {
            float f = this.snapshotWt;
            return f;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPersistenceSnapshotThreshold(int threshold) throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.snapshotThresh = threshold;
            this.addLogRecord(new SnapshotThresholdSetLogObj(threshold));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPersistenceSnapshotThreshold() throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.readLock();
        try {
            int n = this.snapshotThresh;
            return n;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    @Override
    public Object getServiceProxy() throws NoSuchObjectException {
        this.readyState.check();
        return this.outerProxy;
    }

    @Override
    public Uuid getProxyID() throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        return this.proxyID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupDiscoveryRegistration register(String[] groups, LookupLocator[] locators, RemoteEventListener listener, MarshalledObject handback, long leaseDuration) throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        if (locators == null) {
            locators = new LookupLocator[]{};
        }
        if (FiddlerImpl.containsNullElement(groups)) {
            throw new NullPointerException(" on call to register() method, at least one null element in groups");
        }
        if (FiddlerImpl.containsNullElement(locators)) {
            throw new NullPointerException(" on call to register() method, at least one null element in locators");
        }
        if (listener == null) {
            throw new NullPointerException(" null listener input to register() method");
        }
        FiddlerImpl.prepareNewLocators(locatorToDiscoverPreparer, locators);
        LookupDiscoveryRegistration reg = null;
        this.concurrentObj.writeLock();
        try {
            reg = this.registerDo(groups, locators, listener, handback, leaseDuration);
        }
        catch (RemoteException e) {
            problemLogger.log(Level.INFO, "cannot grant registration request", e);
            throw e;
        }
        catch (IOException e) {
            problemLogger.log(Level.INFO, "cannot grant registration request - multicast problem", e);
            Entry[] errorAttrs = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment("Failure during registration")};
            this.joinMgr.addAttributes(errorAttrs, true);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MarshalledObject[] getRegistrars(Uuid registrationID) throws NoSuchObjectException, RemoteException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.readLock();
        try {
            RegistrationInfo regInfo = (RegistrationInfo)this.registrationByID.get(registrationID);
            if (regInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to getRegistrars() method"));
            }
            Collection mVals = regInfo.discoveredRegsMap.values();
            MarshalledObject[] marshalledObjectArray = mVals.toArray(new MarshalledObject[mVals.size()]);
            return marshalledObjectArray;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getGroups(Uuid registrationID) throws NoSuchObjectException, RemoteException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.readLock();
        try {
            RegistrationInfo regInfo = (RegistrationInfo)this.registrationByID.get(registrationID);
            if (regInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to getGroups() method"));
            }
            String[] groups = null;
            groups = regInfo.groups == null ? DiscoveryGroupManagement.ALL_GROUPS : regInfo.groups.toArray(new String[regInfo.groups.size()]);
            String[] stringArray = groups;
            return stringArray;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupLocator[] getLocators(Uuid registrationID) throws NoSuchObjectException, RemoteException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.readLock();
        try {
            RegistrationInfo regInfo = (RegistrationInfo)this.registrationByID.get(registrationID);
            if (regInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to getLocators() method"));
            }
            LookupLocator[] lookupLocatorArray = regInfo.locators.toArray(new LookupLocator[regInfo.locators.size()]);
            return lookupLocatorArray;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGroups(Uuid registrationID, String[] groups) throws NoSuchObjectException, RemoteException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            RegistrationInfo regInfo = (RegistrationInfo)this.registrationByID.get(registrationID);
            if (regInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to addGroups() method"));
            }
            if (groups == null) {
                throw new NullPointerException(" on call to addGroups() method, cannot add 'ALL_GROUPS' (the null set) to a registration's set of groups to discover");
            }
            if (FiddlerImpl.containsNullElement(groups)) {
                throw new NullPointerException(" on call to addGroups() method, at least one null element in groups parameter");
            }
            if (regInfo.groups == null) {
                throw new UnsupportedOperationException(" on call to addGroups() method, cannot add a set ofgroups to a set already configured for 'ALL_GROUPS' (the null set)");
            }
            this.addGroupsDo(regInfo, groups);
            this.addLogRecord(new GroupsAddedToRegistrationLogObj(regInfo.registrationID, groups));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGroups(Uuid registrationID, String[] groups) throws NoSuchObjectException, RemoteException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            RegistrationInfo regInfo = (RegistrationInfo)this.registrationByID.get(registrationID);
            if (regInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to setGroups() method"));
            }
            if (FiddlerImpl.containsNullElement(groups)) {
                throw new NullPointerException(" on call to setGroups() method, at least one null element in groups parameter");
            }
            if (groups == null && regInfo.groups == null) {
                return;
            }
            this.setGroupsDo(regInfo, groups);
            this.addLogRecord(new GroupsSetInRegistrationLogObj(regInfo.registrationID, groups));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroups(Uuid registrationID, String[] groups) throws NoSuchObjectException, RemoteException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            RegistrationInfo regInfo = (RegistrationInfo)this.registrationByID.get(registrationID);
            if (regInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to removeGroups() method"));
            }
            if (groups == null) {
                throw new NullPointerException(" on call to removeGroups() method, cannot remove 'ALL_GROUPS' (the null set) from a registration's set of groups to discover");
            }
            if (FiddlerImpl.containsNullElement(groups)) {
                throw new NullPointerException(" on call to removeGroups() method, at least one null element in groups parameter");
            }
            if (regInfo.groups == null) {
                throw new UnsupportedOperationException(" on call to removeGroups() method, cannot remove a set ofgroups from a set already configured for 'ALL_GROUPS' (the null set)");
            }
            this.removeGroupsDo(regInfo, groups);
            this.logInfoGroups("\nAfter Group Removal --");
            this.addLogRecord(new GroupsRemovedFromRegistrationLogObj(regInfo.registrationID, groups));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLocators(Uuid registrationID, LookupLocator[] locators) throws NoSuchObjectException, RemoteException, ThrowThis {
        this.readyState.check();
        FiddlerImpl.prepareNewLocators(locatorToDiscoverPreparer, locators);
        this.concurrentObj.writeLock();
        try {
            RegistrationInfo regInfo = (RegistrationInfo)this.registrationByID.get(registrationID);
            if (regInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to addLocators() method"));
            }
            if (locators == null) {
                throw new NullPointerException(" on call to addLocators() method, cannot add null to a registration's set of locators to discover");
            }
            if (FiddlerImpl.containsNullElement(locators)) {
                throw new NullPointerException(" on call to addLocators() method, at least one null element in locators parameter");
            }
            this.addLocatorsDo(regInfo, locators);
            this.addLogRecord(new LocsAddedToRegistrationLogObj(regInfo.registrationID, locators));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLocators(Uuid registrationID, LookupLocator[] locators) throws NoSuchObjectException, RemoteException, ThrowThis {
        this.readyState.check();
        FiddlerImpl.prepareNewLocators(locatorToDiscoverPreparer, locators);
        this.concurrentObj.writeLock();
        try {
            RegistrationInfo regInfo = (RegistrationInfo)this.registrationByID.get(registrationID);
            if (regInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to setLocators() method"));
            }
            if (locators == null) {
                throw new NullPointerException(" on call to setLocators() method, cannot replace a registration's current set of locators with null");
            }
            if (FiddlerImpl.containsNullElement(locators)) {
                throw new NullPointerException(" on call to setLocators() method, at least one null element in locators parameter");
            }
            this.setLocatorsDo(regInfo, locators);
            this.addLogRecord(new LocsSetInRegistrationLogObj(regInfo.registrationID, locators));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLocators(Uuid registrationID, LookupLocator[] locators) throws NoSuchObjectException, RemoteException, ThrowThis {
        this.readyState.check();
        FiddlerImpl.prepareNewLocators(locatorToDiscoverPreparer, locators);
        this.concurrentObj.writeLock();
        try {
            RegistrationInfo regInfo = (RegistrationInfo)this.registrationByID.get(registrationID);
            if (regInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to removeLocators() method"));
            }
            if (locators == null) {
                throw new NullPointerException(" on call to removeLocators() method, cannot remove null from a registration's set of locators to discover");
            }
            if (FiddlerImpl.containsNullElement(locators)) {
                throw new NullPointerException(" on call to removeLocators() method, at least one null element in locators parameter");
            }
            this.removeLocatorsDo(regInfo, locators);
            this.addLogRecord(new LocsRemovedFromRegistrationLogObj(regInfo.registrationID, locators));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discard(Uuid registrationID, ServiceRegistrar registrar) throws NoSuchObjectException, RemoteException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.logInfoDiscard("\ndiscard: ", registrationID);
            RegistrationInfo regInfo = (RegistrationInfo)this.registrationByID.get(registrationID);
            if (regInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to discard() method"));
            }
            if (registrar == null) {
                throw new NullPointerException(" on call to discard() method, null input for registrar to discard");
            }
            if (this.regIsElementOfRegSet(registrar, this.discoveryMgr.getRegistrars())) {
                this.logInfoDiscard("  Registrar IS an element of Mgr's discovered registrars ... discarding from discovery manager");
                regInfo.discardFlag = true;
                this.discoveryMgr.discard(registrar);
            } else {
                this.logInfoDiscard("  Registrar NOT an element of Mgr's discovered registrars ... queuing new DiscardRegistrarTask");
                this.taskMgr.add(new DiscardRegistrarTask(regInfo, registrar));
            }
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long renewLease(Uuid registrationID, Uuid leaseID, long duration) throws UnknownLeaseException, NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.priorityWriteLock();
        try {
            RegistrationInfo regInfo = (RegistrationInfo)this.registrationByID.get(registrationID);
            if (regInfo == null) {
                throw new UnknownLeaseException("\n    Invalid registration ID on call to cancelLease() method\n    The lease may have expired or been cancelled");
            }
            long newDuration = 0L;
            newDuration = this.renewLeaseDo(regInfo, leaseID, duration);
            this.logInfoLease("Renewed lease: ", registrationID, leaseID);
            long l = newDuration;
            return l;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FiddlerRenewResults renewLeases(Uuid[] registrationIDs, Uuid[] leaseIDs, long[] durations) throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.priorityWriteLock();
        try {
            FiddlerRenewResults fiddlerRenewResults = this.renewLeasesDo(registrationIDs, leaseIDs, durations);
            return fiddlerRenewResults;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelLease(Uuid registrationID, Uuid leaseID) throws UnknownLeaseException, NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            RegistrationInfo regInfo = (RegistrationInfo)this.registrationByID.get(registrationID);
            if (regInfo == null) {
                throw new UnknownLeaseException("\n    Invalid registration ID on call to cancelLease() method\n    The lease may have expired or been cancelled");
            }
            try {
                this.cancelLeaseDo(regInfo, leaseID);
                this.logInfoLease("Cancelled lease: ", registrationID, leaseID);
            }
            catch (IOException e) {
                String eStr = "Failure while cancelling the lease on registration with ID = " + registrationID;
                if (problemLogger.isLoggable(Level.INFO)) {
                    problemLogger.log(Level.INFO, eStr, e);
                }
                Entry[] errorAttrs = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(eStr)};
                this.joinMgr.addAttributes(errorAttrs, true);
            }
            this.addLogRecord(new LeaseCancelledLogObj(regInfo.registrationID, leaseID));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exception[] cancelLeases(Uuid[] registrationIDs, Uuid[] leaseIDs) throws NoSuchObjectException, RemoteException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.addLogRecord(new LeasesCancelledLogObj(registrationIDs, leaseIDs));
            Exception[] exceptionArray = this.cancelLeasesDo(registrationIDs, leaseIDs);
            return exceptionArray;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private static Object[] appendArray(Object[] array, Object elt) {
        int len = array.length;
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), len + 1);
        System.arraycopy(array, 0, newArray, 0, len);
        newArray[len] = elt;
        return newArray;
    }

    private static long applyBoundToLeaseDuration(long leaseDuration, long bound) {
        long newLeaseDuration = leaseDuration;
        if (leaseDuration == -1L || leaseDuration > bound) {
            newLeaseDuration = bound;
        } else if (leaseDuration < 0L) {
            throw new IllegalArgumentException("negative lease duration");
        }
        return newLeaseDuration;
    }

    private static boolean containsNullElement(Object[] arr) {
        if (arr == null || arr.length == 0) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != null) continue;
            return true;
        }
        return false;
    }

    private static boolean interested(String[] regGroups, Set desiredGroups) {
        if (desiredGroups == null) {
            return true;
        }
        if (desiredGroups.size() == 0) {
            return false;
        }
        for (int i = 0; i < regGroups.length; ++i) {
            if (!desiredGroups.contains(regGroups[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean interested(LookupLocator regLoc, String[] regGroups, Set desiredLocators, Set desiredGroups) {
        if (FiddlerImpl.locSetContainsLoc(desiredLocators, regLoc)) {
            return true;
        }
        return FiddlerImpl.interested(regGroups, desiredGroups);
    }

    private static HashMap getUndesiredRegsByGroup(Map regMap, RegistrationInfo regInfo) {
        HashSet desiredGroups = regInfo.groups;
        HashMap<ServiceRegistrar, String[]> undesiredRegMap = new HashMap<ServiceRegistrar, String[]>(regMap.size());
        Set eSet = regMap.entrySet();
        for (Map.Entry pair : eSet) {
            String[] regGroups = ((LocatorGroupsStruct)pair.getValue()).groups;
            if (FiddlerImpl.interested(regGroups, desiredGroups)) continue;
            undesiredRegMap.put((ServiceRegistrar)pair.getKey(), regGroups);
        }
        return undesiredRegMap;
    }

    private static Map getUndesiredRegsByLocator(Map regMap, RegistrationInfo regInfo) {
        HashSet desiredLocators = regInfo.locators;
        HashMap<ServiceRegistrar, LookupLocator> undesiredRegMap = new HashMap<ServiceRegistrar, LookupLocator>(regMap.size());
        Set eSet = regMap.entrySet();
        for (Map.Entry pair : eSet) {
            LookupLocator regLocator = ((LocatorGroupsStruct)pair.getValue()).locator;
            if (FiddlerImpl.locSetContainsLoc(desiredLocators, regLocator)) continue;
            undesiredRegMap.put((ServiceRegistrar)pair.getKey(), regLocator);
        }
        return undesiredRegMap;
    }

    private static MarshalledObject[] marshalAttributes(FiddlerImpl fiddlerImpl, Entry[] attrs) {
        if (attrs == null) {
            return new MarshalledObject[0];
        }
        ArrayList<MarshalledObject<Entry>> marshalledAttrs = new ArrayList<MarshalledObject<Entry>>();
        for (int i = 0; i < attrs.length; ++i) {
            try {
                marshalledAttrs.add(new MarshalledObject<Entry>(attrs[i]));
                continue;
            }
            catch (Throwable e) {
                if (!problemLogger.isLoggable(Level.INFO)) continue;
                problemLogger.log(Level.INFO, "Error while marshalling attribute[" + i + "] (" + attrs[i] + ")", e);
            }
        }
        return marshalledAttrs.toArray(new MarshalledObject[marshalledAttrs.size()]);
    }

    private static Entry[] unmarshalAttributes(FiddlerImpl fiddlerImpl, MarshalledObject[] marshalledAttrs) {
        if (marshalledAttrs == null) {
            return new Entry[0];
        }
        ArrayList<Entry> attrs = new ArrayList<Entry>();
        for (int i = 0; i < marshalledAttrs.length; ++i) {
            try {
                attrs.add((Entry)marshalledAttrs[i].get());
                continue;
            }
            catch (Throwable e) {
                if (!problemLogger.isLoggable(Level.INFO)) continue;
                problemLogger.log(Level.INFO, "Error while unmarshalling attribute[" + i + "]", e);
            }
        }
        return attrs.toArray(new Entry[attrs.size()]);
    }

    private static void prepareNewLocators(ProxyPreparer preparer, LookupLocator[] locators) throws RemoteException {
        for (int i = 0; i < locators.length; ++i) {
            locators[i] = (LookupLocator)preparer.prepareProxy(locators[i]);
        }
    }

    private static LookupLocator[] prepareOldLocators(ProxyPreparer preparer, LookupLocator[] locators) {
        int i;
        ArrayList<Object> locsList = new ArrayList<Object>(locators.length);
        for (i = 0; i < locators.length; ++i) {
            try {
                locsList.add(preparer.prepareProxy(locators[i]));
                continue;
            }
            catch (Throwable e) {
                if (!problemLogger.isLoggable(Level.INFO)) continue;
                problemLogger.log(Level.INFO, "failure preparing recovered lookup locator[" + i + "]", e);
            }
        }
        if (locators.length != locsList.size() && problemLogger.isLoggable(Levels.HANDLED)) {
            problemLogger.log(Levels.HANDLED, "number of requested recovered lookup locators = " + locators.length);
            problemLogger.log(Levels.HANDLED, "number of successfully prepared recovered lookup locators = " + locsList.size());
            for (i = 0; i < locsList.size(); ++i) {
                problemLogger.log(Levels.HANDLED, "successfully prepared recovered lookup locator = " + locsList.get(i));
            }
        }
        return locsList.toArray(new LookupLocator[locsList.size()]);
    }

    private static Set prepareOldLocators(ProxyPreparer preparer, Set locators) {
        HashSet<LookupLocator> locSet = new HashSet<LookupLocator>(locators.size());
        LookupLocator[] locsArray = FiddlerImpl.prepareOldLocators(preparer, locators.toArray(new LookupLocator[locators.size()]));
        for (int i = 0; i < locsArray.length; ++i) {
            locSet.add(locsArray[i]);
        }
        return locSet;
    }

    private static boolean locSetContainsLoc(Set locSet, LookupLocator loc) {
        if (locSet.contains(loc)) {
            return true;
        }
        int port0 = loc.getPort();
        InetAddress addr0 = null;
        for (LookupLocator nextLoc : locSet) {
            if (nextLoc.getPort() != port0) continue;
            if (addr0 == null) {
                try {
                    addr0 = InetAddress.getByName(loc.getHost());
                }
                catch (Exception e) {
                    problemLogger.log(Levels.HANDLED, "problem retrieving address by name", e);
                    return false;
                }
            }
            InetAddress addr1 = null;
            try {
                addr1 = InetAddress.getByName(nextLoc.getHost());
            }
            catch (Exception e) {
                problemLogger.log(Level.FINEST, "problem retrieving address by name", e);
                continue;
            }
            if (!addr1.equals(addr0)) continue;
            return true;
        }
        return false;
    }

    private void init(String[] configArgs, boolean persistent) throws IOException, ConfigurationException, LoginException {
        this.config = ConfigurationProvider.getInstance(configArgs, this.getClass().getClassLoader());
        this.loginContext = (LoginContext)this.config.getEntry(COMPONENT_NAME, "loginContext", LoginContext.class, null);
        if (this.loginContext != null) {
            this.initWithLogin(this.config, persistent, this.loginContext);
        } else {
            this.doInit(this.config, persistent);
        }
    }

    private void initWithLogin(final Configuration config, final boolean persistent, LoginContext loginContext) throws IOException, ConfigurationException, LoginException {
        loginContext.login();
        try {
            Subject.doAsPrivileged(loginContext.getSubject(), new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    FiddlerImpl.this.doInit(config, persistent);
                    return null;
                }
            }, null);
        }
        catch (Throwable e) {
            if (e instanceof PrivilegedExceptionAction) {
                e = e.getCause();
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ConfigurationException) {
                throw (ConfigurationException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void doInit(Configuration config, boolean persistent) throws IOException, ConfigurationException {
        block21: {
            this.discoveryMgr = new LookupDiscoveryManager(DiscoveryGroupManagement.NO_GROUPS, new LookupLocator[0], null, config);
            listenerPreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT_NAME, "listenerPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            locatorToJoinPreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT_NAME, "locatorToJoinPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            locatorToDiscoverPreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT_NAME, "locatorToDiscoverPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            if (persistent) {
                recoveredListenerPreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT_NAME, "recoveredListenerPreparer", ProxyPreparer.class, new BasicProxyPreparer());
                recoveredLocatorToJoinPreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT_NAME, "recoveredLocatorToJoinPreparer", ProxyPreparer.class, new BasicProxyPreparer());
                recoveredLocatorToDiscoverPreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT_NAME, "recoveredLocatorToDiscoverPreparer", ProxyPreparer.class, new BasicProxyPreparer());
                this.persistDir = (String)Config.getNonNullEntry(config, COMPONENT_NAME, "persistenceDirectory", String.class);
                this.log = new ReliableLog(this.persistDir, new LocalLogHandler());
                this.inRecovery = true;
                this.log.recover();
                this.inRecovery = false;
            }
            if (this.initialStartup) {
                if (this.log != null) {
                    this.snapshotWt = ((Float)config.getEntry(COMPONENT_NAME, "initialPersistenceSnapshotWeight", Float.TYPE, new Float(this.snapshotWt))).floatValue();
                    this.snapshotThresh = Config.getIntEntry(config, COMPONENT_NAME, "initialPersistenceSnapshotThreshold", this.snapshotThresh, 0, Integer.MAX_VALUE);
                }
                this.leaseBound = Config.getLongEntry(config, COMPONENT_NAME, "initialLeaseBound", this.leaseBound, 0L, Long.MAX_VALUE);
                Entry[] initAttrs = (Entry[])config.getEntry(COMPONENT_NAME, "initialLookupAttributes", Entry[].class, null);
                if (initAttrs != null) {
                    int i;
                    ArrayList<Entry> attrsList = new ArrayList<Entry>(this.thisServicesAttrs.length + initAttrs.length);
                    for (i = 0; i < this.thisServicesAttrs.length; ++i) {
                        attrsList.add(this.thisServicesAttrs[i]);
                    }
                    for (i = 0; i < initAttrs.length; ++i) {
                        attrsList.add(initAttrs[i]);
                    }
                    this.thisServicesAttrs = attrsList.toArray(new Entry[attrsList.size()]);
                }
                this.thisServicesGroups = (String[])config.getEntry(COMPONENT_NAME, "initialLookupGroups", String[].class, this.thisServicesGroups);
                this.thisServicesLocators = (LookupLocator[])config.getEntry(COMPONENT_NAME, "initialLookupLocators", LookupLocator[].class, new LookupLocator[0]);
                if (this.thisServicesLocators == null) {
                    this.thisServicesLocators = new LookupLocator[0];
                }
                this.proxyID = UuidFactory.generate();
            }
            if (this.proxyID == null) {
                throw new NullPointerException("proxyID == null");
            }
            this.leaseMax = Config.getLongEntry(config, COMPONENT_NAME, "leaseMax", this.leaseMax, 0L, Long.MAX_VALUE);
            if (this.log != null) {
                this.log.snapshot();
            }
            this.serviceID = new ServiceID(this.proxyID.getMostSignificantBits(), this.proxyID.getLeastSignificantBits());
            this.taskMgr = (TaskManager)Config.getNonNullEntry(config, COMPONENT_NAME, "taskManager", TaskManager.class, new TaskManager(10, 15000L, 1.0f));
            try {
                this.joinMgrLDM = (DiscoveryManagement)Config.getNonNullEntry(config, COMPONENT_NAME, "discoveryManager", DiscoveryManagement.class);
                if (this.joinMgrLDM instanceof DiscoveryGroupManagement) {
                    String[] groups0 = ((DiscoveryGroupManagement)((Object)this.joinMgrLDM)).getGroups();
                    if (groups0 == DiscoveryGroupManagement.ALL_GROUPS || groups0.length != 0) {
                        throw new ConfigurationException("discoveryManager entry must be configured to initially discover/join NO_GROUPS");
                    }
                } else {
                    throw new ConfigurationException("discoveryManager entry must implement DiscoveryGroupManagement");
                }
                if (this.joinMgrLDM instanceof DiscoveryLocatorManagement) {
                    LookupLocator[] locs0 = ((DiscoveryLocatorManagement)((Object)this.joinMgrLDM)).getLocators();
                    if (locs0 != null && locs0.length != 0) {
                        throw new ConfigurationException("discoveryManager entry must be configured to initially discover/join no locators");
                    }
                    break block21;
                }
                throw new ConfigurationException("discoveryManager entry must implement DiscoveryLocatorManagement");
            }
            catch (NoSuchEntryException e) {
                this.joinMgrLDM = new LookupDiscoveryManager(DiscoveryGroupManagement.NO_GROUPS, new LookupLocator[0], null, config);
            }
        }
        TcpServerEndpoint endpoint = TcpServerEndpoint.getInstance(0);
        BasicILFactory ilFactory = new BasicILFactory();
        Exporter defaultExporter = new BasicJeriExporter(endpoint, ilFactory, false, true);
        if (this.activationID != null) {
            ProxyPreparer aidPreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT_NAME, "activationIdPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            ProxyPreparer aSysPreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT_NAME, "activationSystemPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            this.activationID = (ActivationID)aidPreparer.prepareProxy(this.activationID);
            this.activationSystem = (ActivationSystem)aSysPreparer.prepareProxy(this.activationSystem);
            defaultExporter = new ActivationExporter(this.activationID, defaultExporter);
        }
        try {
            this.serverExporter = (Exporter)Config.getNonNullEntry(config, COMPONENT_NAME, "serverExporter", Exporter.class, defaultExporter, this.activationID);
        }
        catch (ConfigurationException e) {
            throw new ExportException("Configuration exception while retrieving service's exporter", e);
        }
        this.innerProxy = (Fiddler)this.serverExporter.export(this);
        this.outerProxy = FiddlerProxy.createServiceProxy(this.innerProxy, this.proxyID);
        this.adminProxy = FiddlerAdminProxy.createAdminProxy(this.innerProxy, this.proxyID);
        this.leaseExpireThread = new LeaseExpireThread();
        if (this.log != null) {
            this.snapshotThread = new SnapshotThread();
        }
        this.discoveryMgr.addDiscoveryListener(this.discoveryListener);
        this.joinMgr = new JoinManager((Object)this.outerProxy, this.thisServicesAttrs, this.serviceID, this.joinMgrLDM, null, config);
        ((DiscoveryLocatorManagement)((Object)this.joinMgrLDM)).setLocators(this.thisServicesLocators);
        ((DiscoveryGroupManagement)((Object)this.joinMgrLDM)).setGroups(this.thisServicesGroups);
        this.leaseExpireThread.start();
        if (this.log != null) {
            this.snapshotThread.start();
        }
        this.logInfoStartup();
        this.readyState.ready();
    }

    private void cleanupInitFailure() {
        if (this.innerProxy != null) {
            try {
                this.serverExporter.unexport(true);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.taskMgr != null) {
            try {
                this.taskMgr.terminate();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.joinMgr != null) {
            try {
                this.joinMgr.terminate();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.joinMgrLDM != null) {
            try {
                this.joinMgrLDM.terminate();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.discoveryMgr != null) {
            try {
                this.discoveryMgr.terminate();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.leaseExpireThread != null) {
            try {
                this.leaseExpireThread.interrupt();
                this.leaseExpireThread.join();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.snapshotThread != null) {
            try {
                this.snapshotThread.interrupt();
                this.snapshotThread.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void handleActivatableInitThrowable(Throwable t) throws IOException, ActivationException, ConfigurationException, LoginException, ClassNotFoundException {
        this.handleInitThrowable(t);
        if (t instanceof ActivationException) {
            throw (ActivationException)t;
        }
        if (t instanceof LoginException) {
            throw (ClassNotFoundException)t;
        }
        throw new AssertionError((Object)t);
    }

    private void handleInitThrowable(Throwable t) throws IOException, ConfigurationException, LoginException {
        problemLogger.log(Level.SEVERE, "cannot initialize the service", t);
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof ConfigurationException) {
            throw (ConfigurationException)t;
        }
        if (t instanceof LoginException) {
            throw (LoginException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
    }

    private void destroyDo() {
        new DestroyThread().start();
    }

    private LookupDiscoveryRegistration registerDo(String[] groups, LookupLocator[] locators, RemoteEventListener listener, MarshalledObject handback, long leaseDuration) throws RemoteException, IOException {
        Uuid regID;
        long curTime = System.currentTimeMillis();
        leaseDuration = FiddlerImpl.applyBoundToLeaseDuration(leaseDuration, this.leaseBound);
        Uuid leaseID = regID = UuidFactory.generate();
        long expiration = curTime + leaseDuration;
        listener = (RemoteEventListener)listenerPreparer.prepareProxy(listener);
        RegistrationInfo regInfo = new RegistrationInfo(regID, groups, locators, leaseID, expiration, this.curEventID, handback, listener);
        ++this.curEventID;
        this.addRegistration(regInfo);
        this.logInfoRegistration("\nadded registration:  registrationID = ", regID);
        this.addLogRecord(new RegistrationGrantedLogObj(regInfo));
        this.taskMgr.add(new NewRegistrationTask(regInfo));
        if (expiration < this.minExpiration) {
            this.minExpiration = expiration;
            this.concurrentObj.waiterNotify(this.leaseExpireThreadSyncObj);
        }
        FiddlerLease regLease = FiddlerLease.createLease(this.innerProxy, this.proxyID, regID, leaseID, expiration);
        EventRegistration eventReg = new EventRegistration(regInfo.eventID, this.outerProxy, regLease, regInfo.seqNum);
        this.logInfoGroups();
        this.logInfoLocators();
        FiddlerRegistration regObj = FiddlerRegistration.createRegistration(this.innerProxy, regID, eventReg);
        this.logInfoRegistration("\ncreated registration: registrationID = ", regObj);
        return regObj;
    }

    private void addRegistration(RegistrationInfo regInfo) throws IOException {
        if (regInfo.listener == null) {
            if (problemLogger.isLoggable(Level.INFO)) {
                problemLogger.log(Level.INFO, "cannot add registration (ID = " + regInfo.registrationID + "); failed to " + "unmarshal listener during recovery");
            }
            return;
        }
        this.registrationByID.put(regInfo.registrationID, regInfo);
        this.registrationByTime.put(regInfo, regInfo);
        this.updateDiscoveryMgrGroups();
        this.updateDiscoveryMgrLocators();
    }

    private void removeRegistration(RegistrationInfo regInfo) throws IOException {
        this.registrationByID.remove(regInfo.registrationID);
        this.registrationByTime.remove(regInfo);
        this.logInfoRegistration("\nremoved registration: registrationID = ", regInfo.registrationID);
        this.updateDiscoveryMgrGroups();
        this.updateDiscoveryMgrLocators();
        this.logInfoGroups();
        this.logInfoLocators();
    }

    private void addGroupsDo(RegistrationInfo regInfo, String[] groups) {
        this.taskMgr.add(new AddGroupsTask(regInfo, groups));
    }

    private void addGroupsDo(Uuid registrationID, HashMap registrationByID, String[] groups) {
        this.addGroupsDo((RegistrationInfo)registrationByID.get(registrationID), groups);
    }

    private void setGroupsDo(RegistrationInfo regInfo, String[] groups) {
        this.taskMgr.add(new SetGroupsTask(regInfo, groups));
    }

    private void setGroupsDo(Uuid registrationID, HashMap registrationByID, String[] groups) {
        this.setGroupsDo((RegistrationInfo)registrationByID.get(registrationID), groups);
    }

    private void removeGroupsDo(RegistrationInfo regInfo, String[] groups) {
        this.taskMgr.add(new RemoveGroupsTask(regInfo, groups));
    }

    private void removeGroupsDo(Uuid registrationID, HashMap registrationByID, String[] groups) {
        this.removeGroupsDo((RegistrationInfo)registrationByID.get(registrationID), groups);
    }

    private String[] getGroupsFromAllRegs() {
        HashSet groupSet = new HashSet();
        for (RegistrationInfo rInfo : this.registrationByID.values()) {
            if (rInfo.groups == null) {
                return DiscoveryGroupManagement.ALL_GROUPS;
            }
            groupSet.addAll(rInfo.groups);
        }
        return groupSet.toArray(new String[groupSet.size()]);
    }

    private HashMap getDesiredRegsByGroup(RegistrationInfo regInfo) {
        HashSet desiredGroups = regInfo.groups;
        HashMap<ServiceRegistrar, LocatorGroupsStruct> desiredRegMap = new HashMap<ServiceRegistrar, LocatorGroupsStruct>(this.allDiscoveredRegs.size());
        Set eSet = this.allDiscoveredRegs.entrySet();
        for (Map.Entry pair : eSet) {
            LocatorGroupsStruct locGroupsStruct = (LocatorGroupsStruct)pair.getValue();
            if (!FiddlerImpl.interested(locGroupsStruct.groups, desiredGroups)) continue;
            desiredRegMap.put((ServiceRegistrar)pair.getKey(), locGroupsStruct);
        }
        return desiredRegMap;
    }

    private void updateDiscoveryMgrGroups() {
        String[] groupsAcrossAllRegs = this.getGroupsFromAllRegs();
        try {
            this.discoveryMgr.setGroups(groupsAcrossAllRegs);
        }
        catch (IOException e) {
            String warnStr = "IOException: on call to setGroups() method of discovery manager";
            problemLogger.log(Level.INFO, warnStr, e);
            Entry[] warnAttrs = new Entry[]{new FiddlerStatus(StatusType.WARNING), new Comment(warnStr)};
            this.joinMgr.addAttributes(warnAttrs, true);
        }
        catch (IllegalStateException e) {
            String errStr = "IllegalStateException: discovery manager's setGroups() method was called after the manager was terminated";
            problemLogger.log(Level.INFO, errStr, e);
            Entry[] errorAttrs = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(errStr)};
            this.joinMgr.addAttributes(errorAttrs, true);
            throw new IllegalStateException(" discovery manager's setGroups() method was called after the manager was terminated");
        }
    }

    private void addLocatorsDo(RegistrationInfo regInfo, LookupLocator[] locators) {
        this.taskMgr.add(new AddLocatorsTask(regInfo, locators));
    }

    private void addLocatorsDo(Uuid registrationID, HashMap registrationByID, LookupLocator[] locators) {
        this.addLocatorsDo((RegistrationInfo)registrationByID.get(registrationID), locators);
    }

    private void setLocatorsDo(RegistrationInfo regInfo, LookupLocator[] locators) {
        this.taskMgr.add(new SetLocatorsTask(regInfo, locators));
    }

    private void setLocatorsDo(Uuid registrationID, HashMap registrationByID, LookupLocator[] locators) {
        this.setLocatorsDo((RegistrationInfo)registrationByID.get(registrationID), locators);
    }

    private void removeLocatorsDo(RegistrationInfo regInfo, LookupLocator[] locators) {
        this.taskMgr.add(new RemoveLocatorsTask(regInfo, locators));
    }

    private void removeLocatorsDo(Uuid registrationID, HashMap registrationByID, LookupLocator[] locators) {
        this.removeLocatorsDo((RegistrationInfo)registrationByID.get(registrationID), locators);
    }

    private LookupLocator[] getLocatorsFromAllRegs() {
        HashSet locatorSet = new HashSet();
        for (RegistrationInfo rInfo : this.registrationByID.values()) {
            if (rInfo.locators == null) {
                throw new AssertionError((Object)"registration contains a null set of locators");
            }
            locatorSet.addAll(rInfo.locators);
        }
        return locatorSet.toArray(new LookupLocator[locatorSet.size()]);
    }

    private HashMap getDesiredRegsByLocator(RegistrationInfo regInfo) {
        HashSet desiredLocators = regInfo.locators;
        HashMap<ServiceRegistrar, LocatorGroupsStruct> desiredRegMap = new HashMap<ServiceRegistrar, LocatorGroupsStruct>(this.allDiscoveredRegs.size());
        Set eSet = this.allDiscoveredRegs.entrySet();
        for (Map.Entry pair : eSet) {
            LocatorGroupsStruct locGroupsStruct = (LocatorGroupsStruct)pair.getValue();
            if (!FiddlerImpl.locSetContainsLoc(desiredLocators, locGroupsStruct.locator)) continue;
            desiredRegMap.put((ServiceRegistrar)pair.getKey(), locGroupsStruct);
        }
        return desiredRegMap;
    }

    private void updateDiscoveryMgrLocators() {
        LookupLocator[] locsAcrossAllRegs = this.getLocatorsFromAllRegs();
        try {
            this.discoveryMgr.setLocators(locsAcrossAllRegs);
        }
        catch (IllegalStateException e) {
            String errStr = "IllegalStateException: discovery manager's setLocators() method was called after the manager was terminated";
            problemLogger.log(Level.INFO, errStr, e);
            Entry[] errorAttrs = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(errStr)};
            this.joinMgr.addAttributes(errorAttrs, true);
            throw new IllegalStateException(" discovery manager's setLocators() method was called after the manager was terminated");
        }
    }

    private long renewLeaseDo(RegistrationInfo regInfo, Uuid leaseID, long duration) throws UnknownLeaseException {
        long curTime = System.currentTimeMillis();
        long newExpiration = this.renewLeaseInt(regInfo, leaseID, duration, curTime);
        this.addLogRecord(new LeaseRenewedLogObj(regInfo.registrationID, leaseID, newExpiration));
        return newExpiration - curTime;
    }

    private long renewLeaseInt(RegistrationInfo regInfo, Uuid leaseID, long duration, long curTime) throws UnknownLeaseException {
        if (duration == -1L) {
            duration = this.leaseBound;
        } else if (duration <= 0L) {
            throw new IllegalArgumentException("non-positive lease duration");
        }
        if (regInfo == null || !regInfo.leaseID.equals(leaseID) || regInfo.leaseExpiration <= curTime) {
            throw new UnknownLeaseException();
        }
        if (duration > this.leaseBound && duration > regInfo.leaseExpiration - curTime) {
            duration = Math.max(regInfo.leaseExpiration - curTime, this.leaseBound);
        }
        long newExpiration = curTime + duration;
        this.registrationByTime.remove(regInfo);
        regInfo.leaseExpiration = newExpiration;
        this.registrationByTime.put(regInfo, regInfo);
        if (newExpiration < this.minExpiration) {
            this.minExpiration = newExpiration;
            this.concurrentObj.waiterNotify(this.leaseExpireThreadSyncObj);
        }
        return newExpiration;
    }

    private void renewLeaseAbs(RegistrationInfo regInfo, Uuid leaseID, long expiration) {
        if (regInfo == null || regInfo.leaseID != leaseID) {
            return;
        }
        this.registrationByTime.remove(regInfo);
        regInfo.leaseExpiration = expiration;
        this.registrationByTime.put(regInfo, regInfo);
    }

    private void renewLeaseAbs(Uuid registrationID, HashMap registrationByID, Uuid leaseID, long expiration) {
        this.renewLeaseAbs((RegistrationInfo)registrationByID.get(registrationID), leaseID, expiration);
    }

    private FiddlerRenewResults renewLeasesDo(Uuid[] registrationIDs, Uuid[] leaseIDs, long[] durations) {
        int i;
        long curTime = System.currentTimeMillis();
        Exception[] exceptions = null;
        for (i = 0; i < registrationIDs.length; ++i) {
            RegistrationInfo regInfo = (RegistrationInfo)this.registrationByID.get(registrationIDs[i]);
            try {
                durations[i] = this.renewLeaseInt(regInfo, leaseIDs[i], durations[i], curTime);
                continue;
            }
            catch (Exception e) {
                durations[i] = -1L;
                exceptions = exceptions == null ? new Exception[]{e} : (Exception[])FiddlerImpl.appendArray(exceptions, e);
            }
        }
        this.addLogRecord(new LeasesRenewedLogObj(registrationIDs, leaseIDs, durations));
        i = registrationIDs.length;
        while (--i >= 0) {
            if (durations[i] < 0L) continue;
            int n = i;
            durations[n] = durations[n] - curTime;
        }
        return new FiddlerRenewResults(durations, exceptions);
    }

    private void renewLeasesAbs(Uuid[] registrationIDs, Uuid[] leaseIDs, long[] expirations) {
        int i = registrationIDs.length;
        while (--i >= 0) {
            long expiration = expirations[i];
            if (expiration < 0L) continue;
            RegistrationInfo regInfo = (RegistrationInfo)this.registrationByID.get(registrationIDs[i]);
            this.renewLeaseAbs(regInfo, leaseIDs[i], expiration);
        }
    }

    private void cancelLeaseDo(RegistrationInfo regInfo, Uuid leaseID) throws UnknownLeaseException, IOException {
        long curTime = System.currentTimeMillis();
        if (regInfo == null || regInfo.leaseExpiration <= curTime) {
            throw new UnknownLeaseException();
        }
        this.removeRegistration(regInfo);
        if (regInfo.leaseExpiration == this.minExpiration) {
            this.concurrentObj.waiterNotify(this.leaseExpireThreadSyncObj);
        }
    }

    private void cancelLeaseDo(Uuid registrationID, HashMap registrationByID, Uuid leaseID) throws UnknownLeaseException, IOException {
        this.cancelLeaseDo((RegistrationInfo)registrationByID.get(registrationID), leaseID);
    }

    private Exception[] cancelLeasesDo(Uuid[] registrationIDs, Uuid[] leaseIDs) {
        Exception[] exceptions = null;
        int i = registrationIDs.length;
        while (--i >= 0) {
            try {
                RegistrationInfo regInfo = (RegistrationInfo)this.registrationByID.get(registrationIDs[i]);
                this.cancelLeaseDo(regInfo, leaseIDs[i]);
            }
            catch (Exception e) {
                if (exceptions == null) {
                    exceptions = new Exception[registrationIDs.length];
                }
                exceptions[i] = e;
            }
        }
        return exceptions;
    }

    private ServiceRegistrar[] intersectRegSets(ServiceRegistrar[] regs0, ServiceRegistrar[] regs1) {
        HashSet<ServiceRegistrar> regSet = new HashSet<ServiceRegistrar>();
        block0: for (int i = 0; i < regs0.length; ++i) {
            for (int j = 0; j < regs1.length; ++j) {
                if (!regs0[i].equals(regs1[j])) continue;
                regSet.add(regs0[i]);
                continue block0;
            }
        }
        return regSet.toArray(new ServiceRegistrar[regSet.size()]);
    }

    private boolean regIsElementOfRegSet(ServiceRegistrar reg, ServiceRegistrar[] regSet) {
        for (int i = 0; i < regSet.length; ++i) {
            if (!regSet[i].equals(reg)) continue;
            return true;
        }
        return false;
    }

    private void maybeSendDiscoveredEvent(RegistrationInfo regInfo, Map regsMap) {
        HashMap<ServiceRegistrar, LocatorGroupsStruct> regsToAdd = new HashMap<ServiceRegistrar, LocatorGroupsStruct>(regsMap.size());
        Set eSet = regsMap.entrySet();
        for (Map.Entry pair : eSet) {
            ServiceRegistrar reg = (ServiceRegistrar)pair.getKey();
            LocatorGroupsStruct curStructVal = (LocatorGroupsStruct)pair.getValue();
            if (regInfo.groups == null) {
                regsToAdd.put(reg, curStructVal);
                continue;
            }
            if (!FiddlerImpl.interested(curStructVal.locator, curStructVal.groups, regInfo.locators, regInfo.groups)) continue;
            regsToAdd.put(reg, curStructVal);
        }
        HashMap regsAdded = regInfo.addToDiscoveredRegs(regsToAdd);
        RemoteDiscoveryEvent event = this.buildEvent(regInfo, regsAdded, false);
        if (event != null) {
            this.queueEvent(regInfo, event);
            this.logInfoEvents("NewReg/Discovered EventTask.run(): DISCOVERED Event was SENT\n");
        }
    }

    private RegistrationInfo externalDiscardRequest() {
        for (RegistrationInfo regInfo : this.registrationByID.values()) {
            if (!regInfo.discardFlag) continue;
            this.logInfoDiscard("\nexternalDiscardRequest: discardFlag == true\n");
            regInfo.discardFlag = false;
            return regInfo;
        }
        return null;
    }

    private HashMap mapRegToGroups(ServiceRegistrar reg, String[] groups) {
        HashMap<ServiceRegistrar, String[]> groupsMap = new HashMap<ServiceRegistrar, String[]>(1);
        groupsMap.put(reg, groups);
        return groupsMap;
    }

    private void maybeRemoveDiscardedRegsFromGlobalSet(Set discardedRegs) {
        Iterator itr = discardedRegs.iterator();
        while (itr.hasNext()) {
            this.maybeRemoveDiscardedRegFromGlobalSet(itr.next());
        }
    }

    private void maybeRemoveDiscardedRegFromGlobalSet(Object dReg) {
        for (RegistrationInfo regInfo : this.registrationByID.values()) {
            if (!regInfo.discoveredRegsMap.containsKey(dReg)) continue;
            return;
        }
        this.allDiscoveredRegs.remove(dReg);
    }

    private void updateGroupsInGlobalSet(Map groupsMap) {
        Set eSet = groupsMap.entrySet();
        for (Map.Entry pair : eSet) {
            ServiceRegistrar reg = (ServiceRegistrar)pair.getKey();
            if (!this.allDiscoveredRegs.containsKey(reg)) continue;
            LookupLocator loc = ((LocatorGroupsStruct)this.allDiscoveredRegs.get((Object)reg)).locator;
            String[] newGroups = (String[])pair.getValue();
            LocatorGroupsStruct locGroups = new LocatorGroupsStruct(loc, newGroups);
            this.allDiscoveredRegs.put(reg, locGroups);
        }
    }

    private RemoteDiscoveryEvent buildEvent(RegistrationInfo regInfo, Map groupsMap, boolean discarded) {
        RemoteDiscoveryEvent newEvent = null;
        if (groupsMap.size() > 0) {
            try {
                newEvent = new RemoteDiscoveryEvent(this.outerProxy, regInfo.eventID, ++regInfo.seqNum, regInfo.handback, discarded, groupsMap);
                this.logInfoEvents(groupsMap, regInfo.eventID, regInfo.seqNum, regInfo.handback, discarded, eventsLogger, Level.FINE);
            }
            catch (IOException e) {
                String eStr = "Failed to serialize ALL registrars during event construction ... could not send event";
                problemLogger.log(Level.INFO, eStr, e);
                Entry[] errorAttrs = new Entry[]{new FiddlerStatus(StatusType.WARNING), new Comment(eStr)};
                this.joinMgr.addAttributes(errorAttrs, true);
            }
        }
        return newEvent;
    }

    private void queueEvent(RegistrationInfo regInfo, RemoteDiscoveryEvent event) {
        this.taskMgr.add(new SendEventTask(regInfo, event));
    }

    private void takeSnapshot(OutputStream out) throws IOException {
        ObjectOutputStream stream = new ObjectOutputStream(out);
        stream.writeUTF(FiddlerImpl.class.getName());
        stream.writeInt(2);
        stream.writeObject(this.proxyID);
        stream.writeLong(this.curEventID);
        stream.writeObject(this.thisServicesGroups);
        stream.writeObject(this.thisServicesLocators);
        stream.writeObject(FiddlerImpl.marshalAttributes(this, this.thisServicesAttrs));
        stream.writeLong(this.leaseBound);
        stream.writeInt(this.snapshotThresh);
        stream.writeFloat(this.snapshotWt);
        Iterator iter2 = this.registrationByID.values().iterator();
        while (iter2.hasNext()) {
            stream.writeObject(iter2.next());
        }
        stream.writeObject(null);
        stream.flush();
    }

    private void recoverSnapshot(InputStream in) throws IOException, ClassNotFoundException {
        RegistrationInfo regInfo;
        ObjectInputStream stream = new ObjectInputStream(in);
        if (!FiddlerImpl.class.getName().equals(stream.readUTF())) {
            throw new IOException("log from wrong implementation");
        }
        if (stream.readInt() != 2) {
            throw new IOException("wrong log format version");
        }
        this.proxyID = (Uuid)stream.readObject();
        this.curEventID = stream.readLong();
        this.thisServicesGroups = (String[])stream.readObject();
        this.thisServicesLocators = FiddlerImpl.prepareOldLocators(recoveredLocatorToJoinPreparer, (LookupLocator[])stream.readObject());
        MarshalledObject[] marshalledAttrs = (MarshalledObject[])stream.readObject();
        this.thisServicesAttrs = FiddlerImpl.unmarshalAttributes(this, marshalledAttrs);
        this.leaseBound = stream.readLong();
        this.snapshotThresh = stream.readInt();
        this.snapshotWt = stream.readFloat();
        while ((regInfo = (RegistrationInfo)stream.readObject()) != null) {
            regInfo.seqNum += Integer.MAX_VALUE;
            this.addRegistration(regInfo);
        }
        this.initialStartup = false;
    }

    private void addLogRecord(LogRecord rec) {
        block4: {
            if (this.log == null) {
                return;
            }
            this.logInfoAddLogRecord(rec);
            try {
                int snapshotSize;
                this.log.update(rec, true);
                if (++this.logFileSize >= this.snapshotThresh && (float)this.logFileSize >= this.snapshotWt * (float)(snapshotSize = this.registrationByID.size())) {
                    this.concurrentObj.waiterNotify(this.snapshotThreadSyncObj);
                }
            }
            catch (Exception e) {
                if (Thread.currentThread().isInterrupted()) break block4;
                String eStr = "Failure while updating the persistent log containing the service state";
                problemLogger.log(Level.INFO, eStr, e);
                Entry[] errorAttrs = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(eStr)};
                this.joinMgr.addAttributes(errorAttrs, true);
            }
        }
    }

    private static String writeArrayElementsToString(Object[] arr) {
        if (arr == null) {
            return new String("[]");
        }
        if (arr.length <= 0) {
            return new String("[]");
        }
        StringBuffer strBuf = new StringBuffer("[" + arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            strBuf.append(", ").append(arr[i]);
        }
        strBuf.append("]");
        return strBuf.toString();
    }

    private static void writeArrayElements(Object[] arr, Logger logger, Level level) {
        if (arr == null || logger == null || !logger.isLoggable(level)) {
            return;
        }
        String writeStr = FiddlerImpl.writeArrayElementsToString(arr);
        logger.log(level, writeStr);
    }

    private static String writeGroupArrayToString(String[] groups) {
        if (groups == null) {
            return new String("[ALL_GROUPS]");
        }
        if (groups.length <= 0) {
            return new String("[]");
        }
        StringBuffer strBuf = null;
        strBuf = groups[0].compareTo("") == 0 ? new StringBuffer("[The PUBLIC Group") : new StringBuffer("[" + groups[0]);
        for (int i = 1; i < groups.length; ++i) {
            if (groups[i].compareTo("") == 0) {
                strBuf.append(", The PUBLIC Group");
                continue;
            }
            strBuf.append(", ").append(groups[i]);
        }
        strBuf.append("]");
        return strBuf.toString();
    }

    private static void writeGroupArray(String[] groups, Logger logger, Level level) {
        if (logger == null || !logger.isLoggable(level)) {
            return;
        }
        String writeStr = FiddlerImpl.writeGroupArrayToString(groups);
        logger.log(level, writeStr);
    }

    private static void writeRegistrarsArray(ServiceRegistrar[] regs, Logger logger, Level level) {
        LookupLocator loc;
        if (regs == null || logger == null || !logger.isLoggable(level)) {
            return;
        }
        if (regs.length == 0) {
            logger.log(level, "[NO REGISTRARS for Event]");
        }
        if (regs.length == 1) {
            try {
                loc = regs[0].getLocator();
                logger.log(level, "[" + loc + "]");
            }
            catch (SecurityException e) {
                logger.log(level, "[SecurityException]");
            }
            catch (Exception e) {
                logger.log(level, "[Exception]");
            }
        }
        if (regs.length > 1) {
            try {
                loc = regs[0].getLocator();
                logger.log(level, "[" + loc + ",");
            }
            catch (SecurityException e) {
                logger.log(level, "[SecurityException,");
            }
            catch (Exception e) {
                logger.log(level, "[Exception,");
            }
            for (int i = 1; i < regs.length - 1; ++i) {
                try {
                    LookupLocator loc2 = regs[i].getLocator();
                    logger.log(level, loc2 + ",");
                    continue;
                }
                catch (SecurityException e) {
                    logger.log(level, "SecurityException,");
                    continue;
                }
                catch (Exception e) {
                    logger.log(level, "Exception,");
                }
            }
            try {
                LookupLocator loc3 = regs[regs.length - 1].getLocator();
                logger.log(level, loc3 + "]");
            }
            catch (SecurityException e) {
                logger.log(level, "SecurityException]");
            }
            catch (Exception e) {
                logger.log(level, "Exception]");
            }
        }
    }

    private static void writeAttribute(Entry attr, Logger logger, Level level) {
        if (attr == null || logger == null || !logger.isLoggable(level)) {
            return;
        }
        if (attr instanceof BasicServiceType) {
            logger.log(level, "  attribute = BasicServiceType");
            logger.log(level, "    Display Name = " + ((BasicServiceType)attr).getDisplayName());
            logger.log(level, "    Description  = " + ((BasicServiceType)attr).getShortDescription());
        } else if (attr instanceof ServiceInfo) {
            logger.log(level, "  attribute = ServiceInfo");
            logger.log(level, "    Service Name         = " + ((ServiceInfo)attr).name);
            logger.log(level, "    Service Manufacturer = " + ((ServiceInfo)attr).manufacturer);
            logger.log(level, "    Service Vendor       = " + ((ServiceInfo)attr).vendor);
            logger.log(level, "    Service Version      = " + ((ServiceInfo)attr).version);
            logger.log(level, "    Service Model        = " + ((ServiceInfo)attr).model);
            logger.log(level, "    Service Serial #     = " + ((ServiceInfo)attr).serialNumber);
        } else {
            logger.log(level, "  attribute = " + attr);
        }
    }

    private static void writeAttributes(Entry[] attrs, Logger logger, Level level) {
        if (attrs == null || logger == null || !logger.isLoggable(level)) {
            return;
        }
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i] == null) continue;
            FiddlerImpl.writeAttribute(attrs[i], logger, level);
        }
        logger.log(level, "");
    }

    private void logInfoStartup() {
        if (startupLogger.isLoggable(Level.INFO)) {
            startupLogger.log(Level.INFO, "Fiddler started: {0}, {1}, {2}", new Object[]{this.serviceID.toString(), FiddlerImpl.writeGroupArrayToString(this.thisServicesGroups), FiddlerImpl.writeArrayElementsToString(this.thisServicesLocators)});
        }
        if (startupLogger.isLoggable(Level.CONFIG)) {
            if (this.persistDir != null) {
                startupLogger.log(Level.CONFIG, " Persistent state directory:  {0}", this.persistDir);
            }
            startupLogger.log(Level.CONFIG, "Attributes to register in each lookup service: ");
            FiddlerImpl.writeAttributes(this.thisServicesAttrs, startupLogger, Level.CONFIG);
        }
    }

    private void logInfoShutdown() {
        if (startupLogger.isLoggable(Level.INFO)) {
            startupLogger.log(Level.INFO, "Fiddler destroyed: {0}, {1}, {2}", new Object[]{this.serviceID.toString(), FiddlerImpl.writeGroupArrayToString(this.thisServicesGroups), FiddlerImpl.writeArrayElementsToString(this.thisServicesLocators)});
        }
    }

    private void logInfoTasks(String str) {
        if (tasksLogger.isLoggable(Level.FINEST)) {
            tasksLogger.log(Level.FINEST, str);
        }
    }

    private void logInfoEvents(String str) {
        if (eventsLogger.isLoggable(Level.FINE)) {
            eventsLogger.log(Level.FINE, str);
        }
    }

    private void logInfoEvents(Map groupsMap, long eventID, long seqNum, MarshalledObject handback, boolean discarded, Logger logger, Level level) {
        if (logger == null || !logger.isLoggable(level)) {
            return;
        }
        String discardedStr = discarded ? "DISCARDED" : "DISCOVERED";
        Object hb = null;
        if (handback != null) {
            try {
                hb = handback.get();
            }
            catch (ClassNotFoundException e) {
                problemLogger.log(Levels.HANDLED, "ClassNotFoundException when unmarshalling handback", e);
            }
            catch (IOException e) {
                problemLogger.log(Levels.HANDLED, "IOException when unmarshalling handback", e);
            }
        }
        logger.log(level, "\n" + discardedStr + " Event:");
        logger.log(level, "  EventID  = " + eventID);
        logger.log(level, "  SeqNum   = " + seqNum);
        logger.log(level, "  handback = " + hb);
        ServiceRegistrar[] regs = groupsMap.keySet().toArray(new ServiceRegistrar[groupsMap.size()]);
        logger.log(level, "  Registrars = ");
        FiddlerImpl.writeRegistrarsArray(regs, logger, level);
        for (int i = 0; i < regs.length; ++i) {
            String[] curGroups = (String[])groupsMap.get(regs[i]);
            logger.log(level, "  member groups [" + i + "] = ");
            FiddlerImpl.writeGroupArray(curGroups, logger, level);
        }
        logger.log(level, "");
    }

    private void logInfoGroups() {
        String[] allGroups = this.discoveryMgr.getGroups();
        if (groupsLogger.isLoggable(Level.FINER)) {
            groupsLogger.log(Level.FINER, "Group(s) over all registrations: ");
            FiddlerImpl.writeGroupArray(allGroups, groupsLogger, Level.FINER);
        }
    }

    private void logInfoGroups(String headerStr) {
        if (headerStr != null && groupsLogger.isLoggable(Level.FINER)) {
            groupsLogger.log(Level.FINER, headerStr);
        }
        this.logInfoGroups();
    }

    private void logInfoLocators() {
        Object[] allLocators = this.discoveryMgr.getLocators();
        if (locatorsLogger.isLoggable(Level.FINER)) {
            locatorsLogger.log(Level.FINER, "Locator(s) over all registrations: ");
            FiddlerImpl.writeArrayElements(allLocators, locatorsLogger, Level.FINER);
        }
    }

    private void logInfoDiscard(String str, Uuid regID) {
        if (str != null && regID != null && discardLogger.isLoggable(Level.FINE)) {
            discardLogger.log(Level.FINE, str + " registrationID = " + regID);
        }
    }

    private void logInfoDiscard(String str) {
        if (discardLogger.isLoggable(Level.FINE)) {
            discardLogger.log(Level.FINE, str);
        }
    }

    private void logInfoLease(String str, Uuid regID, Uuid leaseID) {
        if (str != null && regID != null && leaseLogger.isLoggable(Level.FINER)) {
            leaseLogger.log(Level.FINER, str + " (registrationID,leaseID) = (" + regID + ", " + leaseID + ")");
        }
    }

    private void logInfoRegistration(String str, Object regInfo) {
        if (str != null && regInfo != null && registrationLogger.isLoggable(Level.FINER)) {
            registrationLogger.log(Level.FINER, str + " {0}", regInfo);
        }
    }

    private static void logInfoPersist(String str) {
        if (persistLogger.isLoggable(Level.FINEST)) {
            persistLogger.log(Level.FINEST, str);
        }
    }

    private void logInfoAddLogRecord(LogRecord rec) {
        if (!persistLogger.isLoggable(Level.FINEST)) {
            return;
        }
        String logStr = "Logging a state change: Unknown log record instance";
        if (rec instanceof LookupAttrsAddedLogObj) {
            logStr = "Logging state change: lookup attributes added";
        } else if (rec instanceof LookupAttrsModifiedLogObj) {
            logStr = "Logging state change: lookup attributes modified";
        } else if (rec instanceof LookupGroupsChangedLogObj) {
            logStr = "Logging state change: groups to join changed to " + FiddlerImpl.writeGroupArrayToString(this.thisServicesGroups);
        } else if (rec instanceof LookupLocatorsChangedLogObj) {
            logStr = "Logging state change: locators to join changed to " + FiddlerImpl.writeArrayElementsToString(this.thisServicesLocators);
        } else if (rec instanceof LeaseBoundSetLogObj) {
            logStr = "Logging state change: lease duration bound changed";
        } else if (rec instanceof SnapshotWeightSetLogObj) {
            logStr = "Logging state change: snapshot weight factor changed";
        } else if (rec instanceof SnapshotThresholdSetLogObj) {
            logStr = "Logging state change: log-to-snapshot threshold changed";
        } else if (rec instanceof RegistrationGrantedLogObj) {
            logStr = "Logging state change: new registration granted";
        } else if (rec instanceof GroupsAddedToRegistrationLogObj) {
            logStr = "Logging state change: added new groups to registration's set of groups to discover";
        } else if (rec instanceof GroupsSetInRegistrationLogObj) {
            logStr = "Logging state change: replaced registration's set of groups to discover";
        } else if (rec instanceof GroupsRemovedFromRegistrationLogObj) {
            logStr = "Logging state change: removed groups from registration's set of groups to discover";
        } else if (rec instanceof LocsAddedToRegistrationLogObj) {
            logStr = "Logging state change: added new locators to registration's set of locators to discover";
        } else if (rec instanceof LocsSetInRegistrationLogObj) {
            logStr = "Logging state change: replaced registration's set of locators to discover";
        } else if (rec instanceof LocsRemovedFromRegistrationLogObj) {
            logStr = "Logging state change: removed locators from registration's set of locators to discover";
        } else if (rec instanceof LeaseRenewedLogObj) {
            logStr = "Logging state change: registration's lease renewed";
        } else if (rec instanceof LeasesRenewedLogObj) {
            logStr = "Logging state change: set of leases renewed for a set of registrations";
        } else if (rec instanceof LeaseCancelledLogObj) {
            logStr = "Logging state change: registration's lease cancelled";
        } else if (rec instanceof LeasesCancelledLogObj) {
            logStr = "Logging state change: set of leases cancelled for a set of registrations";
        }
        FiddlerImpl.logInfoPersist(logStr);
    }

    static /* synthetic */ Entry[] access$5202(FiddlerImpl x0, Entry[] x1) {
        x0.thisServicesAttrs = x1;
        return x1;
    }

    static /* synthetic */ String[] access$5302(FiddlerImpl x0, String[] x1) {
        x0.thisServicesGroups = x1;
        return x1;
    }

    static /* synthetic */ LookupLocator[] access$5402(FiddlerImpl x0, LookupLocator[] x1) {
        x0.thisServicesLocators = x1;
        return x1;
    }

    private static class LeasesCancelledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid[] registrationIDs;
        private Uuid[] leaseIDs;

        public LeasesCancelledLogObj(Uuid[] registrationIDs, Uuid[] leaseIDs) {
            this.registrationIDs = registrationIDs;
            this.leaseIDs = leaseIDs;
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply cancelling leases corresponding to " + this.registrationIDs.length + " registration IDs");
            fiddlerImpl.cancelLeasesDo(this.registrationIDs, this.leaseIDs);
        }
    }

    private static class LeaseCancelledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid registrationID;
        private Uuid leaseID;

        public LeaseCancelledLogObj(Uuid registrationID, Uuid leaseID) {
            this.registrationID = registrationID;
            this.leaseID = leaseID;
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            try {
                FiddlerImpl.logInfoPersist("Log recovery: apply cancelling lease for registration\n              (ID = " + this.registrationID + ")");
                fiddlerImpl.cancelLeaseDo(this.registrationID, fiddlerImpl.registrationByID, this.leaseID);
            }
            catch (IOException e) {
                if (problemLogger.isLoggable(Level.SEVERE)) {
                    problemLogger.log(Level.SEVERE, "During log recovery (apply cancelLease) -- failure in multicast request protocol\n", e);
                }
                fiddlerImpl.destroyDo();
            }
            catch (UnknownLeaseException unknownLeaseException) {
                // empty catch block
            }
        }
    }

    private static class LeasesRenewedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid[] registrationIDs;
        private Uuid[] leaseIDs;
        private long[] expirations;

        public LeasesRenewedLogObj(Uuid[] registrationIDs, Uuid[] leaseIDs, long[] expirations) {
            this.registrationIDs = registrationIDs;
            this.leaseIDs = leaseIDs;
            this.expirations = expirations;
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply renewing leases corresponding to " + this.registrationIDs.length + " registration IDs");
            fiddlerImpl.renewLeasesAbs(this.registrationIDs, this.leaseIDs, this.expirations);
        }
    }

    private static class LeaseRenewedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid registrationID;
        private Uuid leaseID;
        private long expiration;

        public LeaseRenewedLogObj(Uuid registrationID, Uuid leaseID, long expiration) {
            this.registrationID = registrationID;
            this.leaseID = leaseID;
            this.expiration = expiration;
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply renewing lease for registration\n              (ID = " + this.registrationID + ")");
            fiddlerImpl.renewLeaseAbs(this.registrationID, fiddlerImpl.registrationByID, this.leaseID, this.expiration);
        }
    }

    private static class LocsRemovedFromRegistrationLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid registrationID;
        private LookupLocator[] locators;

        public LocsRemovedFromRegistrationLogObj(Uuid registrationID, LookupLocator[] locators) {
            this.registrationID = registrationID;
            this.locators = locators;
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply removing from locators to discover for registration\n              (ID = " + this.registrationID + ") ...");
            int nUnprepared = this.locators.length;
            this.locators = FiddlerImpl.prepareOldLocators(recoveredLocatorToDiscoverPreparer, this.locators);
            if (nUnprepared == this.locators.length) {
                fiddlerImpl.removeLocatorsDo(this.registrationID, fiddlerImpl.registrationByID, this.locators);
            } else {
                if (problemLogger.isLoggable(Level.WARNING)) {
                    problemLogger.log(Level.WARNING, "failure preparing locator while recoveringLocsRemovedFromRegistrationLogObj ... removing registration with ID = " + this.registrationID);
                }
                try {
                    fiddlerImpl.removeRegistration((RegistrationInfo)fiddlerImpl.registrationByID.get(this.registrationID));
                }
                catch (IOException e) {
                    String eStr = "failure removing registration (ID = " + this.registrationID + ") after locator preparation failure";
                    if (problemLogger.isLoggable(Level.WARNING)) {
                        problemLogger.log(Level.WARNING, eStr, e);
                    }
                    Entry[] errorAttrs = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(eStr)};
                    fiddlerImpl.joinMgr.addAttributes(errorAttrs, true);
                }
            }
        }
    }

    private static class LocsSetInRegistrationLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid registrationID;
        private LookupLocator[] locators;

        public LocsSetInRegistrationLogObj(Uuid registrationID, LookupLocator[] locators) {
            this.registrationID = registrationID;
            this.locators = locators;
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply replacing locators to discover for registration\n              (ID = " + this.registrationID + ")");
            int nUnprepared = this.locators.length;
            this.locators = FiddlerImpl.prepareOldLocators(recoveredLocatorToDiscoverPreparer, this.locators);
            if (nUnprepared == this.locators.length) {
                fiddlerImpl.setLocatorsDo(this.registrationID, fiddlerImpl.registrationByID, this.locators);
            } else {
                if (problemLogger.isLoggable(Level.WARNING)) {
                    problemLogger.log(Level.WARNING, "failure preparing locator while recovering LocsSetInRegistrationLogObj ... removing registration with ID = " + this.registrationID);
                }
                try {
                    fiddlerImpl.removeRegistration((RegistrationInfo)fiddlerImpl.registrationByID.get(this.registrationID));
                }
                catch (IOException e) {
                    String eStr = "failure removing registration (ID = " + this.registrationID + ") after locator preparation failure";
                    if (problemLogger.isLoggable(Level.WARNING)) {
                        problemLogger.log(Level.WARNING, eStr, e);
                    }
                    Entry[] errorAttrs = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(eStr)};
                    fiddlerImpl.joinMgr.addAttributes(errorAttrs, true);
                }
            }
        }
    }

    private static class LocsAddedToRegistrationLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid registrationID;
        private LookupLocator[] locators;

        public LocsAddedToRegistrationLogObj(Uuid registrationID, LookupLocator[] locators) {
            this.registrationID = registrationID;
            this.locators = locators;
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply adding to locators to discover for registration\n              (ID = " + this.registrationID + ")");
            int nUnprepared = this.locators.length;
            this.locators = FiddlerImpl.prepareOldLocators(recoveredLocatorToDiscoverPreparer, this.locators);
            if (nUnprepared == this.locators.length) {
                fiddlerImpl.addLocatorsDo(this.registrationID, fiddlerImpl.registrationByID, this.locators);
            } else {
                if (problemLogger.isLoggable(Level.WARNING)) {
                    problemLogger.log(Level.WARNING, "failure preparing locator while recovering LocsAddedToRegistrationLogObj ... removing registration with ID = " + this.registrationID);
                }
                try {
                    fiddlerImpl.removeRegistration((RegistrationInfo)fiddlerImpl.registrationByID.get(this.registrationID));
                }
                catch (IOException e) {
                    String eStr = "failure removing registration (ID = " + this.registrationID + ") after locator preparation failure";
                    if (problemLogger.isLoggable(Level.INFO)) {
                        problemLogger.log(Level.INFO, eStr, e);
                    }
                    Entry[] errorAttrs = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(eStr)};
                    fiddlerImpl.joinMgr.addAttributes(errorAttrs, true);
                }
            }
        }
    }

    private static class GroupsRemovedFromRegistrationLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid registrationID;
        private String[] groups;

        public GroupsRemovedFromRegistrationLogObj(Uuid registrationID, String[] groups) {
            this.registrationID = registrationID;
            this.groups = groups;
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply removing from groups to discover for registration\n              (ID = " + this.registrationID + ")");
            try {
                fiddlerImpl.removeGroupsDo(this.registrationID, fiddlerImpl.registrationByID, this.groups);
            }
            catch (Exception e) {
                if (problemLogger.isLoggable(Level.SEVERE)) {
                    problemLogger.log(Level.SEVERE, "Failure during log recovery (apply removeGroups) -- \n", e);
                }
                fiddlerImpl.destroyDo();
            }
        }
    }

    private static class GroupsSetInRegistrationLogObj
    implements LogRecord {
        static final long serialVersionUID = 2L;
        private Uuid registrationID;
        private String[] groups;

        public GroupsSetInRegistrationLogObj(Uuid registrationID, String[] groups) {
            this.registrationID = registrationID;
            this.groups = groups;
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply replacing groups to discover for registration\n              (ID = " + this.registrationID + ") ...");
            try {
                fiddlerImpl.setGroupsDo(this.registrationID, fiddlerImpl.registrationByID, this.groups);
            }
            catch (Exception e) {
                if (problemLogger.isLoggable(Level.SEVERE)) {
                    problemLogger.log(Level.SEVERE, "Failure during log recovery (apply setGroups) -- \n", e);
                }
                fiddlerImpl.destroyDo();
            }
        }
    }

    private static class GroupsAddedToRegistrationLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid registrationID;
        private String[] groups;

        public GroupsAddedToRegistrationLogObj(Uuid registrationID, String[] groups) {
            this.registrationID = registrationID;
            this.groups = groups;
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply adding to groups to discover for registration\n              (ID = " + this.registrationID + ")");
            try {
                fiddlerImpl.addGroupsDo(this.registrationID, fiddlerImpl.registrationByID, this.groups);
            }
            catch (Exception e) {
                if (problemLogger.isLoggable(Level.SEVERE)) {
                    problemLogger.log(Level.SEVERE, "During log recovery (apply addGroupsDO) -- failure in multicast request protocol\n", e);
                }
                fiddlerImpl.destroyDo();
            }
        }
    }

    private static class RegistrationGrantedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 3983963008572188308L;
        private RegistrationInfo regInfo;

        public RegistrationGrantedLogObj(RegistrationInfo regInfo) {
            this.regInfo = regInfo;
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply recording granted registration info\n              (ID = " + this.regInfo.registrationID + ")");
            this.regInfo.seqNum += Integer.MAX_VALUE;
            try {
                fiddlerImpl.addRegistration(this.regInfo);
            }
            catch (IOException e) {
                if (problemLogger.isLoggable(Level.SEVERE)) {
                    problemLogger.log(Level.SEVERE, "During log recovery (apply addRegistration) -- failure in multicast request protocol\n", e);
                }
                fiddlerImpl.destroyDo();
            }
            fiddlerImpl.curEventID++;
        }
    }

    private static class SnapshotThresholdSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2952948867001823559L;
        private int newThreshold;

        public SnapshotThresholdSetLogObj(int newThreshold) {
            this.newThreshold = newThreshold;
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply changing log-to-snapshot threshold");
            fiddlerImpl.snapshotThresh = this.newThreshold;
        }
    }

    private static class SnapshotWeightSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = -4079318959709953285L;
        private float newWeight;

        public SnapshotWeightSetLogObj(float newWeight) {
            this.newWeight = newWeight;
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply changing snapshot weight factor");
            fiddlerImpl.snapshotWt = this.newWeight;
        }
    }

    private static class LeaseBoundSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = 6084059678114714281L;
        private long newLeaseBound;

        public LeaseBoundSetLogObj(long newLeaseBound) {
            this.newLeaseBound = newLeaseBound;
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply changing lease duration bound");
            fiddlerImpl.leaseBound = this.newLeaseBound;
        }
    }

    private static class LookupLocatorsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 6448427261140043291L;
        private LookupLocator[] locators;

        public LookupLocatorsChangedLogObj(LookupLocator[] locators) {
            this.locators = locators;
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply changing lookup locators to join");
            FiddlerImpl.access$5402(fiddlerImpl, FiddlerImpl.prepareOldLocators(recoveredLocatorToJoinPreparer, this.locators));
        }
    }

    private static class LookupGroupsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = -6973676200404539919L;
        private String[] groups;

        public LookupGroupsChangedLogObj(String[] groups) {
            this.groups = groups;
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply changing lookup groups to join");
            FiddlerImpl.access$5302(fiddlerImpl, this.groups);
        }
    }

    private static class LookupAttrsModifiedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2671139518188470469L;
        private MarshalledObject[] marshalledAttrTmpls;
        private MarshalledObject[] marshalledModAttrs;

        public LookupAttrsModifiedLogObj(FiddlerImpl fiddlerImpl, Entry[] attrTmpls, Entry[] modAttrs) {
            this.marshalledAttrTmpls = FiddlerImpl.marshalAttributes(fiddlerImpl, attrTmpls);
            this.marshalledModAttrs = FiddlerImpl.marshalAttributes(fiddlerImpl, modAttrs);
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply modifying lookup attributes");
            Entry[] attrTmpls = FiddlerImpl.unmarshalAttributes(fiddlerImpl, this.marshalledAttrTmpls);
            Entry[] modAttrs = FiddlerImpl.unmarshalAttributes(fiddlerImpl, this.marshalledModAttrs);
            FiddlerImpl.access$5202(fiddlerImpl, LookupAttributes.modify(fiddlerImpl.thisServicesAttrs, attrTmpls, modAttrs));
        }
    }

    private static class LookupAttrsAddedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 4983778026976938585L;
        private MarshalledObject[] marshalledAttrs;

        public LookupAttrsAddedLogObj(FiddlerImpl fiddlerImpl, Entry[] attrs) {
            this.marshalledAttrs = FiddlerImpl.marshalAttributes(fiddlerImpl, attrs);
        }

        @Override
        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply adding lookup attributes");
            Entry[] attrs = FiddlerImpl.unmarshalAttributes(fiddlerImpl, this.marshalledAttrs);
            FiddlerImpl.access$5202(fiddlerImpl, LookupAttributes.add(fiddlerImpl.thisServicesAttrs, attrs));
        }
    }

    private static interface LogRecord
    extends Serializable {
        public void apply(FiddlerImpl var1);
    }

    private class DestroyThread
    extends InterruptedStatusThread {
        private static final long MAX_UNEXPORT_DELAY = 120000L;

        public DestroyThread() {
            super("destroy");
            this.setDaemon(false);
        }

        @Override
        public void run() {
            if (FiddlerImpl.this.activationID != null) {
                try {
                    FiddlerImpl.this.activationSystem.unregisterObject(FiddlerImpl.this.activationID);
                }
                catch (RemoteException e) {
                    problemLogger.log(Level.WARNING, "aborting shutdown - could not unregister activation ID", e);
                    return;
                }
                catch (ActivationException e) {
                    problemLogger.log(Levels.HANDLED, "shutdown problem - could not unregister activation ID", e);
                }
            }
            FiddlerImpl.this.readyState.shutdown();
            long endTime = System.currentTimeMillis() + 120000L;
            boolean unexported = false;
            boolean interrupted = false;
            while (!unexported && System.currentTimeMillis() < endTime) {
                unexported = FiddlerImpl.this.serverExporter.unexport(false);
                if (unexported) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (!unexported) {
                FiddlerImpl.this.serverExporter.unexport(true);
            }
            FiddlerImpl.this.leaseExpireThread.interrupt();
            if (FiddlerImpl.this.log != null) {
                FiddlerImpl.this.snapshotThread.interrupt();
            }
            FiddlerImpl.this.taskMgr.terminate();
            FiddlerImpl.this.joinMgr.terminate();
            FiddlerImpl.this.joinMgrLDM.terminate();
            FiddlerImpl.this.discoveryMgr.terminate();
            try {
                FiddlerImpl.this.leaseExpireThread.join();
                if (FiddlerImpl.this.log != null) {
                    FiddlerImpl.this.snapshotThread.join();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (FiddlerImpl.this.log != null) {
                FiddlerImpl.this.log.deletePersistentStore();
            }
            if (FiddlerImpl.this.activationID != null) {
                try {
                    ActivationGroup.inactive(FiddlerImpl.this.activationID, FiddlerImpl.this.serverExporter);
                }
                catch (RemoteException e) {
                }
                catch (ActivationException e) {}
            } else if (FiddlerImpl.this.lifeCycle != null) {
                FiddlerImpl.this.lifeCycle.unregister(FiddlerImpl.this);
            }
            if (FiddlerImpl.this.loginContext != null) {
                try {
                    FiddlerImpl.this.loginContext.logout();
                }
                catch (Exception e) {
                    startupLogger.log(Level.INFO, "Problem logging out of JAAS login session", e);
                }
            }
            FiddlerImpl.this.logInfoShutdown();
        }
    }

    private class SnapshotThread
    extends InterruptedStatusThread {
        public SnapshotThread() {
            super("snapshot thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: {
                try {
                    FiddlerImpl.this.concurrentObj.readLock();
                }
                catch (ReadersWriter.ConcurrentLockException e) {
                    return;
                }
                while (true) {
                    if (this.hasBeenInterrupted()) break block13;
                    FiddlerImpl.this.concurrentObj.readerWait(FiddlerImpl.this.snapshotThreadSyncObj, Long.MAX_VALUE);
                    try {
                        FiddlerImpl.this.log.snapshot();
                        FiddlerImpl.this.logFileSize = 0;
                    }
                    catch (Exception e) {
                        if (this.hasBeenInterrupted()) {
                            FiddlerImpl.this.concurrentObj.readUnlock();
                            return;
                        }
                        try {
                            String eStr = "Failure while taking a snapshot of the service state";
                            problemLogger.log(Level.INFO, eStr, e);
                            Entry[] errorAttrs = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(eStr)};
                            FiddlerImpl.this.joinMgr.addAttributes(errorAttrs, true);
                        }
                        catch (ReadersWriter.ConcurrentLockException e2) {
                            FiddlerImpl.this.concurrentObj.readUnlock();
                            return;
                        }
                    }
                }
                finally {
                    FiddlerImpl.this.concurrentObj.readUnlock();
                }
            }
        }
    }

    private class LeaseExpireThread
    extends InterruptedStatusThread {
        public LeaseExpireThread() {
            super("lease expire");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                FiddlerImpl.this.concurrentObj.writeLock();
            }
            catch (ReadersWriter.ConcurrentLockException e) {
                return;
            }
            try {
                while (!this.hasBeenInterrupted()) {
                    long curTime = System.currentTimeMillis();
                    FiddlerImpl.this.minExpiration = Long.MAX_VALUE;
                    while (!FiddlerImpl.this.registrationByTime.isEmpty()) {
                        RegistrationInfo regInfo = (RegistrationInfo)FiddlerImpl.this.registrationByTime.firstKey();
                        if (regInfo.leaseExpiration > curTime) {
                            FiddlerImpl.this.minExpiration = regInfo.leaseExpiration;
                            break;
                        }
                        try {
                            FiddlerImpl.this.removeRegistration(regInfo);
                        }
                        catch (IOException e) {
                            String eStr = "Failure while removing registration (ID = " + regInfo.registrationID + ") from service state";
                            if (problemLogger.isLoggable(Level.INFO)) {
                                problemLogger.log(Level.INFO, eStr, e);
                            }
                            Entry[] errorAttrs = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(eStr)};
                            FiddlerImpl.this.joinMgr.addAttributes(errorAttrs, true);
                        }
                    }
                    try {
                        FiddlerImpl.this.concurrentObj.writerWait(FiddlerImpl.this.leaseExpireThreadSyncObj, FiddlerImpl.this.minExpiration - curTime);
                    }
                    catch (ReadersWriter.ConcurrentLockException e) {
                        FiddlerImpl.this.concurrentObj.writeUnlock();
                        return;
                    }
                }
            }
            finally {
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
        }
    }

    private class LocalLogHandler
    extends LogHandler {
        @Override
        public void snapshot(OutputStream out) throws IOException {
            FiddlerImpl.this.takeSnapshot(out);
        }

        @Override
        public void recover(InputStream in) throws IOException, ClassNotFoundException {
            FiddlerImpl.this.recoverSnapshot(in);
        }

        @Override
        public void applyUpdate(Object logRecObj) {
            ((LogRecord)logRecObj).apply(FiddlerImpl.this);
        }
    }

    private final class SendEventTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;
        public final RemoteDiscoveryEvent event;

        public SendEventTask(RegistrationInfo regInfo, RemoteDiscoveryEvent event) {
            this.regInfo = regInfo;
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.regInfo.listener.notify(this.event);
            }
            catch (Throwable e) {
                problemLogger.log(Level.INFO, "Exception in SendEventTask", e);
                switch (ThrowableConstants.retryable(e)) {
                    case 2: {
                        if (e instanceof Error) {
                            throw (Error)e;
                        }
                    }
                    case 1: 
                    case 3: {
                        FiddlerImpl.this.concurrentObj.writeLock();
                        try {
                            try {
                                FiddlerImpl.this.logInfoEvents("  Cancelling lease on registration:  (registrationID,leaseID) = (" + this.regInfo.registrationID + ", " + this.regInfo.leaseID + ")");
                                FiddlerImpl.this.cancelLeaseDo(this.regInfo, this.regInfo.leaseID);
                                FiddlerImpl.this.addLogRecord(new LeaseCancelledLogObj(this.regInfo.registrationID, this.regInfo.leaseID));
                            }
                            catch (UnknownLeaseException ee) {
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            break;
                        }
                        finally {
                            FiddlerImpl.this.concurrentObj.writeUnlock();
                        }
                    }
                }
            }
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private final class RemoveLocatorsTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;
        public final LookupLocator[] locators;

        public RemoveLocatorsTask(RegistrationInfo regInfo, LookupLocator[] locators) {
            this.regInfo = regInfo;
            this.locators = locators;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            try {
                if (this.locators.length == 0) {
                    return;
                }
                FiddlerImpl.this.logInfoTasks("RemoveLocatorsTask.run(): removing locators from the registration's current locator set");
                HashMap oldDesiredRegs = FiddlerImpl.this.getDesiredRegsByLocator(this.regInfo);
                this.removeRegInfoLocators(this.regInfo, this.locators);
                Map undesiredRegs = FiddlerImpl.getUndesiredRegsByLocator(oldDesiredRegs, this.regInfo);
                HashMap<ServiceRegistrar, String[]> discardRegs = new HashMap<ServiceRegistrar, String[]>(undesiredRegs.size());
                for (ServiceRegistrar reg : undesiredRegs.keySet()) {
                    this.regInfo.discoveredRegsMap.remove(reg);
                    discardRegs.put(reg, ((LocatorGroupsStruct)((FiddlerImpl)FiddlerImpl.this).allDiscoveredRegs.get((Object)reg)).groups);
                }
                RemoteDiscoveryEvent event = FiddlerImpl.this.buildEvent(this.regInfo, discardRegs, true);
                if (event != null) {
                    FiddlerImpl.this.queueEvent(this.regInfo, event);
                    FiddlerImpl.this.logInfoEvents("SetLocatorsTask.run(): DISCARDED Event was SENT\n");
                }
                FiddlerImpl.this.updateDiscoveryMgrLocators();
            }
            finally {
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
        }

        private void removeRegInfoLocators(RegistrationInfo regInfo, LookupLocator[] locators) {
            HashSet<LookupLocator> removeSet = new HashSet<LookupLocator>();
            for (int i = 0; i < locators.length; ++i) {
                removeSet.add(locators[i]);
            }
            regInfo.locators.removeAll(removeSet);
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private final class SetLocatorsTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;
        public final LookupLocator[] locators;

        public SetLocatorsTask(RegistrationInfo regInfo, LookupLocator[] locators) {
            this.regInfo = regInfo;
            this.locators = locators;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            try {
                FiddlerImpl.this.logInfoTasks("SetLocatorsTask.run(): setting the registration's locators");
                HashMap oldDesiredRegs = FiddlerImpl.this.getDesiredRegsByLocator(this.regInfo);
                this.setRegInfoLocators(this.regInfo, this.locators);
                HashMap newDesiredRegs = FiddlerImpl.this.getDesiredRegsByLocator(this.regInfo);
                HashMap regsAdded = this.regInfo.addToDiscoveredRegs(newDesiredRegs);
                RemoteDiscoveryEvent event = FiddlerImpl.this.buildEvent(this.regInfo, regsAdded, false);
                if (event != null) {
                    FiddlerImpl.this.queueEvent(this.regInfo, event);
                    FiddlerImpl.this.logInfoEvents("SetLocatorsTask.run(): DISCOVERED Event was SENT\n");
                }
                Map undesiredRegs = FiddlerImpl.getUndesiredRegsByLocator(oldDesiredRegs, this.regInfo);
                HashMap<ServiceRegistrar, String[]> discardRegs = new HashMap<ServiceRegistrar, String[]>(undesiredRegs.size());
                for (ServiceRegistrar reg : undesiredRegs.keySet()) {
                    this.regInfo.discoveredRegsMap.remove(reg);
                    discardRegs.put(reg, ((LocatorGroupsStruct)((FiddlerImpl)FiddlerImpl.this).allDiscoveredRegs.get((Object)reg)).groups);
                }
                event = FiddlerImpl.this.buildEvent(this.regInfo, discardRegs, true);
                if (event != null) {
                    FiddlerImpl.this.queueEvent(this.regInfo, event);
                    FiddlerImpl.this.logInfoEvents("SetLocatorsTask.run(): DISCARDED Event was SENT\n");
                }
                FiddlerImpl.this.updateDiscoveryMgrLocators();
            }
            finally {
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
        }

        private void setRegInfoLocators(RegistrationInfo regInfo, LookupLocator[] locators) {
            HashSet<LookupLocator> newLocSet = new HashSet<LookupLocator>();
            for (int i = 0; i < locators.length; ++i) {
                newLocSet.add(locators[i]);
            }
            if (regInfo.locators == null) {
                regInfo.locators = new HashSet();
            } else {
                regInfo.locators.clear();
            }
            regInfo.locators.addAll(newLocSet);
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private final class AddLocatorsTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;
        public final LookupLocator[] locators;

        public AddLocatorsTask(RegistrationInfo regInfo, LookupLocator[] locators) {
            this.regInfo = regInfo;
            this.locators = locators;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            try {
                HashSet newLocSet = this.addRegInfoLocators(this.regInfo, this.locators);
                if (newLocSet.size() > 0) {
                    FiddlerImpl.this.logInfoTasks("AddLocatorsTask.run(): adding to the registration's locators");
                    HashMap discoveredRegs = FiddlerImpl.this.getDesiredRegsByLocator(this.regInfo);
                    HashMap regsAdded = this.regInfo.addToDiscoveredRegs(discoveredRegs);
                    RemoteDiscoveryEvent event = FiddlerImpl.this.buildEvent(this.regInfo, regsAdded, false);
                    if (event != null) {
                        FiddlerImpl.this.queueEvent(this.regInfo, event);
                        FiddlerImpl.this.logInfoEvents("AddLocatorsTask.run(): DISCOVERED Event was SENT\n");
                    }
                    FiddlerImpl.this.updateDiscoveryMgrLocators();
                }
            }
            finally {
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
        }

        private HashSet addRegInfoLocators(RegistrationInfo regInfo, LookupLocator[] locators) {
            HashSet<LookupLocator> newLocSet = new HashSet<LookupLocator>(1);
            for (int i = 0; i < locators.length; ++i) {
                newLocSet.add(locators[i]);
            }
            if (newLocSet.size() > 0) {
                regInfo.locators.addAll(newLocSet);
            }
            return newLocSet;
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private final class RemoveGroupsTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;
        public final String[] groups;

        public RemoveGroupsTask(RegistrationInfo regInfo, String[] groups) {
            this.regInfo = regInfo;
            this.groups = groups;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            try {
                if (this.groups.length == 0) {
                    return;
                }
                FiddlerImpl.this.logInfoTasks("RemoveGroupsTask.run(): removing groups from the registration's current group set");
                HashMap oldDesiredRegs = FiddlerImpl.this.getDesiredRegsByGroup(this.regInfo);
                this.removeRegInfoGroups(this.regInfo, this.groups);
                HashMap discardRegs = FiddlerImpl.getUndesiredRegsByGroup(oldDesiredRegs, this.regInfo);
                Iterator itr = discardRegs.keySet().iterator();
                while (itr.hasNext()) {
                    this.regInfo.discoveredRegsMap.remove(itr.next());
                }
                RemoteDiscoveryEvent event = FiddlerImpl.this.buildEvent(this.regInfo, discardRegs, true);
                if (event != null) {
                    FiddlerImpl.this.queueEvent(this.regInfo, event);
                    FiddlerImpl.this.logInfoEvents("RemoveGroupsTask.run(): DISCARDED Event was SENT\n");
                }
                FiddlerImpl.this.updateDiscoveryMgrGroups();
            }
            finally {
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
        }

        private void removeRegInfoGroups(RegistrationInfo regInfo, String[] groups) {
            HashSet<String> removeSet = new HashSet<String>();
            for (int i = 0; i < groups.length; ++i) {
                removeSet.add(groups[i]);
            }
            regInfo.groups.removeAll(removeSet);
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private final class SetGroupsTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;
        public final String[] groups;

        public SetGroupsTask(RegistrationInfo regInfo, String[] groups) {
            this.regInfo = regInfo;
            this.groups = groups;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            try {
                FiddlerImpl.this.logInfoTasks("SetGroupsTask.run(): setting the registration's groups");
                HashMap oldDesiredRegs = FiddlerImpl.this.getDesiredRegsByGroup(this.regInfo);
                this.setRegInfoGroups(this.regInfo, this.groups);
                HashMap newDesiredRegs = FiddlerImpl.this.getDesiredRegsByGroup(this.regInfo);
                HashMap regsAdded = this.regInfo.addToDiscoveredRegs(newDesiredRegs);
                RemoteDiscoveryEvent event = FiddlerImpl.this.buildEvent(this.regInfo, regsAdded, false);
                if (event != null) {
                    FiddlerImpl.this.queueEvent(this.regInfo, event);
                    FiddlerImpl.this.logInfoEvents("SetGroupsTask.run(): DISCOVERED Event was SENT\n");
                }
                HashMap discardRegs = FiddlerImpl.getUndesiredRegsByGroup(oldDesiredRegs, this.regInfo);
                Iterator itr = discardRegs.keySet().iterator();
                while (itr.hasNext()) {
                    this.regInfo.discoveredRegsMap.remove(itr.next());
                }
                event = FiddlerImpl.this.buildEvent(this.regInfo, discardRegs, true);
                if (event != null) {
                    FiddlerImpl.this.queueEvent(this.regInfo, event);
                    FiddlerImpl.this.logInfoEvents("SetGroupsTask.run(): DISCARDED Event was SENT\n");
                }
                FiddlerImpl.this.updateDiscoveryMgrGroups();
            }
            finally {
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
        }

        private void setRegInfoGroups(RegistrationInfo regInfo, String[] groups) {
            if (groups == DiscoveryGroupManagement.ALL_GROUPS) {
                regInfo.groups = null;
            } else {
                HashSet<String> newGroups = new HashSet<String>();
                for (int i = 0; i < groups.length; ++i) {
                    newGroups.add(groups[i]);
                }
                if (regInfo.groups == null) {
                    regInfo.groups = new HashSet();
                } else {
                    regInfo.groups.clear();
                }
                regInfo.groups.addAll(newGroups);
            }
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private final class AddGroupsTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;
        public final String[] groups;

        public AddGroupsTask(RegistrationInfo regInfo, String[] groups) {
            this.regInfo = regInfo;
            this.groups = groups;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            try {
                HashSet newGroupSet = this.addRegInfoGroups(this.regInfo, this.groups);
                if (newGroupSet.size() > 0) {
                    FiddlerImpl.this.logInfoTasks("AddGroupsTask.run(): adding to the registration's groups");
                    HashMap discoveredRegs = FiddlerImpl.this.getDesiredRegsByGroup(this.regInfo);
                    HashMap regsAdded = this.regInfo.addToDiscoveredRegs(discoveredRegs);
                    RemoteDiscoveryEvent event = FiddlerImpl.this.buildEvent(this.regInfo, regsAdded, false);
                    if (event != null) {
                        FiddlerImpl.this.queueEvent(this.regInfo, event);
                        FiddlerImpl.this.logInfoEvents("AddGroupsTask.run(): DISCOVERED Event was SENT\n");
                    }
                    FiddlerImpl.this.updateDiscoveryMgrGroups();
                }
            }
            finally {
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
        }

        private HashSet addRegInfoGroups(RegistrationInfo regInfo, String[] groups) {
            HashSet<String> newGroupSet = new HashSet<String>(1);
            for (int i = 0; i < groups.length; ++i) {
                newGroupSet.add(groups[i]);
            }
            if (newGroupSet.size() > 0) {
                regInfo.groups.addAll(newGroupSet);
            }
            return newGroupSet;
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private final class ChangedEventTask
    implements TaskManager.Task {
        public final DiscoveryEvent event;

        public ChangedEventTask(DiscoveryEvent event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            FiddlerImpl.this.logInfoTasks("ChangedEventTask.run(): processing CHANGED event from discovery manager");
            try {
                Map groupsMap = this.event.getGroups();
                HashSet allDiscardedRegs = new HashSet(groupsMap.size());
                HashMap<ServiceRegistrar, LookupLocator> locatorMap = new HashMap<ServiceRegistrar, LookupLocator>(groupsMap.size());
                for (ServiceRegistrar reg : groupsMap.keySet()) {
                    locatorMap.put(reg, ((LocatorGroupsStruct)((FiddlerImpl)FiddlerImpl.this).allDiscoveredRegs.get((Object)reg)).locator);
                }
                for (RegistrationInfo regInfo : FiddlerImpl.this.registrationByID.values()) {
                    HashSet discardedRegs = this.maybeSendDiscardedEvent(regInfo, groupsMap, locatorMap);
                    Iterator jtr = discardedRegs.iterator();
                    while (jtr.hasNext()) {
                        allDiscardedRegs.add(jtr.next());
                    }
                }
                FiddlerImpl.this.maybeRemoveDiscardedRegsFromGlobalSet(allDiscardedRegs);
                FiddlerImpl.this.updateGroupsInGlobalSet(groupsMap);
            }
            finally {
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
        }

        private HashSet maybeSendDiscardedEvent(RegistrationInfo regInfo, Map groupsMap, Map locatorMap) {
            HashSet<ServiceRegistrar> discardedRegs = new HashSet<ServiceRegistrar>(groupsMap.size());
            if (regInfo.groups != null && regInfo.groups.size() == 0) {
                return discardedRegs;
            }
            HashMap<ServiceRegistrar, String[]> discardMap = new HashMap<ServiceRegistrar, String[]>(groupsMap.size());
            Set eSet = groupsMap.entrySet();
            for (Map.Entry pair : eSet) {
                ServiceRegistrar reg = (ServiceRegistrar)pair.getKey();
                String[] regGroups = (String[])pair.getValue();
                LookupLocator regLoc = (LookupLocator)locatorMap.get(reg);
                if (!regInfo.discoveredRegsMap.containsKey(reg) || FiddlerImpl.interested(regLoc, regGroups, regInfo.locators, regInfo.groups)) continue;
                discardMap.put(reg, regGroups);
                discardedRegs.add(reg);
                regInfo.discoveredRegsMap.remove(reg);
            }
            RemoteDiscoveryEvent event = FiddlerImpl.this.buildEvent(regInfo, discardMap, true);
            if (event != null) {
                FiddlerImpl.this.queueEvent(regInfo, event);
                FiddlerImpl.this.logInfoEvents("ChangedEventTask.run(): DISCARDED Event was SENT\n");
            }
            return discardedRegs;
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private final class DiscardRegistrarTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;
        public final ServiceRegistrar registrar;

        public DiscardRegistrarTask(RegistrationInfo regInfo, ServiceRegistrar registrar) {
            this.regInfo = regInfo;
            this.registrar = registrar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            try {
                FiddlerImpl.this.logInfoTasks("DiscardRegistrarTask.run(): registrar requested to be discarded");
                if (this.regInfo.discoveredRegsMap.remove(this.registrar) != null) {
                    HashMap groupsMap = FiddlerImpl.this.mapRegToGroups(this.registrar, ((LocatorGroupsStruct)((FiddlerImpl)FiddlerImpl.this).allDiscoveredRegs.get((Object)this.registrar)).groups);
                    RemoteDiscoveryEvent event = FiddlerImpl.this.buildEvent(this.regInfo, groupsMap, true);
                    if (event != null) {
                        FiddlerImpl.this.queueEvent(this.regInfo, event);
                        FiddlerImpl.this.logInfoEvents("DiscardRegistrarTask.run(): DISCARDED Event was SENT\n");
                    }
                    FiddlerImpl.this.maybeRemoveDiscardedRegFromGlobalSet(this.registrar);
                }
            }
            finally {
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private final class DiscardedEventTask
    implements TaskManager.Task {
        public final DiscoveryEvent event;

        public DiscardedEventTask(DiscoveryEvent event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            FiddlerImpl.this.logInfoTasks("DiscardedEventTask.run(): processing DISCARDED event from discovery manager");
            try {
                Map groupsMap = this.event.getGroups();
                HashSet allDiscardedRegs = new HashSet(groupsMap.size());
                RegistrationInfo regInfo2 = FiddlerImpl.this.externalDiscardRequest();
                if (regInfo2 != null) {
                    HashSet discardedRegs = this.maybeSendDiscardedEvent(regInfo2, groupsMap, true);
                    Iterator jtr = discardedRegs.iterator();
                    while (jtr.hasNext()) {
                        allDiscardedRegs.add(jtr.next());
                    }
                } else {
                    for (RegistrationInfo regInfo2 : FiddlerImpl.this.registrationByID.values()) {
                        HashSet discardedRegs = this.maybeSendDiscardedEvent(regInfo2, groupsMap, false);
                        Iterator jtr = discardedRegs.iterator();
                        while (jtr.hasNext()) {
                            allDiscardedRegs.add(jtr.next());
                        }
                    }
                }
                FiddlerImpl.this.maybeRemoveDiscardedRegsFromGlobalSet(allDiscardedRegs);
            }
            finally {
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
        }

        private HashSet maybeSendDiscardedEvent(RegistrationInfo regInfo, Map groupsMap, boolean active) {
            HashSet<ServiceRegistrar> discardedRegs = new HashSet<ServiceRegistrar>(groupsMap.size());
            if (regInfo.groups != null && regInfo.groups.size() == 0 && regInfo.locators.size() == 0) {
                return discardedRegs;
            }
            HashMap<ServiceRegistrar, String[]> discardMap = new HashMap<ServiceRegistrar, String[]>(groupsMap.size());
            Set eSet = groupsMap.entrySet();
            for (Map.Entry pair : eSet) {
                String[] regGroups;
                ServiceRegistrar reg = (ServiceRegistrar)pair.getKey();
                if (!regInfo.discoveredRegsMap.containsKey(reg)) continue;
                String[] stringArray = regGroups = active ? (String[])pair.getValue() : ((LocatorGroupsStruct)((FiddlerImpl)FiddlerImpl.this).allDiscoveredRegs.get((Object)reg)).groups;
                if (!active && !FiddlerImpl.interested(regGroups, regInfo.groups)) continue;
                discardMap.put(reg, regGroups);
                discardedRegs.add(reg);
                regInfo.discoveredRegsMap.remove(reg);
            }
            RemoteDiscoveryEvent event = FiddlerImpl.this.buildEvent(regInfo, discardMap, true);
            if (event != null) {
                FiddlerImpl.this.queueEvent(regInfo, event);
                FiddlerImpl.this.logInfoEvents("DiscardedEventTask.run(): DISCARDED Event SENT to regInfo\n");
            }
            return discardedRegs;
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private final class DiscoveredEventTask
    implements TaskManager.Task {
        public final DiscoveryEvent event;

        public DiscoveredEventTask(DiscoveryEvent event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map groupsMap = this.event.getGroups();
            ServiceRegistrar[] regs = this.event.getRegistrars();
            HashMap<ServiceRegistrar, LocatorGroupsStruct> regMap = new HashMap<ServiceRegistrar, LocatorGroupsStruct>(regs.length);
            for (int i = 0; i < regs.length; ++i) {
                try {
                    LookupLocator regLoc = regs[i].getLocator();
                    String[] regGroups = (String[])groupsMap.get(regs[i]);
                    LocatorGroupsStruct regLocGroups = new LocatorGroupsStruct(regLoc, regGroups);
                    regMap.put(regs[i], regLocGroups);
                    continue;
                }
                catch (Exception e) {
                    problemLogger.log(Levels.FAILED, "problem retrieving locator from discovered lookup service ... discarded the lookup service", e);
                    FiddlerImpl.this.discoveryMgr.discard(regs[i]);
                }
            }
            FiddlerImpl.this.concurrentObj.writeLock();
            FiddlerImpl.this.logInfoTasks("DiscoveredEventTask.run(): processing DISCOVERED event from discovery manager");
            try {
                Set eSet = regMap.entrySet();
                for (Map.Entry pair : eSet) {
                    FiddlerImpl.this.allDiscoveredRegs.put(pair.getKey(), pair.getValue());
                }
                for (RegistrationInfo regInfo : FiddlerImpl.this.registrationByID.values()) {
                    FiddlerImpl.this.maybeSendDiscoveredEvent(regInfo, regMap);
                }
            }
            finally {
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private final class NewRegistrationTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;

        public NewRegistrationTask(RegistrationInfo regInfo) {
            this.regInfo = regInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            try {
                FiddlerImpl.this.logInfoTasks("NewRegistrationTask.run(): new Registration added");
                FiddlerImpl.this.maybeSendDiscoveredEvent(this.regInfo, FiddlerImpl.this.allDiscoveredRegs);
            }
            finally {
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private static final class RegistrationInfo
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 2L;
        public final Uuid registrationID;
        public HashMap discoveredRegsMap;
        public HashSet groups;
        public HashSet locators;
        public final Uuid leaseID;
        public long leaseExpiration;
        public long eventID;
        public long seqNum;
        public final MarshalledObject handback;
        public boolean discardFlag;
        public transient RemoteEventListener listener;

        public RegistrationInfo(Uuid registrationID, String[] groups, LookupLocator[] locators, Uuid leaseID, long leaseExpiration, long eventID, MarshalledObject handback, RemoteEventListener listener) {
            int i;
            this.registrationID = registrationID;
            if (groups != null) {
                this.groups = new HashSet();
                for (i = 0; i < groups.length; ++i) {
                    if (groups[i] == null) continue;
                    this.groups.add(groups[i]);
                }
            }
            this.locators = new HashSet();
            if (locators != null && locators.length > 0) {
                for (i = 0; i < locators.length; ++i) {
                    if (locators[i] == null) continue;
                    this.locators.add(locators[i]);
                }
            }
            this.discoveredRegsMap = new HashMap(11);
            this.leaseID = leaseID;
            this.leaseExpiration = leaseExpiration;
            this.eventID = eventID;
            this.seqNum = 0L;
            this.handback = handback;
            this.discardFlag = false;
            this.listener = listener;
        }

        public HashMap addToDiscoveredRegs(HashMap regMapIn) {
            HashMap<ServiceRegistrar, String[]> regMapOut = new HashMap<ServiceRegistrar, String[]>(regMapIn.size());
            Iterator itr = regMapIn.entrySet().iterator();
            int i = 0;
            while (itr.hasNext()) {
                block4: {
                    Map.Entry pair = itr.next();
                    ServiceRegistrar reg = (ServiceRegistrar)pair.getKey();
                    if (!this.discoveredRegsMap.containsKey(reg)) {
                        MarshalledObject<ServiceRegistrar> mReg = null;
                        try {
                            mReg = new MarshalledObject<ServiceRegistrar>(reg);
                        }
                        catch (IOException e) {
                            break block4;
                        }
                        this.discoveredRegsMap.put(reg, mReg);
                        regMapOut.put(reg, ((LocatorGroupsStruct)pair.getValue()).groups);
                    }
                }
                ++i;
            }
            return regMapOut;
        }

        public int compareTo(Object obj) {
            RegistrationInfo regInfo = (RegistrationInfo)obj;
            if (this == regInfo) {
                return 0;
            }
            if (this.leaseExpiration < regInfo.leaseExpiration || this.leaseExpiration == regInfo.leaseExpiration && this.eventID < regInfo.eventID) {
                return -1;
            }
            return 1;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeObject(new MarshalledObject<RemoteEventListener>(this.listener));
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            block4: {
                stream.defaultReadObject();
                MarshalledObject mo = (MarshalledObject)stream.readObject();
                try {
                    this.listener = (RemoteEventListener)mo.get();
                    this.listener = (RemoteEventListener)recoveredListenerPreparer.prepareProxy(this.listener);
                }
                catch (Throwable e) {
                    problemLogger.log(Level.INFO, "problem recovering listener for recovered registration", e);
                    if (!(e instanceof Error) || ThrowableConstants.retryable(e) != 2) break block4;
                    throw (Error)e;
                }
            }
            int nUnprepared = this.locators.size();
            this.locators = (HashSet)FiddlerImpl.prepareOldLocators(recoveredLocatorToDiscoverPreparer, this.locators);
            if (nUnprepared != this.locators.size()) {
                this.listener = null;
                if (problemLogger.isLoggable(Level.WARNING)) {
                    problemLogger.log(Level.WARNING, "failure preparing locator while recovering registration... discarding recoveredregistration");
                }
            }
        }
    }

    private class LookupDiscoveryListener
    implements DiscoveryChangeListener {
        @Override
        public void discovered(DiscoveryEvent event) {
            FiddlerImpl.this.taskMgr.add(new DiscoveredEventTask(event));
        }

        @Override
        public void discarded(DiscoveryEvent event) {
            FiddlerImpl.this.taskMgr.add(new DiscardedEventTask(event));
        }

        @Override
        public void changed(DiscoveryEvent event) {
            FiddlerImpl.this.taskMgr.add(new ChangedEventTask(event));
        }
    }

    private static class FiddlerStatus
    extends Status {
        private static final long serialVersionUID = -8511826097053446749L;

        public FiddlerStatus(StatusType severity) {
            super(severity);
        }
    }

    protected final class LocatorGroupsStruct {
        public LookupLocator locator;
        public String[] groups;

        LocatorGroupsStruct(LookupLocator locator, String[] groups) {
            this.locator = locator;
            this.groups = groups;
        }
    }
}

