/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.fiddler;

import com.sun.jini.fiddler.Fiddler;
import com.sun.jini.fiddler.ProxyUtil;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import net.jini.admin.Administrable;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.event.RemoteEventListener;
import net.jini.discovery.LookupDiscoveryRegistration;
import net.jini.discovery.LookupDiscoveryService;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class FiddlerProxy
implements Administrable,
LookupDiscoveryService,
ReferentUuid,
Serializable {
    private static final long serialVersionUID = 2L;
    final Fiddler server;
    final Uuid proxyID;

    public static FiddlerProxy createServiceProxy(Fiddler server, Uuid proxyID) {
        if (server instanceof RemoteMethodControl) {
            return new ConstrainableFiddlerProxy(server, proxyID, null);
        }
        return new FiddlerProxy(server, proxyID);
    }

    private FiddlerProxy(Fiddler server, Uuid proxyID) {
        this.server = server;
        this.proxyID = proxyID;
    }

    @Override
    public Object getAdmin() throws RemoteException {
        return this.server.getAdmin();
    }

    @Override
    public LookupDiscoveryRegistration register(String[] groups, LookupLocator[] locators, RemoteEventListener listener, MarshalledObject handback, long leaseDuration) throws RemoteException {
        return this.server.register(groups, locators, listener, handback, leaseDuration);
    }

    @Override
    public Uuid getReferentUuid() {
        return this.proxyID;
    }

    public int hashCode() {
        return this.proxyID.hashCode();
    }

    public boolean equals(Object obj) {
        return ReferentUuids.compare(this, obj);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.server == null) {
            throw new InvalidObjectException("FiddlerProxy.readObject failure - server field is null");
        }
        if (this.proxyID == null) {
            throw new InvalidObjectException("FiddlerProxy.readObject failure - proxyID field is null");
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data found when attempting to deserialize FiddlerProxy instance");
    }

    static final class ConstrainableFiddlerProxy
    extends FiddlerProxy
    implements RemoteMethodControl {
        static final long serialVersionUID = 2L;
        private static final Method[] methodMapArray = new Method[]{ProxyUtil.getMethod(Administrable.class, "getAdmin", new Class[0]), ProxyUtil.getMethod(Administrable.class, "getAdmin", new Class[0]), ProxyUtil.getMethod(LookupDiscoveryService.class, "register", new Class[]{String[].class, LookupLocator[].class, RemoteEventListener.class, MarshalledObject.class, Long.TYPE}), ProxyUtil.getMethod(Fiddler.class, "register", new Class[]{String[].class, LookupLocator[].class, RemoteEventListener.class, MarshalledObject.class, Long.TYPE})};
        private MethodConstraints methodConstraints;

        private ConstrainableFiddlerProxy(Fiddler server, Uuid proxyID, MethodConstraints methodConstraints) {
            super(ConstrainableFiddlerProxy.constrainServer(server, methodConstraints), proxyID);
            this.methodConstraints = methodConstraints;
        }

        private static Fiddler constrainServer(Fiddler server, MethodConstraints constraints) {
            MethodConstraints newConstraints = ConstrainableProxyUtil.translateConstraints(constraints, methodMapArray);
            RemoteMethodControl constrainedServer = ((RemoteMethodControl)((Object)server)).setConstraints(newConstraints);
            return (Fiddler)((Object)constrainedServer);
        }

        @Override
        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableFiddlerProxy(this.server, this.proxyID, constraints);
        }

        @Override
        public MethodConstraints getConstraints() {
            return this.methodConstraints;
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator(this.server);
        }

        @Override
        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            ConstrainableProxyUtil.verifyConsistentConstraints(this.methodConstraints, this.server, methodMapArray);
        }
    }
}

