/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.mux;

import com.sun.jini.jeri.internal.mux.ConnectionIO;
import com.sun.jini.jeri.internal.mux.IOFuture;
import com.sun.jini.jeri.internal.mux.Mux;
import com.sun.jini.jeri.internal.mux.ProtocolException;
import com.sun.jini.jeri.internal.runtime.SelectionManager;
import com.sun.jini.logging.Levels;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SocketChannelConnectionIO
extends ConnectionIO {
    private static final int RECEIVE_BUFFER_SIZE = 4096;
    private static final int IOV_MAX = 16;
    private static final Logger logger = Logger.getLogger("net.jini.jeri.connection.mux");
    private static final SelectionManager selectionManager;
    private static final String detailMessage4854354 = "A non-blocking socket operation could not be completed immediately";
    private final SocketChannel channel;
    private final SelectionManager.Key key;
    private final LinkedList sendQueue = new LinkedList();
    private final LinkedList notifyQueue = new LinkedList();
    private final ByteBuffer inputBuffer = ByteBuffer.allocateDirect(4096);
    private final ByteBuffer[] bufferPair = new ByteBuffer[2];
    private final ByteBuffer[] preallocBufferArray = new ByteBuffer[16];

    SocketChannelConnectionIO(Mux mux, SocketChannel channel) throws IOException {
        super(mux);
        channel.configureBlocking(false);
        this.channel = channel;
        this.key = selectionManager.register(channel, new Handler());
    }

    @Override
    void start() throws IOException {
        this.key.renewInterestMask(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void asyncSend(ByteBuffer buffer) {
        Object object = this.mux.muxLock;
        synchronized (object) {
            if (this.mux.muxDown) {
                return;
            }
            try {
                if (this.sendQueue.isEmpty()) {
                    this.channel.write(buffer);
                }
                if (buffer.hasRemaining()) {
                    this.sendQueue.addLast(buffer);
                    this.key.renewInterestMask(4);
                }
            }
            catch (IOException e) {
                this.mux.setDown("I/O error writing to mux connection: " + e.toString(), e);
                try {
                    this.channel.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void asyncSend(ByteBuffer first, ByteBuffer second) {
        Object object = this.mux.muxLock;
        synchronized (object) {
            if (this.mux.muxDown) {
                return;
            }
            try {
                if (this.sendQueue.isEmpty()) {
                    this.bufferPair[0] = first;
                    this.bufferPair[1] = second;
                    try {
                        this.channel.write(this.bufferPair);
                    }
                    catch (IOException e) {
                        String message = e.getMessage();
                        if (message != null && message.indexOf(detailMessage4854354) != -1) {
                            logger.log(Levels.HANDLED, "ignoring to work around 4854354", e);
                        }
                        throw e;
                    }
                }
                if (!first.hasRemaining()) {
                    if (second.hasRemaining()) {
                        this.sendQueue.addLast(second);
                        this.key.renewInterestMask(4);
                    }
                } else {
                    this.sendQueue.addLast(first);
                    this.sendQueue.addLast(second);
                    this.key.renewInterestMask(4);
                }
            }
            catch (IOException e) {
                this.mux.setDown("I/O error writing to mux connection: " + e.toString(), e);
                try {
                    this.channel.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            finally {
                this.bufferPair[0] = null;
                this.bufferPair[1] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    IOFuture futureSend(ByteBuffer first, ByteBuffer second) {
        Object object = this.mux.muxLock;
        synchronized (object) {
            IOFuture future = new IOFuture();
            if (this.mux.muxDown) {
                IOException ioe = new IOException(this.mux.muxDownMessage);
                ioe.initCause(this.mux.muxDownCause);
                future.done(ioe);
                return future;
            }
            try {
                if (this.sendQueue.isEmpty()) {
                    this.bufferPair[0] = first;
                    this.bufferPair[1] = second;
                    try {
                        this.channel.write(this.bufferPair);
                    }
                    catch (IOException e) {
                        String message = e.getMessage();
                        if (message != null && message.indexOf(detailMessage4854354) != -1) {
                            logger.log(Levels.HANDLED, "ignoring to work around 4854354", e);
                        }
                        throw e;
                    }
                }
                if (!first.hasRemaining()) {
                    if (second.hasRemaining()) {
                        this.sendQueue.addLast(second);
                        this.key.renewInterestMask(4);
                        this.notifyQueue.addLast(second);
                        this.notifyQueue.addLast(future);
                    } else {
                        future.done();
                    }
                } else {
                    this.sendQueue.addLast(first);
                    this.sendQueue.addLast(second);
                    this.key.renewInterestMask(4);
                    this.notifyQueue.addLast(second);
                    this.notifyQueue.addLast(future);
                }
            }
            catch (IOException e) {
                this.mux.setDown("I/O error writing to mux connection: " + e.toString(), e);
                future.done(e);
                try {
                    this.channel.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            finally {
                this.bufferPair[0] = first;
                this.bufferPair[1] = second;
            }
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWriteReady() {
        try {
            Object object = this.mux.muxLock;
            synchronized (object) {
                block16: while (!this.sendQueue.isEmpty()) {
                    ByteBuffer[] bufs = this.preallocBufferArray;
                    int len = this.sendQueue.size();
                    if (len <= bufs.length) {
                        bufs = this.sendQueue.toArray(bufs);
                    } else {
                        Iterator iter2 = this.sendQueue.iterator();
                        len = 0;
                        while (iter2.hasNext() && len < bufs.length) {
                            bufs[len++] = (ByteBuffer)iter2.next();
                        }
                    }
                    try {
                        this.channel.write(bufs, 0, len);
                    }
                    catch (IOException e) {
                        String message = e.getMessage();
                        if (message != null && message.indexOf(detailMessage4854354) != -1) {
                            logger.log(Levels.HANDLED, "ignoring to work around 4854354", e);
                        }
                        throw e;
                    }
                    for (int i = 0; i < len; ++i) {
                        ByteBuffer bb = bufs[i];
                        assert (bb == this.sendQueue.getFirst());
                        if (!bb.hasRemaining()) {
                            this.sendQueue.removeFirst();
                            if (this.notifyQueue.isEmpty() || bb != this.notifyQueue.getFirst()) continue;
                            this.notifyQueue.removeFirst();
                            IOFuture future = (IOFuture)this.notifyQueue.removeFirst();
                            future.done();
                            continue;
                        }
                        this.key.renewInterestMask(4);
                        break block16;
                    }
                }
            }
        }
        catch (IOException e) {
            try {
                logger.log(Levels.HANDLED, "mux write handler, I/O error", e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.mux.setDown("I/O error writing to mux connection: " + e.toString(), e);
            this.drainNotifyQueue();
            try {
                this.channel.close();
            }
            catch (IOException ignore) {}
        }
        catch (Throwable t) {
            try {
                logger.log(Level.WARNING, "mux write handler, unexpected exception", t);
            }
            catch (Throwable tt) {
                // empty catch block
            }
            this.mux.setDown("unexpected exception in mux write handler: " + t.toString(), t);
            this.drainNotifyQueue();
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainNotifyQueue() {
        Object object = this.mux.muxLock;
        synchronized (object) {
            assert (this.mux.muxDown);
            while (!this.notifyQueue.isEmpty()) {
                this.notifyQueue.removeFirst();
                IOFuture future = (IOFuture)this.notifyQueue.removeFirst();
                IOException ioe = new IOException(this.mux.muxDownMessage);
                ioe.initCause(this.mux.muxDownCause);
                future.done(ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReadReady() {
        try {
            int n = this.channel.read(this.inputBuffer);
            if (n == -1) {
                throw new EOFException();
            }
            if (n > 0) {
                this.mux.processIncomingData(this.inputBuffer);
            }
            assert (this.inputBuffer.hasRemaining());
            this.key.renewInterestMask(1);
        }
        catch (ProtocolException e) {
            IOFuture future = null;
            Object object = this.mux.muxLock;
            synchronized (object) {
                if (!this.mux.muxDown) {
                    try {
                        logger.log(Levels.HANDLED, "mux read handler, protocol error", e);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    future = this.mux.futureSendError(e.getMessage());
                    this.mux.setDown("protocol violation detected: " + e.getMessage(), null);
                } else {
                    try {
                        logger.log(Level.FINEST, "mux read handler: " + e.getMessage());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
            if (future != null) {
                try {
                    future.waitUntilDone();
                }
                catch (IOException ignore) {
                }
                catch (InterruptedException interrupt) {
                    Thread.currentThread().interrupt();
                }
            }
            try {
                this.channel.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            try {
                logger.log(Levels.HANDLED, "mux read handler, I/O error", e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.mux.setDown("I/O error reading from mux connection: " + e.toString(), e);
            try {
                this.channel.close();
            }
            catch (IOException ignore) {}
        }
        catch (Throwable t) {
            try {
                logger.log(Level.WARNING, "mux read handler, unexpected exception", t);
            }
            catch (Throwable tt) {
                // empty catch block
            }
            this.mux.setDown("unexpected exception in mux read handler: " + t.toString(), t);
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        try {
            selectionManager = new SelectionManager();
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class.forName("sun.nio.ch.IOVecWrapper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private class Handler
    implements SelectionManager.SelectionHandler {
        private Handler() {
        }

        @Override
        public void handleSelection(int readyMask, SelectionManager.Key key) {
            if ((readyMask & 4) != 0) {
                SocketChannelConnectionIO.this.handleWriteReady();
            }
            if ((readyMask & 1) != 0) {
                SocketChannelConnectionIO.this.handleReadReady();
            }
        }
    }
}

