/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.mux;

import com.sun.jini.jeri.internal.mux.ConnectionIO;
import com.sun.jini.jeri.internal.mux.IOFuture;
import com.sun.jini.jeri.internal.mux.Mux;
import com.sun.jini.jeri.internal.mux.ProtocolException;
import com.sun.jini.logging.Levels;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.AccessController;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

final class StreamConnectionIO
extends ConnectionIO {
    private static final int RECEIVE_BUFFER_SIZE = 2048;
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private static final Logger logger = Logger.getLogger("net.jini.jeri.connection.mux");
    private final OutputStream out;
    private final InputStream in;
    private final WritableByteChannel outChannel;
    private final ReadableByteChannel inChannel;
    private LinkedList sendQueue = new LinkedList();
    private final ByteBuffer inputBuffer = ByteBuffer.allocate(2048);

    StreamConnectionIO(Mux mux, OutputStream out, InputStream in) {
        super(mux);
        this.out = out;
        this.in = in;
        this.outChannel = StreamConnectionIO.newChannel(out);
        this.inChannel = StreamConnectionIO.newChannel(in);
    }

    @Override
    void start() throws IOException {
        try {
            systemThreadPool.execute(new Writer(), "mux writer");
            systemThreadPool.execute(new Reader(), "mux reader");
        }
        catch (OutOfMemoryError e) {
            try {
                logger.log(Level.WARNING, "could not create thread for request dispatch", e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            IOException ioe = new IOException("could not create I/O threads");
            ioe.initCause(e);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void asyncSend(ByteBuffer buffer) {
        Object object = this.mux.muxLock;
        synchronized (object) {
            if (this.mux.muxDown) {
                return;
            }
            this.sendQueue.addLast(buffer);
            this.mux.muxLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void asyncSend(ByteBuffer first, ByteBuffer second) {
        Object object = this.mux.muxLock;
        synchronized (object) {
            if (this.mux.muxDown) {
                return;
            }
            this.sendQueue.addLast(first);
            this.sendQueue.addLast(second);
            this.mux.muxLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    IOFuture futureSend(ByteBuffer first, ByteBuffer second) {
        Object object = this.mux.muxLock;
        synchronized (object) {
            IOFuture future = new IOFuture();
            if (this.mux.muxDown) {
                IOException ioe = new IOException(this.mux.muxDownMessage);
                ioe.initCause(this.mux.muxDownCause);
                future.done(ioe);
                return future;
            }
            this.sendQueue.addLast(first);
            this.sendQueue.addLast(second);
            this.sendQueue.addLast(future);
            this.mux.muxLock.notifyAll();
            return future;
        }
    }

    private void drainQueue(LinkedList queue) {
        while (!queue.isEmpty()) {
            Object next = queue.removeFirst();
            if (!(next instanceof IOFuture)) continue;
            IOException ioe = new IOException(this.mux.muxDownMessage);
            ioe.initCause(this.mux.muxDownCause);
            ((IOFuture)next).done(ioe);
        }
    }

    public static ReadableByteChannel newChannel(final InputStream in) {
        return new ReadableByteChannel(){
            private boolean open = true;

            @Override
            public int read(ByteBuffer dst) throws IOException {
                int pos;
                int totalRead;
                int bytesToRead;
                assert (dst.hasArray());
                byte[] array = dst.array();
                int arrayOffset = dst.arrayOffset();
                int bytesRead = 0;
                for (totalRead = 0; (bytesToRead = dst.remaining()) > 0 && (totalRead <= 0 || in.available() > 0) && (bytesRead = in.read(array, arrayOffset + (pos = dst.position()), bytesToRead)) >= 0; totalRead += bytesRead) {
                    dst.position(pos + bytesRead);
                }
                if (bytesRead < 0 && totalRead == 0) {
                    return -1;
                }
                return totalRead;
            }

            @Override
            public boolean isOpen() {
                return this.open;
            }

            @Override
            public void close() throws IOException {
                in.close();
                this.open = false;
            }
        };
    }

    public static WritableByteChannel newChannel(final OutputStream out) {
        return new WritableByteChannel(){
            private boolean open = true;

            @Override
            public int write(ByteBuffer src) throws IOException {
                assert (src.hasArray());
                int len = src.remaining();
                if (len > 0) {
                    int pos = src.position();
                    out.write(src.array(), src.arrayOffset() + pos, len);
                    src.position(pos + len);
                }
                return len;
            }

            @Override
            public boolean isOpen() {
                return this.open;
            }

            @Override
            public void close() throws IOException {
                out.close();
                this.open = false;
            }
        };
    }

    static /* synthetic */ LinkedList access$000(StreamConnectionIO x0) {
        return x0.sendQueue;
    }

    static /* synthetic */ LinkedList access$002(StreamConnectionIO x0, LinkedList x1) {
        x0.sendQueue = x1;
        return x0.sendQueue;
    }

    static /* synthetic */ WritableByteChannel access$200(StreamConnectionIO x0) {
        return x0.outChannel;
    }

    static /* synthetic */ OutputStream access$300(StreamConnectionIO x0) {
        return x0.out;
    }

    static /* synthetic */ void access$400(StreamConnectionIO x0, LinkedList x1) {
        x0.drainQueue(x1);
    }

    private class Reader
    implements Runnable {
        Reader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            try {
                while (true) {
                    int n;
                    if ((n = StreamConnectionIO.this.inChannel.read(StreamConnectionIO.this.inputBuffer)) == -1) {
                        throw new EOFException();
                    }
                    assert (n > 0);
                    StreamConnectionIO.this.mux.processIncomingData(StreamConnectionIO.this.inputBuffer);
                    assert (StreamConnectionIO.this.inputBuffer.hasRemaining());
                }
            }
            catch (ProtocolException e) {
                IOFuture future = null;
                Object object = StreamConnectionIO.this.mux.muxLock;
                synchronized (object) {
                    if (!StreamConnectionIO.this.mux.muxDown) {
                        try {
                            logger.log(Levels.HANDLED, "mux reader thread dying, protocol error", e);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        future = StreamConnectionIO.this.mux.futureSendError(e.getMessage());
                        StreamConnectionIO.this.mux.setDown("protocol violation detected: " + e.getMessage(), null);
                    } else {
                        try {
                            logger.log(Level.FINEST, "mux reader thread dying: " + e.getMessage());
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
                if (future != null) {
                    try {
                        future.waitUntilDone();
                    }
                    catch (IOException ignore) {
                    }
                    catch (InterruptedException interrupt) {
                        Thread.currentThread().interrupt();
                    }
                }
                try {
                    StreamConnectionIO.this.inChannel.close();
                }
                catch (IOException e2) {}
            }
            catch (IOException e) {
                try {
                    logger.log(Levels.HANDLED, "mux reader thread dying, I/O error", e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                StreamConnectionIO.this.mux.setDown("I/O error reading from mux connection: " + e.toString(), e);
            }
            catch (Throwable t) {
                try {
                    logger.log(Level.WARNING, "mux reader thread dying, unexpected exception", t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                StreamConnectionIO.this.mux.setDown("unexpected exception in mux reader thread: " + t.toString(), t);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    StreamConnectionIO.this.inChannel.close();
                }
                catch (IOException iOException) {}
            }
            {
                finally {
                    try {
                        StreamConnectionIO.this.inChannel.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private class Writer
    implements Runnable {
        Writer() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

