/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.action.GetLongAction;
import com.sun.jini.thread.NewThreadAction;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

abstract class AbstractDgcClient {
    private static final long leaseValue = (Long)AccessController.doPrivileged(new GetLongAction("com.sun.jini.jeri.dgc.leaseValue", 600000L));
    private static final long cleanInterval = (Long)AccessController.doPrivileged(new GetLongAction("com.sun.jini.jeri.dgc.cleanInterval", 180000L));
    private static final long minimumDuration = (Long)AccessController.doPrivileged(new GetLongAction("com.sun.jini.jeri.dgc.minimumDuration", 5000L));
    private static final int dirtyFailureRetries = 5;
    private static final int cleanConnectRetries = 3;
    private static final Object[] emptyObjectArray = new Object[0];
    private static long nextSequenceNum = Long.MIN_VALUE;
    private final Map endpointTable = new HashMap(5);

    protected AbstractDgcClient() {
    }

    protected abstract DgcProxy getDgcProxy(Object var1);

    protected abstract void freeEndpoint(Object var1);

    protected abstract Object getRefEndpoint(Object var1);

    protected abstract Object getRefObjectID(Object var1);

    protected final void registerRefs(Object endpoint, Collection refs) {
        EndpointEntry epEntry;
        while (!(epEntry = this.getEndpointEntry(endpoint)).registerRefs(refs)) {
        }
    }

    private static synchronized long getNextSequenceNum() {
        return nextSequenceNum++;
    }

    private static long computeRenewTime(long grantTime, long duration) {
        return grantTime + duration / 2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EndpointEntry getEndpointEntry(Object endpoint) {
        Map map = this.endpointTable;
        synchronized (map) {
            EndpointEntry entry = (EndpointEntry)this.endpointTable.get(endpoint);
            if (entry == null) {
                entry = new EndpointEntry(endpoint);
                this.endpointTable.put(endpoint, entry);
            }
            return entry;
        }
    }

    private static class CleanRequest {
        long sequenceNum;
        Object[] objectIDs;
        boolean strong;
        int connectFailures = 0;

        CleanRequest(long sequenceNum, Object[] objectIDs, boolean strong) {
            this.sequenceNum = sequenceNum;
            this.objectIDs = objectIDs;
            this.strong = strong;
        }
    }

    private final class EndpointEntry {
        private final Object endpoint;
        private final DgcProxy dgcProxy;
        private final Thread renewCleanThread;
        private final ReferenceQueue refQueue = new ReferenceQueue();
        private boolean removed = false;
        private final Map refTable = new HashMap(5);
        private Set invalidRefs = new HashSet(5);
        private long renewTime = Long.MAX_VALUE;
        private long expirationTime = Long.MIN_VALUE;
        private int dirtyFailures = 0;
        private long dirtyFailureStartTime;
        private long dirtyFailureDuration;
        private boolean interruptible = false;
        private final Set pendingCleans = new HashSet(5);

        private EndpointEntry(Object endpoint) {
            this.endpoint = endpoint;
            this.dgcProxy = AbstractDgcClient.this.getDgcProxy(endpoint);
            this.renewCleanThread = (Thread)AccessController.doPrivileged(new NewThreadAction(new RenewCleanThread(), "RenewClean-" + endpoint, true));
            this.renewCleanThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean registerRefs(Collection refs) {
            long sequenceNum;
            assert (!Thread.holdsLock(this));
            HashSet<RefEntry> refsToDirty = null;
            EndpointEntry endpointEntry = this;
            synchronized (endpointEntry) {
                if (this.removed) {
                    return false;
                }
                for (Object ref : refs) {
                    assert (AbstractDgcClient.this.getRefEndpoint(ref).equals(this.endpoint));
                    Object objectID = AbstractDgcClient.this.getRefObjectID(ref);
                    RefEntry refEntry = (RefEntry)this.refTable.get(objectID);
                    if (refEntry == null) {
                        refEntry = new RefEntry(objectID);
                        this.refTable.put(objectID, refEntry);
                        if (refsToDirty == null) {
                            refsToDirty = new HashSet<RefEntry>(5);
                        }
                        refsToDirty.add(refEntry);
                    }
                    refEntry.addInstanceToRefSet(ref);
                }
                if (refsToDirty == null) {
                    return true;
                }
                refsToDirty.addAll(this.invalidRefs);
                this.invalidRefs.clear();
                sequenceNum = AbstractDgcClient.getNextSequenceNum();
            }
            this.makeDirtyCall(refsToDirty, sequenceNum);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeRefEntry(RefEntry refEntry) {
            assert (Thread.holdsLock(this));
            assert (!this.removed);
            assert (this.refTable.containsKey(refEntry.getObjectID()));
            this.refTable.remove(refEntry.getObjectID());
            this.invalidRefs.remove(refEntry);
            if (this.refTable.isEmpty()) {
                Map map = AbstractDgcClient.this.endpointTable;
                synchronized (map) {
                    AbstractDgcClient.this.endpointTable.remove(this.endpoint);
                    AbstractDgcClient.this.freeEndpoint(this.endpoint);
                }
                this.removed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void makeDirtyCall(Set refEntries, long sequenceNum) {
            assert (!Thread.holdsLock(this));
            Object[] ids = refEntries != null ? this.createObjectIDArray(refEntries) : emptyObjectArray;
            long startTime = System.currentTimeMillis();
            try {
                long duration = this.dgcProxy.dirty(sequenceNum, ids, leaseValue);
                EndpointEntry endpointEntry = this;
                synchronized (endpointEntry) {
                    this.dirtyFailures = 0;
                    if (duration < 0L) {
                        this.setRenewTime(Long.MAX_VALUE);
                        this.invalidRefs.addAll(this.refTable.values());
                    } else {
                        this.setRenewTime(AbstractDgcClient.computeRenewTime(startTime, Math.max(duration, minimumDuration)));
                        this.expirationTime = startTime + duration;
                    }
                }
            }
            catch (NoSuchObjectException e) {
                EndpointEntry endpointEntry = this;
                synchronized (endpointEntry) {
                    this.setRenewTime(Long.MAX_VALUE);
                    this.invalidRefs.addAll(this.refTable.values());
                }
            }
            catch (Exception e) {
                long endTime = System.currentTimeMillis();
                EndpointEntry endpointEntry = this;
                synchronized (endpointEntry) {
                    ++this.dirtyFailures;
                    if (this.dirtyFailures == 1) {
                        this.dirtyFailureStartTime = startTime;
                        this.dirtyFailureDuration = endTime - startTime;
                        this.setRenewTime(endTime);
                    } else {
                        long newRenewTime;
                        int n = this.dirtyFailures - 2;
                        if (n == 0) {
                            this.dirtyFailureDuration = Math.max(this.dirtyFailureDuration + (endTime - startTime) >> 1, 1000L);
                        }
                        if ((newRenewTime = endTime + (this.dirtyFailureDuration << n)) < this.expirationTime || this.dirtyFailures < 5 || newRenewTime < this.dirtyFailureStartTime + leaseValue) {
                            this.setRenewTime(newRenewTime);
                        } else {
                            this.setRenewTime(Long.MAX_VALUE);
                        }
                    }
                    if (refEntries != null) {
                        this.invalidRefs.addAll(refEntries);
                        for (RefEntry refEntry : refEntries) {
                            refEntry.markDirtyFailed();
                        }
                    }
                    if (this.renewTime >= this.expirationTime) {
                        this.invalidRefs.addAll(this.refTable.values());
                    }
                }
            }
        }

        private void setRenewTime(long newRenewTime) {
            assert (Thread.holdsLock(this));
            if (newRenewTime < this.renewTime) {
                this.renewTime = newRenewTime;
                if (this.interruptible) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            EndpointEntry.this.renewCleanThread.interrupt();
                            return null;
                        }
                    });
                }
            } else {
                this.renewTime = newRenewTime;
            }
        }

        private void processPhantomRefs(RefEntry.PhantomLiveRef phantom) {
            assert (Thread.holdsLock(this));
            HashSet<RefEntry> strongCleans = null;
            HashSet<RefEntry> normalCleans = null;
            do {
                RefEntry refEntry = phantom.getRefEntry();
                refEntry.removeInstanceFromRefSet(phantom);
                if (!refEntry.isRefSetEmpty()) continue;
                if (refEntry.hasDirtyFailed()) {
                    if (strongCleans == null) {
                        strongCleans = new HashSet<RefEntry>(5);
                    }
                    strongCleans.add(refEntry);
                } else {
                    if (normalCleans == null) {
                        normalCleans = new HashSet<RefEntry>(5);
                    }
                    normalCleans.add(refEntry);
                }
                this.removeRefEntry(refEntry);
            } while ((phantom = (RefEntry.PhantomLiveRef)this.refQueue.poll()) != null);
            if (strongCleans != null) {
                this.pendingCleans.add(new CleanRequest(AbstractDgcClient.getNextSequenceNum(), this.createObjectIDArray(strongCleans), true));
            }
            if (normalCleans != null) {
                this.pendingCleans.add(new CleanRequest(AbstractDgcClient.getNextSequenceNum(), this.createObjectIDArray(normalCleans), false));
            }
        }

        private void makeCleanCalls() {
            assert (!Thread.holdsLock(this));
            Iterator iter2 = this.pendingCleans.iterator();
            while (iter2.hasNext()) {
                CleanRequest request = (CleanRequest)iter2.next();
                try {
                    this.dgcProxy.clean(request.sequenceNum, request.objectIDs, request.strong);
                    iter2.remove();
                }
                catch (NoSuchObjectException e) {
                    iter2.remove();
                }
                catch (Exception e) {
                    if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException) || ++request.connectFailures < 3) continue;
                    iter2.remove();
                }
            }
        }

        private Object[] createObjectIDArray(Set refEntries) {
            Object[] ids = new Object[refEntries.size()];
            Iterator iter2 = refEntries.iterator();
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = ((RefEntry)iter2.next()).getObjectID();
            }
            return ids;
        }

        private class RefEntry {
            private final Object objectID;
            private final Set refSet = new HashSet(5);
            private boolean dirtyFailed = false;

            RefEntry(Object objectID) {
                this.objectID = objectID;
            }

            Object getObjectID() {
                return this.objectID;
            }

            void addInstanceToRefSet(Object ref) {
                assert (Thread.holdsLock(EndpointEntry.this));
                assert (AbstractDgcClient.this.getRefObjectID(ref).equals(this.objectID));
                this.refSet.add(new PhantomLiveRef(ref));
            }

            void removeInstanceFromRefSet(PhantomLiveRef phantom) {
                assert (Thread.holdsLock(EndpointEntry.this));
                assert (this.refSet.contains(phantom));
                this.refSet.remove(phantom);
            }

            boolean isRefSetEmpty() {
                assert (Thread.holdsLock(EndpointEntry.this));
                return this.refSet.size() == 0;
            }

            void markDirtyFailed() {
                assert (Thread.holdsLock(EndpointEntry.this));
                this.dirtyFailed = true;
            }

            boolean hasDirtyFailed() {
                assert (Thread.holdsLock(EndpointEntry.this));
                return this.dirtyFailed;
            }

            class PhantomLiveRef
            extends PhantomReference {
                PhantomLiveRef(Object ref) {
                    super(ref, EndpointEntry.this.refQueue);
                }

                RefEntry getRefEntry() {
                    return RefEntry.this;
                }
            }
        }

        private class RenewCleanThread
        implements Runnable {
            private RenewCleanThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                do {
                    long timeToWait;
                    RefEntry.PhantomLiveRef phantom = null;
                    boolean needRenewal = false;
                    Set refsToDirty = null;
                    long sequenceNum = Long.MIN_VALUE;
                    EndpointEntry endpointEntry = EndpointEntry.this;
                    synchronized (endpointEntry) {
                        long timeUntilRenew = EndpointEntry.this.renewTime - System.currentTimeMillis();
                        timeToWait = Math.max(timeUntilRenew, 1L);
                        if (!EndpointEntry.this.pendingCleans.isEmpty()) {
                            timeToWait = Math.min(timeToWait, cleanInterval);
                        }
                        EndpointEntry.this.interruptible = true;
                    }
                    try {
                        phantom = (RefEntry.PhantomLiveRef)EndpointEntry.this.refQueue.remove(timeToWait);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    endpointEntry = EndpointEntry.this;
                    synchronized (endpointEntry) {
                        long currentTime;
                        EndpointEntry.this.interruptible = false;
                        Thread.interrupted();
                        if (phantom != null) {
                            EndpointEntry.this.processPhantomRefs(phantom);
                        }
                        if ((currentTime = System.currentTimeMillis()) > EndpointEntry.this.renewTime) {
                            needRenewal = true;
                            if (currentTime >= EndpointEntry.this.expirationTime) {
                                EndpointEntry.this.invalidRefs.addAll(EndpointEntry.this.refTable.values());
                            }
                            if (!EndpointEntry.this.invalidRefs.isEmpty()) {
                                refsToDirty = EndpointEntry.this.invalidRefs;
                                EndpointEntry.this.invalidRefs = new HashSet(5);
                            }
                            sequenceNum = AbstractDgcClient.getNextSequenceNum();
                        }
                    }
                    if (needRenewal) {
                        EndpointEntry.this.makeDirtyCall(refsToDirty, sequenceNum);
                    }
                    if (EndpointEntry.this.pendingCleans.isEmpty()) continue;
                    EndpointEntry.this.makeCleanCalls();
                } while (!EndpointEntry.this.removed || !EndpointEntry.this.pendingCleans.isEmpty());
            }
        }
    }

    protected static interface DgcProxy {
        public long dirty(long var1, Object[] var3, long var4) throws RemoteException;

        public void clean(long var1, Object[] var3, boolean var4) throws RemoteException;
    }
}

