/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.jeri.internal.runtime.ObjectTable;
import com.sun.jini.jeri.internal.runtime.SameClassKey;
import java.io.IOException;
import java.rmi.server.Unreferenced;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ConcurrentMap;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;
import net.jini.security.Security;

class Binding {
    private final ServerEndpoint.ListenEndpoint listenEndpoint;
    private final ObjectTable table;
    private final ConcurrentMap listenPool;
    private RequestDispatcher requestDispatcher;
    private ServerEndpoint.ListenHandle listenHandle;
    boolean activated;
    boolean closed;
    private int exportsInProgress = 1;

    Binding(ServerEndpoint.ListenEndpoint listenEndpoint, ObjectTable table, ConcurrentMap listenPool) throws IOException {
        this.table = table;
        this.listenPool = listenPool;
        this.listenEndpoint = listenEndpoint;
        this.activated = false;
        this.closed = false;
    }

    synchronized boolean incrementExportInProgress() {
        if (this.closed) {
            return false;
        }
        ++this.exportsInProgress;
        return true;
    }

    synchronized void decrementExportInProgress() {
        if (this.closed) {
            throw new IllegalStateException("Cannot decrement closed Binding");
        }
        --this.exportsInProgress;
    }

    synchronized boolean activate() throws IOException {
        if (this.closed) {
            return false;
        }
        if (this.activated) {
            return true;
        }
        this.requestDispatcher = this.table.createRequestDispatcher(new Unreferenced(){

            @Override
            public void unreferenced() {
                Binding.this.checkReferenced();
            }
        });
        try {
            this.listenHandle = (ServerEndpoint.ListenHandle)Security.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return Binding.this.listenEndpoint.listen(Binding.this.requestDispatcher);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        this.activated = true;
        return true;
    }

    synchronized void checkReferenced() {
        if (this.exportsInProgress > 0 || this.table.isReferenced(this.requestDispatcher)) {
            return;
        }
        this.listenPool.remove(new SameClassKey(this.listenEndpoint), this);
        this.listenHandle.close();
        this.closed = true;
    }

    synchronized RequestDispatcher getRequestDispatcher() {
        return this.requestDispatcher;
    }

    synchronized ServerEndpoint.ListenHandle getListenHandle() {
        return this.listenHandle;
    }
}

