/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.jeri.internal.runtime.DgcRequestDispatcher;
import com.sun.jini.jeri.internal.runtime.DgcServer;
import com.sun.jini.jeri.internal.runtime.ImplRefManager;
import com.sun.jini.jeri.internal.runtime.Jeri;
import com.sun.jini.jeri.internal.runtime.JvmLifeSupport;
import com.sun.jini.jeri.internal.runtime.Lease;
import com.sun.jini.jeri.internal.runtime.Target;
import com.sun.jini.thread.NewThreadAction;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.rmi.server.Unreferenced;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.id.Uuid;
import net.jini.jeri.RequestDispatcher;
import net.jini.security.Security;
import net.jini.security.SecurityContext;

final class ObjectTable {
    private static final Logger logger = Logger.getLogger("net.jini.jeri.BasicJeriExporter");
    private final Object requestDispatchersLock = new Object();
    private final ImplRefManager implRefManager = new ImplRefManager();
    private final JvmLifeSupport keepAliveCount = new JvmLifeSupport();
    private final ConcurrentMap<Uuid, Lease> leaseTable = new ConcurrentHashMap<Uuid, Lease>(256);
    private Thread leaseChecker = null;
    private final Object runLock = new Object();
    private volatile boolean running = false;

    ObjectTable() {
    }

    RequestDispatcher createRequestDispatcher(Unreferenced unrefCallback) {
        return new DgcRequestDispatcher(unrefCallback, this);
    }

    boolean isReferenced(RequestDispatcher requestDispatcher) {
        return this.getRD(requestDispatcher).isReferenced();
    }

    DgcServer getDgcServer(DgcRequestDispatcher dgdRD) {
        return new DgcServerImpl(dgdRD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Target export(Remote impl, RequestDispatcher[] requestDispatchers, boolean allowDGC, boolean keepAlive, Uuid id) throws ExportException {
        DgcRequestDispatcher[] rds = new DgcRequestDispatcher[requestDispatchers.length];
        for (int i = 0; i < requestDispatchers.length; ++i) {
            rds[i] = this.getRD(requestDispatchers[i]);
        }
        SecurityContext securityContext = Security.getContext();
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Target t = null;
        t = new Target(id, rds, allowDGC, keepAlive, this, securityContext, ccl, this.keepAliveCount);
        Object object = this.requestDispatchersLock;
        synchronized (object) {
            t.procRequestDispatchers();
        }
        ImplRefManager.ImplRef implRef = this.implRefManager.getImplRef(impl, t);
        t.setImplRef(implRef);
        t.setExported();
        return t;
    }

    private DgcRequestDispatcher getRD(RequestDispatcher requestDispatcher) {
        DgcRequestDispatcher rd = (DgcRequestDispatcher)requestDispatcher;
        if (!rd.forTable(this)) {
            throw new IllegalArgumentException("request dispatcher for different object table");
        }
        return rd;
    }

    void registerTarget(Target target, Uuid clientID) {
        Lease lease = (Lease)this.leaseTable.get(clientID);
        if (lease == null) {
            target.leaseExpired(clientID);
        } else {
            boolean added = lease.add(target);
            if (!added) {
                target.leaseExpired(clientID);
            }
        }
    }

    void unregisterTarget(Target target, Uuid clientID) {
        Lease lease = (Lease)this.leaseTable.get(clientID);
        if (lease != null) {
            lease.remove(target);
        }
    }

    static class NoSuchObject
    extends Exception {
        NoSuchObject() {
        }
    }

    private class LeaseChecker
    implements Runnable {
        private LeaseChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean done = false;
            try {
                do {
                    Thread.sleep(Jeri.leaseCheckInterval);
                    long now = System.currentTimeMillis();
                    Iterator i = ObjectTable.this.leaseTable.values().iterator();
                    while (i.hasNext()) {
                        Lease lease = (Lease)i.next();
                        boolean expired = lease.notifyIfExpired(now);
                        if (!expired) continue;
                        i.remove();
                    }
                    if (!ObjectTable.this.leaseTable.isEmpty()) continue;
                    done = true;
                } while (!done);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                Object object = ObjectTable.this.runLock;
                synchronized (object) {
                    ObjectTable.this.leaseChecker = null;
                    ObjectTable.this.running = false;
                }
            }
        }
    }

    private class DgcServerImpl
    implements DgcServer {
        private final DgcRequestDispatcher dgcRequestDispatcher;

        DgcServerImpl(DgcRequestDispatcher dgcRequestDispatcher) {
            this.dgcRequestDispatcher = dgcRequestDispatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long dirty(Uuid clientID, long sequenceNum, Uuid[] ids) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "clientID={0}, sequenceNum={1}, ids={2}", new Object[]{clientID, sequenceNum, Arrays.asList(ids)});
            }
            long duration = Jeri.leaseValue;
            Lease lease = (Lease)ObjectTable.this.leaseTable.get(clientID);
            if (lease == null) {
                lease = new Lease(clientID, duration);
                Lease existed = ObjectTable.this.leaseTable.putIfAbsent(clientID, lease);
                if (existed != null) {
                    assert (clientID.equals(existed.getClientID()));
                    boolean renewed = existed.renew(duration);
                    if (!renewed && logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "Problem with lease table, try a longer lease duration clientID={0}, sequenceNum={1}, ids={2}", new Object[]{clientID, sequenceNum, Arrays.asList(ids)});
                    }
                }
            } else {
                assert (clientID.equals(lease.getClientID()));
                boolean renewed = lease.renew(duration);
                if (!renewed) {
                    ObjectTable.this.leaseTable.remove(clientID, lease);
                    lease = new Lease(clientID, duration);
                    Lease existed = ObjectTable.this.leaseTable.putIfAbsent(clientID, lease);
                    if (existed != null) {
                        lease = existed;
                        assert (clientID.equals(lease.getClientID()));
                        renewed = lease.renew(duration);
                        if (!renewed && logger.isLoggable(Level.WARNING)) {
                            logger.log(Level.WARNING, "Problem with lease table, try a longer lease duration clientID={0}, sequenceNum={1}, ids={2}", new Object[]{clientID, sequenceNum, Arrays.asList(ids)});
                        }
                    }
                }
            }
            if (!ObjectTable.this.running) {
                Object renewed = ObjectTable.this.runLock;
                synchronized (renewed) {
                    if (!ObjectTable.this.running) {
                        ObjectTable.this.leaseChecker = (Thread)AccessController.doPrivileged(new NewThreadAction(new LeaseChecker(), "DGC Lease Checker", true));
                        ObjectTable.this.leaseChecker.start();
                        ObjectTable.this.running = true;
                    }
                }
            }
            for (int i = 0; i < ids.length; ++i) {
                Target target = this.dgcRequestDispatcher.get(ids[i]);
                if (target == null) continue;
                target.referenced(clientID, sequenceNum);
            }
            return duration;
        }

        @Override
        public void clean(Uuid clientID, long sequenceNum, Uuid[] ids, boolean strong) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "clientID={0}, sequenceNum={1}, ids={2}, strong={3}", new Object[]{clientID, sequenceNum, Arrays.asList(ids), strong});
            }
            for (int i = 0; i < ids.length; ++i) {
                Target target = this.dgcRequestDispatcher.get(ids[i]);
                if (target == null) continue;
                target.unreferenced(clientID, sequenceNum, strong);
            }
        }
    }
}

