/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.collection.WeakIdentityMap;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.URL;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import java.rmi.server.ServerNotActiveException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import javax.security.auth.Subject;
import net.jini.export.ServerContext;
import net.jini.io.context.ClientHost;
import net.jini.io.context.ClientSubject;
import net.jini.io.context.ContextPermission;
import net.jini.io.context.IntegrityEnforcement;
import net.jini.security.proxytrust.TrustEquivalence;

public class Util {
    private static TableCache methodToHash_TableCache = new TableCache(true);
    private static Map proxyRemoteMethodCache = new WeakHashMap();
    private static Class[] paramTypes = new Class[]{ActivationID.class, MarshalledObject.class};
    private static final String prohibitedProxyInterfacesResource = "com/sun/jini/proxy/resources/InvocationHandler.moreProhibitedProxyInterfaces";
    private static final Collection prohibitedProxyInterfaces = Util.getProhibitedProxyInterfaces();

    public static void exceptionReceivedFromServer(Throwable t) {
        Util.__________EXCEPTION_RECEIVED_FROM_SERVER__________(t);
    }

    private static void __________EXCEPTION_RECEIVED_FROM_SERVER__________(Throwable t) {
        StackTraceElement[] serverTrace = t.getStackTrace();
        StackTraceElement[] clientTrace = new Throwable().getStackTrace();
        StackTraceElement[] combinedTrace = new StackTraceElement[serverTrace.length + clientTrace.length];
        System.arraycopy(serverTrace, 0, combinedTrace, 0, serverTrace.length);
        System.arraycopy(clientTrace, 0, combinedTrace, serverTrace.length, clientTrace.length);
        t.setStackTrace(combinedTrace);
    }

    public static void clearStackTraces(Throwable t) {
        StackTraceElement[] empty = new StackTraceElement[]{};
        while (t != null) {
            t.setStackTrace(empty);
            t = t.getCause();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void marshalValue(Class type, Object value, ObjectOutput out) throws IOException {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                out.writeInt((Integer)value);
                return;
            } else if (type == Boolean.TYPE) {
                out.writeBoolean((Boolean)value);
                return;
            } else if (type == Byte.TYPE) {
                out.writeByte(((Byte)value).byteValue());
                return;
            } else if (type == Character.TYPE) {
                out.writeChar(((Character)value).charValue());
                return;
            } else if (type == Short.TYPE) {
                out.writeShort(((Short)value).shortValue());
                return;
            } else if (type == Long.TYPE) {
                out.writeLong((Long)value);
                return;
            } else if (type == Float.TYPE) {
                out.writeFloat(((Float)value).floatValue());
                return;
            } else {
                if (type != Double.TYPE) throw new AssertionError((Object)("Unrecognized primitive type: " + type));
                out.writeDouble((Double)value);
            }
            return;
        } else {
            out.writeObject(value);
        }
    }

    public static Object unmarshalValue(Class type, ObjectInput in) throws IOException, ClassNotFoundException {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return in.readInt();
            }
            if (type == Boolean.TYPE) {
                return in.readBoolean();
            }
            if (type == Byte.TYPE) {
                return in.readByte();
            }
            if (type == Character.TYPE) {
                return Character.valueOf(in.readChar());
            }
            if (type == Short.TYPE) {
                return in.readShort();
            }
            if (type == Long.TYPE) {
                return in.readLong();
            }
            if (type == Float.TYPE) {
                return new Float(in.readFloat());
            }
            if (type == Double.TYPE) {
                return new Double(in.readDouble());
            }
            throw new AssertionError((Object)("Unrecognized primitive type: " + type));
        }
        return in.readObject();
    }

    private static long computeMethodHash(Method m) {
        long hash = 0L;
        ByteArrayOutputStream sink = new ByteArrayOutputStream(127);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            DataOutputStream out = new DataOutputStream(new DigestOutputStream(sink, md));
            String s = Util.getMethodNameAndDescriptor(m);
            out.writeUTF(s);
            out.flush();
            byte[] hasharray = md.digest();
            for (int i = 0; i < Math.min(8, hasharray.length); ++i) {
                hash += (long)(hasharray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException ignore) {
            hash = -1L;
        }
        catch (NoSuchAlgorithmException complain) {
            throw new SecurityException(complain.getMessage());
        }
        return hash;
    }

    public static long getMethodHash(Method m) {
        Map table = methodToHash_TableCache.getTable(m.getDeclaringClass());
        Long hash = (Long)table.get(m);
        return hash;
    }

    private static void checkMethod(Method m) {
        Class<?>[] ex = m.getExceptionTypes();
        for (int i = 0; i < ex.length; ++i) {
            if (!ex[i].isAssignableFrom(RemoteException.class)) continue;
            return;
        }
        throw new IllegalArgumentException("illegal remote method encountered: " + m);
    }

    public static String getMethodNameAndDescriptor(Method m) {
        StringBuffer desc = new StringBuffer(m.getName());
        desc.append('(');
        Class<?>[] paramTypes = m.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            desc.append(Util.getTypeDescriptor(paramTypes[i]));
        }
        desc.append(')');
        Class<?> returnType = m.getReturnType();
        if (returnType == Void.TYPE) {
            desc.append('V');
        } else {
            desc.append(Util.getTypeDescriptor(returnType));
        }
        return desc.toString();
    }

    private static String getTypeDescriptor(Class type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return "I";
            }
            if (type == Boolean.TYPE) {
                return "Z";
            }
            if (type == Byte.TYPE) {
                return "B";
            }
            if (type == Character.TYPE) {
                return "C";
            }
            if (type == Short.TYPE) {
                return "S";
            }
            if (type == Long.TYPE) {
                return "J";
            }
            if (type == Float.TYPE) {
                return "F";
            }
            if (type == Double.TYPE) {
                return "D";
            }
            if (type == Void.TYPE) {
                return "V";
            }
            throw new Error("unrecognized primitive type: " + type);
        }
        if (type.isArray()) {
            return type.getName().replace('.', '/');
        }
        return "L" + type.getName().replace('.', '/') + ";";
    }

    public static Class[] getRemoteInterfaces(Class remoteClass) {
        ArrayList list = new ArrayList();
        Util.getRemoteInterfaces(list, remoteClass);
        return list.toArray(new Class[list.size()]);
    }

    private static void getRemoteInterfaces(ArrayList list, Class cl) {
        Class superclass = cl.getSuperclass();
        if (superclass != null) {
            Util.getRemoteInterfaces(list, superclass);
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> intf = interfaces[i];
            if (!Remote.class.isAssignableFrom(intf) || list.contains(intf)) continue;
            Method[] methods = intf.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                Util.checkMethod(methods[j]);
            }
            list.add(intf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkProxyRemoteMethod(Class c, Method m) {
        WeakIdentityMap map;
        SoftReference ref;
        Object object = proxyRemoteMethodCache;
        synchronized (object) {
            ref = (SoftReference)proxyRemoteMethodCache.get(c);
            WeakIdentityMap weakIdentityMap = map = ref == null ? null : (WeakIdentityMap)ref.get();
            if (map == null && ref != null) {
                map = new WeakIdentityMap();
                proxyRemoteMethodCache.put(c, new SoftReference<WeakIdentityMap>(map));
            }
        }
        if (map == null) {
            Util.checkProhibitedProxyInterfaces(c);
            object = proxyRemoteMethodCache;
            synchronized (object) {
                ref = (SoftReference)proxyRemoteMethodCache.get(c);
                WeakIdentityMap weakIdentityMap = map = ref == null ? null : (WeakIdentityMap)ref.get();
                if (map == null) {
                    map = new WeakIdentityMap();
                    proxyRemoteMethodCache.put(c, new SoftReference<WeakIdentityMap>(map));
                }
            }
        }
        object = map;
        synchronized (object) {
            if (map.get(m) != null) {
                return;
            }
        }
        Util.checkExceptions(c, m.getName(), m.getParameterTypes());
        object = map;
        synchronized (object) {
            map.put(m, Boolean.TRUE);
        }
    }

    private static void checkExceptions(Class c, String name, Class[] types) {
        Class<?>[] ifaces = c.getInterfaces();
        int i = ifaces.length;
        while (--i >= 0) {
            try {
                Util.checkMethod(ifaces[i].getMethod(name, types));
                Util.checkExceptions(ifaces[i], name, types);
            }
            catch (NoSuchMethodException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection getProhibitedProxyInterfaces() {
        Enumeration<URL> resources;
        HashSet<String> names = new HashSet<String>();
        names.add("javax.management.MBeanServerConnection");
        try {
            resources = ClassLoader.getSystemResources(prohibitedProxyInterfacesResource);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(new IOException("problem getting resources: com/sun/jini/proxy/resources/InvocationHandler.moreProhibitedProxyInterfaces").initCause(e));
        }
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                InputStream in = url.openStream();
                try {
                    String s;
                    BufferedReader r = new BufferedReader(new InputStreamReader(in, "utf-8"));
                    while ((s = r.readLine()) != null) {
                        int n;
                        int i = s.indexOf(35);
                        if (i >= 0) {
                            s = s.substring(0, i);
                        }
                        if ((n = (s = s.trim()).length()) == 0) continue;
                        int prev = 46;
                        for (i = 0; i < n; ++i) {
                            char c = s.charAt(i);
                            if (prev == 46 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c) && (c != '.' || i >= n - 1)) {
                                throw new ExceptionInInitializerError("illegal interface name in " + url + ": " + s);
                            }
                            prev = c;
                        }
                        names.add(s);
                    }
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            catch (IOException e) {
                throw new ExceptionInInitializerError(new IOException("problem reading " + url).initCause(e));
            }
        }
        return names;
    }

    private static void checkProhibitedProxyInterfaces(Class c) {
        Class<?>[] ifaces = c.getInterfaces();
        int i = ifaces.length;
        while (--i >= 0) {
            String name = ifaces[i].getName();
            if (prohibitedProxyInterfaces.contains(name)) {
                throw new IllegalArgumentException("prohibited proxy interface encountered: " + name);
            }
            Util.checkProhibitedProxyInterfaces(ifaces[i]);
        }
    }

    public static String getUnqualifiedName(Class c) {
        String binaryName = c.getName();
        return binaryName.substring(binaryName.lastIndexOf(46) + 1);
    }

    public static boolean equals(Object subject, Object object) {
        return subject == null ? object == null : subject.equals(object);
    }

    public static boolean sameClassAndEquals(Object subject, Object object) {
        return subject == null ? object == null : object != null && subject.getClass() == object.getClass() && subject.equals(object);
    }

    public static boolean checkTrustEquivalence(Object subject, Object object) {
        return subject == null ? object == null : subject instanceof TrustEquivalence && ((TrustEquivalence)subject).checkTrustEquivalence(object);
    }

    public static boolean sameProxyClass(Object proxy1, Object proxy2) {
        return proxy1.getClass() == proxy2.getClass() || Proxy.isProxyClass(proxy2.getClass()) && Util.equalInterfaces(proxy1, proxy2);
    }

    public static boolean equalInterfaces(Object obj1, Object obj2) {
        Class<?>[] intf2;
        Class<?>[] intf1 = obj1.getClass().getInterfaces();
        if (intf1.length != (intf2 = obj2.getClass().getInterfaces()).length) {
            return false;
        }
        for (int i = 0; i < intf1.length; ++i) {
            if (intf1[i] == intf2[i]) continue;
            return false;
        }
        return true;
    }

    public static void populateContext(Collection context, InetAddress addr) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (addr != null) {
            context.add(new ClientHostImpl(addr));
        }
    }

    public static void populateContext(Collection context, Subject s) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        context.add(new ClientSubjectImpl(s));
    }

    public static void populateContext(Collection context, boolean integrity) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        context.add(new IntegrityEnforcementImpl(integrity));
    }

    public static InetAddress getClientHost() throws ServerNotActiveException {
        ClientHost ch = (ClientHost)ServerContext.getServerContextElement(ClientHost.class);
        return ch != null ? ch.getClientHost() : null;
    }

    public static String getClientHostString() throws ServerNotActiveException {
        InetAddress addr = Util.getClientHost();
        return addr != null ? addr.toString() : null;
    }

    public static Subject getClientSubject() throws ServerNotActiveException {
        ClientSubject cs = (ClientSubject)ServerContext.getServerContextElement(ClientSubject.class);
        return cs != null ? cs.getClientSubject() : null;
    }

    public static void checkPackageAccess(Class type) {
        String name;
        int i;
        SecurityManager security = System.getSecurityManager();
        if (security != null && (i = (name = type.getName()).lastIndexOf(46)) != -1) {
            security.checkPackageAccess(name.substring(0, i));
        }
    }

    private static class IntegrityEnforcementImpl
    implements IntegrityEnforcement {
        private final boolean integrity;

        public IntegrityEnforcementImpl(boolean integrity) {
            this.integrity = integrity;
        }

        @Override
        public boolean integrityEnforced() {
            return this.integrity;
        }
    }

    private static class ClientSubjectImpl
    implements ClientSubject {
        private final Subject s;
        private static final Permission getClientSubjectPerm = new ContextPermission("net.jini.io.context.ClientSubject.getClientSubject");

        public ClientSubjectImpl(Subject s) {
            this.s = s;
        }

        @Override
        public Subject getClientSubject() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(getClientSubjectPerm);
            }
            return this.s;
        }
    }

    private static class ClientHostImpl
    implements ClientHost {
        private final InetAddress addr;

        public ClientHostImpl(InetAddress addr) {
            this.addr = addr;
        }

        @Override
        public InetAddress getClientHost() {
            return this.addr;
        }
    }

    private static class LazyMethodToHash_Map
    extends WeakHashMap {
        @Override
        public synchronized Object get(Object key) {
            Object hash = super.get(key);
            if (hash == null) {
                Method method = (Method)key;
                hash = Util.computeMethodHash(method);
                this.put(method, hash);
            }
            return (Long)hash;
        }
    }

    private static class TableCache
    extends WeakHashMap {
        private boolean mapsMethodToHash;

        public TableCache(boolean mapsMethodToHash) {
            this.mapsMethodToHash = mapsMethodToHash;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map getTable(Class remoteClass) {
            SoftReference[] softReferenceArray = this;
            synchronized (this) {
                SoftReference[] tableRef = (SoftReference[])this.get(remoteClass);
                if (tableRef == null) {
                    tableRef = new SoftReference[]{null};
                    this.put(remoteClass, tableRef);
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                softReferenceArray = tableRef;
                synchronized (tableRef) {
                    Map table = null;
                    if (tableRef[0] != null) {
                        table = (Map)tableRef[0].get();
                    }
                    if (table == null) {
                        if (!this.mapsMethodToHash) {
                            throw new UnsupportedOperationException();
                        }
                        table = new LazyMethodToHash_Map();
                        tableRef[0] = new SoftReference<Map>(table);
                    }
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return table;
                }
            }
        }
    }
}

