/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.logging;

import com.sun.jini.logging.Levels;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogManager
extends java.util.logging.LogManager {
    private Probe probe = null;

    public LogManager() {
        Levels.FAILED.toString();
        Levels.HANDLED.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readConfiguration(InputStream ins) throws IOException {
        super.readConfiguration(ins);
        LogManager logManager = this;
        synchronized (logManager) {
            long interval;
            if (this.probe == null && (interval = this.getInterval()) > 0L) {
                this.probe = new Probe(interval);
                this.probe.start();
            }
        }
    }

    private long getInterval() {
        String val = this.getProperty("com.sun.jini.logging.interval");
        if (val != null) {
            try {
                return Long.decode(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private static File getFile() {
        String fname = System.getProperty("java.util.logging.config.file");
        if (fname != null) {
            return new File(fname);
        }
        return new File(System.getProperty("java.home"), "lib" + File.separator + "logging.properties");
    }

    private class Probe
    extends Thread {
        private long interval;
        private File prevFile;
        private long prevModified;

        Probe(long interval) {
            super("LogManager config file probe");
            this.setDaemon(true);
            this.interval = interval;
            this.prevFile = LogManager.getFile();
            this.prevModified = this.prevFile.lastModified();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object file;
            Logger logger = Logger.getLogger("com.sun.jini.logging.LogManager");
            try {
                while (this.interval > 0L) {
                    Thread.sleep(this.interval);
                    file = LogManager.getFile();
                    long lastModified = ((File)file).lastModified();
                    if (lastModified <= 0L || ((File)file).equals(this.prevFile) && lastModified == this.prevModified) continue;
                    try {
                        LogManager.this.readConfiguration();
                        this.interval = LogManager.this.getInterval();
                        logger.log(Level.CONFIG, "logging config file reread complete, new interval is {0}", this.interval);
                    }
                    catch (Throwable t) {
                        try {
                            logger.log(Level.WARNING, "exception reading logging config file", t);
                        }
                        catch (Throwable t2) {
                            // empty catch block
                        }
                    }
                    this.prevFile = file;
                    this.prevModified = lastModified;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                file = LogManager.this;
                synchronized (file) {
                    LogManager.this.probe = null;
                }
                logger.config("logging config file probe terminating");
            }
        }
    }
}

