/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.mahalo.Job;
import com.sun.jini.mahalo.JobException;
import com.sun.jini.mahalo.JobNotStartedException;
import com.sun.jini.mahalo.ParticipantCommitRecord;
import com.sun.jini.mahalo.ParticipantHandle;
import com.sun.jini.mahalo.ParticipantTask;
import com.sun.jini.mahalo.ResultNotReadyException;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.log.ClientLog;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.rmi.AccessException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.activation.ActivateFailedException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionParticipant;

public class CommitJob
extends Job
implements TransactionConstants {
    ServerTransaction tr;
    ClientLog log;
    ParticipantHandle[] handles;
    int maxtries = Integer.MAX_VALUE;
    static final Logger logger = TxnManagerImpl.participantLogger;

    public CommitJob(Transaction tr, TaskManager pool, WakeupManager wm, ClientLog log, ParticipantHandle[] handles) {
        super(pool, wm);
        if (log == null) {
            throw new IllegalArgumentException("CommitJob: CommitJob: log is null");
        }
        this.log = log;
        if (!(tr instanceof ServerTransaction)) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must be a ServerTransaction");
        }
        this.tr = (ServerTransaction)tr;
        if (handles == null) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must have participants");
        }
        if (handles.length == 0) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must have participants");
        }
        this.handles = handles;
    }

    @Override
    Object doWork(TaskManager.Task who, Object param) {
        ParticipantHandle handle = (ParticipantHandle)param;
        TransactionParticipant par = null;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "CommitJob:doWork committing handle: {0}", handle);
        }
        int vote = handle.getPrepState();
        switch (vote) {
            case 4: 
            case 5: 
            case 6: {
                return vote;
            }
        }
        if (par == null) {
            par = handle.getPreParedParticipant();
        }
        try {
            if (this.attempt(who) >= this.maxtries) {
                return 5;
            }
        }
        catch (JobException je) {
            return null;
        }
        if (par == null) {
            return null;
        }
        Integer response = null;
        try {
            par.commit(this.tr.mgr, this.tr.id);
            response = 5;
        }
        catch (TransactionException bte) {
            response = 5;
        }
        catch (NoSuchObjectException nsoe) {
            response = 5;
        }
        catch (ConnectException ce) {
        }
        catch (UnknownHostException uhe) {
            response = 5;
        }
        catch (ConnectIOException cioe) {
        }
        catch (MarshalException me) {
            response = 5;
        }
        catch (AccessException ae) {
            response = 5;
        }
        catch (ActivateFailedException afe) {
            response = 5;
        }
        catch (RemoteException re) {
        }
        catch (RuntimeException rte) {
            response = 5;
        }
        if (response != null) {
            handle.setPrepState(5);
            try {
                this.log.write(new ParticipantCommitRecord(handle));
            }
            catch (LogException le) {
                // empty catch block
            }
            return response;
        }
        return null;
    }

    @Override
    TaskManager.Task[] createTasks() {
        TaskManager.Task[] tmp = new TaskManager.Task[this.handles.length];
        for (int i = 0; i < this.handles.length; ++i) {
            tmp[i] = new ParticipantTask(this.getPool(), this.getMgr(), this, this.handles[i]);
        }
        return tmp;
    }

    @Override
    Object computeResult() throws JobException {
        try {
            if (!this.isCompleted(0L)) {
                throw new ResultNotReadyException("Cannot compute result since there are jobs pending");
            }
        }
        catch (JobNotStartedException jnse) {
            throw new ResultNotReadyException("Cannot compute result since jobs were not created");
        }
        int tmp = 0;
        int count = 0;
        for (int i = 0; i < this.results.length; ++i) {
            tmp = (Integer)this.results[i];
            if (tmp != 5) continue;
            ++count;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "CommitJob:computeResult {0} participants COMMITTED", count);
        }
        return 5;
    }
}

